/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import java.util.HashMap;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.common.ViewsExpandingTest$;
import org.apache.flink.table.planner.utils.TableFunc0;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.table.planner.utils.TableTestUtilBase;
import org.apache.flink.table.types.DataType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u0001E\u0011!CV5foN,\u0005\u0010]1oI&tw\rV3ti*\u00111\u0001B\u0001\u0007G>lWn\u001c8\u000b\u0005\u00151\u0011\u0001\u00029mC:T!a\u0002\u0005\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\t)b!A\u0003vi&d7/\u0003\u0002\u0018)\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016D\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u000ei\u0006\u0014G.\u001a+fgR,F/\u001b7\u0011\tmq\"\u0003I\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\tIa)\u001e8di&|g.\r\t\u0003'\u0005J!A\t\u000b\u0003\u001bQ\u000b'\r\\3UKN$X\u000b^5m\u0011\u0015!\u0003\u0001\"\u0001&\u0003\u0019a\u0014N\\5u}Q\u0011a\u0005\u000b\t\u0003O\u0001i\u0011A\u0001\u0005\u00063\r\u0002\rA\u0007\u0005\u0006U\u0001!\taK\u0001\u001fi\u0016\u001cH/T5yK\u0012\u001c\u0016\u000f\u001c+bE2,g+[3x\u000bb\u0004\u0018M\u001c3j]\u001e$\u0012\u0001\f\t\u000375J!A\f\u000f\u0003\tUs\u0017\u000e\u001e\u0015\u0003SA\u0002\"!\r\u001d\u000e\u0003IR!a\r\u001b\u0002\u0007\u0005\u0004\u0018N\u0003\u00026m\u00059!.\u001e9ji\u0016\u0014(BA\u001c\u000f\u0003\u0015QWO\\5u\u0013\tI$G\u0001\u0007UKN$H+Z7qY\u0006$X\rC\u0003<\u0001\u0011\u00051&A\u000buKN$H+\u00192mK\u0006\u0003\u0018.\u0012=qC:$\u0017N\\4)\u0005i\u0002\u0004\"\u0002 \u0001\t\u0003Y\u0013\u0001\u0005;fgR\u001c\u0016\u000f\\#ya\u0006tG-\u001b8hQ\ti\u0004\u0007C\u0003B\u0001\u0011\u00051&\u0001\u0013uKN$h+[3x\u000bb\u0004\u0018M\u001c3j]\u001e<\u0016\u000e\u001e5NSNl\u0017\r^2i%><H+\u001f9fQ\t\u0001\u0005\u0007C\u0003E\u0001\u0011\u00051&A\u0015uKN$h+[3x\u000bb\u0004\u0018M\u001c3j]\u001e<\u0016\u000e\u001e5MCR,'/\u00197UC\ndWMR;oGRLwN\u001c\u0015\u0003\u0007BBQa\u0012\u0001\u0005\u0002-\nA\u0005^3tiZKWm^#ya\u0006tG-\u001b8h/&$\bNQ;jYRLgNR;oGRLwN\u001c\u0015\u0003\rBBQA\u0013\u0001\u0005\u0002-\n\u0001\u0004^3tiZKWm^#ya\u0006tG-\u001b8h/&$\b.\u0016#GQ\tI\u0005\u0007C\u0003N\u0001\u0011\u00051&\u0001\u0010uKN$X\t\u001f9b]\u0012\fV/\u001a:z/&$\bnU=ti\u0016l\u0017\t\\5bg\"\u0012A\n\r\u0005\u0006!\u0002!I!U\u0001\u000eGJ,\u0017\r^3Tc24\u0016.Z<\u0015\u0005IC\u0006CA*W\u001b\u0005!&BA+\t\u0003\u001d\u0019\u0017\r^1m_\u001eL!a\u0016+\u0003\u0017\r\u000bG/\u00197pOZKWm\u001e\u0005\u00063>\u0003\rAW\u0001\f_JLw-\u001b8UC\ndW\r\u0005\u0002\\E:\u0011A\f\u0019\t\u0003;ri\u0011A\u0018\u0006\u0003?B\ta\u0001\u0010:p_Rt\u0014BA1\u001d\u0003\u0019\u0001&/\u001a3fM&\u00111\r\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005d\u0002\u0006\u0002\u0001gY6\u0004\"a\u001a6\u000e\u0003!T!!\u001b\u001a\u0002\u0013\u0015DH/\u001a8tS>t\u0017BA6i\u0005))\u0005\u0010^3oI^KG\u000f[\u0001\u0006m\u0006dW/\u001a\u0017\u0002]\u000e\nq\u000e\u0005\u0002qq6\t\u0011O\u0003\u0002sg\u0006i\u0001/\u0019:b[\u0016$XM]5{K\u0012T!\u0001^;\u0002\u0015\u0015DH/\u001a8tS>t7O\u0003\u00028m*\u0011qOC\u0001\ni\u0016\u001cH/\u001e;jYNL!!_9\u00035A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8\b\u000bm\u0014\u0001\u0012\u0001?\u0002%YKWm^:FqB\fg\u000eZ5oOR+7\u000f\u001e\t\u0003Ou4Q!\u0001\u0002\t\u0002y\u001c\"!`@\u0011\u0007m\t\t!C\u0002\u0002\u0004q\u0011a!\u00118z%\u00164\u0007B\u0002\u0013~\t\u0003\t9\u0001F\u0001}\u0011\u001d\tY! C\u0001\u0003\u001b\t!\u0002]1sC6,G/\u001a:t)\t\ty\u0001\u0005\u0004\u0002\u0012\u0005m\u0011qD\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u0005!Q\u000f^5m\u0015\t\tI\"\u0001\u0003kCZ\f\u0017\u0002BA\u000f\u0003'\u0011!bQ8mY\u0016\u001cG/[8o!\u0015YbDEA\u0011!\r\u0019\u00121E\u0005\u0004\u0003K!\"!\u0005+bE2,G+Z:u+RLGNQ1tK\"\"\u0011\u0011BA\u0015!\r\u0001\u00181F\u0005\u0004\u0003[\t(A\u0003)be\u0006lW\r^3sg\u001a1\u0011\u0011G?\u0001\u0003g\u0011q\u0003\u0015:j[&$\u0018N^3TG\u0006d\u0017M\u001d$v]\u000e$\u0018n\u001c8\u0014\t\u0005=\u0012Q\u0007\t\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111\b\u0005\u0002\u0013\u0019,hn\u0019;j_:\u001c\u0018\u0002BA \u0003s\u0011abU2bY\u0006\u0014h)\u001e8di&|g\u000eC\u0004%\u0003_!\t!a\u0011\u0015\u0005\u0005\u0015\u0003\u0003BA$\u0003_i\u0011! \u0005\t\u0003\u0017\ny\u0003\"\u0001\u0002N\u0005!QM^1m)!\ty%!\u0016\u0002`\u0005\r\u0004cA\u000e\u0002R%\u0019\u00111\u000b\u000f\u0003\t1{gn\u001a\u0005\t\u0003/\nI\u00051\u0001\u0002Z\u0005\t\u0011\u000eE\u0002\u001c\u00037J1!!\u0018\u001d\u0005\rIe\u000e\u001e\u0005\t\u0003C\nI\u00051\u0001\u0002P\u0005\tA\u000eC\u0004\u0002f\u0005%\u0003\u0019\u0001.\u0002\u0003M\u0004")
public class ViewsExpandingTest
extends TableTestBase {
    private final Function1<TableTestBase, TableTestUtil> tableTestUtil;

    @Parameters
    public static Collection<Function1<TableTestBase, TableTestUtilBase>> parameters() {
        return ViewsExpandingTest$.MODULE$.parameters();
    }

    @TestTemplate
    public void testMixedSqlTableViewExpanding() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableUtil.addDataStream("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.common.ViewsExpandingTest$$anon$5 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Catalog catalog = (Catalog)tableEnv.getCatalog(tableEnv.getCurrentCatalog()).get();
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view1"), (CatalogBaseTable)this.createSqlView("t1"), false);
        tableEnv.createTemporaryView("view2", tableEnv.from("view1"));
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view3"), (CatalogBaseTable)this.createSqlView("view2"), false);
        tableEnv.createTemporaryView("view4", tableEnv.from("view3"));
        tableUtil.verifyExecPlan("select * from view4");
    }

    @TestTemplate
    public void testTableApiExpanding() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableUtil.addDataStream("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.common.ViewsExpandingTest$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        tableEnv.createTemporaryView("view1", tableEnv.from("t1"));
        tableEnv.createTemporaryView("view2", tableEnv.from("view1"));
        tableEnv.createTemporaryView("view3", tableEnv.from("view2"));
        Table query = tableEnv.from("view3");
        tableUtil.verifyExecPlan(query);
    }

    @TestTemplate
    public void testSqlExpanding() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableUtil.addDataStream("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.common.ViewsExpandingTest$$anon$7 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Catalog catalog = (Catalog)tableEnv.getCatalog(tableEnv.getCurrentCatalog()).get();
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view1"), (CatalogBaseTable)this.createSqlView("t1"), false);
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view2"), (CatalogBaseTable)this.createSqlView("view1"), false);
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view3"), (CatalogBaseTable)this.createSqlView("view2"), false);
        String query = "SELECT * FROM view3";
        tableUtil.verifyExecPlan(query);
    }

    @TestTemplate
    public void testViewExpandingWithMismatchRowType() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        String originTableName = "t1";
        tableUtil.addDataStream(originTableName, (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.common.ViewsExpandingTest$$anon$8 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        CatalogView aggSqlView = CatalogView.of((Schema)Schema.newBuilder().fromResolvedSchema(ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"a", (DataType)((DataType)DataTypes.INT().notNull())), Column.physical((String)"b", (DataType)DataTypes.STRING()), Column.physical((String)"c", (DataType)DataTypes.INT())})).build(), (String)"", (String)new StringBuilder(41).append("select a, b, count(c) from ").append(originTableName).append(" group by a, b").toString(), (String)new StringBuilder(41).append("select a, b, count(c) from ").append(originTableName).append(" group by a, b").toString(), new HashMap());
        Catalog catalog = (Catalog)tableEnv.getCatalog(tableEnv.getCurrentCatalog()).get();
        catalog.createTable(new ObjectPath(tableEnv.getCurrentDatabase(), "view1"), (CatalogBaseTable)aggSqlView, false);
        tableUtil.verifyExecPlan("select * from view1");
    }

    @TestTemplate
    public void testViewExpandingWithLateralTableFunction() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableEnv.createTemporarySystemFunction("myFunc", (UserDefinedFunction)new TableFunc0());
        tableEnv.createTemporaryView("source", tableEnv.fromValues(new Object[]{"danny#21", "julian#55", "fabian#30"}).as("f0", new String[0]));
        String createView = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp_view AS\n        |  SELECT f0, f1\n        |  FROM source as S, LATERAL TABLE(myFunc(f0)) as T(f1, f2)\n        |")).stripMargin();
        tableEnv.executeSql(createView);
        tableUtil.verifyExecPlan("select * from tmp_view");
    }

    @TestTemplate
    public void testViewExpandingWithBuiltinFunction() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        String createView = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp_view AS\n        |  SELECT CONCAT('a', 'bc', 'def')\n        |")).stripMargin();
        tableEnv.executeSql(createView);
        ObjectIdentifier objectID = ObjectIdentifier.of((String)tableEnv.getCurrentCatalog(), (String)tableEnv.getCurrentDatabase(), (String)"tmp_view");
        CatalogBaseTable view = ((Catalog)tableEnv.getCatalog(objectID.getCatalogName()).get()).getTable(objectID.toObjectPath());
        Assertions.assertThat((String)((CatalogView)view).getExpandedQuery()).isEqualTo("SELECT `CONCAT`('a', 'bc', 'def')");
    }

    @TestTemplate
    public void testViewExpandingWithUDF() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableEnv.createTemporaryFunction("func", PrimitiveScalarFunction.class);
        String createView = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp_view AS\n        |  SELECT func(1, 2, 'abc')\n        |")).stripMargin();
        tableEnv.executeSql(createView);
        ObjectIdentifier objectID = ObjectIdentifier.of((String)tableEnv.getCurrentCatalog(), (String)tableEnv.getCurrentDatabase(), (String)"tmp_view");
        CatalogBaseTable view = ((Catalog)tableEnv.getCatalog(objectID.getCatalogName()).get()).getTable(objectID.toObjectPath());
        Assertions.assertThat((String)((CatalogView)view).getExpandedQuery()).isEqualTo("SELECT `default_catalog`.`default_database`.`func`(1, 2, 'abc')");
    }

    @TestTemplate
    public void testExpandQueryWithSystemAlias() {
        TableTestUtil tableUtil = (TableTestUtil)this.tableTestUtil.apply((Object)this);
        TableEnvironment tableEnv = tableUtil.tableEnv();
        tableEnv.createTemporaryView("source", tableEnv.fromValues(new Object[]{"danny#21", "julian#55", "fabian#30"}).as("f0", new String[0]));
        String createView = new StringOps(Predef$.MODULE$.augmentString("\n        |create view tmp_view as\n        |select * from (\n        |  select f0,\n        |  row_number() over (partition by f0 order by f0 desc) as rowNum\n        |  from source)\n        |  where rowNum = 1\n        |")).stripMargin();
        tableEnv.executeSql(createView);
        ObjectIdentifier objectID = ObjectIdentifier.of((String)tableEnv.getCurrentCatalog(), (String)tableEnv.getCurrentDatabase(), (String)"tmp_view");
        CatalogBaseTable view = ((Catalog)tableEnv.getCatalog(objectID.getCatalogName()).get()).getTable(objectID.toObjectPath());
        Assertions.assertThat((String)((CatalogView)view).getExpandedQuery()).isEqualTo("SELECT *\nFROM (SELECT `source`.`f0`, ROW_NUMBER() OVER (PARTITION BY `source`.`f0` ORDER BY `source`.`f0` DESC) AS `rowNum`\nFROM `default_catalog`.`default_database`.`source`)\nWHERE `rowNum` = 1");
    }

    private CatalogView createSqlView(String originTable) {
        return CatalogView.of((Schema)Schema.newBuilder().fromResolvedSchema(ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"a", (DataType)DataTypes.INT()), Column.physical((String)"b", (DataType)DataTypes.STRING()), Column.physical((String)"c", (DataType)DataTypes.INT())})).build(), (String)"", (String)new StringBuilder(19).append("select * as c from ").append(originTable).toString(), (String)new StringBuilder(14).append("select * from ").append(originTable).toString(), new HashMap());
    }

    public ViewsExpandingTest(Function1<TableTestBase, TableTestUtil> tableTestUtil) {
        this.tableTestUtil = tableTestUtil;
    }

    public static class PrimitiveScalarFunction
    extends ScalarFunction {
        public long eval(int i, long l, String s) {
            return (long)i + l + (long)s.length();
        }
    }
}

