/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkRexBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.plan.metadata.AggCallSelectivityEstimator;
import org.apache.flink.table.planner.plan.metadata.AggCallSelectivityEstimatorTest$;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.metadata.MockMetaTable;
import org.apache.flink.table.planner.plan.metadata.SelectivityEstimator;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.apache.flink.util.Preconditions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rmc\u0001B\u0001\u0003\u0001E\u0011q$Q4h\u0007\u0006dGnU3mK\u000e$\u0018N^5us\u0016\u001bH/[7bi>\u0014H+Z:u\u0015\t\u0019A!\u0001\u0005nKR\fG-\u0019;b\u0015\t)a!\u0001\u0003qY\u0006t'BA\u0004\t\u0003\u001d\u0001H.\u00198oKJT!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001aDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000fy\u0001!\u0019!C\u0005?\u0005i\u0011\r\u001c7GS\u0016dGMT1nKN,\u0012\u0001\t\t\u0004C\u00112S\"\u0001\u0012\u000b\u0005\r\"\u0012AC2pY2,7\r^5p]&\u0011QE\t\u0002\u0004'\u0016\f\bCA\u0014-\u001b\u0005A#BA\u0015+\u0003\u0011a\u0017M\\4\u000b\u0003-\nAA[1wC&\u0011Q\u0006\u000b\u0002\u0007'R\u0014\u0018N\\4\t\r=\u0002\u0001\u0015!\u0003!\u00039\tG\u000e\u001c$jK2$g*Y7fg\u0002Bq!\r\u0001C\u0002\u0013%!'A\u0007bY24\u0015.\u001a7e)f\u0004Xm]\u000b\u0002gA\u0019\u0011\u0005\n\u001b\u0011\u0005UbT\"\u0001\u001c\u000b\u0005]B\u0014\u0001\u0002;za\u0016T!!\u000f\u001e\u0002\u0007M\fHN\u0003\u0002<\u0019\u000591-\u00197dSR,\u0017BA\u001f7\u0005-\u0019\u0016\u000f\u001c+za\u0016t\u0015-\\3\t\r}\u0002\u0001\u0015!\u00034\u00039\tG\u000e\u001c$jK2$G+\u001f9fg\u0002B!\"\u0011\u0001\u0011\u0002\u0003\r\t\u0015!\u0003C\u0003\rAH%\r\t\u0006'\r+U)R\u0005\u0003\tR\u0011a\u0001V;qY\u0016\u001c\u0004CA\nG\u0013\t9ECA\u0002J]RDq!\u0013\u0001C\u0002\u0013\u0005!*\u0001\u0005oC6,w,\u001b3y+\u0005)\u0005B\u0002'\u0001A\u0003%Q)A\u0005oC6,w,\u001b3yA!9a\n\u0001b\u0001\n\u0003Q\u0015AC1n_VtGoX5eq\"1\u0001\u000b\u0001Q\u0001\n\u0015\u000b1\"Y7pk:$x,\u001b3yA!9!\u000b\u0001b\u0001\n\u0003Q\u0015!\u00039sS\u000e,w,\u001b3y\u0011\u0019!\u0006\u0001)A\u0005\u000b\u0006Q\u0001O]5dK~KG\r\u001f\u0011\t\u000fY\u0003!\u0019!C\u0001/\u0006YA/\u001f9f\r\u0006\u001cGo\u001c:z+\u0005A\u0006CA-\\\u001b\u0005Q&BA\u001e\u0007\u0013\ta&L\u0001\tGY&t7\u000eV=qK\u001a\u000b7\r^8ss\"1a\f\u0001Q\u0001\na\u000bA\u0002^=qK\u001a\u000b7\r^8ss\u0002Bq\u0001\u0019\u0001A\u0002\u0013\u0005\u0011-\u0001\u0006sKb\u0014U/\u001b7eKJ,\u0012A\u0019\t\u00033\u000eL!\u0001\u001a.\u0003\u001f\u0019c\u0017N\\6SKb\u0014U/\u001b7eKJDqA\u001a\u0001A\u0002\u0013\u0005q-\u0001\bsKb\u0014U/\u001b7eKJ|F%Z9\u0015\u0005!\\\u0007CA\nj\u0013\tQGC\u0001\u0003V]&$\bbB!f\u0003\u0003\u0005\rA\u0019\u0005\u0007[\u0002\u0001\u000b\u0015\u00022\u0002\u0017I,\u0007PQ;jY\u0012,'\u000f\t\u0005\b_\u0002\u0011\r\u0011\"\u0001q\u0003-\u0011X\r\u001c#bi\u0006$\u0016\u0010]3\u0016\u0003E\u0004\"A\u001d<\u000e\u0003MT!a\u000e;\u000b\u0005UT\u0014a\u0001:fY&\u0011qo\u001d\u0002\f%\u0016dG)\u0019;b)f\u0004X\r\u0003\u0004z\u0001\u0001\u0006I!]\u0001\re\u0016dG)\u0019;b)f\u0004X\r\t\u0005\bw\u0002\u0011\r\u0011\"\u0001}\u0003\ti\u0017/F\u0001~!\tab0\u0003\u0002\u0000\u0005\t)b\t\\5oWJ+G.T3uC\u0012\fG/Y)vKJL\bbBA\u0002\u0001\u0001\u0006I!`\u0001\u0004[F\u0004\u0003bCA\u0004\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0013\tAa]2b]V\u0011\u00111\u0002\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003;\u0002\t\r|'/Z\u0005\u0005\u0003+\tyAA\u0005UC\ndWmU2b]\"Y\u0011\u0011\u0004\u0001A\u0002\u0003\u0007I\u0011AA\u000e\u0003!\u00198-\u00198`I\u0015\fHc\u00015\u0002\u001e!I\u0011)a\u0006\u0002\u0002\u0003\u0007\u00111\u0002\u0005\f\u0003C\u0001\u0001\u0019!A!B\u0013\tY!A\u0003tG\u0006t\u0007\u0005C\u0004\u0002&\u0001!\t!a\n\u0002\u000bM,G/\u001e9\u0015\u0003!DC!a\t\u0002,A!\u0011QFA\u001e\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012aA1qS*!\u0011QGA\u001c\u0003\u001dQW\u000f]5uKJT1!!\u000f\u000f\u0003\u0015QWO\\5u\u0013\u0011\ti$a\f\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007\u000eC\u0004\u0002B\u0001!I!a\u0011\u0002\u00115|7m[*dC:$B!a\u0003\u0002F!Q\u0011qIA !\u0003\u0005\r!!\u0013\u0002\u0013M$\u0018\r^5ti&\u001c\u0007\u0003BA&\u0003#j!!!\u0014\u000b\u0007\u0005=C!A\u0003ti\u0006$8/\u0003\u0003\u0002T\u00055#A\u0004$mS:\\7\u000b^1uSN$\u0018n\u0019\u0005\b\u0003/\u0002A\u0011BA-\u0003=\u0019'/Z1uK\u0006;wM]3hCR,GCBA.\u0003C\nY\u0007\u0005\u0003\u0002\u000e\u0005u\u0013\u0002BA0\u0003\u001f\u0011\u0011\"Q4he\u0016<\u0017\r^3\t\u0011\u0005\r\u0014Q\u000ba\u0001\u0003K\n\u0001b\u001a:pkB\u001cV\r\u001e\t\u0005'\u0005\u001dT)C\u0002\u0002jQ\u0011Q!\u0011:sCfD\u0001\"!\u001c\u0002V\u0001\u0007\u0011qN\u0001\u0011gFd\u0017iZ4Gk:<\u0016\u000e\u001e5Be\u001e\u0004b!!\u001d\u0002\u0002\u0006\u0015e\u0002BA:\u0003{rA!!\u001e\u0002|5\u0011\u0011q\u000f\u0006\u0004\u0003s\u0002\u0012A\u0002\u001fs_>$h(C\u0001\u0016\u0013\r\ty\bF\u0001\ba\u0006\u001c7.Y4f\u0013\r)\u00131\u0011\u0006\u0004\u0003\u007f\"\u0002CB\n\u0002\b\u0006-U)C\u0002\u0002\nR\u0011a\u0001V;qY\u0016\u0014\u0004\u0003BAG\u0003\u001fk\u0011\u0001O\u0005\u0004\u0003#C$AD*rY\u0006;wMR;oGRLwN\u001c\u0005\b\u0003/\u0002A\u0011BAK)!\tY&a&\u0002\u001a\u0006m\u0005\u0002CA\u0004\u0003'\u0003\r!a\u0003\t\u0011\u0005\r\u00141\u0013a\u0001\u0003KB\u0001\"!\u001c\u0002\u0014\u0002\u0007\u0011q\u000e\u0005\b\u0003?\u0003A\u0011BAQ\u0003Q\u0019'/Z1uK:+X.\u001a:jG2KG/\u001a:bYR!\u00111UAX!\u0011\t)+a+\u000e\u0005\u0005\u001d&bAAUu\u0005\u0019!/\u001a=\n\t\u00055\u0016q\u0015\u0002\u000b%\u0016DH*\u001b;fe\u0006d\u0007\u0002CAY\u0003;\u0003\r!a-\u0002\u00079,X\u000eE\u0002\u0014\u0003kK1!a.\u0015\u0005\u0011auN\\4\t\u000f\u0005m\u0006\u0001\"\u0003\u0002>\u0006q1M]3bi\u0016Le\u000e];u%\u00164G\u0003BA`\u0003\u000b\u0004B!!*\u0002B&!\u00111YAT\u0005-\u0011V\r_%oaV$(+\u001a4\t\u000f\u0005\u001d\u0017\u0011\u0018a\u0001\u000b\u0006)\u0011N\u001c3fq\"9\u00111\u001a\u0001\u0005\n\u00055\u0017AC2sK\u0006$XmQ1mYR1\u0011qZAk\u0003?\u0004B!!*\u0002R&!\u00111[AT\u0005\u001d\u0011V\r\u001f(pI\u0016D\u0001\"a6\u0002J\u0002\u0007\u0011\u0011\\\u0001\t_B,'/\u0019;peB!\u0011QRAn\u0013\r\ti\u000e\u000f\u0002\f'Fdw\n]3sCR|'\u000f\u0003\u0005\u0002b\u0006%\u0007\u0019AAr\u0003\u0015)\u0007\u0010\u001d:t!\u0015\u0019\u0012Q]Ah\u0013\r\t9\u000f\u0006\u0002\u000byI,\u0007/Z1uK\u0012t\u0004bBAv\u0001\u0011%\u0011Q^\u0001\u0012GJ,\u0017\r^3D_2,XN\\*uCR\u001cHCDAx\u0003w\u0014)C!\u000b\u00036\t\u0005#Q\r\t\u0005\u0003c\f90\u0004\u0002\u0002t*!\u0011qJA{\u0015\t)\u0001\"\u0003\u0003\u0002z\u0006M(aC\"pYVlgn\u0015;biND!\"!@\u0002jB\u0005\t\u0019AA\u0000\u0003\rqGM\u001e\t\u0006'\t\u0005!QA\u0005\u0004\u0005\u0007!\"AB(qi&|g\u000e\u0005\u0003\u0003\b\t}a\u0002\u0002B\u0005\u0005;qAAa\u0003\u0003\u001c9!!Q\u0002B\r\u001d\u0011\u0011yAa\u0006\u000f\t\tE!Q\u0003\b\u0005\u0003k\u0012\u0019\"C\u0001\u0010\u0013\tia\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I1!a \u0007\u0013\u0011\u0011\tCa\t\u0003\u000b)cuN\\4\u000b\u0007\u0005}d\u0001\u0003\u0006\u0003(\u0005%\b\u0013!a\u0001\u0003\u007f\f\u0011B\\;mY\u000e{WO\u001c;\t\u0015\t-\u0012\u0011\u001eI\u0001\u0002\u0004\u0011i#\u0001\u0004bm\u001edUM\u001c\t\u0006'\t\u0005!q\u0006\t\u0005\u0005\u000f\u0011\t$\u0003\u0003\u00034\t\r\"a\u0002&E_V\u0014G.\u001a\u0005\u000b\u0005o\tI\u000f%AA\u0002\te\u0012AB7bq2+g\u000eE\u0003\u0014\u0005\u0003\u0011Y\u0004E\u0002(\u0005{I1Aa\u0010)\u0005\u001dIe\u000e^3hKJD!Ba\u0011\u0002jB\u0005\t\u0019\u0001B#\u0003\ri\u0017N\u001c\t\u0006'\t\u0005!q\t\u0019\u0005\u0005\u0013\u0012\u0019\u0006E\u0003(\u0005\u0017\u0012y%C\u0002\u0003N!\u0012!bQ8na\u0006\u0014\u0018M\u00197f!\u0011\u0011\tFa\u0015\r\u0001\u0011a!Q\u000bB!\u0003\u0003\u0005\tQ!\u0001\u0003X\t\u0019q\fJ\u0019\u0012\t\te#q\f\t\u0004'\tm\u0013b\u0001B/)\t9aj\u001c;iS:<\u0007cA\n\u0003b%\u0019!1\r\u000b\u0003\u0007\u0005s\u0017\u0010\u0003\u0006\u0003h\u0005%\b\u0013!a\u0001\u0005S\n1!\\1y!\u0015\u0019\"\u0011\u0001B6a\u0011\u0011iG!\u001d\u0011\u000b\u001d\u0012YEa\u001c\u0011\t\tE#\u0011\u000f\u0003\r\u0005g\u0012)'!A\u0001\u0002\u000b\u0005!q\u000b\u0002\u0004?\u0012\u0012\u0004b\u0002B<\u0001\u0011%!\u0011P\u0001\u0015GJ,\u0017\r^3GY&t7n\u0015;bi&\u001cH/[2\u0015\r\u0005%#1\u0010B@\u0011)\u0011iH!\u001e\u0011\u0002\u0003\u0007\u0011q`\u0001\te><8i\\;oi\"Q!\u0011\u0011B;!\u0003\u0005\rAa!\u0002\u0011\r|Gn\u0015;biN\u0004Ra\u0005B\u0001\u0005\u000b\u0003\u0002Ba\"\u0003\u0010\nU\u0015q\u001e\b\u0005\u0005\u0013\u0013Y\tE\u0002\u0002vQI1A!$\u0015\u0003\u0019\u0001&/\u001a3fM&!!\u0011\u0013BJ\u0005\ri\u0015\r\u001d\u0006\u0004\u0005\u001b#\u0002\u0003\u0002BD\u0005/K1!\fBJ\u0011\u001d\u0011Y\n\u0001C\u0001\u0003O\t\u0011\u0003^3tiN+XnV5uQ\u0016\u000bX/\u00197tQ\u0011\u0011IJa(\u0011\t\u00055\"\u0011U\u0005\u0005\u0005G\u000byC\u0001\u0003UKN$\bb\u0002BT\u0001\u0011\u0005\u0011qE\u0001\u0014i\u0016\u001cHoU;n/&$\b\u000eT3tgRC\u0017M\u001c\u0015\u0005\u0005K\u0013y\nC\u0004\u0003.\u0002!\t!a\n\u0002;Q,7\u000f^*v[^KG\u000f\u001b'fgN$\u0006.\u00198Pe\u0016\u000bX/\u00197t)>DCAa+\u0003 \"9!1\u0017\u0001\u0005\u0002\u0005\u001d\u0012A\u0006;fgR\u001cV/\\,ji\"<%/Z1uKJ$\u0006.\u00198)\t\tE&q\u0014\u0005\b\u0005s\u0003A\u0011AA\u0014\u0003y!Xm\u001d;Tk6<\u0016\u000e\u001e5He\u0016\fG/\u001a:UQ\u0006twJ]#rk\u0006d7\u000f\u000b\u0003\u00038\n}\u0005b\u0002B`\u0001\u0011\u0005\u0011qE\u0001\u000bi\u0016\u001cH/T1y\u001b&t\u0007\u0006\u0002B_\u0005?CqA!2\u0001\t\u0003\t9#A\u0004uKN$\u0018I^4)\t\t\r'q\u0014\u0005\b\u0005\u0017\u0004A\u0011AA\u0014\u0003%!Xm\u001d;D_VtG\u000f\u000b\u0003\u0003J\n}\u0005b\u0002Bi\u0001\u0011\u0005\u0011qE\u0001\bi\u0016\u001cH/\u00118eQ\u0011\u0011yMa(\t\u000f\t]\u0007\u0001\"\u0001\u0002(\u00051A/Z:u\u001fJDCA!6\u0003 \"I!Q\u001c\u0001\u0012\u0002\u0013%!q\\\u0001\u0013[>\u001c7nU2b]\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003b*\"\u0011\u0011\nBrW\t\u0011)\u000f\u0005\u0003\u0003h\nEXB\u0001Bu\u0015\u0011\u0011YO!<\u0002\u0013Ut7\r[3dW\u0016$'b\u0001Bx)\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tM(\u0011\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003B|\u0001E\u0005I\u0011\u0002B}\u0003m\u0019'/Z1uK\u000e{G.^7o'R\fGo\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1 \u0016\u0005\u0003\u007f\u0014\u0019\u000fC\u0005\u0003\u0000\u0002\t\n\u0011\"\u0003\u0003z\u0006Y2M]3bi\u0016\u001cu\u000e\\;n]N#\u0018\r^:%I\u00164\u0017-\u001e7uIIB\u0011ba\u0001\u0001#\u0003%Ia!\u0002\u00027\r\u0014X-\u0019;f\u0007>dW/\u001c8Ti\u0006$8\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u00199A\u000b\u0003\u0003.\t\r\b\"CB\u0006\u0001E\u0005I\u0011BB\u0007\u0003m\u0019'/Z1uK\u000e{G.^7o'R\fGo\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u00111q\u0002\u0016\u0005\u0005s\u0011\u0019\u000fC\u0005\u0004\u0014\u0001\t\n\u0011\"\u0003\u0004\u0016\u0005Y2M]3bi\u0016\u001cu\u000e\\;n]N#\u0018\r^:%I\u00164\u0017-\u001e7uIU*\"aa\u0006+\t\re!1\u001d\t\u0006'\t\u000511\u0004\u0019\u0005\u0007;\u0019\t\u0003E\u0003(\u0005\u0017\u001ay\u0002\u0005\u0003\u0003R\r\u0005B\u0001\u0004B+\u0007#\t\t\u0011!A\u0003\u0002\t]\u0003\"CB\u0013\u0001E\u0005I\u0011BB\u0014\u0003m\u0019'/Z1uK\u000e{G.^7o'R\fGo\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u00111\u0011\u0006\u0016\u0005\u0007W\u0011\u0019\u000fE\u0003\u0014\u0005\u0003\u0019i\u0003\r\u0003\u00040\rM\u0002#B\u0014\u0003L\rE\u0002\u0003\u0002B)\u0007g!ABa\u001d\u0004$\u0005\u0005\t\u0011!B\u0001\u0005/B\u0011ba\u000e\u0001#\u0003%IA!?\u0002=\r\u0014X-\u0019;f\r2Lgn[*uCRL7\u000f^5dI\u0011,g-Y;mi\u0012\n\u0004\"CB\u001e\u0001E\u0005I\u0011BB\u001f\u0003y\u0019'/Z1uK\u001ac\u0017N\\6Ti\u0006$\u0018n\u001d;jG\u0012\"WMZ1vYR$#'\u0006\u0002\u0004@)\"!1\u0011Br\u000f\u001d\u0019\u0019E\u0001E\u0001\u0007\u000b\nq$Q4h\u0007\u0006dGnU3mK\u000e$\u0018N^5us\u0016\u001bH/[7bi>\u0014H+Z:u!\ra2q\t\u0004\u0007\u0003\tA\ta!\u0013\u0014\u0007\r\u001d#\u0003C\u0004\u001a\u0007\u000f\"\ta!\u0014\u0015\u0005\r\u0015\u0003\u0002CB)\u0007\u000f\"\t!a\n\u0002\u0013\t,gm\u001c:f\u00032d\u0007\u0006BB(\u0007+\u0002B!!\f\u0004X%!1\u0011LA\u0018\u0005%\u0011UMZ8sK\u0006cG\u000e")
public class AggCallSelectivityEstimatorTest {
    private final Seq<String> allFieldNames = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "amount", "price"}));
    private final Seq<SqlTypeName> allFieldTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SqlTypeName[]{SqlTypeName.VARCHAR, SqlTypeName.INTEGER, SqlTypeName.DOUBLE}));
    private final /* synthetic */ Tuple3 x$1;
    private final int name_idx;
    private final int amount_idx;
    private final int price_idx;
    private final FlinkTypeFactory typeFactory;
    private FlinkRexBuilder rexBuilder;
    private final RelDataType relDataType;
    private final FlinkRelMetadataQuery mq;
    private TableScan scan;

    @BeforeAll
    public static void beforeAll() {
        AggCallSelectivityEstimatorTest$.MODULE$.beforeAll();
    }

    private Seq<String> allFieldNames() {
        return this.allFieldNames;
    }

    private Seq<SqlTypeName> allFieldTypes() {
        return this.allFieldTypes;
    }

    public int name_idx() {
        return this.name_idx;
    }

    public int amount_idx() {
        return this.amount_idx;
    }

    public int price_idx() {
        return this.price_idx;
    }

    public FlinkTypeFactory typeFactory() {
        return this.typeFactory;
    }

    public FlinkRexBuilder rexBuilder() {
        return this.rexBuilder;
    }

    public void rexBuilder_$eq(FlinkRexBuilder x$1) {
        this.rexBuilder = x$1;
    }

    public RelDataType relDataType() {
        return this.relDataType;
    }

    public FlinkRelMetadataQuery mq() {
        return this.mq;
    }

    public TableScan scan() {
        return this.scan;
    }

    public void scan_$eq(TableScan x$1) {
        this.scan = x$1;
    }

    @BeforeEach
    public void setup() {
        this.scan_$eq(this.mockScan(this.mockScan$default$1()));
    }

    private TableScan mockScan(FlinkStatistic statistic) {
        SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)true, (boolean)false).plus();
        MockMetaTable table = new MockMetaTable(this.relDataType(), statistic);
        rootSchema.add("test", (Table)table);
        PlannerContext plannerContext = PlannerMocks.newBuilder().withRootSchema(CalciteSchema.from((SchemaPlus)rootSchema)).build().getPlannerContext();
        FlinkRelBuilder relBuilder = plannerContext.createRelBuilder();
        relBuilder.clear();
        return (TableScan)relBuilder.scan(Arrays.asList((Object[])new String[]{"test"})).build();
    }

    private FlinkStatistic mockScan$default$1() {
        return FlinkStatistic$.MODULE$.UNKNOWN();
    }

    private Aggregate createAggregate(int[] groupSet, Seq<Tuple2<SqlAggFunction, Object>> sqlAggFunWithArg) {
        return this.createAggregate(this.scan(), groupSet, sqlAggFunWithArg);
    }

    private Aggregate createAggregate(TableScan scan, int[] groupSet, Seq<Tuple2<SqlAggFunction, Object>> sqlAggFunWithArg) {
        Seq aggCalls = (Seq)sqlAggFunWithArg.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SqlAggFunction sqlAggFun = (SqlAggFunction)tuple2._1();
            int arg = tuple2._2$mcI$sp();
            SqlAggFunction sqlAggFunction = sqlAggFun;
            SqlAggFunction sqlAggFunction2 = SqlStdOperatorTable.COUNT;
            SqlAggFunction sqlAggFunction3 = sqlAggFunction;
            RelDataType relDataType = !(sqlAggFunction2 != null ? !sqlAggFunction2.equals(sqlAggFunction3) : sqlAggFunction3 != null) ? this.typeFactory().createSqlType(SqlTypeName.BIGINT) : ((RelDataTypeField)scan.getRowType().getFieldList().get(arg)).getType();
            RelDataType aggCallType = relDataType;
            AggregateCall aggregateCall = AggregateCall.create((SqlAggFunction)sqlAggFun, (boolean)false, (boolean)false, (boolean)false, (List)ImmutableList.of((Object)arg), (int)-1, null, (RelCollation)RelCollations.EMPTY, (int)groupSet.length, (RelNode)scan, (RelDataType)aggCallType, (String)((String)scan.getRowType().getFieldNames().get(arg)));
            return aggregateCall;
        }, Seq$.MODULE$.canBuildFrom());
        return LogicalAggregate.create((RelNode)scan, (List)ImmutableList.of(), (ImmutableBitSet)ImmutableBitSet.of((int[])groupSet), null, (List)ImmutableList.copyOf((Object[])((Object[])aggCalls.toArray(ClassTag$.MODULE$.apply(AggregateCall.class)))));
    }

    private RexLiteral createNumericLiteral(long num) {
        return this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(num));
    }

    private RexInputRef createInputRef(int index) {
        RelDataType relDataType = this.typeFactory().createSqlType((SqlTypeName)this.allFieldTypes().apply(index));
        RelDataType relDataTypeWithNullability = this.typeFactory().createTypeWithNullability(relDataType, false);
        return this.rexBuilder().makeInputRef(relDataTypeWithNullability, index);
    }

    private RexNode createCall(SqlOperator operator, Seq<RexNode> exprs) {
        Preconditions.checkArgument((boolean)exprs.nonEmpty());
        return this.rexBuilder().makeCall(operator, (RexNode[])exprs.toArray(ClassTag$.MODULE$.apply(RexNode.class)));
    }

    private ColumnStats createColumnStats(Option<Long> ndv, Option<Long> nullCount, Option<Double> avgLen, Option<Integer> maxLen, Option<Comparable<?>> min, Option<Comparable<?>> max) {
        return ColumnStats.Builder.builder().setNdv((Long)ndv.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setNullCount((Long)nullCount.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setAvgLen((Double)avgLen.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setMaxLen((Integer)maxLen.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setMax((Comparable)max.orNull(Predef$.MODULE$.$conforms())).setMin((Comparable)min.orNull(Predef$.MODULE$.$conforms())).build();
    }

    private Option<Long> createColumnStats$default$1() {
        return None$.MODULE$;
    }

    private Option<Long> createColumnStats$default$2() {
        return None$.MODULE$;
    }

    private Option<Double> createColumnStats$default$3() {
        return None$.MODULE$;
    }

    private Option<Integer> createColumnStats$default$4() {
        return None$.MODULE$;
    }

    private Option<Comparable<?>> createColumnStats$default$5() {
        return None$.MODULE$;
    }

    private Option<Comparable<?>> createColumnStats$default$6() {
        return None$.MODULE$;
    }

    private FlinkStatistic createFlinkStatistic(Option<Long> rowCount, Option<scala.collection.immutable.Map<String, ColumnStats>> colStats) {
        Predef$.MODULE$.require(rowCount.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "rowCount must be non null now");
        TableStats tableStats = colStats.isDefined() ? new TableStats(Predef$.MODULE$.Long2long((Long)rowCount.get()), JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)colStats.get())) : new TableStats(Predef$.MODULE$.Long2long((Long)rowCount.get()), null);
        return FlinkStatistic$.MODULE$.builder().tableStats(tableStats).build();
    }

    private Option<Long> createFlinkStatistic$default$1() {
        return None$.MODULE$;
    }

    private Option<scala.collection.immutable.Map<String, ColumnStats>> createFlinkStatistic$default$2() {
        return None$.MODULE$;
    }

    @Test
    public void testSumWithEquals() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assertions.assertEquals((Object)se.defaultEqualsSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.025)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(5L)}));
        Assertions.assertEquals((Object)estimator1.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assertions.assertEquals((Object)se.defaultEqualsSelectivity(), (Object)estimator3.evaluate(predicate1));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg4 = this.createAggregate(this.mockScan(statistic3), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator4 = new AggCallSelectivityEstimator((RelNode)agg4, this.mq());
        Assertions.assertEquals((Object)se.defaultEqualsSelectivity(), (Object)estimator4.evaluate(predicate1));
    }

    @Test
    public void testSumWithLessThan() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(5L)}));
        Assertions.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.25)), (Object)estimator2.evaluate(predicate1));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
    }

    @Test
    public void testSumWithLessThanOrEqualsTo() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(5L)}));
        Assertions.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.25)), (Object)estimator2.evaluate(predicate1));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
    }

    @Test
    public void testSumWithGreaterThan() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assertions.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(5L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.75)), (Object)estimator2.evaluate(predicate1));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
    }

    @Test
    public void testSumWithGreaterThanOrEquals() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assertions.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(5L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.75)), (Object)estimator2.evaluate(predicate1));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
    }

    @Test
    public void testMaxMin() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.MAX, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.MIN, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(15L)}));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(10L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate2));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(20L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(30.0))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.MAX, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.MIN, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(15L)}));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(50L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate5));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator2.evaluate(predicate1));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3103448275862069)), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.MIN, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.MAX, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate2));
    }

    @Test
    public void testAvg() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        SelectivityEstimator se = new SelectivityEstimator((RelNode)agg1, this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(15L)}));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(10L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate2));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(20L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(30.0))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(15L)}));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(50L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(100L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate5));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator2.evaluate(predicate1));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3103448275862069)), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.AVG, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate1));
        Assertions.assertEquals((Object)se.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate2));
    }

    @Test
    public void testCount() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(6L)}));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(5L)}));
        AggCallSelectivityEstimator estimator1 = new AggCallSelectivityEstimator((RelNode)agg1, this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.9526830054771714)), (Object)estimator1.evaluate(predicate1));
        Assertions.assertEquals((Object)estimator1.defaultAggCallSelectivity(), (Object)estimator1.evaluate(predicate2));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(20L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(30.0))))}))));
        Aggregate agg2 = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator2 = new AggCallSelectivityEstimator((RelNode)agg2, this.mq());
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(6L)}));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(10L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.16666666666666666)), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)estimator2.defaultAggCallSelectivity(), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(10L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultAggCallSelectivity().get())))), (Object)estimator2.evaluate(predicate5));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)estimator2.evaluate(predicate1));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Aggregate agg3 = this.createAggregate(this.mockScan(statistic2), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.COUNT, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator3 = new AggCallSelectivityEstimator((RelNode)agg3, this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)estimator3.evaluate(predicate1));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator3.evaluate(predicate2));
    }

    @Test
    public void testAnd() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(20L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(30.0))))}))));
        Aggregate agg = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator = new AggCallSelectivityEstimator((RelNode)agg, this.mq());
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(10L)}))}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.23706896551724138)), (Object)estimator.evaluate(predicate));
    }

    @Test
    public void testOr() {
        Aggregate agg1 = this.createAggregate(new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(25L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(20L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.double2Double(30.0))))}))));
        Aggregate agg = this.createAggregate(this.mockScan(statistic1), new int[]{this.name_idx()}, (Seq<Tuple2<SqlAggFunction, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.amount_idx())), new Tuple2((Object)SqlStdOperatorTable.SUM, (Object)BoxesRunTime.boxToInteger((int)this.price_idx()))}))));
        AggCallSelectivityEstimator estimator = new AggCallSelectivityEstimator((RelNode)agg, this.mq());
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(1), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(2), this.createNumericLiteral(10L)}))}));
        double s1 = 0.25;
        double s2 = 0.9482758620689655;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(s1 + s2 - s1 * s2))), (Object)estimator.evaluate(predicate));
    }

    public AggCallSelectivityEstimatorTest() {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int name_idx = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int amount_idx = BoxesRunTime.unboxToInt((Object)tuple3._2());
        int price_idx = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)name_idx), (Object)BoxesRunTime.boxToInteger((int)amount_idx), (Object)BoxesRunTime.boxToInteger((int)price_idx));
        this.x$1 = tuple32;
        this.name_idx = BoxesRunTime.unboxToInt((Object)this.x$1._1());
        this.amount_idx = BoxesRunTime.unboxToInt((Object)this.x$1._2());
        this.price_idx = BoxesRunTime.unboxToInt((Object)this.x$1._3());
        this.typeFactory = new FlinkTypeFactory(Thread.currentThread().getContextClassLoader(), (RelDataTypeSystem)FlinkTypeSystem.INSTANCE);
        this.rexBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        this.relDataType = this.typeFactory().createStructType(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)this.allFieldTypes().map((Function1 & Serializable & scala.Serializable)typeName -> this.typeFactory().createSqlType(typeName), Seq$.MODULE$.canBuildFrom())), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(this.allFieldNames()));
        this.mq = FlinkRelMetadataQuery.instance();
    }
}

