/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMdHandlerTestBase;
import org.apache.flink.table.planner.plan.nodes.calcite.Expand;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalExpand;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalRank;
import org.apache.flink.table.planner.plan.nodes.calcite.Rank;
import org.apache.flink.table.planner.plan.nodes.common.CommonCalc;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalHashAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalLocalHashAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.common.CommonPhysicalLookupJoin;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalGroupAggregateBase;
import org.apache.flink.table.planner.plan.utils.ExpandUtil$;
import org.apache.flink.table.runtime.operators.rank.ConstantRankRange;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001#\tqb\t\\5oWJ+G.\u00143D_2,XN\\+oSF,XM\\3tgR+7\u000f\u001e\u0006\u0003\u0007\u0011\t\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003\u000b\u0019\tA\u0001\u001d7b]*\u0011q\u0001C\u0001\ba2\fgN\\3s\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!!\u0007$mS:\\'+\u001a7NI\"\u000bg\u000e\u001a7feR+7\u000f\u001e\"bg\u0016DQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005M\u0001\u0001\"B\u000e\u0001\t\u0003a\u0012a\b;fgR\f%/Z\"pYVlgn]+oSF,Xm\u00148UC\ndWmU2b]R\tQ\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0003V]&$\bF\u0001\u000e%!\t)C&D\u0001'\u0015\t9\u0003&A\u0002ba&T!!\u000b\u0016\u0002\u000f),\b/\u001b;fe*\u00111FD\u0001\u0006UVt\u0017\u000e^\u0005\u0003[\u0019\u0012A\u0001V3ti\")q\u0006\u0001C\u00019\u0005aB/Z:u\u0003J,7i\u001c7v[:\u001cXK\\5rk\u0016|eNV1mk\u0016\u001c\bF\u0001\u0018%\u0011\u0015\u0011\u0004\u0001\"\u0001\u001d\u0003u!Xm\u001d;Be\u0016\u001cu\u000e\\;n]N,f.[9vK>s\u0007K]8kK\u000e$\bFA\u0019%\u0011\u0015)\u0004\u0001\"\u0001\u001d\u0003q!Xm\u001d;Be\u0016\u001cu\u000e\\;n]N,f.[9vK>sg)\u001b7uKJD#\u0001\u000e\u0013\t\u000ba\u0002A\u0011\u0001\u000f\u00025Q,7\u000f^!sK\u000e{G.^7ogVs\u0017.];f\u001f:\u001c\u0015\r\\2)\u0005]\"\u0003\"B\u001e\u0001\t\u0003a\u0012\u0001\b;fgR\f%/Z\"pYVlgn]+oSF,Xm\u00148FqB\fg\u000e\u001a\u0015\u0003u\u0011BQA\u0010\u0001\u0005\u0002q\ta\u0004^3ti\u0006\u0013XmQ8mk6t7/\u00168jcV,wJ\\#yG\"\fgnZ3)\u0005u\"\u0003\"B!\u0001\t\u0003a\u0012A\u0007;fgR\f%/Z\"pYVlgn]+oSF,Xm\u00148SC:\\\u0007F\u0001!%\u0011\u0015!\u0005\u0001\"\u0001\u001d\u0003}!Xm\u001d;Be\u0016\u001cu\u000e\\;n]N,f.[9vK\u000e{WO\u001c;P]N{'\u000f\u001e\u0015\u0003\u0007\u0012BQa\u0012\u0001\u0005\u0002q\t\u0001\u0007^3ti\u0006\u0013XmQ8mk6t7/\u00168jcV,7i\\;oi>s7\u000b\u001e:fC6,\u00050Z2EK\u0012,\b\u000f\\5dCR,\u0007F\u0001$%\u0011\u0015Q\u0005\u0001\"\u0001\u001d\u0003]\"Xm\u001d;Be\u0016\u001cu\u000e\\;n]N,f.[9vK\u000e{WO\u001c;P]N#(/Z1n\u000bb,7m\u00115b]\u001e,Gn\\4O_Jl\u0017\r\\5{K\"\u0012\u0011\n\n\u0005\u0006\u001b\u0002!\t\u0001H\u00016i\u0016\u001cH/\u0011:f\u0007>dW/\u001c8t+:L\u0017/^3D_VtGo\u00148TiJ,\u0017-\\#yK\u000e$%o\u001c9Va\u0012\fG/\u001a\"fM>\u0014X\r\u000b\u0002MI!)\u0001\u000b\u0001C\u00019\u0005yB/Z:u\u0003J,7i\u001c7v[:\u001cXK\\5rk\u0016|e.Q4he\u0016<\u0017\r^3)\u0005=#\u0003\"B*\u0001\t\u0003a\u0012\u0001\u000b;fgR\f%/Z\"pYVlgn]+oSF,Xm\u00148CCR\u001c\u0007.\u0012=fG\u0006;wM]3hCR,\u0007F\u0001*%\u0011\u00151\u0006\u0001\"\u0001\u001d\u0003%\"Xm\u001d;Be\u0016\u001cu\u000e\\;n]N,f.[9vK>s7\u000b\u001e:fC6,\u00050Z2BO\u001e\u0014XmZ1uK\"\u0012Q\u000b\n\u0005\u00063\u0002!\t\u0001H\u0001 i\u0016\u001cH/\u0011:f\u0007>dW/\u001c8t+:L\u0017/^3P]^Kg\u000eZ8x\u0003\u001e<\u0007F\u0001-%\u0011\u0015a\u0006\u0001\"\u0001\u001d\u0003u!Xm\u001d;Be\u0016\u001cu\u000e\\;n]N,f.[9vK>swJ^3s\u0003\u001e<\u0007FA.%\u0011\u0015y\u0006\u0001\"\u0001\u001d\u0003i!Xm\u001d;Be\u0016\u001cu\u000e\\;n]N,f.[9vK>s'j\\5oQ\tqF\u0005C\u0003c\u0001\u0011\u0005A$\u0001\u0011uKN$\u0018I]3D_2,XN\\:V]&\fX/Z(o\u0019>|7.\u001e9K_&t\u0007FA1%\u0011\u0015)\u0007\u0001\"\u0001\u001d\u0003m!Xm\u001d;Be\u0016\u001cu\u000e\\;n]N,f.[9vK>sWK\\5p]\"\u0012A\r\n\u0005\u0006Q\u0002!\t\u0001H\u0001 i\u0016\u001cH/\u0011:f\u0007>dW/\u001c8t+:L\u0017/^3P]&sG/\u001a:tK\u000e$\bFA4%\u0011\u0015Y\u0007\u0001\"\u0001\u001d\u0003m!Xm\u001d;Be\u0016\u001cu\u000e\\;n]N,f.[9vK>sW*\u001b8vg\"\u0012!\u000e\n\u0005\u0006]\u0002!\t\u0001H\u0001 i\u0016\u001cHoR3u\u0007>dW/\u001c8Ok2d7i\\;oi>sG)\u001a4bk2$\bFA7%\u0011\u0015\t\b\u0001\"\u0001\u001d\u0003\u0019\"Xm\u001d;Be\u0016\u001cu\u000e\\;n]N,f.[9vK>sG+\u00192mKN{WO]2f)\u0006\u0014G.\u001a\u0015\u0003a\u0012BQ\u0001\u001e\u0001\u0005\u0002q\t\u0001\u0007^3ti\u0006\u0013XmQ8mk6t7/\u00168jcV,wJ\u001c+bE2,\u0007+\u0019:uS\u0006dG.\u001f)s_*,7\r^3e\u0017\u0016L\bFA:%\u0011\u00159\b\u0001\"\u0001\u001d\u0003I\"Xm\u001d;Be\u0016\u001cu\u000e\\;n]N,f.[9vK>sG/\u00192mKN{WO]2f)\u0006\u0014G.\u001a(p].+\u0017PT8o\u0017\u0016L\bF\u0001<%\u0001")
public class FlinkRelMdColumnUniquenessTest
extends FlinkRelMdHandlerTestBase {
    @Test
    public void testAreColumnsUniqueOnTableScan() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.studentLogicalScan(), this.studentFlinkLogicalScan(), this.studentBatchScan(), this.studentStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnTableScan$1(this, scan);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.empLogicalScan(), this.empFlinkLogicalScan(), this.empBatchScan(), this.empStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnTableScan$3(this, scan);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAreColumnsUniqueOnValues() {
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{3}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{4}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{5}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{6}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{7}))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.emptyValues().getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.emptyValues(), ImmutableBitSet.of((int[])new int[]{idx})))));
    }

    @Test
    public void testAreColumnsUniqueOnProject() {
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{2})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{3})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{4})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{5})));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{6}))));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{7})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{8})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{9})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{10})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{11})));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{2, 3})));
        this.relBuilder().push((RelNode)this.studentLogicalScan());
        .colon.colon exprs = new .colon.colon((Object)this.relBuilder().field(0), (List)new .colon.colon((Object)this.relBuilder().cast((RexNode)this.relBuilder().field(0), SqlTypeName.BIGINT), (List)new .colon.colon((Object)this.relBuilder().field(1), (List)new .colon.colon((Object)this.relBuilder().cast((RexNode)this.relBuilder().field(1), SqlTypeName.VARCHAR), (List)Nil$.MODULE$))));
        RelNode project = this.relBuilder().project((Iterable)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)exprs)).build();
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(project, ImmutableBitSet.of((int[])new int[]{0}))));
        Assertions.assertNull((Object)this.mq().areColumnsUnique(project, ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(project, ImmutableBitSet.of((int[])new int[]{1}), true)));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(project, ImmutableBitSet.of((int[])new int[]{2}))));
        Assertions.assertNull((Object)this.mq().areColumnsUnique(project, ImmutableBitSet.of((int[])new int[]{3})));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(project, ImmutableBitSet.of((int[])new int[]{1, 2}), true)));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(project, ImmutableBitSet.of((int[])new int[]{1, 3}), true)));
    }

    @Test
    public void testAreColumnsUniqueOnFilter() {
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFilter(), ImmutableBitSet.of())));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{0}))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.logicalFilter().getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{idx})))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
    }

    @Test
    public void testAreColumnsUniqueOnCalc() {
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{2})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{3})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{4})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{5})));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{6}))));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{7})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{8})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{9})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{10})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{11})));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.logicalCalc(), ImmutableBitSet.of((int[])new int[]{2, 3})));
    }

    @Test
    public void testAreColumnsUniqueOnExpand() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Expand[]{this.logicalExpand(), this.flinkLogicalExpand(), this.batchExpand(), this.streamExpand()})).foreach((Function1 & Serializable & scala.Serializable)expand -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnExpand$1(this, expand);
            return BoxedUnit.UNIT;
        });
        java.util.List expandProjects = ExpandUtil$.MODULE$.createExpandProjects(this.studentLogicalScan().getCluster().getRexBuilder(), this.studentLogicalScan().getRowType(), ImmutableBitSet.of((int[])new int[]{0, 3, 5}), ImmutableList.of((Object)ImmutableBitSet.of((int[])new int[]{0, 3, 5}), (Object)ImmutableBitSet.of((int[])new int[]{3, 5}), (Object)ImmutableBitSet.of((int[])new int[]{3})), (Integer[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Integer.class)));
        LogicalExpand logicalExpand2 = new LogicalExpand(this.cluster(), this.studentLogicalScan().getTraitSet(), (RelNode)this.studentLogicalScan(), expandProjects, 7);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), logicalExpand2.getRowType().getFieldCount() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)logicalExpand2, ImmutableBitSet.of((int[])new int[]{idx, 7})))));
    }

    @Test
    public void testAreColumnsUniqueOnExchange() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.batchExchange(), this.streamExchange()})).foreach((Function1 & Serializable & scala.Serializable)exchange -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnExchange$1(this, exchange);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAreColumnsUniqueOnRank() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalRank(), this.flinkLogicalRank(), this.batchLocalRank(), this.batchGlobalRank(), this.streamRank(), this.logicalRankWithVariableRange(), this.flinkLogicalRankWithVariableRange(), this.streamRankWithVariableRange()})).foreach((Function1 & Serializable & scala.Serializable)rank -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnRank$1(this, rank);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Rank[]{this.logicalRowNumber(), this.flinkLogicalRowNumber(), this.streamRowNumber()})).foreach((Function1 & Serializable & scala.Serializable)rank -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnRank$3(this, rank);
            return BoxedUnit.UNIT;
        });
        LogicalRank rowNumber = new LogicalRank(this.cluster(), this.logicalTraits(), (RelNode)this.studentLogicalScan(), ImmutableBitSet.of((int[])new int[]{6}), RelCollations.of((int)4), RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(3L, 6L), (RelDataTypeField)new RelDataTypeFieldImpl("rn", 7, this.longType()), true);
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)rowNumber, ImmutableBitSet.of((int[])new int[]{0}))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), rowNumber.getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)rowNumber, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)rowNumber, ImmutableBitSet.of((int[])new int[]{0, 7}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)rowNumber, ImmutableBitSet.of((int[])new int[]{1, 7}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)rowNumber, ImmutableBitSet.of((int[])new int[]{6, 7}))));
    }

    @Test
    public void testAreColumnsUniqueCountOnSort() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalSort(), this.flinkLogicalSort(), this.batchSort(), this.streamSort(), this.logicalLimit(), this.flinkLogicalLimit(), this.batchLimit(), this.batchLocalLimit(), this.batchGlobalLimit(), this.streamLimit(), this.logicalSortLimit(), this.flinkLogicalSortLimit(), this.batchSortLimit(), this.batchLocalSortLimit(), this.batchGlobalSortLimit(), this.streamSortLimit()})).foreach((Function1 & Serializable & scala.Serializable)sort -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueCountOnSort$1(this, sort);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAreColumnsUniqueCountOnStreamExecDeduplicate() {
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamProcTimeDeduplicateFirstRow(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamProcTimeDeduplicateFirstRow(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamProcTimeDeduplicateFirstRow(), ImmutableBitSet.of((int[])new int[]{0, 1, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamProcTimeDeduplicateLastRow(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamProcTimeDeduplicateLastRow(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamProcTimeDeduplicateLastRow(), ImmutableBitSet.of((int[])new int[]{0, 1, 2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamRowTimeDeduplicateFirstRow(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamRowTimeDeduplicateFirstRow(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamRowTimeDeduplicateFirstRow(), ImmutableBitSet.of((int[])new int[]{0, 1, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamRowTimeDeduplicateLastRow(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamRowTimeDeduplicateLastRow(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.streamRowTimeDeduplicateLastRow(), ImmutableBitSet.of((int[])new int[]{0, 1, 2}))));
    }

    @Test
    public void testAreColumnsUniqueCountOnStreamExecChangelogNormalize() {
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamChangelogNormalize(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamChangelogNormalize(), ImmutableBitSet.of((int[])new int[]{1, 0}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamChangelogNormalize(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamChangelogNormalize(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamChangelogNormalize(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
    }

    @Test
    public void testAreColumnsUniqueCountOnStreamExecDropUpdateBefore() {
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamDropUpdateBefore(), ImmutableBitSet.of())));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamDropUpdateBefore(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamDropUpdateBefore(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamDropUpdateBefore(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamDropUpdateBefore(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
    }

    @Test
    public void testAreColumnsUniqueOnAggregate() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Aggregate[]{this.logicalAgg(), this.flinkLogicalAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnAggregate$1(this, agg);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Aggregate[]{this.logicalAggWithAuxGroup(), this.flinkLogicalAggWithAuxGroup()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnAggregate$3(this, agg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAreColumnsUniqueOnBatchExecAggregate() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new BatchPhysicalHashAggregate[]{this.batchGlobalAggWithLocal(), this.batchGlobalAggWithoutLocal()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnBatchExecAggregate$1(this, agg);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new BatchPhysicalHashAggregate[]{this.batchGlobalAggWithLocalWithAuxGroup(), this.batchGlobalAggWithoutLocalWithAuxGroup()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnBatchExecAggregate$3(this, agg);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new BatchPhysicalLocalHashAggregate[]{this.batchLocalAgg(), this.batchLocalAggWithAuxGroup()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnBatchExecAggregate$5(this, agg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAreColumnsUniqueOnStreamExecAggregate() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StreamPhysicalGroupAggregateBase[]{this.streamGlobalAggWithLocal(), this.streamGlobalAggWithoutLocal()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnStreamExecAggregate$1(this, agg);
            return BoxedUnit.UNIT;
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.streamLocalAgg().getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.streamLocalAgg(), ImmutableBitSet.of((int[])new int[]{idx}))));
    }

    @Test
    public void testAreColumnsUniqueOnWindowAgg() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalWindowAgg(), this.flinkLogicalWindowAgg(), this.batchGlobalWindowAggWithLocalAgg(), this.batchGlobalWindowAggWithoutLocalAgg(), this.streamWindowAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnWindowAgg$1(this, agg);
            return BoxedUnit.UNIT;
        });
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{0, 1, 3})));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalWindowAgg2(), this.flinkLogicalWindowAgg2(), this.batchGlobalWindowAggWithLocalAgg2(), this.batchGlobalWindowAggWithoutLocalAgg2(), this.streamWindowAgg2()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnWindowAgg$2(this, agg);
            return BoxedUnit.UNIT;
        });
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.batchLocalWindowAgg2(), ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.batchLocalWindowAgg2(), ImmutableBitSet.of((int[])new int[]{0, 2})));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalWindowAggWithAuxGroup(), this.flinkLogicalWindowAggWithAuxGroup(), this.batchGlobalWindowAggWithLocalAggWithAuxGroup(), this.batchGlobalWindowAggWithoutLocalAggWithAuxGroup()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnWindowAgg$3(this, agg);
            return BoxedUnit.UNIT;
        });
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.batchLocalWindowAggWithAuxGroup(), ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.batchLocalWindowAggWithAuxGroup(), ImmutableBitSet.of((int[])new int[]{0, 3})));
    }

    @Test
    public void testAreColumnsUniqueOnOverAgg() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new CommonCalc[]{this.flinkLogicalOverAgg(), this.batchOverAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnOverAgg$1(this, agg);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{3}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{4}))));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{5})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{6})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{7})));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{0, 5}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{0, 7}))));
        Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.streamOverAgg(), ImmutableBitSet.of((int[])new int[]{5, 7})));
    }

    @Test
    public void testAreColumnsUniqueOnJoin() {
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{6}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 5}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 5}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 6}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 6}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5, 6}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 5, 6}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{6}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 5}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 6}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5, 6}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 5, 6}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{6}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 5}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 6}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5, 6}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 5, 6}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{6}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 5}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1, 6}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{5, 6}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0, 1, 5, 6}))));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalSemiJoinOnUniqueKeys(), this.logicalSemiJoinNotOnUniqueKeys(), this.logicalSemiJoinOnDisjointKeys(), this.logicalAntiJoinOnUniqueKeys(), this.logicalAntiJoinNotOnUniqueKeys(), this.logicalAntiJoinOnDisjointKeys()})).foreach((Function1 & Serializable & scala.Serializable)join -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnJoin$1(this, join);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAreColumnsUniqueOnLookupJoin() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new CommonPhysicalLookupJoin[]{this.batchLookupJoin(), this.streamLookupJoin()})).foreach((Function1 & Serializable & scala.Serializable)join -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnLookupJoin$1(this, join);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAreColumnsUniqueOnUnion() {
        int fieldCnt = this.logicalUnionAll().getRowType().getFieldCount();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), fieldCnt).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalUnionAll(), ImmutableBitSet.of((int[])new int[]{idx})))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalUnionAll(), ImmutableBitSet.range((int)fieldCnt))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), fieldCnt).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalUnion(), ImmutableBitSet.of((int[])new int[]{idx})))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalUnion(), ImmutableBitSet.range((int)fieldCnt))));
    }

    @Test
    public void testAreColumnsUniqueOnIntersect() {
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersectAll(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersectAll(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersectAll(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersectAll(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersectAll(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersectAll(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersect(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersect(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersect(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersect(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersect(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersect(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalIntersect(), ImmutableBitSet.range((int)this.logicalIntersect().getRowType().getFieldCount()))));
    }

    @Test
    public void testAreColumnsUniqueOnMinus() {
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinusAll(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinusAll(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinusAll(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinusAll(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinusAll(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinusAll(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinus(), ImmutableBitSet.of((int[])new int[]{0}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinus(), ImmutableBitSet.of((int[])new int[]{1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinus(), ImmutableBitSet.of((int[])new int[]{2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinus(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinus(), ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinus(), ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(this.logicalMinus(), ImmutableBitSet.range((int)this.logicalMinus().getRowType().getFieldCount()))));
        RelNode logicalMinus2 = this.relBuilder().scan(new String[]{"MyTable2"}).scan(new String[]{"MyTable1"}).minus(false).build();
        Assertions.assertNull((Object)this.mq().areColumnsUnique(logicalMinus2, ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique(logicalMinus2, ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique(logicalMinus2, ImmutableBitSet.of((int[])new int[]{2})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique(logicalMinus2, ImmutableBitSet.of((int[])new int[]{1, 2})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique(logicalMinus2, ImmutableBitSet.of((int[])new int[]{0, 2})));
        Assertions.assertNull((Object)this.mq().areColumnsUnique(logicalMinus2, ImmutableBitSet.of((int[])new int[]{1, 2})));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(this.mq().areColumnsUnique(logicalMinus2, ImmutableBitSet.range((int)logicalMinus2.getRowType().getFieldCount()))));
    }

    @Test
    public void testGetColumnNullCountOnDefault() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.testRel().getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertNull((Object)this.mq().areColumnsUnique((RelNode)this.testRel(), ImmutableBitSet.of((int[])new int[]{idx}))));
    }

    @Test
    public void testAreColumnsUniqueOnTableSourceTable() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.tableSourceTableLogicalScan(), this.tableSourceTableFlinkLogicalScan(), this.tableSourceTableBatchScan(), this.tableSourceTableStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnTableSourceTable$1(this, scan);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAreColumnsUniqueOnTablePartiallyProjectedKey() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.tablePartiallyProjectedKeyLogicalScan(), this.tablePartiallyProjectedKeyFlinkLogicalScan(), this.tablePartiallyProjectedKeyBatchScan(), this.tablePartiallyProjectedKeyStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOnTablePartiallyProjectedKey$1(this, scan);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAreColumnsUniqueOntableSourceTableNonKeyNonKey() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.tableSourceTableNonKeyLogicalScan(), this.tableSourceTableNonKeyFlinkLogicalScan(), this.tableSourceTableNonKeyBatchScan(), this.tableSourceTableNonKeyStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdColumnUniquenessTest.$anonfun$testAreColumnsUniqueOntableSourceTableNonKeyNonKey$1(this, scan);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnTableScan$1(FlinkRelMdColumnUniquenessTest $this, TableScan scan) {
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of())));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0}))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), scan.getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{1, 2}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnTableScan$3(FlinkRelMdColumnUniquenessTest $this, TableScan scan) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), scan.getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{idx}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnExpand$1(FlinkRelMdColumnUniquenessTest $this, Expand expand) {
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)expand, ImmutableBitSet.of())));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), expand.getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)expand, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)expand, ImmutableBitSet.of((int[])new int[]{0, 7}))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), expand.getRowType().getFieldCount() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)expand, ImmutableBitSet.of((int[])new int[]{idx, 7})))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnExchange$1(FlinkRelMdColumnUniquenessTest $this, RelNode exchange) {
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(exchange, ImmutableBitSet.of())));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(exchange, ImmutableBitSet.of((int[])new int[]{0}))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), exchange.getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(exchange, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(exchange, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(exchange, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(exchange, ImmutableBitSet.of((int[])new int[]{1, 2}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnRank$1(FlinkRelMdColumnUniquenessTest $this, RelNode rank) {
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(rank, ImmutableBitSet.of((int[])new int[]{0}))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), rank.getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(rank, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(rank, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(rank, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(rank, ImmutableBitSet.of((int[])new int[]{1, 2}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnRank$3(FlinkRelMdColumnUniquenessTest $this, Rank rank) {
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)rank, ImmutableBitSet.of((int[])new int[]{0}))));
        int rankFunColumn = rank.getRowType().getFieldCount() - 1;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), rankFunColumn).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)rank, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)rank, ImmutableBitSet.of((int[])new int[]{rankFunColumn}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)rank, ImmutableBitSet.of((int[])new int[]{0, rankFunColumn}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)rank, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)rank, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)rank, ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)rank, ImmutableBitSet.of((int[])new int[]{1, rankFunColumn}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)rank, ImmutableBitSet.of((int[])new int[]{2, rankFunColumn}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueCountOnSort$1(FlinkRelMdColumnUniquenessTest $this, RelNode sort) {
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(sort, ImmutableBitSet.of())));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(sort, ImmutableBitSet.of((int[])new int[]{0}))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), sort.getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(sort, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(sort, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(sort, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(sort, ImmutableBitSet.of((int[])new int[]{1, 2}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnAggregate$1(FlinkRelMdColumnUniquenessTest $this, Aggregate agg) {
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0}))));
        int fieldCnt = agg.getRowType().getFieldCount();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), fieldCnt).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.range((int)1, (int)fieldCnt))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnAggregate$3(FlinkRelMdColumnUniquenessTest $this, Aggregate agg) {
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0}))));
        int fieldCnt = agg.getRowType().getFieldCount();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), fieldCnt).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.range((int)1, (int)fieldCnt))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnBatchExecAggregate$1(FlinkRelMdColumnUniquenessTest $this, BatchPhysicalHashAggregate agg) {
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0}))));
        int fieldCnt = agg.getRowType().getFieldCount();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), fieldCnt).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.range((int)1, (int)fieldCnt))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnBatchExecAggregate$3(FlinkRelMdColumnUniquenessTest $this, BatchPhysicalHashAggregate agg) {
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0}))));
        int fieldCnt = agg.getRowType().getFieldCount();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), fieldCnt).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.range((int)1, (int)fieldCnt))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnBatchExecAggregate$5(FlinkRelMdColumnUniquenessTest $this, BatchPhysicalLocalHashAggregate agg) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), agg.getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{idx}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnStreamExecAggregate$1(FlinkRelMdColumnUniquenessTest $this, StreamPhysicalGroupAggregateBase agg) {
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0}))));
        int fieldCnt = agg.getRowType().getFieldCount();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), fieldCnt).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{idx})))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.range((int)1, (int)fieldCnt))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnWindowAgg$1(FlinkRelMdColumnUniquenessTest $this, SingleRel agg) {
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 3}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 3}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 4}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 5}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 6}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 3, 4, 5, 6}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 2, 3}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnWindowAgg$2(FlinkRelMdColumnUniquenessTest $this, SingleRel agg) {
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 3}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 4}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 5}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 2, 3, 4, 5}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 3}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnWindowAgg$3(FlinkRelMdColumnUniquenessTest $this, SingleRel agg) {
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1, 2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 3}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 4}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 5}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 6}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 3, 4, 5, 6}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 3}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnOverAgg$1(FlinkRelMdColumnUniquenessTest $this, CommonCalc agg) {
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{3}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{4}))));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{5})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{6})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{7})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{8})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{9})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{10})));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 5}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 10}))));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)agg, ImmutableBitSet.of((int[])new int[]{5, 10})));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnJoin$1(FlinkRelMdColumnUniquenessTest $this, RelNode join) {
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(join, ImmutableBitSet.of((int[])new int[]{0}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(join, ImmutableBitSet.of((int[])new int[]{1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(join, ImmutableBitSet.of((int[])new int[]{2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(join, ImmutableBitSet.of((int[])new int[]{3}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(join, ImmutableBitSet.of((int[])new int[]{4}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(join, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique(join, ImmutableBitSet.of((int[])new int[]{0, 2}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnLookupJoin$1(FlinkRelMdColumnUniquenessTest $this, CommonPhysicalLookupJoin join) {
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of())));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{0})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{1})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{2})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{3})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{4})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{5})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{6})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{7})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{8})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{9})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{0, 1})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{1, 2})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{0, 7})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{1, 7})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{0, 8})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{7, 8})));
        Assertions.assertNull((Object)$this.mq().areColumnsUnique((RelNode)join, ImmutableBitSet.of((int[])new int[]{8, 9})));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnTableSourceTable$1(FlinkRelMdColumnUniquenessTest $this, TableScan scan) {
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{1, 2}))));
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOnTablePartiallyProjectedKey$1(FlinkRelMdColumnUniquenessTest $this, TableScan scan) {
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3}))));
    }

    public static final /* synthetic */ void $anonfun$testAreColumnsUniqueOntableSourceTableNonKeyNonKey$1(FlinkRelMdColumnUniquenessTest $this, TableScan scan) {
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1, 2}))));
        Assertions.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean($this.mq().areColumnsUnique((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0, 1, 2, 3}))));
    }
}

