/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkRexBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.metadata.MockMetaTable;
import org.apache.flink.table.planner.plan.metadata.SelectivityEstimator;
import org.apache.flink.table.planner.plan.metadata.SelectivityEstimatorTest$;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.apache.flink.util.Preconditions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011\u001da\u0001B\u0001\u0003\u0001E\u0011\u0001dU3mK\u000e$\u0018N^5us\u0016\u001bH/[7bi>\u0014H+Z:u\u0015\t\u0019A!\u0001\u0005nKR\fG-\u0019;b\u0015\t)a!\u0001\u0003qY\u0006t'BA\u0004\t\u0003\u001d\u0001H.\u00198oKJT!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001aDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000fy\u0001!\u0019!C\u0005?\u0005i\u0011\r\u001c7GS\u0016dGMT1nKN,\u0012\u0001\t\t\u0004C\u00112S\"\u0001\u0012\u000b\u0005\r\"\u0012AC2pY2,7\r^5p]&\u0011QE\t\u0002\u0004'\u0016\f\bCA\u0014-\u001b\u0005A#BA\u0015+\u0003\u0011a\u0017M\\4\u000b\u0003-\nAA[1wC&\u0011Q\u0006\u000b\u0002\u0007'R\u0014\u0018N\\4\t\r=\u0002\u0001\u0015!\u0003!\u00039\tG\u000e\u001c$jK2$g*Y7fg\u0002Bq!\r\u0001C\u0002\u0013%!'A\u0007bY24\u0015.\u001a7e)f\u0004Xm]\u000b\u0002gA\u0019\u0011\u0005\n\u001b\u0011\u0005UbT\"\u0001\u001c\u000b\u0005]B\u0014\u0001\u0002;za\u0016T!!\u000f\u001e\u0002\u0007M\fHN\u0003\u0002<\u0019\u000591-\u00197dSR,\u0017BA\u001f7\u0005-\u0019\u0016\u000f\u001c+za\u0016t\u0015-\\3\t\r}\u0002\u0001\u0015!\u00034\u00039\tG\u000e\u001c$jK2$G+\u001f9fg\u0002B!\"\u0011\u0001\u0011\u0002\u0003\r\t\u0015!\u0003C\u0003\rAH%\r\t\u000b'\r+U)R#F\u000b\u0016+\u0015B\u0001#\u0015\u0005\u0019!V\u000f\u001d7fqA\u00111CR\u0005\u0003\u000fR\u00111!\u00138u\u0011\u001dI\u0005A1A\u0005\u0002)\u000b\u0001B\\1nK~KG\r_\u000b\u0002\u000b\"1A\n\u0001Q\u0001\n\u0015\u000b\u0011B\\1nK~KG\r\u001f\u0011\t\u000f9\u0003!\u0019!C\u0001\u0015\u0006Q\u0011-\\8v]R|\u0016\u000e\u001a=\t\rA\u0003\u0001\u0015!\u0003F\u0003-\tWn\\;oi~KG\r\u001f\u0011\t\u000fI\u0003!\u0019!C\u0001\u0015\u0006I\u0001O]5dK~KG\r\u001f\u0005\u0007)\u0002\u0001\u000b\u0011B#\u0002\u0015A\u0014\u0018nY3`S\u0012D\b\u0005C\u0004W\u0001\t\u0007I\u0011\u0001&\u0002\u0011\u0019d\u0017mZ0jIbDa\u0001\u0017\u0001!\u0002\u0013)\u0015!\u00034mC\u001e|\u0016\u000e\u001a=!\u0011\u001dQ\u0006A1A\u0005\u0002)\u000bQ\u0002]1si&$\u0018n\u001c8`S\u0012D\bB\u0002/\u0001A\u0003%Q)\u0001\bqCJ$\u0018\u000e^5p]~KG\r\u001f\u0011\t\u000fy\u0003!\u0019!C\u0001\u0015\u0006AA-\u0019;f?&$\u0007\u0010\u0003\u0004a\u0001\u0001\u0006I!R\u0001\nI\u0006$XmX5eq\u0002BqA\u0019\u0001C\u0002\u0013\u0005!*\u0001\u0005uS6,w,\u001b3y\u0011\u0019!\u0007\u0001)A\u0005\u000b\u0006IA/[7f?&$\u0007\u0010\t\u0005\bM\u0002\u0011\r\u0011\"\u0001K\u00035!\u0018.\\3ti\u0006l\u0007oX5eq\"1\u0001\u000e\u0001Q\u0001\n\u0015\u000ba\u0002^5nKN$\u0018-\u001c9`S\u0012D\b\u0005C\u0004k\u0001\t\u0007I\u0011A6\u0002\u0017QL\b/\u001a$bGR|'/_\u000b\u0002YB\u0011Qn\\\u0007\u0002]*\u00111HB\u0005\u0003a:\u0014\u0001C\u00127j].$\u0016\u0010]3GC\u000e$xN]=\t\rI\u0004\u0001\u0015!\u0003m\u00031!\u0018\u0010]3GC\u000e$xN]=!\u0011\u001d!\b\u00011A\u0005\u0002U\f!B]3y\u0005VLG\u000eZ3s+\u00051\bCA7x\u0013\tAhNA\bGY&t7NU3y\u0005VLG\u000eZ3s\u0011\u001dQ\b\u00011A\u0005\u0002m\faB]3y\u0005VLG\u000eZ3s?\u0012*\u0017\u000f\u0006\u0002}\u007fB\u00111#`\u0005\u0003}R\u0011A!\u00168ji\"9\u0011)_A\u0001\u0002\u00041\bbBA\u0002\u0001\u0001\u0006KA^\u0001\fe\u0016D()^5mI\u0016\u0014\b\u0005C\u0005\u0002\b\u0001\u0011\r\u0011\"\u0001\u0002\n\u0005Y!/\u001a7ECR\fG+\u001f9f+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005UQBAA\b\u0015\r9\u0014\u0011\u0003\u0006\u0004\u0003'Q\u0014a\u0001:fY&!\u0011qCA\b\u0005-\u0011V\r\u001c#bi\u0006$\u0016\u0010]3\t\u0011\u0005m\u0001\u0001)A\u0005\u0003\u0017\tAB]3m\t\u0006$\u0018\rV=qK\u0002B\u0011\"a\b\u0001\u0005\u0004%\t!!\t\u0002\u00055\fXCAA\u0012!\ra\u0012QE\u0005\u0004\u0003O\u0011!!\u0006$mS:\\'+\u001a7NKR\fG-\u0019;b#V,'/\u001f\u0005\t\u0003W\u0001\u0001\u0015!\u0003\u0002$\u0005\u0019Q.\u001d\u0011\t\u0017\u0005=\u0002\u00011AA\u0002\u0013\u0005\u0011\u0011G\u0001\u0005g\u000e\fg.\u0006\u0002\u00024A!\u0011QGA\u001e\u001b\t\t9D\u0003\u0003\u0002:\u0005E\u0011\u0001B2pe\u0016LA!!\u0010\u00028\tIA+\u00192mKN\u001b\u0017M\u001c\u0005\f\u0003\u0003\u0002\u0001\u0019!a\u0001\n\u0003\t\u0019%\u0001\u0005tG\u0006tw\fJ3r)\ra\u0018Q\t\u0005\n\u0003\u0006}\u0012\u0011!a\u0001\u0003gA1\"!\u0013\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00024\u0005)1oY1oA!9\u0011Q\n\u0001\u0005\u0002\u0005=\u0013!B:fiV\u0004H#\u0001?)\t\u0005-\u00131\u000b\t\u0005\u0003+\n\u0019'\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003\r\t\u0007/\u001b\u0006\u0005\u0003;\ny&A\u0004kkBLG/\u001a:\u000b\u0007\u0005\u0005d\"A\u0003kk:LG/\u0003\u0003\u0002f\u0005]#A\u0003\"fM>\u0014X-R1dQ\"9\u0011\u0011\u000e\u0001\u0005\n\u0005-\u0014\u0001C7pG.\u001c6-\u00198\u0015\t\u0005M\u0012Q\u000e\u0005\u000b\u0003_\n9\u0007%AA\u0002\u0005E\u0014!C:uCRL7\u000f^5d!\u0011\t\u0019(!\u001f\u000e\u0005\u0005U$bAA<\t\u0005)1\u000f^1ug&!\u00111PA;\u000591E.\u001b8l'R\fG/[:uS\u000eDq!a \u0001\t\u0013\t\t)\u0001\u000bde\u0016\fG/\u001a(v[\u0016\u0014\u0018n\u0019'ji\u0016\u0014\u0018\r\u001c\u000b\u0005\u0003\u0007\u000by\t\u0005\u0003\u0002\u0006\u0006-UBAAD\u0015\r\tIIO\u0001\u0004e\u0016D\u0018\u0002BAG\u0003\u000f\u0013!BU3y\u0019&$XM]1m\u0011!\t\t*! A\u0002\u0005M\u0015a\u00018v[B\u00191#!&\n\u0007\u0005]EC\u0001\u0003M_:<\u0007bBA@\u0001\u0011%\u00111\u0014\u000b\u0005\u0003\u0007\u000bi\n\u0003\u0005\u0002\u0012\u0006e\u0005\u0019AAP!\r\u0019\u0012\u0011U\u0005\u0004\u0003G#\"A\u0002#pk\ndW\rC\u0004\u0002(\u0002!I!!+\u0002)\r\u0014X-\u0019;f\u0005>|G.Z1o\u0019&$XM]1m)\u0011\t\u0019)a+\t\u0011\u00055\u0016Q\u0015a\u0001\u0003_\u000b\u0011A\u0019\t\u0004'\u0005E\u0016bAAZ)\t9!i\\8mK\u0006t\u0007bBA\\\u0001\u0011%\u0011\u0011X\u0001\u0014GJ,\u0017\r^3TiJLgn\u001a'ji\u0016\u0014\u0018\r\u001c\u000b\u0005\u0003\u0007\u000bY\f\u0003\u0005\u0002>\u0006U\u0006\u0019AA`\u0003\r\u0019HO\u001d\t\u0005\u0003\u0003\fyM\u0004\u0003\u0002D\u0006-\u0007cAAc)5\u0011\u0011q\u0019\u0006\u0004\u0003\u0013\u0004\u0012A\u0002\u001fs_>$h(C\u0002\u0002NR\ta\u0001\u0015:fI\u00164\u0017bA\u0017\u0002R*\u0019\u0011Q\u001a\u000b\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\u0006\t2M]3bi\u0016$\u0015\r^3MSR,'/\u00197\u0015\t\u0005\r\u0015\u0011\u001c\u0005\t\u0003{\u000b\u0019\u000e1\u0001\u0002@\"9\u0011Q\u001c\u0001\u0005\n\u0005}\u0017!E2sK\u0006$X\rV5nK2KG/\u001a:bYR!\u00111QAq\u0011!\ti,a7A\u0002\u0005}\u0006bBAs\u0001\u0011%\u0011q]\u0001\u0017GJ,\u0017\r^3US6,7\u000b^1na2KG/\u001a:bYR!\u00111QAu\u0011!\tY/a9A\u0002\u0005M\u0015AB7jY2L7\u000fC\u0004\u0002p\u0002!I!!=\u0002\u001d\r\u0014X-\u0019;f\u0013:\u0004X\u000f\u001e*fMR!\u00111_A}!\u0011\t))!>\n\t\u0005]\u0018q\u0011\u0002\f%\u0016D\u0018J\u001c9viJ+g\rC\u0004\u0002|\u00065\b\u0019A#\u0002\u000b%tG-\u001a=\t\u000f\u0005}\b\u0001\"\u0003\u0003\u0002\u0005i2M]3bi\u0016Le\u000e];u%\u00164w+\u001b;i\u001dVdG.\u00192jY&$\u0018\u0010\u0006\u0004\u0002t\n\r!Q\u0001\u0005\b\u0003w\fi\u00101\u0001F\u0011!\u00119!!@A\u0002\u0005=\u0016AC5t\u001dVdG.\u00192mK\"9!1\u0002\u0001\u0005\n\t5\u0011AC2sK\u0006$XmQ1mYR1!q\u0002B\u000b\u0005C\u0001B!!\"\u0003\u0012%!!1CAD\u0005\u001d\u0011V\r\u001f(pI\u0016D\u0001Ba\u0006\u0003\n\u0001\u0007!\u0011D\u0001\t_B,'/\u0019;peB!!1\u0004B\u000f\u001b\u0005A\u0014b\u0001B\u0010q\tY1+\u001d7Pa\u0016\u0014\u0018\r^8s\u0011!\u0011\u0019C!\u0003A\u0002\t\u0015\u0012!B3yaJ\u001c\b#B\n\u0003(\t=\u0011b\u0001B\u0015)\tQAH]3qK\u0006$X\r\u001a \t\u000f\t5\u0002\u0001\"\u0003\u00030\u0005Q1M]3bi\u0016\u001c\u0015m\u001d;\u0015\t\t=!\u0011\u0007\u0005\t\u0005g\u0011Y\u00031\u0001\u0003\u0010\u0005!Q\r\u001f9s\u0011\u001d\u00119\u0004\u0001C\u0005\u0005s\t\u0011c\u0019:fCR,7i\u001c7v[:\u001cF/\u0019;t)9\u0011YDa\u0012\u0003t\t]$1\u0011BH\u0005g\u0003BA!\u0010\u0003D5\u0011!q\b\u0006\u0005\u0003o\u0012\tE\u0003\u0002\u0006\u0011%!!Q\tB \u0005-\u0019u\u000e\\;n]N#\u0018\r^:\t\u0015\t%#Q\u0007I\u0001\u0002\u0004\u0011Y%A\u0002oIZ\u0004Ra\u0005B'\u0005#J1Aa\u0014\u0015\u0005\u0019y\u0005\u000f^5p]B!!1\u000bB7\u001d\u0011\u0011)F!\u001b\u000f\t\t]#q\r\b\u0005\u00053\u0012)G\u0004\u0003\u0003\\\t\rd\u0002\u0002B/\u0005CrA!!2\u0003`%\tq\"\u0003\u0002\u000e\u001d%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0007\t-d!A\u0004qC\u000e\\\u0017mZ3\n\t\t=$\u0011\u000f\u0002\u0006\u00152{gn\u001a\u0006\u0004\u0005W2\u0001B\u0003B;\u0005k\u0001\n\u00111\u0001\u0003L\u0005Ia.\u001e7m\u0007>,h\u000e\u001e\u0005\u000b\u0005s\u0012)\u0004%AA\u0002\tm\u0014AB1wO2+g\u000eE\u0003\u0014\u0005\u001b\u0012i\b\u0005\u0003\u0003T\t}\u0014\u0002\u0002BA\u0005c\u0012qA\u0013#pk\ndW\r\u0003\u0006\u0003\u0006\nU\u0002\u0013!a\u0001\u0005\u000f\u000ba!\\1y\u0019\u0016t\u0007#B\n\u0003N\t%\u0005cA\u0014\u0003\f&\u0019!Q\u0012\u0015\u0003\u000f%sG/Z4fe\"Q!\u0011\u0013B\u001b!\u0003\u0005\rAa%\u0002\u00075Lg\u000eE\u0003\u0014\u0005\u001b\u0012)\n\r\u0003\u0003\u0018\n\u0005\u0006#B\u0014\u0003\u001a\nu\u0015b\u0001BNQ\tQ1i\\7qCJ\f'\r\\3\u0011\t\t}%\u0011\u0015\u0007\u0001\t1\u0011\u0019Ka$\u0002\u0002\u0003\u0005)\u0011\u0001BS\u0005\ryF%M\t\u0005\u0005O\u0013i\u000bE\u0002\u0014\u0005SK1Aa+\u0015\u0005\u001dqu\u000e\u001e5j]\u001e\u00042a\u0005BX\u0013\r\u0011\t\f\u0006\u0002\u0004\u0003:L\bB\u0003B[\u0005k\u0001\n\u00111\u0001\u00038\u0006\u0019Q.\u0019=\u0011\u000bM\u0011iE!/1\t\tm&q\u0018\t\u0006O\te%Q\u0018\t\u0005\u0005?\u0013y\f\u0002\u0007\u0003B\nM\u0016\u0011!A\u0001\u0006\u0003\u0011)KA\u0002`IIBqA!2\u0001\t\u0013\u00119-\u0001\u000bde\u0016\fG/\u001a$mS:\\7\u000b^1uSN$\u0018n\u0019\u000b\u0007\u0003c\u0012IM!4\t\u0015\t-'1\u0019I\u0001\u0002\u0004\u0011Y%\u0001\u0005s_^\u001cu.\u001e8u\u0011)\u0011yMa1\u0011\u0002\u0003\u0007!\u0011[\u0001\tG>d7\u000b^1ugB)1C!\u0014\u0003TBA\u0011\u0011\u0019Bk\u0003\u007f\u0013Y$\u0003\u0003\u0003X\u0006E'aA'ba\"9!1\u001c\u0001\u0005\u0002\u0005=\u0013A\t;fgR,\u0015/^1mg^KG\u000f\u001b'ji\u0016\u0014\u0018\r\\(g\u001dVlWM]5d)f\u0004X\r\u000b\u0003\u0003Z\n}\u0007\u0003BA+\u0005CLAAa9\u0002X\t!A+Z:u\u0011\u001d\u00119\u000f\u0001C\u0001\u0003\u001f\n\u0011\u0005^3ti\u0016\u000bX/\u00197t/&$\b\u000eT5uKJ\fGn\u00144TiJLgn\u001a+za\u0016DCA!:\u0003`\"9!Q\u001e\u0001\u0005\u0002\u0005=\u0013A\t;fgR,\u0015/^1mg^KG\u000f\u001b'ji\u0016\u0014\u0018\r\\(g\u0005>|G.Z1o)f\u0004X\r\u000b\u0003\u0003l\n}\u0007b\u0002Bz\u0001\u0011\u0005\u0011qJ\u0001 i\u0016\u001cH/R9vC2\u001cx+\u001b;i\u0019&$XM]1m\u001f\u001a$\u0015\r^3UsB,\u0007\u0006\u0002By\u0005?DqA!?\u0001\t\u0003\ty%A\u0010uKN$X)];bYN<\u0016\u000e\u001e5MSR,'/\u00197PMRKW.\u001a+za\u0016DCAa>\u0003`\"9!q \u0001\u0005\u0002\u0005=\u0013\u0001\n;fgR,\u0015/^1mg^KG\u000f\u001b'ji\u0016\u0014\u0018\r\\(g)&lWm\u001d;b[B$\u0016\u0010]3)\t\tu(q\u001c\u0005\b\u0007\u000b\u0001A\u0011AA(\u0003a!Xm\u001d;FcV\fGn],ji\"|W\u000f\u001e'ji\u0016\u0014\u0018\r\u001c\u0015\u0005\u0007\u0007\u0011y\u000eC\u0004\u0004\f\u0001!\t!a\u0014\u00021Q,7\u000f\u001e(pi\u0016\u000bX/\u00197t/&$\b\u000eT5uKJ\fG\u000e\u000b\u0003\u0004\n\t}\u0007bBB\t\u0001\u0011\u0005\u0011qJ\u0001&i\u0016\u001cHoQ8na\u0006\u0014\u0018n]8o/&$\b\u000eT5uKJ\fGn\u00144TiJLgn\u001a+za\u0016DCaa\u0004\u0003`\"91q\u0003\u0001\u0005\u0002\u0005=\u0013A\u0007;fgR<%/Z1uKJ$\u0006.\u00198XSRDG*\u001b;fe\u0006d\u0007\u0006BB\u000b\u0005?Dqa!\b\u0001\t\u0003\ty%A\u000fuKN$xI]3bi\u0016\u0014H\u000b[1o/&$\bn\\;u\u0019&$XM]1mQ\u0011\u0019YBa8\t\u000f\r\r\u0002\u0001\"\u0001\u0002P\u0005!C/Z:u\u000fJ,\u0017\r^3s)\"\fgn\u0014:FcV\fGn\u001d+p/&$\b\u000eT5uKJ\fG\u000e\u000b\u0003\u0004\"\t}\u0007bBB\u0015\u0001\u0011\u0005\u0011qJ\u0001(i\u0016\u001cHo\u0012:fCR,'\u000f\u00165b]>\u0013X)];bYN$vnV5uQ>,H\u000fT5uKJ\fG\u000e\u000b\u0003\u0004(\t}\u0007bBB\u0018\u0001\u0011\u0005\u0011qJ\u0001\u0018i\u0016\u001cH\u000fT3tgRC\u0017M\\,ji\"d\u0015\u000e^3sC2DCa!\f\u0003`\"91Q\u0007\u0001\u0005\u0002\u0005=\u0013A\u0007;fgRdUm]:UQ\u0006tw+\u001b;i_V$H*\u001b;fe\u0006d\u0007\u0006BB\u001a\u0005?Dqaa\u000f\u0001\t\u0003\ty%A\u0011uKN$H*Z:t)\"\fgn\u0014:FcV\fGn\u001d+p/&$\b\u000eT5uKJ\fG\u000e\u000b\u0003\u0004:\t}\u0007bBB!\u0001\u0011\u0005\u0011qJ\u0001%i\u0016\u001cH\u000fT3tgRC\u0017M\\(s\u000bF,\u0018\r\\:U_^KG\u000f[8vi2KG/\u001a:bY\"\"1q\bBp\u0011\u001d\u00199\u0005\u0001C\u0001\u0003\u001f\n\u0001\u0002^3ti2K7.\u001a\u0015\u0005\u0007\u000b\u0012y\u000eC\u0004\u0004N\u0001!\t!a\u0014\u0002\u0015Q,7\u000f^%t\u001dVdG\u000e\u000b\u0003\u0004L\t}\u0007bBB*\u0001\u0011\u0005\u0011qJ\u0001\u000ei\u0016\u001cH/S:O_RtU\u000f\u001c7)\t\rE#q\u001c\u0005\b\u00073\u0002A\u0011AA(\u0003\u0019!Xm\u001d;J]\"\"1q\u000bBp\u0011\u001d\u0019y\u0006\u0001C\u0001\u0003\u001f\nq\u0001^3ti\u0006sG\r\u000b\u0003\u0004^\t}\u0007bBB3\u0001\u0011\u0005\u0011qJ\u0001\u0007i\u0016\u001cHo\u0014:)\t\r\r$q\u001c\u0005\b\u0007W\u0002A\u0011AA(\u0003\u001d!Xm\u001d;O_RDCa!\u001b\u0003`\"91\u0011\u000f\u0001\u0005\u0002\u0005=\u0013\u0001\u0004;fgR\fe\u000eZ(s\u001d>$\b\u0006BB8\u0005?Dqaa\u001e\u0001\t\u0003\ty%\u0001\u000buKN$\bK]3eS\u000e\fG/Z,ji\",FM\u001a\u0015\u0005\u0007k\u0012y\u000eC\u0004\u0004~\u0001!\t!a\u0014\u0002GQ,7\u000f^*fY\u0016\u001cG/\u001b<jif<\u0016\u000e\u001e5TC6,'+\u001a=J]B,HOU3gg\"\"11\u0010Bp\u0011\u001d\u0019\u0019\t\u0001C\u0001\u0003\u001f\n\u0001\u0007^3tiN+G.Z2uSZLG/_,ji\"\u001c\u0016-\\3SKbLe\u000e];u%\u001647/\u00118e'R\u0014\u0018N\\4UsB,\u0007\u0006BBA\u0005?D\u0011b!#\u0001#\u0003%Iaa#\u0002%5|7m[*dC:$C-\u001a4bk2$H%M\u000b\u0003\u0007\u001bSC!!\u001d\u0004\u0010.\u00121\u0011\u0013\t\u0005\u0007'\u001bi*\u0004\u0002\u0004\u0016*!1qSBM\u0003%)hn\u00195fG.,GMC\u0002\u0004\u001cR\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0019yj!&\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0004$\u0002\t\n\u0011\"\u0003\u0004&\u0006Y2M]3bi\u0016\u001cu\u000e\\;n]N#\u0018\r^:%I\u00164\u0017-\u001e7uIE*\"aa*+\t\t-3q\u0012\u0005\n\u0007W\u0003\u0011\u0013!C\u0005\u0007K\u000b1d\u0019:fCR,7i\u001c7v[:\u001cF/\u0019;tI\u0011,g-Y;mi\u0012\u0012\u0004\"CBX\u0001E\u0005I\u0011BBY\u0003m\u0019'/Z1uK\u000e{G.^7o'R\fGo\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u001111\u0017\u0016\u0005\u0005w\u001ay\tC\u0005\u00048\u0002\t\n\u0011\"\u0003\u0004:\u0006Y2M]3bi\u0016\u001cu\u000e\\;n]N#\u0018\r^:%I\u00164\u0017-\u001e7uIQ*\"aa/+\t\t\u001d5q\u0012\u0005\n\u0007\u007f\u0003\u0011\u0013!C\u0005\u0007\u0003\f1d\u0019:fCR,7i\u001c7v[:\u001cF/\u0019;tI\u0011,g-Y;mi\u0012*TCABbU\u0011\u0019)ma$\u0011\u000bM\u0011iea21\t\r%7Q\u001a\t\u0006O\te51\u001a\t\u0005\u0005?\u001bi\r\u0002\u0007\u0003$\u000eu\u0016\u0011!A\u0001\u0006\u0003\u0011)\u000bC\u0005\u0004R\u0002\t\n\u0011\"\u0003\u0004T\u0006Y2M]3bi\u0016\u001cu\u000e\\;n]N#\u0018\r^:%I\u00164\u0017-\u001e7uIY*\"a!6+\t\r]7q\u0012\t\u0006'\t53\u0011\u001c\u0019\u0005\u00077\u001cy\u000eE\u0003(\u00053\u001bi\u000e\u0005\u0003\u0003 \u000e}G\u0001\u0004Ba\u0007\u001f\f\t\u0011!A\u0003\u0002\t\u0015\u0006\"CBr\u0001E\u0005I\u0011BBS\u0003y\u0019'/Z1uK\u001ac\u0017N\\6Ti\u0006$\u0018n\u001d;jG\u0012\"WMZ1vYR$\u0013\u0007C\u0005\u0004h\u0002\t\n\u0011\"\u0003\u0004j\u0006q2M]3bi\u00164E.\u001b8l'R\fG/[:uS\u000e$C-\u001a4bk2$HEM\u000b\u0003\u0007WTCA!5\u0004\u0010\u001e91q\u001e\u0002\t\u0002\rE\u0018\u0001G*fY\u0016\u001cG/\u001b<jif,5\u000f^5nCR|'\u000fV3tiB\u0019Ada=\u0007\r\u0005\u0011\u0001\u0012AB{'\r\u0019\u0019P\u0005\u0005\b3\rMH\u0011AB})\t\u0019\t\u0010\u0003\u0005\u0004~\u000eMH\u0011AA(\u0003%\u0011WMZ8sK\u0006cG\u000e\u000b\u0003\u0004|\u0012\u0005\u0001\u0003BA+\t\u0007IA\u0001\"\u0002\u0002X\tI!)\u001a4pe\u0016\fE\u000e\u001c")
public class SelectivityEstimatorTest {
    private final Seq<String> allFieldNames = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "amount", "price", "flag", "partition", "date_col", "time_col", "timestamp_col"}));
    private final Seq<SqlTypeName> allFieldTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SqlTypeName[]{SqlTypeName.VARCHAR, SqlTypeName.INTEGER, SqlTypeName.DOUBLE, SqlTypeName.BOOLEAN, SqlTypeName.VARCHAR, SqlTypeName.DATE, SqlTypeName.TIME, SqlTypeName.TIMESTAMP}));
    private final /* synthetic */ Tuple8 x$1;
    private final int name_idx;
    private final int amount_idx;
    private final int price_idx;
    private final int flag_idx;
    private final int partition_idx;
    private final int date_idx;
    private final int time_idx;
    private final int timestamp_idx;
    private final FlinkTypeFactory typeFactory;
    private FlinkRexBuilder rexBuilder;
    private final RelDataType relDataType;
    private final FlinkRelMetadataQuery mq;
    private TableScan scan;

    @BeforeAll
    public static void beforeAll() {
        SelectivityEstimatorTest$.MODULE$.beforeAll();
    }

    private Seq<String> allFieldNames() {
        return this.allFieldNames;
    }

    private Seq<SqlTypeName> allFieldTypes() {
        return this.allFieldTypes;
    }

    public int name_idx() {
        return this.name_idx;
    }

    public int amount_idx() {
        return this.amount_idx;
    }

    public int price_idx() {
        return this.price_idx;
    }

    public int flag_idx() {
        return this.flag_idx;
    }

    public int partition_idx() {
        return this.partition_idx;
    }

    public int date_idx() {
        return this.date_idx;
    }

    public int time_idx() {
        return this.time_idx;
    }

    public int timestamp_idx() {
        return this.timestamp_idx;
    }

    public FlinkTypeFactory typeFactory() {
        return this.typeFactory;
    }

    public FlinkRexBuilder rexBuilder() {
        return this.rexBuilder;
    }

    public void rexBuilder_$eq(FlinkRexBuilder x$1) {
        this.rexBuilder = x$1;
    }

    public RelDataType relDataType() {
        return this.relDataType;
    }

    public FlinkRelMetadataQuery mq() {
        return this.mq;
    }

    public TableScan scan() {
        return this.scan;
    }

    public void scan_$eq(TableScan x$1) {
        this.scan = x$1;
    }

    @BeforeEach
    public void setup() {
        this.scan_$eq(this.mockScan(this.mockScan$default$1()));
    }

    private TableScan mockScan(FlinkStatistic statistic) {
        SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)true, (boolean)false).plus();
        MockMetaTable table = new MockMetaTable(this.relDataType(), statistic);
        rootSchema.add("test", (Table)table);
        PlannerContext plannerContext = PlannerMocks.newBuilder().withRootSchema(CalciteSchema.from((SchemaPlus)rootSchema)).build().getPlannerContext();
        FlinkRelBuilder relBuilder = plannerContext.createRelBuilder();
        relBuilder.clear();
        return (TableScan)relBuilder.scan(Arrays.asList((Object[])new String[]{"test"})).build();
    }

    private FlinkStatistic mockScan$default$1() {
        return FlinkStatistic$.MODULE$.UNKNOWN();
    }

    private RexLiteral createNumericLiteral(long num) {
        return this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(num));
    }

    private RexLiteral createNumericLiteral(double num) {
        return this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(num));
    }

    private RexLiteral createBooleanLiteral(boolean b) {
        return this.rexBuilder().makeLiteral(b);
    }

    private RexLiteral createStringLiteral(String str) {
        return this.rexBuilder().makeLiteral(str);
    }

    private RexLiteral createDateLiteral(String str) {
        return this.rexBuilder().makeDateLiteral(new DateString(str));
    }

    private RexLiteral createTimeLiteral(String str) {
        return this.rexBuilder().makeTimeLiteral(new TimeString(str), 0);
    }

    private RexLiteral createTimeStampLiteral(long millis) {
        return this.rexBuilder().makeTimestampLiteral(TimestampString.fromMillisSinceEpoch((long)millis), 0);
    }

    private RexInputRef createInputRef(int index) {
        return this.createInputRefWithNullability(index, false);
    }

    private RexInputRef createInputRefWithNullability(int index, boolean isNullable) {
        RelDataType relDataType = this.typeFactory().createSqlType((SqlTypeName)this.allFieldTypes().apply(index));
        RelDataType relDataTypeWithNullability = this.typeFactory().createTypeWithNullability(relDataType, isNullable);
        return this.rexBuilder().makeInputRef(relDataTypeWithNullability, index);
    }

    private RexNode createCall(SqlOperator operator, Seq<RexNode> exprs) {
        Preconditions.checkArgument((boolean)exprs.nonEmpty());
        return this.rexBuilder().makeCall(operator, (RexNode[])exprs.toArray(ClassTag$.MODULE$.apply(RexNode.class)));
    }

    private RexNode createCast(RexNode expr) {
        RelDataType relDataType = this.typeFactory().createSqlType((SqlTypeName)this.allFieldTypes().apply(1));
        return this.rexBuilder().makeCast(relDataType, expr);
    }

    private ColumnStats createColumnStats(Option<Long> ndv, Option<Long> nullCount, Option<Double> avgLen, Option<Integer> maxLen, Option<Comparable<?>> min, Option<Comparable<?>> max) {
        return ColumnStats.Builder.builder().setNdv((Long)ndv.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setNullCount((Long)nullCount.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setAvgLen((Double)avgLen.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setMaxLen((Integer)maxLen.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setMax((Comparable)max.orNull(Predef$.MODULE$.$conforms())).setMin((Comparable)min.orNull(Predef$.MODULE$.$conforms())).build();
    }

    private Option<Long> createColumnStats$default$1() {
        return None$.MODULE$;
    }

    private Option<Long> createColumnStats$default$2() {
        return None$.MODULE$;
    }

    private Option<Double> createColumnStats$default$3() {
        return None$.MODULE$;
    }

    private Option<Integer> createColumnStats$default$4() {
        return None$.MODULE$;
    }

    private Option<Comparable<?>> createColumnStats$default$5() {
        return None$.MODULE$;
    }

    private Option<Comparable<?>> createColumnStats$default$6() {
        return None$.MODULE$;
    }

    private FlinkStatistic createFlinkStatistic(Option<Long> rowCount, Option<scala.collection.immutable.Map<String, ColumnStats>> colStats) {
        Predef$.MODULE$.require(rowCount.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "rowCount requires not null now");
        TableStats tableStats = colStats.isDefined() ? new TableStats(Predef$.MODULE$.Long2long((Long)rowCount.get()), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)colStats.get()).asJava()) : new TableStats(Predef$.MODULE$.Long2long((Long)rowCount.get()), null);
        return FlinkStatistic$.MODULE$.builder().tableStats(tableStats).build();
    }

    private Option<Long> createFlinkStatistic$default$1() {
        return None$.MODULE$;
    }

    private Option<scala.collection.immutable.Map<String, ColumnStats>> createFlinkStatistic$default$2() {
        return None$.MODULE$;
    }

    @Test
    public void testEqualsWithLiteralOfNumericType() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0125)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(5L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator3 = new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq());
        Assertions.assertEquals((Object)estimator3.defaultEqualsSelectivity(), (Object)estimator3.evaluate(predicate1));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        SelectivityEstimator estimator4 = new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0125)), (Object)estimator4.evaluate(predicate1));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic4 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator5 = new SelectivityEstimator((RelNode)this.mockScan(statistic4), this.mq());
        Assertions.assertEquals((Object)estimator5.defaultEqualsSelectivity(), (Object)estimator5.evaluate(predicate1));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator5.evaluate(predicate2));
    }

    @Test
    public void testEqualsWithLiteralOfStringType() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("abc")}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(1000L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(800L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)new Some((Object)"aaa"), (Option<Comparable<?>>)new Some((Object)"max")))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.00125)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("xyz")}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
    }

    @Test
    public void testEqualsWithLiteralOfBooleanType() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.flag_idx()), this.createBooleanLiteral(true)}));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.flag_idx()), this.createBooleanLiteral(true)}));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.flag_idx()), this.createBooleanLiteral(false)}));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.flag_idx()), this.createBooleanLiteral(false)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)estimator1.evaluate(predicate1));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultEqualsSelectivity().get())))), (Object)estimator1.evaluate(predicate2));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultEqualsSelectivity().get())))), (Object)estimator1.evaluate(predicate3));
        Assertions.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)estimator1.evaluate(predicate4));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(1000L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flag"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(2L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(1)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.boolean2Boolean(false)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.boolean2Boolean(true))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.flag_idx()), this.createBooleanLiteral(false)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator2.evaluate(predicate5));
    }

    @Test
    public void testEqualsWithLiteralOfDateType() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.date_idx()), this.createDateLiteral("2017-10-11")}));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"date_col"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)None$.MODULE$, (Option<Integer>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Date.valueOf("2017-10-01")), (Option<Comparable<?>>)new Some((Object)Date.valueOf("2018-10-01"))))}))));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0125)), (Object)estimator.evaluate(predicate));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.date_idx()), this.createDateLiteral("2018-10-02")}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator.evaluate(predicate2));
    }

    @Test
    public void testEqualsWithLiteralOfTimeType() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.time_idx()), this.createTimeLiteral("11:00:00")}));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"time_col"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)None$.MODULE$, (Option<Integer>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Time.valueOf("10:00:00")), (Option<Comparable<?>>)new Some((Object)Time.valueOf("12:00:00"))))}))));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0125)), (Object)estimator.evaluate(predicate));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.time_idx()), this.createTimeLiteral("13:00:00")}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator.evaluate(predicate2));
    }

    @Test
    public void testEqualsWithLiteralOfTimestampType() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.timestamp_idx()), this.createTimeStampLiteral(1000L)}));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestamp_col"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)None$.MODULE$, (Option<Integer>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)new Timestamp(0L)), (Option<Comparable<?>>)new Some((Object)new Timestamp(2000L))))}))));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0125)), (Object)estimator.evaluate(predicate));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.timestamp_idx()), this.createTimeStampLiteral(3000L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator.evaluate(predicate2));
    }

    @Test
    public void testEqualsWithoutLiteral() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createInputRef(this.price_idx())}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)estimator1.evaluate(predicate));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(19)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq()).evaluate(predicate));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq()).evaluate(predicate));
        FlinkStatistic statistic4 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic4), this.mq()).evaluate(predicate));
        FlinkStatistic statistic5 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic5), this.mq()).evaluate(predicate));
    }

    @Test
    public void testNotEqualsWithLiteral() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultEqualsSelectivity().get())))), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.9875)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(5L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator2.evaluate(predicate2));
    }

    @Test
    public void testComparisonWithLiteralOfStringType() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("abc")}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator1.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(1000L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(800L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)new Some((Object)"aaa"), (Option<Comparable<?>>)new Some((Object)"max")))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assertions.assertEquals((Object)estimator2.defaultComparisonSelectivity(), (Object)estimator2.evaluate(predicate));
    }

    @Test
    public void testGreaterThanWithLiteral() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator1.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(200L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(5L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.7894736842105263)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(10L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.99)), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createNumericLiteral(50L), this.createInputRef(this.amount_idx())}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.21052631578947367)), (Object)estimator2.evaluate(predicate5));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator3 = new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator3.evaluate(predicate2));
        Assertions.assertEquals((Object)estimator3.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate3));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator4 = new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator4.evaluate(predicate2));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator4.evaluate(predicate3));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.7894736842105263)), (Object)estimator4.evaluate(predicate1));
    }

    @Test
    public void testGreaterThanWithoutLiteral() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createInputRef(this.price_idx())}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator.defaultComparisonSelectivity(), (Object)estimator.evaluate(predicate));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(19))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq()).evaluate(predicate));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq()).evaluate(predicate));
        FlinkStatistic statistic4 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic4), this.mq()).evaluate(predicate));
        FlinkStatistic statistic5 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(11)), (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic5), this.mq()).evaluate(predicate));
        FlinkStatistic statistic6 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic6), this.mq()).evaluate(predicate));
    }

    @Test
    public void testGreaterThanOrEqualsToWithLiteral() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator1.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(201L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(10L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.7894736842105263)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(200L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.01)), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createNumericLiteral(50L), this.createInputRef(this.amount_idx())}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.21052631578947367)), (Object)estimator2.evaluate(predicate5));
    }

    @Test
    public void testGreaterThanOrEqualsToWithoutLiteral() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createInputRef(this.price_idx())}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator1.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(19)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq()).evaluate(predicate));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq()).evaluate(predicate));
    }

    @Test
    public void testLessThanWithLiteral() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator1.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(10L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(201L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.21052631578947367)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(200L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.99)), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createNumericLiteral(50L), this.createInputRef(this.amount_idx())}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.7894736842105263)), (Object)estimator2.evaluate(predicate5));
    }

    @Test
    public void testLessThanWithoutLiteral() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createInputRef(this.price_idx())}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator.defaultComparisonSelectivity(), (Object)estimator.evaluate(predicate));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(1)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(19)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq()).evaluate(predicate));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(1)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(19)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq()).evaluate(predicate));
        FlinkStatistic statistic4 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic4), this.mq()).evaluate(predicate));
    }

    @Test
    public void testLessThanOrEqualsToWithLiteral() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator1.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(9L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(200L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator2.evaluate(predicate3));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.21052631578947367)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(10L)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.01)), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createNumericLiteral(50L), this.createInputRef(this.amount_idx())}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.7894736842105263)), (Object)estimator2.evaluate(predicate5));
    }

    @Test
    public void testLessThanOrEqualsToWithoutLiteral() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createInputRef(this.price_idx())}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator.defaultComparisonSelectivity(), (Object)estimator.evaluate(predicate));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(9))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(1)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq()).evaluate(predicate));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq()).evaluate(predicate));
    }

    @Test
    public void testLike() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.LIKE, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("ross")}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator.defaultLikeSelectivity(), (Object)estimator.evaluate(predicate));
    }

    @Test
    public void testIsNull() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.IS_NULL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRefWithNullability(this.name_idx(), true)}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)estimator.defaultIsNullSelectivity(), (Object)estimator.evaluate(predicate));
        ColumnStats colStats = this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$);
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)colStats)}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate));
    }

    @Test
    public void testIsNotNull() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx())}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator.evaluate(predicate));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRefWithNullability(this.name_idx(), true)}));
        Assertions.assertEquals((Object)estimator.defaultIsNotNullSelectivity(), (Object)estimator.evaluate(predicate2));
        ColumnStats colStats = this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$);
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)colStats)}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.9)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate2));
    }

    @Test
    public void testIn() {
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        RexNode predicate1 = this.rexBuilder().makeIn((RexNode)this.createInputRef(this.name_idx()), Arrays.asList((Object[])new RexLiteral[]{this.createStringLiteral("abc"), this.createStringLiteral("def")}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)estimator.defaultEqualsSelectivity().get()) * (double)2))), (Object)estimator.evaluate(predicate1));
        RexNode predicate2 = this.rexBuilder().makeIn((RexNode)this.createInputRef(this.amount_idx()), Arrays.asList((Object[])new RexLiteral[]{this.createNumericLiteral(10.0), this.createNumericLiteral(20.0), this.createNumericLiteral(30.0), this.createNumericLiteral(40.0)}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)estimator.defaultEqualsSelectivity().get()) * (double)4))), (Object)estimator.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(50)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq()).evaluate(predicate2));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(15)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0375)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq()).evaluate(predicate2));
        FlinkStatistic statistic4 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(50)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic4), this.mq()).evaluate(predicate2));
        FlinkStatistic statistic5 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)estimator.defaultEqualsSelectivity().get()) * (double)4))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic5), this.mq()).evaluate(predicate2));
        FlinkStatistic statistic6 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(40L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic6), this.mq()).evaluate(predicate2));
    }

    @Test
    public void testAnd() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(6.5)}))}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        double selectivity = BoxesRunTime.unboxToDouble((Object)estimator.defaultComparisonSelectivity().get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(selectivity * selectivity))), (Object)estimator.evaluate(predicate));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(8))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.05263157894736842)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate));
    }

    @Test
    public void testOr() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(6.5)}))}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        double selectivity = BoxesRunTime.unboxToDouble((Object)estimator.defaultComparisonSelectivity().get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(selectivity * (double)2 - selectivity * selectivity))), (Object)estimator.evaluate(predicate));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(8))))}))));
        double leftSelectivity = 0.21052631578947367;
        double rightSelectivity = 0.25;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(leftSelectivity + rightSelectivity - leftSelectivity * rightSelectivity))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate));
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(60L)}))}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.025)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate1));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(60L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(70L)}))}));
        double inSelectivity = 0.025;
        double greaterThan70Selectivity = 0.6842105263157895;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(inSelectivity + greaterThan70Selectivity - inSelectivity * greaterThan70Selectivity))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(80L)}))}));
        double lessThan50Selectivity = 0.21052631578947367;
        double greaterThan80Selectivity = 0.631578947368421;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(lessThan50Selectivity + greaterThan80Selectivity))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate3));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createNumericLiteral(50L), this.createInputRef(this.amount_idx())})), this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(60L)})), this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createNumericLiteral(70L), this.createInputRef(this.amount_idx())})), this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(5L)})), this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(3L)}))}));
        double inSelectivity1 = 0.025;
        double lessThan70Selectivity = 0.6842105263157895;
        double priceSelectivity = 0.18666666666666665;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(inSelectivity1 + lessThan70Selectivity + priceSelectivity - inSelectivity1 * lessThan70Selectivity * priceSelectivity))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate4));
    }

    @Test
    public void testNot() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.NOT, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}))}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator.defaultComparisonSelectivity().get())))), (Object)estimator.evaluate(predicate));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.7894736842105263)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate));
    }

    @Test
    public void testAndOrNot() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("abc")})), this.createCall((SqlOperator)SqlStdOperatorTable.NOT, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(4.5)}))}))}))}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        double accountSelectivity1 = BoxesRunTime.unboxToDouble((Object)estimator1.defaultComparisonSelectivity().get());
        double nameSelectivity1 = BoxesRunTime.unboxToDouble((Object)estimator1.defaultEqualsSelectivity().get());
        double notPriceSelectivity1 = 1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultComparisonSelectivity().get());
        double selectivity1 = accountSelectivity1 * (nameSelectivity1 + notPriceSelectivity1 - nameSelectivity1 * notPriceSelectivity1);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)selectivity1)), (Object)estimator1.evaluate(predicate));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(8))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        double accountSelectivity2 = 0.21052631578947367;
        double nameSelectivity2 = BoxesRunTime.unboxToDouble((Object)estimator2.defaultEqualsSelectivity().get());
        double notPriceSelectivity2 = 0.5833333333333334;
        double selectivity2 = accountSelectivity2 * (nameSelectivity2 + notPriceSelectivity2 - nameSelectivity2 * notPriceSelectivity2);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)selectivity2)), (Object)estimator2.evaluate(predicate));
    }

    @Test
    public void testPredicateWithUdf() {
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.ABS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx())})), this.createNumericLiteral(50L)}));
        Assertions.assertEquals((Object)estimator.defaultComparisonSelectivity(), (Object)estimator.evaluate(predicate1));
    }

    @Test
    public void testSelectivityWithSameRexInputRefs() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(45L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(40L)}))}));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(45L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(40L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(4.5)})), this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(5L)}))}));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(45L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(40L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(4.5)})), this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCast((RexNode)this.createInputRef(this.price_idx())), this.createNumericLiteral(5L)}))}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        double selectivity = BoxesRunTime.unboxToDouble((Object)estimator.defaultComparisonSelectivity().get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(selectivity * selectivity))), (Object)estimator.evaluate(predicate1));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(selectivity * selectivity * selectivity * selectivity))), (Object)estimator.evaluate(predicate2));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(100)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(8))))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.05)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate1));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.004166666666666667)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate2));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(0.02916666666666667 * selectivity))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate3));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(120L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(80L)}))}));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.2)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate4));
    }

    @Test
    public void testSelectivityWithSameRexInputRefsAndStringType() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("abc")})), this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("test")}))}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        double selectivity = BoxesRunTime.unboxToDouble((Object)estimator.defaultComparisonSelectivity().get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(selectivity * selectivity))), (Object)estimator.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(1000L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(800L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)new Some((Object)"aaa"), (Option<Comparable<?>>)new Some((Object)"max")))}))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(selectivity * selectivity))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate1));
    }

    public SelectivityEstimatorTest() {
        Tuple8 tuple8 = new Tuple8((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToInteger((int)7));
        if (tuple8 == null) {
            throw new MatchError((Object)tuple8);
        }
        int name_idx = BoxesRunTime.unboxToInt((Object)tuple8._1());
        int amount_idx = BoxesRunTime.unboxToInt((Object)tuple8._2());
        int price_idx = BoxesRunTime.unboxToInt((Object)tuple8._3());
        int flag_idx = BoxesRunTime.unboxToInt((Object)tuple8._4());
        int partition_idx = BoxesRunTime.unboxToInt((Object)tuple8._5());
        int date_idx = BoxesRunTime.unboxToInt((Object)tuple8._6());
        int time_idx = BoxesRunTime.unboxToInt((Object)tuple8._7());
        int timestamp_idx = BoxesRunTime.unboxToInt((Object)tuple8._8());
        Tuple8 tuple82 = new Tuple8((Object)BoxesRunTime.boxToInteger((int)name_idx), (Object)BoxesRunTime.boxToInteger((int)amount_idx), (Object)BoxesRunTime.boxToInteger((int)price_idx), (Object)BoxesRunTime.boxToInteger((int)flag_idx), (Object)BoxesRunTime.boxToInteger((int)partition_idx), (Object)BoxesRunTime.boxToInteger((int)date_idx), (Object)BoxesRunTime.boxToInteger((int)time_idx), (Object)BoxesRunTime.boxToInteger((int)timestamp_idx));
        this.x$1 = tuple82;
        this.name_idx = BoxesRunTime.unboxToInt((Object)this.x$1._1());
        this.amount_idx = BoxesRunTime.unboxToInt((Object)this.x$1._2());
        this.price_idx = BoxesRunTime.unboxToInt((Object)this.x$1._3());
        this.flag_idx = BoxesRunTime.unboxToInt((Object)this.x$1._4());
        this.partition_idx = BoxesRunTime.unboxToInt((Object)this.x$1._5());
        this.date_idx = BoxesRunTime.unboxToInt((Object)this.x$1._6());
        this.time_idx = BoxesRunTime.unboxToInt((Object)this.x$1._7());
        this.timestamp_idx = BoxesRunTime.unboxToInt((Object)this.x$1._8());
        this.typeFactory = new FlinkTypeFactory(Thread.currentThread().getContextClassLoader(), FlinkTypeFactory$.MODULE$.$lessinit$greater$default$2());
        this.rexBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        this.relDataType = this.typeFactory().createStructType((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.allFieldTypes().map((Function1 & Serializable & scala.Serializable)typeName -> this.typeFactory().createSqlType(typeName), Seq$.MODULE$.canBuildFrom())).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.allFieldNames()).asJava());
        this.mq = FlinkRelMetadataQuery.instance();
    }
}

