/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.operator;

import java.util.Optional;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.TemporalTableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.nodes.exec.operator.OperatorNameTestBase;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.table.planner.utils.TestLegacyFilterableTableSource;
import org.apache.flink.table.planner.utils.Top3;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import scala.Option;
import scala.collection.immutable.List;

class StreamOperatorNameTest
extends OperatorNameTestBase {
    private StreamTableTestUtil util;

    StreamOperatorNameTest() {
    }

    @Override
    protected TableTestUtil getTableTestUtil() {
        return this.streamTestUtil(TableConfig.getDefault());
    }

    @Override
    @BeforeEach
    void setup() {
        super.setup();
        this.util = (StreamTableTestUtil)((OperatorNameTestBase)this).util;
    }

    @TestTemplate
    void testDropUpdateBefore() {
        this.util.getStreamEnv().setParallelism(2);
        String srcTableDdl = "CREATE TABLE MyTable (\n  a bigint,\n  b int not null,\n  c varchar,\n  d bigint not null,\n  primary key(a, b) NOT ENFORCED\n) with (\n  'connector' = 'values',\n  'changelog-mode' = 'I,UA,UB,D',\n  'bounded' = 'false')";
        this.tEnv.executeSql(srcTableDdl);
        String sinkTableDdl = "CREATE TABLE MySink (\n  c varchar,\n  a bigint,\n  b int not null,\n  primary key(a, b) NOT ENFORCED\n) with (\n  'connector' = 'values',\n  'sink-insert-only' = 'false',\n  'sink-changelog-mode-enforced' = 'I,UA,D',  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        this.verifyInsert("insert into MySink select c, a, b from MyTable");
    }

    @TestTemplate
    void testChangelogNormalize() throws Exception {
        this.util.getStreamEnv().setParallelism(2);
        String srcTableDdl = "CREATE TABLE MyTable (\n  a bigint,\n  b int not null,\n  c varchar,\n  d bigint not null,\n  primary key(a, b) NOT ENFORCED\n) with (\n  'connector' = 'values',\n  'changelog-mode' = 'I,UA,D',\n  'bounded' = 'false')";
        this.tEnv.executeSql(srcTableDdl);
        String sinkTableDdl = "CREATE TABLE MySink (\n  c varchar,\n  a bigint,\n  b int not null,\n  primary key(a) NOT ENFORCED\n) with (\n  'connector' = 'values',\n  'sink-insert-only' = 'false',\n  'sink-changelog-mode-enforced' = 'I,UA,D',  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        this.verifyInsert("insert into MySink select c, a, b from MyTable");
    }

    @TestTemplate
    void testDeduplicate() {
        this.createSourceWithTimeAttribute();
        this.verifyQuery("SELECT a, b, c FROM (SELECT *,     ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime ASC) AS rk FROM MyTable) t WHERE rk = 1");
    }

    @TestTemplate
    void testIncrementalAggregate() {
        this.util.enableMiniBatch();
        this.tEnv.getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)true);
        this.createTestSource();
        this.verifyQuery("SELECT a, count(distinct b) as b FROM MyTable GROUP BY a");
    }

    @TestTemplate
    void testGroupAggregate() {
        this.testGroupAggregateInternal();
    }

    @TestTemplate
    void testTableGroupAggregate() {
        DataStreamSource dataStream = this.util.getStreamEnv().fromElements((Object[])new Integer[]{1, 2, 3, 4, 5});
        TableTestUtil.createTemporaryView(this.tEnv, "MySource", dataStream, (Option<Expression[]>)JavaScalaConversionUtil.toScala(Optional.empty()), (Option<boolean[]>)JavaScalaConversionUtil.toScala(Optional.empty()), (Option<FlinkStatistic>)JavaScalaConversionUtil.toScala(Optional.empty()));
        this.tEnv.createTemporaryFunction("top3", (UserDefinedFunction)new Top3());
        this.tEnv.createTemporaryView("MyTable", this.tEnv.from("MySource").flatAggregate((Expression)Expressions.call(Top3.class, (Object[])new Object[]{Expressions.$((String)"f0")})).select(new Expression[]{Expressions.$((String)"f0"), Expressions.$((String)"f1")}));
        this.verifyQuery("SELECT * FROM MyTable");
    }

    @TestTemplate
    void testIntervalJoin() {
        this.createSourceWithTimeAttribute("A");
        this.createSourceWithTimeAttribute("B");
        this.verifyQuery("SELECT t1.a, t2.b FROM A t1 JOIN B t2 ON\n    t1.a = t2.a AND \n    t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR");
    }

    @TestTemplate
    void testIntervalJoinNegativeWindow() {
        this.createSourceWithTimeAttribute("A");
        this.createSourceWithTimeAttribute("B");
        this.verifyQuery("SELECT t1.a, t2.b FROM A t1 LEFT JOIN B t2 ON\n    t1.a = t2.a AND \n    t1.proctime BETWEEN t2.proctime + INTERVAL '2' HOUR AND t2.proctime + INTERVAL '1' HOUR");
    }

    @TestTemplate
    void testJoin() {
        this.testJoinInternal();
    }

    @TestTemplate
    void testMatch() {
        this.createSourceWithTimeAttribute();
        String sql = "SELECT T.aid, T.bid, T.cid\n     FROM MyTable MATCH_RECOGNIZE (\n             ORDER BY proctime\n             MEASURES\n             `A\"`.a AS aid,\n             l.a AS bid,\n             C.a AS cid\n             PATTERN (`A\"` l C)\n             DEFINE\n                 `A\"` AS a = 1,\n                 l AS b = 2,\n                 C AS c = 'c'\n     ) AS T";
        this.verifyQuery(sql);
    }

    @TestTemplate
    void testTemporalJoin() {
        this.tEnv.executeSql("CREATE TABLE Orders (\n amount INT,\n currency STRING,\n rowtime TIMESTAMP(3),\n proctime AS PROCTIME(),\n WATERMARK FOR rowtime AS rowtime\n) WITH (\n 'connector' = 'values'\n)");
        this.tEnv.executeSql("CREATE TABLE RatesHistory (\n currency STRING,\n rate INT,\n rowtime TIMESTAMP(3),\n WATERMARK FOR rowtime AS rowtime,\n PRIMARY KEY(currency) NOT ENFORCED\n) WITH (\n 'connector' = 'values'\n)");
        TemporalTableFunction ratesHistory = this.tEnv.from("RatesHistory").createTemporalTableFunction((Expression)Expressions.$((String)"rowtime"), (Expression)Expressions.$((String)"currency"));
        this.tEnv.createTemporarySystemFunction("Rates", (UserDefinedFunction)ratesHistory);
        this.verifyQuery("SELECT amount * r.rate FROM Orders AS o,  LATERAL TABLE (Rates(o.rowtime)) AS r WHERE o.currency = r.currency ");
    }

    @TestTemplate
    void testTemporalSortOnProcTime() {
        this.createSourceWithTimeAttribute();
        this.verifyQuery("SELECT a FROM MyTable order by proctime, c");
    }

    @TestTemplate
    void testTemporalSortOnEventTime() {
        this.createSourceWithTimeAttribute();
        this.verifyQuery("SELECT a FROM MyTable order by rowtime, c");
    }

    @TestTemplate
    void testWindowAggregate() {
        this.tEnv.getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)"ONE_PHASE");
        this.createSourceWithTimeAttribute();
        this.verifyQuery("SELECT\n  b,\n  window_start,\n  window_end,\n  COUNT(*),\n  SUM(a)\nFROM TABLE(\n   TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\nGROUP BY b, window_start, window_end");
    }

    @TestTemplate
    void testLocalGlobalWindowAggregate() {
        this.createSourceWithTimeAttribute();
        this.verifyQuery("SELECT\n  b,\n  window_start,\n  window_end,\n  COUNT(*),\n  SUM(a)\nFROM TABLE(\n   TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\nGROUP BY b, window_start, window_end");
    }

    @TestTemplate
    void testWindowJoin() {
        this.createSourceWithTimeAttribute("MyTable");
        this.createSourceWithTimeAttribute("MyTable2");
        this.verifyQuery("select\n  L.a,\n  L.window_start,\n  L.window_end,\n  L.cnt,\n  L.uv,\n  R.a,\n  R.cnt,\n  R.uv\nFROM (\n  SELECT\n    a,\n    window_start,\n    window_end,\n    count(*) as cnt,\n    count(distinct c) AS uv\n  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n  GROUP BY a, window_start, window_end, window_time\n) L\nJOIN (\n  SELECT\n    a,\n    window_start,\n    window_end,\n    count(*) as cnt,\n    count(distinct c) AS uv\n  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n  GROUP BY a, window_start, window_end, window_time\n) R\nON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a");
    }

    @TestTemplate
    void testWindowRank() {
        this.createSourceWithTimeAttribute();
        this.verifyQuery("select\n  window_start,\n  window_end,\n  a,\n  b,\n  c\nFROM (\n  SELECT\n    *,\n   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY b DESC) as rownum\n  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE)))\nWHERE rownum <= 3");
    }

    @TestTemplate
    void testWindowDeduplicate() {
        this.createSourceWithTimeAttribute();
        this.verifyQuery("select\n  window_start,\n  window_end,\n  a,\n  b,\n  c\nFROM (\n  SELECT\n    *,\n   ROW_NUMBER() OVER(PARTITION BY a, window_start, window_end ORDER BY rowtime DESC) as rownum\n  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE)))\nWHERE rownum <= 1");
    }

    @TestTemplate
    void testLegacySourceSink() {
        TableSchema schema = TestLegacyFilterableTableSource.defaultSchema();
        TestLegacyFilterableTableSource.createTemporaryTable(this.tEnv, schema, "MySource", true, (List<Row>)TestLegacyFilterableTableSource.defaultRows().toList(), TestLegacyFilterableTableSource.defaultFilterableFields());
        AppendStreamTableSink<Row> sink = this.util.createAppendTableSink(schema.getFieldNames(), (LogicalType[])schema.getTableColumns().stream().map(col -> col.getType().getLogicalType()).toArray(LogicalType[]::new));
        this.util.testingTableEnv().registerTableSinkInternal("MySink", (TableSink)sink);
        this.verifyInsert("insert into MySink select * from MySource");
    }
}

