/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeTestUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@Execution(value=ExecutionMode.CONCURRENT)
public class DataTypeJsonSerdeTest {
    @ParameterizedTest
    @MethodSource(value={"testDataTypeSerde"})
    public void testDataTypeSerde(DataType dataType) throws IOException {
        SerdeContext serdeContext = JsonSerdeTestUtil.configuredSerdeContext();
        String json = JsonSerdeTestUtil.toJson(serdeContext, dataType);
        DataType actual = JsonSerdeTestUtil.toObject(serdeContext, json, DataType.class);
        Assertions.assertThat((Object)actual).isEqualTo((Object)dataType);
    }

    private static Stream<DataType> testDataTypeSerde() {
        return Stream.of(DataTypes.INT(), (DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE), DataTypes.TIMESTAMP_LTZ((int)3).toInternal(), (DataType)DataTypes.TIMESTAMP_LTZ((int)9).bridgedTo(Long.TYPE), DataTypes.ROW((DataType[])new DataType[]{DataTypes.TIMESTAMP_LTZ((int)3).toInternal(), (DataType)DataTypes.TIMESTAMP_LTZ((int)9).bridgedTo(Long.TYPE), DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT(), DataTypes.MULTISET((DataType)((DataType)((DataType)DataTypes.DOUBLE().notNull()).bridgedTo(Double.TYPE)))})}), (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull())).bridgedTo(int[].class), DataTypes.STRUCTURED(PojoClass.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), DataTypes.FIELD((String)"f1", (DataType)((DataType)((DataType)DataTypes.BIGINT().notNull()).bridgedTo(Long.TYPE))), DataTypes.FIELD((String)"f2", (DataType)DataTypes.STRING())}), DataTypes.MAP((DataType)DataTypes.STRING().toInternal(), (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.ROW((DataType[])new DataType[]{DataTypes.TIMESTAMP_LTZ((int)3)}).toInternal());
    }

    public static class PojoClass {
        public int f0;
        public long f1;
        public String f2;
    }
}

