/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.TestDynamicTableFactory;
import org.apache.flink.table.factories.TestFormatFactory;
import org.apache.flink.table.planner.plan.abilities.sink.OverwriteSpec;
import org.apache.flink.table.planner.plan.abilities.sink.PartitioningSpec;
import org.apache.flink.table.planner.plan.abilities.sink.WritingMetadataSpec;
import org.apache.flink.table.planner.plan.nodes.exec.serde.DynamicTableSourceSpecSerdeTest;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeTestUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DynamicTableSinkSpec;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@Execution(value=ExecutionMode.CONCURRENT)
class DynamicTableSinkSpecSerdeTest {
    DynamicTableSinkSpecSerdeTest() {
    }

    static Stream<DynamicTableSinkSpec> testDynamicTableSinkSpecSerde() {
        HashMap<String, String> options1 = new HashMap<String, String>();
        options1.put("connector", "filesystem");
        options1.put("format", "testcsv");
        options1.put("path", "/tmp");
        ResolvedSchema resolvedSchema1 = new ResolvedSchema(Collections.singletonList(Column.physical((String)"a", (DataType)DataTypes.BIGINT())), Collections.emptyList(), null);
        CatalogTable catalogTable1 = CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(resolvedSchema1).build(), null, Collections.emptyList(), options1);
        DynamicTableSinkSpec spec1 = new DynamicTableSinkSpec(ContextResolvedTable.temporary((ObjectIdentifier)ObjectIdentifier.of((String)CatalogManagerMocks.DEFAULT_CATALOG, (String)CatalogManagerMocks.DEFAULT_DATABASE, (String)"MyTable"), (ResolvedCatalogBaseTable)new ResolvedCatalogTable(catalogTable1, resolvedSchema1)), null, (int[][])null);
        HashMap<String, String> options2 = new HashMap<String, String>();
        options2.put("connector", "filesystem");
        options2.put("format", "testcsv");
        options2.put("path", "/tmp");
        ResolvedSchema resolvedSchema2 = new ResolvedSchema(Arrays.asList(Column.physical((String)"a", (DataType)DataTypes.BIGINT()), Column.physical((String)"b", (DataType)DataTypes.INT()), Column.physical((String)"p", (DataType)DataTypes.STRING())), Collections.emptyList(), null);
        CatalogTable catalogTable2 = CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(resolvedSchema2).build(), null, Collections.emptyList(), options2);
        DynamicTableSinkSpec spec2 = new DynamicTableSinkSpec(ContextResolvedTable.temporary((ObjectIdentifier)ObjectIdentifier.of((String)CatalogManagerMocks.DEFAULT_CATALOG, (String)CatalogManagerMocks.DEFAULT_DATABASE, (String)"MyTable"), (ResolvedCatalogBaseTable)new ResolvedCatalogTable(catalogTable2, resolvedSchema2)), Arrays.asList(new OverwriteSpec(true), new PartitioningSpec((Map)new HashMap<String, String>(){
            {
                this.put("p", "A");
            }
        })), (int[][])new int[][]{{0}, {1}});
        HashMap<String, String> options3 = new HashMap<String, String>();
        options3.put("connector", "values");
        options3.put("writable-metadata", "m:STRING");
        ResolvedSchema resolvedSchema3 = new ResolvedSchema(Arrays.asList(Column.physical((String)"a", (DataType)DataTypes.BIGINT()), Column.physical((String)"b", (DataType)DataTypes.INT()), Column.metadata((String)"m", (DataType)DataTypes.STRING(), null, (boolean)false)), Collections.emptyList(), null);
        CatalogTable catalogTable3 = CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(resolvedSchema3).build(), null, Collections.emptyList(), options3);
        DynamicTableSinkSpec spec3 = new DynamicTableSinkSpec(ContextResolvedTable.temporary((ObjectIdentifier)ObjectIdentifier.of((String)CatalogManagerMocks.DEFAULT_CATALOG, (String)CatalogManagerMocks.DEFAULT_DATABASE, (String)"MyTable"), (ResolvedCatalogBaseTable)new ResolvedCatalogTable(catalogTable3, resolvedSchema3)), Collections.singletonList(new WritingMetadataSpec(Collections.singletonList("m"), (LogicalType)RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType()}))), (int[][])null);
        return Stream.of(spec1, spec2, spec3);
    }

    @ParameterizedTest
    @MethodSource(value={"testDynamicTableSinkSpecSerde"})
    void testDynamicTableSinkSpecSerde(DynamicTableSinkSpec spec) throws IOException {
        PlannerMocks plannerMocks = PlannerMocks.create();
        CatalogManager catalogManager = plannerMocks.getCatalogManager();
        catalogManager.createTable((CatalogBaseTable)spec.getContextResolvedTable().getResolvedTable(), spec.getContextResolvedTable().getIdentifier(), false);
        SerdeContext serdeCtx = JsonSerdeTestUtil.configuredSerdeContext(catalogManager, plannerMocks.getTableConfig());
        spec = new DynamicTableSinkSpec(ContextResolvedTable.permanent((ObjectIdentifier)spec.getContextResolvedTable().getIdentifier(), (Catalog)((Catalog)catalogManager.getCatalog(catalogManager.getCurrentCatalog()).get()), (ResolvedCatalogBaseTable)spec.getContextResolvedTable().getResolvedTable()), spec.getSinkAbilities(), (int[][])null);
        String actualJson = JsonSerdeTestUtil.toJson(serdeCtx, spec);
        DynamicTableSinkSpec actual = JsonSerdeTestUtil.toObject(serdeCtx, actualJson, DynamicTableSinkSpec.class);
        Assertions.assertThat((Object)actual.getContextResolvedTable()).isEqualTo((Object)spec.getContextResolvedTable());
        Assertions.assertThat((List)actual.getSinkAbilities()).isEqualTo((Object)spec.getSinkAbilities());
        Assertions.assertThat((Object)actual.getTableSink(plannerMocks.getPlannerContext().getFlinkContext())).isNotNull();
    }

    @Test
    void testDynamicTableSinkSpecSerdeWithEnrichmentOptions() throws Exception {
        ObjectIdentifier identifier = ObjectIdentifier.of((String)CatalogManagerMocks.DEFAULT_CATALOG, (String)CatalogManagerMocks.DEFAULT_DATABASE, (String)"my_table");
        String formatPrefix = FactoryUtil.getFormatPrefix((ConfigOption)FactoryUtil.FORMAT, (String)"test-format");
        HashMap<String, String> planOptions = new HashMap<String, String>();
        planOptions.put(FactoryUtil.CONNECTOR.key(), "test-connector");
        planOptions.put(TestDynamicTableFactory.TARGET.key(), "abc");
        planOptions.put(TestDynamicTableFactory.BUFFER_SIZE.key(), "1000");
        planOptions.put(FactoryUtil.FORMAT.key(), "test-format");
        planOptions.put(formatPrefix + TestFormatFactory.DELIMITER.key(), "|");
        HashMap<String, String> catalogOptions = new HashMap<String, String>();
        catalogOptions.put(FactoryUtil.CONNECTOR.key(), "test-connector");
        catalogOptions.put(TestDynamicTableFactory.TARGET.key(), "xyz");
        catalogOptions.put(TestDynamicTableFactory.BUFFER_SIZE.key(), "2000");
        catalogOptions.put(FactoryUtil.FORMAT.key(), "test-format");
        catalogOptions.put(formatPrefix + TestFormatFactory.DELIMITER.key(), ",");
        ResolvedCatalogTable planResolvedCatalogTable = DynamicTableSourceSpecSerdeTest.tableWithOnlyPhysicalColumns(planOptions);
        ResolvedCatalogTable catalogResolvedCatalogTable = DynamicTableSourceSpecSerdeTest.tableWithOnlyPhysicalColumns(catalogOptions);
        PlannerMocks plannerMocks = PlannerMocks.create(new Configuration().set(TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS, (Object)TableConfigOptions.CatalogPlanRestore.ALL).set(TableConfigOptions.PLAN_COMPILE_CATALOG_OBJECTS, (Object)TableConfigOptions.CatalogPlanCompilation.ALL));
        CatalogManager catalogManager = plannerMocks.getCatalogManager();
        catalogManager.createTable((CatalogBaseTable)catalogResolvedCatalogTable, identifier, false);
        SerdeContext serdeCtx = JsonSerdeTestUtil.configuredSerdeContext(catalogManager, plannerMocks.getTableConfig());
        DynamicTableSinkSpec planSpec = new DynamicTableSinkSpec(ContextResolvedTable.permanent((ObjectIdentifier)identifier, (Catalog)((Catalog)catalogManager.getCatalog(catalogManager.getCurrentCatalog()).get()), (ResolvedCatalogBaseTable)planResolvedCatalogTable), Collections.emptyList(), (int[][])null);
        String actualJson = JsonSerdeTestUtil.toJson(serdeCtx, planSpec);
        DynamicTableSinkSpec actual = JsonSerdeTestUtil.toObject(serdeCtx, actualJson, DynamicTableSinkSpec.class);
        Assertions.assertThat((Object)actual.getContextResolvedTable()).isEqualTo((Object)planSpec.getContextResolvedTable());
        Assertions.assertThat((List)actual.getSinkAbilities()).isNull();
        TestDynamicTableFactory.DynamicTableSinkMock dynamicTableSink = (TestDynamicTableFactory.DynamicTableSinkMock)actual.getTableSink(plannerMocks.getPlannerContext().getFlinkContext());
        Assertions.assertThat((String)dynamicTableSink.target).isEqualTo("abc");
        Assertions.assertThat((Long)dynamicTableSink.bufferSize).isEqualTo(2000L);
        Assertions.assertThat((String)((TestFormatFactory.EncodingFormatMock)dynamicTableSink.valueFormat).delimiter).isEqualTo(",");
    }
}

