/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.List;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.MultipleExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeTestUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.plan.utils.ExecNodeMetadataUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExecNodeVersionUpgradeSerdeTest {
    @Test
    public void testDeserializeOldVersionUsingNewVersion() throws IOException {
        ExecNodeMetadataUtil.addTestNode(DummyExecNode.class);
        String serializedUsingOldVersion = "{\"id\":1,\"type\":\"dummy-exec-node_1\",\"inputProperties\":[],\"outputType\":\"ROW<>\",\"description\":\"Dummy\"}";
        SerdeContext context = JsonSerdeTestUtil.configuredSerdeContext();
        DummyExecNode deserializedUsingNewVersion = JsonSerdeTestUtil.toObject(context, serializedUsingOldVersion, DummyExecNode.class);
        Assertions.assertThat((String)JsonSerdeTestUtil.toJson(context, (Object)deserializedUsingNewVersion)).isEqualTo(serializedUsingOldVersion);
    }

    @MultipleExecNodeMetadata(value={@ExecNodeMetadata(name="dummy-exec-node", version=1, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15), @ExecNodeMetadata(name="dummy-exec-node", version=2, minPlanVersion=FlinkVersion.v1_18, minStateVersion=FlinkVersion.v1_15)})
    private static class DummyExecNode
    extends ExecNodeBase<RowData> {
        private static final String FIELD_NAME_NEW_ADDED = "newProperty";
        private final Integer newProperty;

        @JsonCreator
        protected DummyExecNode(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") LogicalType outputType, @JsonProperty(value="description") String description, @JsonProperty(value="newProperty") Integer newProperty) {
            super(id, context, persistedConfig, inputProperties, outputType, description);
            this.newProperty = newProperty;
        }

        protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
            return null;
        }
    }
}

