/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.Sarg;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.functions.utils.UserDefinedFunctionUtils;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeTestUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@Execution(value=ExecutionMode.CONCURRENT)
public class RexNodeJsonSerdeTest {
    private static final FlinkTypeFactory FACTORY = new FlinkTypeFactory(RexNodeJsonSerdeTest.class.getClassLoader(), (RelDataTypeSystem)FlinkTypeSystem.INSTANCE);
    private static final String FUNCTION_NAME = "MyFunc";
    private static final FunctionIdentifier FUNCTION_SYS_ID = FunctionIdentifier.of((String)"MyFunc");
    private static final FunctionIdentifier FUNCTION_CAT_ID = FunctionIdentifier.of((ObjectIdentifier)ObjectIdentifier.of((String)CatalogManagerMocks.DEFAULT_CATALOG, (String)CatalogManagerMocks.DEFAULT_DATABASE, (String)"MyFunc"));
    private static final UnresolvedIdentifier UNRESOLVED_FUNCTION_CAT_ID = UnresolvedIdentifier.of((List)FUNCTION_CAT_ID.toList());
    private static final SerializableScalarFunction SER_UDF_IMPL = new SerializableScalarFunction();
    private static final Class<SerializableScalarFunction> SER_UDF_CLASS = SerializableScalarFunction.class;
    private static final OtherSerializableScalarFunction SER_UDF_IMPL_OTHER = new OtherSerializableScalarFunction();
    private static final Class<OtherSerializableScalarFunction> SER_UDF_CLASS_OTHER = OtherSerializableScalarFunction.class;
    private static final NonSerializableScalarFunction NON_SER_UDF_IMPL = new NonSerializableScalarFunction(true);
    private static final NonSerializableFunctionDefinition NON_SER_FUNCTION_DEF_IMPL = new NonSerializableFunctionDefinition();
    private static final ContextResolvedFunction PERMANENT_FUNCTION = ContextResolvedFunction.permanent((FunctionIdentifier)FUNCTION_CAT_ID, (FunctionDefinition)SER_UDF_IMPL);

    @ParameterizedTest
    @MethodSource(value={"testRexNodeSerde"})
    public void testRexNodeSerde(RexNode rexNode) throws IOException {
        RexNode actual = JsonSerdeTestUtil.testJsonRoundTrip(rexNode, RexNode.class);
        Assertions.assertThat((Object)actual).isEqualTo((Object)rexNode);
    }

    @Test
    public void testInlineFunction() throws IOException {
        SerdeContext serdeContext = RexNodeJsonSerdeTest.contradictingSerdeContext();
        JsonSerdeTestUtil.testJsonRoundTrip(RexNodeJsonSerdeTest.createFunctionCall(serdeContext, ContextResolvedFunction.anonymous((FunctionDefinition)SER_UDF_IMPL)), RexNode.class);
        Assertions.assertThatThrownBy(() -> JsonSerdeTestUtil.toJson(serdeContext, RexNodeJsonSerdeTest.createFunctionCall(serdeContext, ContextResolvedFunction.anonymous((FunctionDefinition)NON_SER_UDF_IMPL)))).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(TableException.class, (String)"The function's implementation class must not be stateful")});
    }

    @Test
    public void testSystemFunction() throws Throwable {
        SerdeContext serdeContext = RexNodeJsonSerdeTest.contradictingSerdeContext();
        ThrowableAssert.ThrowingCallable callable = () -> JsonSerdeTestUtil.testJsonRoundTrip(serdeContext, RexNodeJsonSerdeTest.createFunctionCall(serdeContext, ContextResolvedFunction.permanent((FunctionIdentifier)FUNCTION_SYS_ID, (FunctionDefinition)NON_SER_UDF_IMPL)), RexNode.class);
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(TableException.class, (String)"Could not lookup system function 'MyFunc'.")});
        serdeContext.getFlinkContext().getModuleManager().loadModule("myModule", (Module)FunctionProvidingModule.INSTANCE);
        callable.call();
    }

    @Test
    public void testTemporarySystemFunction() throws Throwable {
        SerdeContext serdeContext = RexNodeJsonSerdeTest.contradictingSerdeContext();
        ThrowableAssert.ThrowingCallable callable = () -> JsonSerdeTestUtil.testJsonRoundTrip(serdeContext, RexNodeJsonSerdeTest.createFunctionCall(serdeContext, ContextResolvedFunction.temporary((FunctionIdentifier)FUNCTION_SYS_ID, (FunctionDefinition)NON_SER_UDF_IMPL)), RexNode.class);
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(TableException.class, (String)"Could not lookup system function 'MyFunc'.")});
        RexNodeJsonSerdeTest.registerTemporarySystemFunction(serdeContext);
        callable.call();
    }

    @Test
    public void testTemporaryCatalogFunction() throws Throwable {
        SerdeContext serdeContext = RexNodeJsonSerdeTest.contradictingSerdeContext();
        ThrowableAssert.ThrowingCallable callable = () -> JsonSerdeTestUtil.testJsonRoundTrip(serdeContext, RexNodeJsonSerdeTest.createFunctionCall(serdeContext, ContextResolvedFunction.temporary((FunctionIdentifier)FUNCTION_CAT_ID, (FunctionDefinition)NON_SER_FUNCTION_DEF_IMPL)), RexNode.class);
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(TableException.class, (String)("The persisted plan does not include all required catalog metadata for function '" + FUNCTION_CAT_ID.asSummaryString() + "'."))});
        RexNodeJsonSerdeTest.registerTemporaryFunction(serdeContext);
        callable.call();
    }

    @Test
    public void testUnsupportedLegacyFunction() {
        SerdeContext serdeContext = RexNodeJsonSerdeTest.contradictingSerdeContext();
        Assertions.assertThatThrownBy(() -> JsonSerdeTestUtil.testJsonRoundTrip(RexNodeJsonSerdeTest.createFunctionCall(serdeContext, UserDefinedFunctionUtils.createScalarSqlFunction((FunctionIdentifier)FUNCTION_SYS_ID, (String)FUNCTION_SYS_ID.toString(), (ScalarFunction)SER_UDF_IMPL, (FlinkTypeFactory)FACTORY)), RexNode.class)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(TableException.class, (String)"Functions of the deprecated function stack are not supported.")});
    }

    private static Stream<RexNode> testRexNodeSerde() {
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)FACTORY);
        RelDataType inputType = FACTORY.createStructType(StructKind.PEEK_FIELDS_NO_EXPAND, Arrays.asList(FACTORY.createSqlType(SqlTypeName.INTEGER), FACTORY.createSqlType(SqlTypeName.BIGINT), FACTORY.createStructType(StructKind.PEEK_FIELDS_NO_EXPAND, Arrays.asList(FACTORY.createSqlType(SqlTypeName.VARCHAR), FACTORY.createSqlType(SqlTypeName.VARCHAR)), Arrays.asList("n1", "n2"))), Arrays.asList("f1", "f2", "f3"));
        return Stream.of(rexBuilder.makeNullLiteral(FACTORY.createSqlType(SqlTypeName.VARCHAR)), rexBuilder.makeLiteral(true), rexBuilder.makeExactLiteral(new BigDecimal(127), FACTORY.createSqlType(SqlTypeName.TINYINT)), rexBuilder.makeExactLiteral(new BigDecimal(Short.MAX_VALUE), FACTORY.createSqlType(SqlTypeName.SMALLINT)), rexBuilder.makeExactLiteral(new BigDecimal(Integer.MAX_VALUE), FACTORY.createSqlType(SqlTypeName.INTEGER)), rexBuilder.makeExactLiteral(new BigDecimal(Long.MAX_VALUE), FACTORY.createSqlType(SqlTypeName.BIGINT)), rexBuilder.makeExactLiteral(BigDecimal.valueOf(Double.MAX_VALUE), FACTORY.createSqlType(SqlTypeName.DOUBLE)), rexBuilder.makeApproxLiteral(BigDecimal.valueOf(3.4028234663852886E38), FACTORY.createSqlType(SqlTypeName.FLOAT)), rexBuilder.makeExactLiteral(new BigDecimal("23.1234567890123456789012345678")), rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(100L), new SqlIntervalQualifier(TimeUnit.YEAR, 4, TimeUnit.YEAR, -1, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(3L), new SqlIntervalQualifier(TimeUnit.YEAR, 2, TimeUnit.MONTH, -1, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(3L), new SqlIntervalQualifier(TimeUnit.DAY, 2, TimeUnit.SECOND, 6, SqlParserPos.ZERO)), rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(3L), new SqlIntervalQualifier(TimeUnit.SECOND, 2, TimeUnit.SECOND, 6, SqlParserPos.ZERO)), rexBuilder.makeDateLiteral(DateString.fromDaysSinceEpoch((int)10)), rexBuilder.makeDateLiteral(new DateString("2000-12-12")), rexBuilder.makeTimeLiteral(TimeString.fromMillisOfDay((int)1234), 3), rexBuilder.makeTimeLiteral(TimeString.fromMillisOfDay((int)123456), 6), rexBuilder.makeTimeLiteral(new TimeString("01:01:01.000000001"), 9), rexBuilder.makeTimestampLiteral(TimestampString.fromMillisSinceEpoch((long)1234L), 3), rexBuilder.makeTimestampLiteral(TimestampString.fromMillisSinceEpoch((long)123456789L), 9), rexBuilder.makeTimestampLiteral(new TimestampString("0001-01-01 01:01:01.000000001"), 9), rexBuilder.makeTimestampLiteral(new TimestampString("2000-12-12 12:30:57.1234"), 4), rexBuilder.makeBinaryLiteral(ByteString.EMPTY), rexBuilder.makeBinaryLiteral(ByteString.ofBase64((String)"SGVsbG8gV29ybGQh")), rexBuilder.makeLiteral(""), rexBuilder.makeLiteral("abc"), rexBuilder.makeFlag((Enum)SqlTrimFunction.Flag.BOTH), rexBuilder.makeFlag((Enum)TimeUnitRange.DAY), rexBuilder.makeSearchArgumentLiteral(Sarg.of((boolean)false, (RangeSet)ImmutableRangeSet.of((Range)Range.closed((Comparable)BigDecimal.valueOf(1L), (Comparable)BigDecimal.valueOf(10L)))), FACTORY.createSqlType(SqlTypeName.INTEGER)), rexBuilder.makeSearchArgumentLiteral(Sarg.of((boolean)false, (RangeSet)ImmutableRangeSet.of((Range)Range.range((Comparable)BigDecimal.valueOf(1L), (BoundType)BoundType.OPEN, (Comparable)BigDecimal.valueOf(10L), (BoundType)BoundType.CLOSED))), FACTORY.createSqlType(SqlTypeName.INTEGER)), rexBuilder.makeSearchArgumentLiteral(Sarg.of((boolean)false, (RangeSet)TreeRangeSet.create(Arrays.asList(Range.closed((Comparable)BigDecimal.valueOf(1L), (Comparable)BigDecimal.valueOf(1L)), Range.closed((Comparable)BigDecimal.valueOf(3L), (Comparable)BigDecimal.valueOf(3L)), Range.closed((Comparable)BigDecimal.valueOf(6L), (Comparable)BigDecimal.valueOf(6L))))), FACTORY.createSqlType(SqlTypeName.INTEGER)), rexBuilder.makeInputRef(FACTORY.createSqlType(SqlTypeName.BIGINT), 0), rexBuilder.makeCorrel(inputType, new CorrelationId("$cor1")), rexBuilder.makeFieldAccess(rexBuilder.makeCorrel(inputType, new CorrelationId("$cor2")), "f2", true), rexBuilder.makeCast(FACTORY.createSqlType(SqlTypeName.SMALLINT), (RexNode)rexBuilder.makeInputRef(FACTORY.createSqlType(SqlTypeName.INTEGER), 1)), rexBuilder.makeIn((RexNode)rexBuilder.makeInputRef(FACTORY.createSqlType(SqlTypeName.INTEGER), 1), Arrays.asList(rexBuilder.makeExactLiteral(new BigDecimal(1)), rexBuilder.makeExactLiteral(new BigDecimal(3)), rexBuilder.makeExactLiteral(new BigDecimal(5)))), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{rexBuilder.makeNullLiteral(FACTORY.createSqlType(SqlTypeName.INTEGER)), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{rexBuilder.makeInputRef(FACTORY.createSqlType(SqlTypeName.INTEGER), 1)})}), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{rexBuilder.makeInputRef(FACTORY.createSqlType(SqlTypeName.INTEGER), 1), rexBuilder.makeExactLiteral(new BigDecimal(10))}), rexBuilder.makeCall((SqlOperator)FlinkSqlOperatorTable.HASH_CODE, new RexNode[]{rexBuilder.makeInputRef(FACTORY.createSqlType(SqlTypeName.INTEGER), 1)}), rexBuilder.makePatternFieldRef("test", FACTORY.createSqlType(SqlTypeName.INTEGER), 0));
    }

    private static RexNode createFunctionCall(SerdeContext serdeContext, ContextResolvedFunction resolvedFunction) {
        BridgingSqlFunction nonSerializableFunction = BridgingSqlFunction.of((FlinkContext)serdeContext.getFlinkContext(), (FlinkTypeFactory)serdeContext.getTypeFactory(), (ContextResolvedFunction)resolvedFunction);
        return RexNodeJsonSerdeTest.createFunctionCall(serdeContext, (SqlFunction)nonSerializableFunction);
    }

    private static RexNode createFunctionCall(SerdeContext serdeContext, SqlFunction sqlFunction) {
        return serdeContext.getRexBuilder().makeCall((SqlOperator)sqlFunction, new RexNode[]{serdeContext.getRexBuilder().makeLiteral((Object)12, serdeContext.getTypeFactory().createSqlType(SqlTypeName.INTEGER), false)});
    }

    private static SerdeContext serdeContext(TableConfigOptions.CatalogPlanCompilation planCompilationOption, TableConfigOptions.CatalogPlanRestore planRestoreOption) {
        Configuration configuration = new Configuration();
        configuration.set(TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS, (Object)planRestoreOption);
        configuration.set(TableConfigOptions.PLAN_COMPILE_CATALOG_OBJECTS, (Object)planCompilationOption);
        return JsonSerdeTestUtil.configuredSerdeContext(configuration);
    }

    private static SerdeContext serdeContextWithPermanentFunction(TableConfigOptions.CatalogPlanCompilation planCompilationOption, TableConfigOptions.CatalogPlanRestore planRestoreOption) {
        SerdeContext serdeContext = RexNodeJsonSerdeTest.serdeContext(planCompilationOption, planRestoreOption);
        serdeContext.getFlinkContext().getFunctionCatalog().registerCatalogFunction(UNRESOLVED_FUNCTION_CAT_ID, SER_UDF_CLASS, false);
        return serdeContext;
    }

    private static void dropPermanentFunction(SerdeContext serdeContext) {
        serdeContext.getFlinkContext().getFunctionCatalog().dropCatalogFunction(UNRESOLVED_FUNCTION_CAT_ID, false);
    }

    private static void modifyPermanentFunction(SerdeContext serdeContext) {
        RexNodeJsonSerdeTest.dropPermanentFunction(serdeContext);
        serdeContext.getFlinkContext().getFunctionCatalog().registerCatalogFunction(UNRESOLVED_FUNCTION_CAT_ID, SER_UDF_CLASS_OTHER, false);
    }

    private static void registerTemporaryFunction(SerdeContext serdeContext) {
        serdeContext.getFlinkContext().getFunctionCatalog().registerTemporaryCatalogFunction(UNRESOLVED_FUNCTION_CAT_ID, (FunctionDefinition)NON_SER_FUNCTION_DEF_IMPL, false);
    }

    private static void registerTemporarySystemFunction(SerdeContext serdeContext) {
        serdeContext.getFlinkContext().getFunctionCatalog().registerTemporarySystemFunction(FUNCTION_NAME, (FunctionDefinition)NON_SER_FUNCTION_DEF_IMPL, false);
    }

    private JsonNode serializePermanentFunction(SerdeContext serdeContext) throws Exception {
        byte[] actualSerialized = JsonSerdeUtil.createObjectWriter((SerdeContext)serdeContext).writeValueAsBytes((Object)RexNodeJsonSerdeTest.createFunctionCall(serdeContext, PERMANENT_FUNCTION));
        return JsonSerdeUtil.createObjectReader((SerdeContext)serdeContext).readTree(actualSerialized);
    }

    private ContextResolvedFunction deserialize(SerdeContext serdeContext, JsonNode node) throws IOException {
        RexNode actualDeserialized = (RexNode)JsonSerdeUtil.createObjectReader((SerdeContext)serdeContext).readValue(node, RexNode.class);
        return ((BridgingSqlFunction)((RexCall)actualDeserialized).getOperator()).getResolvedFunction();
    }

    private static SerdeContext contradictingSerdeContext() {
        return RexNodeJsonSerdeTest.serdeContext(TableConfigOptions.CatalogPlanCompilation.IDENTIFIER, TableConfigOptions.CatalogPlanRestore.ALL_ENFORCED);
    }

    public static class NonSerializableFunctionDefinition
    implements FunctionDefinition {
        public FunctionKind getKind() {
            return FunctionKind.SCALAR;
        }

        public TypeInference getTypeInference(DataTypeFactory typeFactory) {
            return TypeInference.newBuilder().typedArguments(new DataType[]{DataTypes.INT()}).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.STRING())).build();
        }
    }

    public static class NonSerializableScalarFunction
    extends ScalarFunction {
        private final boolean flag;

        public NonSerializableScalarFunction(boolean flag) {
            this.flag = flag;
        }

        public String eval(Integer i) {
            throw new UnsupportedOperationException();
        }
    }

    public static class OtherSerializableScalarFunction
    extends ScalarFunction {
        public String eval(Integer i) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            return obj instanceof OtherSerializableScalarFunction;
        }
    }

    public static class SerializableScalarFunction
    extends ScalarFunction {
        public String eval(Integer i) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            return obj instanceof SerializableScalarFunction;
        }
    }

    private static class FunctionProvidingModule
    implements Module {
        private static final FunctionProvidingModule INSTANCE = new FunctionProvidingModule();

        private FunctionProvidingModule() {
        }

        public Set<String> listFunctions() {
            return Collections.singleton(RexNodeJsonSerdeTest.FUNCTION_NAME);
        }

        public Optional<FunctionDefinition> getFunctionDefinition(String name) {
            if (name.equalsIgnoreCase(RexNodeJsonSerdeTest.FUNCTION_NAME)) {
                return Optional.of(NON_SER_FUNCTION_DEF_IMPL);
            }
            return Optional.empty();
        }
    }

    @Nested
    @DisplayName(value="Test CatalogPlanCompilation == ALL")
    class TestCompileAll {
        private final TableConfigOptions.CatalogPlanCompilation compilation = TableConfigOptions.CatalogPlanCompilation.ALL;

        TestCompileAll() {
        }

        @Nested
        @DisplayName(value="and CatalogPlanRestore == ALL")
        class TestRestoreAll {
            private final TableConfigOptions.CatalogPlanRestore restore = TableConfigOptions.CatalogPlanRestore.ALL;

            TestRestoreAll() {
            }

            @Test
            void withConstantCatalogFunction() throws Exception {
                SerdeContext ctx = RexNodeJsonSerdeTest.serdeContextWithPermanentFunction(TestCompileAll.this.compilation, this.restore);
                JsonNode json = RexNodeJsonSerdeTest.this.serializePermanentFunction(ctx);
                JsonSerdeTestUtil.assertThatJsonContains(json, "class");
                ContextResolvedFunction actual = RexNodeJsonSerdeTest.this.deserialize(ctx, json);
                Assertions.assertThat((Object)actual).isEqualTo((Object)PERMANENT_FUNCTION);
            }

            @Test
            void withDroppedCatalogFunction() throws Exception {
                SerdeContext ctx = RexNodeJsonSerdeTest.serdeContextWithPermanentFunction(TestCompileAll.this.compilation, this.restore);
                JsonNode json = RexNodeJsonSerdeTest.this.serializePermanentFunction(ctx);
                JsonSerdeTestUtil.assertThatJsonContains(json, "class");
                RexNodeJsonSerdeTest.dropPermanentFunction(ctx);
                ContextResolvedFunction actual = RexNodeJsonSerdeTest.this.deserialize(ctx, json);
                Assertions.assertThat((Object)actual).isEqualTo((Object)ContextResolvedFunction.permanent((FunctionIdentifier)FUNCTION_CAT_ID, (FunctionDefinition)SER_UDF_IMPL));
            }

            @Test
            void withShadowingTemporaryFunction() throws Exception {
                SerdeContext ctx = RexNodeJsonSerdeTest.serdeContextWithPermanentFunction(TestCompileAll.this.compilation, this.restore);
                JsonNode json = RexNodeJsonSerdeTest.this.serializePermanentFunction(ctx);
                JsonSerdeTestUtil.assertThatJsonContains(json, "class");
                RexNodeJsonSerdeTest.registerTemporaryFunction(ctx);
                ContextResolvedFunction actual = RexNodeJsonSerdeTest.this.deserialize(ctx, json);
                Assertions.assertThat((Object)actual).isEqualTo((Object)ContextResolvedFunction.temporary((FunctionIdentifier)FUNCTION_CAT_ID, (FunctionDefinition)NON_SER_FUNCTION_DEF_IMPL));
            }
        }

        @Nested
        @DisplayName(value="and CatalogPlanRestore == ALL_ENFORCED")
        class TestRestoreAllEnforced {
            private final TableConfigOptions.CatalogPlanRestore restore = TableConfigOptions.CatalogPlanRestore.ALL_ENFORCED;

            TestRestoreAllEnforced() {
            }

            @Test
            void withConstantCatalogFunction() throws Exception {
                SerdeContext ctx = RexNodeJsonSerdeTest.serdeContextWithPermanentFunction(TestCompileAll.this.compilation, this.restore);
                RexNodeJsonSerdeTest.dropPermanentFunction(ctx);
                RexNodeJsonSerdeTest.registerTemporaryFunction(ctx);
                JsonNode json = RexNodeJsonSerdeTest.this.serializePermanentFunction(ctx);
                JsonSerdeTestUtil.assertThatJsonContains(json, "class");
                ContextResolvedFunction actual = RexNodeJsonSerdeTest.this.deserialize(ctx, json);
                Assertions.assertThat((Object)actual).isEqualTo((Object)ContextResolvedFunction.permanent((FunctionIdentifier)FUNCTION_CAT_ID, (FunctionDefinition)SER_UDF_IMPL));
            }
        }

        @Nested
        @DisplayName(value="and CatalogPlanRestore == IDENTIFIER")
        class TestRestoreIdentifier {
            private final TableConfigOptions.CatalogPlanRestore restore = TableConfigOptions.CatalogPlanRestore.IDENTIFIER;

            TestRestoreIdentifier() {
            }

            @Test
            void withConstantCatalogFunction() throws Exception {
                SerdeContext ctx = RexNodeJsonSerdeTest.serdeContextWithPermanentFunction(TestCompileAll.this.compilation, this.restore);
                JsonNode json = RexNodeJsonSerdeTest.this.serializePermanentFunction(ctx);
                JsonSerdeTestUtil.assertThatJsonContains(json, "class");
                ContextResolvedFunction actual = RexNodeJsonSerdeTest.this.deserialize(ctx, json);
                Assertions.assertThat((Object)actual).isEqualTo((Object)PERMANENT_FUNCTION);
            }

            @Test
            void withDroppedCatalogFunction() throws Exception {
                SerdeContext ctx = RexNodeJsonSerdeTest.serdeContextWithPermanentFunction(TestCompileAll.this.compilation, this.restore);
                JsonNode json = RexNodeJsonSerdeTest.this.serializePermanentFunction(ctx);
                RexNodeJsonSerdeTest.dropPermanentFunction(ctx);
                Assertions.assertThatThrownBy(() -> RexNodeJsonSerdeTest.this.deserialize(ctx, json)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(TableException.class, (String)"Make sure a registered catalog contains the function")});
            }

            @Test
            void withShadowingTemporaryFunction() throws Exception {
                SerdeContext ctx = RexNodeJsonSerdeTest.serdeContextWithPermanentFunction(TestCompileAll.this.compilation, this.restore);
                JsonNode json = RexNodeJsonSerdeTest.this.serializePermanentFunction(ctx);
                RexNodeJsonSerdeTest.registerTemporaryFunction(ctx);
                ContextResolvedFunction actual = RexNodeJsonSerdeTest.this.deserialize(ctx, json);
                Assertions.assertThat((Object)actual).isEqualTo((Object)ContextResolvedFunction.temporary((FunctionIdentifier)FUNCTION_CAT_ID, (FunctionDefinition)NON_SER_FUNCTION_DEF_IMPL));
            }
        }
    }

    @Nested
    @DisplayName(value="Test CatalogPlanCompilation == IDENTIFIER")
    class TestCompileIdentifier {
        private final TableConfigOptions.CatalogPlanCompilation compilation = TableConfigOptions.CatalogPlanCompilation.IDENTIFIER;

        TestCompileIdentifier() {
        }

        @Nested
        @DisplayName(value="and CatalogPlanRestore == ALL")
        class TestRestoreAll {
            private final TableConfigOptions.CatalogPlanRestore restore = TableConfigOptions.CatalogPlanRestore.ALL;

            TestRestoreAll() {
            }

            @Test
            void withConstantCatalogFunction() throws Exception {
                SerdeContext ctx = RexNodeJsonSerdeTest.serdeContextWithPermanentFunction(TestCompileIdentifier.this.compilation, this.restore);
                JsonNode json = RexNodeJsonSerdeTest.this.serializePermanentFunction(ctx);
                JsonSerdeTestUtil.assertThatJsonDoesNotContain(json, "class");
                ContextResolvedFunction actual = RexNodeJsonSerdeTest.this.deserialize(ctx, json);
                Assertions.assertThat((Object)actual).isEqualTo((Object)PERMANENT_FUNCTION);
            }

            @Test
            void withShadowingTemporaryFunction() throws Exception {
                SerdeContext ctx = RexNodeJsonSerdeTest.serdeContextWithPermanentFunction(TestCompileIdentifier.this.compilation, this.restore);
                JsonNode json = RexNodeJsonSerdeTest.this.serializePermanentFunction(ctx);
                RexNodeJsonSerdeTest.registerTemporaryFunction(ctx);
                ContextResolvedFunction actual = RexNodeJsonSerdeTest.this.deserialize(ctx, json);
                Assertions.assertThat((Object)actual).isEqualTo((Object)ContextResolvedFunction.temporary((FunctionIdentifier)FUNCTION_CAT_ID, (FunctionDefinition)NON_SER_FUNCTION_DEF_IMPL));
            }

            @Test
            void withModifiedCatalogFunction() throws Exception {
                SerdeContext ctx = RexNodeJsonSerdeTest.serdeContextWithPermanentFunction(TestCompileIdentifier.this.compilation, this.restore);
                JsonNode json = RexNodeJsonSerdeTest.this.serializePermanentFunction(ctx);
                RexNodeJsonSerdeTest.modifyPermanentFunction(ctx);
                ContextResolvedFunction actual = RexNodeJsonSerdeTest.this.deserialize(ctx, json);
                Assertions.assertThat((Object)actual).isEqualTo((Object)ContextResolvedFunction.permanent((FunctionIdentifier)FUNCTION_CAT_ID, (FunctionDefinition)SER_UDF_IMPL_OTHER));
            }
        }

        @Nested
        @DisplayName(value="and CatalogPlanRestore == ALL_ENFORCED")
        class TestRestoreAllEnforced {
            private final TableConfigOptions.CatalogPlanRestore restore = TableConfigOptions.CatalogPlanRestore.ALL_ENFORCED;

            TestRestoreAllEnforced() {
            }

            @Test
            void withConstantCatalogFunction() throws Exception {
                SerdeContext ctx = RexNodeJsonSerdeTest.serdeContextWithPermanentFunction(TestCompileIdentifier.this.compilation, this.restore);
                JsonNode json = RexNodeJsonSerdeTest.this.serializePermanentFunction(ctx);
                JsonSerdeTestUtil.assertThatJsonDoesNotContain(json, "class");
                Assertions.assertThatThrownBy(() -> RexNodeJsonSerdeTest.this.deserialize(ctx, json)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(TableException.class, (String)"plan does not include all required catalog metadata")});
            }

            @Test
            void withShadowingTemporaryFunction() throws Exception {
                SerdeContext ctx = RexNodeJsonSerdeTest.serdeContextWithPermanentFunction(TestCompileIdentifier.this.compilation, this.restore);
                JsonNode json = RexNodeJsonSerdeTest.this.serializePermanentFunction(ctx);
                RexNodeJsonSerdeTest.registerTemporaryFunction(ctx);
                ContextResolvedFunction actual = RexNodeJsonSerdeTest.this.deserialize(ctx, json);
                Assertions.assertThat((Object)actual).isEqualTo((Object)ContextResolvedFunction.temporary((FunctionIdentifier)FUNCTION_CAT_ID, (FunctionDefinition)NON_SER_FUNCTION_DEF_IMPL));
            }
        }

        @Nested
        @DisplayName(value="and CatalogPlanRestore == IDENTIFIER")
        class TestRestoreIdentifier {
            private final TableConfigOptions.CatalogPlanRestore restore = TableConfigOptions.CatalogPlanRestore.IDENTIFIER;

            TestRestoreIdentifier() {
            }

            @Test
            void withConstantCatalogFunction() throws Exception {
                SerdeContext ctx = RexNodeJsonSerdeTest.serdeContextWithPermanentFunction(TestCompileIdentifier.this.compilation, this.restore);
                JsonNode json = RexNodeJsonSerdeTest.this.serializePermanentFunction(ctx);
                JsonSerdeTestUtil.assertThatJsonDoesNotContain(json, "class");
                ContextResolvedFunction actual = RexNodeJsonSerdeTest.this.deserialize(ctx, json);
                Assertions.assertThat((Object)actual).isEqualTo((Object)PERMANENT_FUNCTION);
            }

            @Test
            void withDroppedCatalogFunction() throws Exception {
                SerdeContext ctx = RexNodeJsonSerdeTest.serdeContextWithPermanentFunction(TestCompileIdentifier.this.compilation, this.restore);
                JsonNode json = RexNodeJsonSerdeTest.this.serializePermanentFunction(ctx);
                RexNodeJsonSerdeTest.dropPermanentFunction(ctx);
                Assertions.assertThatThrownBy(() -> RexNodeJsonSerdeTest.this.deserialize(ctx, json)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(TableException.class, (String)"Make sure a registered catalog contains the function")});
            }

            @Test
            void withModifiedCatalogFunction() throws Exception {
                SerdeContext ctx = RexNodeJsonSerdeTest.serdeContextWithPermanentFunction(TestCompileIdentifier.this.compilation, this.restore);
                JsonNode json = RexNodeJsonSerdeTest.this.serializePermanentFunction(ctx);
                RexNodeJsonSerdeTest.modifyPermanentFunction(ctx);
                ContextResolvedFunction actual = RexNodeJsonSerdeTest.this.deserialize(ctx, json);
                Assertions.assertThat((Object)actual).isEqualTo((Object)ContextResolvedFunction.permanent((FunctionIdentifier)FUNCTION_CAT_ID, (FunctionDefinition)SER_UDF_IMPL_OTHER));
            }
        }
    }
}

