/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeTestUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RexWindowBoundSerdeTest {
    RexWindowBoundSerdeTest() {
    }

    @Test
    void testSerde() throws IOException {
        SerdeContext serdeCtx = JsonSerdeTestUtil.configuredSerdeContext();
        ObjectReader objectReader = JsonSerdeUtil.createObjectReader((SerdeContext)serdeCtx);
        ObjectWriter objectWriter = JsonSerdeUtil.createObjectWriter((SerdeContext)serdeCtx);
        Assertions.assertThat((Object)objectReader.readValue(objectWriter.writeValueAsString((Object)RexWindowBounds.CURRENT_ROW), RexWindowBound.class)).isEqualTo((Object)RexWindowBounds.CURRENT_ROW);
        Assertions.assertThat((Object)objectReader.readValue(objectWriter.writeValueAsString((Object)RexWindowBounds.UNBOUNDED_FOLLOWING), RexWindowBound.class)).isEqualTo((Object)RexWindowBounds.UNBOUNDED_FOLLOWING);
        Assertions.assertThat((Object)objectReader.readValue(objectWriter.writeValueAsString((Object)RexWindowBounds.UNBOUNDED_PRECEDING), RexWindowBound.class)).isEqualTo((Object)RexWindowBounds.UNBOUNDED_PRECEDING);
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)serdeCtx.getTypeFactory());
        RexWindowBound windowBound = RexWindowBounds.following((RexNode)builder.makeLiteral("test"));
        Assertions.assertThat((Object)objectReader.readValue(objectWriter.writeValueAsString((Object)windowBound), RexWindowBound.class)).isEqualTo((Object)windowBound);
        windowBound = RexWindowBounds.preceding((RexNode)builder.makeLiteral("test"));
        Assertions.assertThat((Object)objectReader.readValue(objectWriter.writeValueAsString((Object)windowBound), RexWindowBound.class)).isEqualTo((Object)windowBound);
    }
}

