/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.time.LocalDateTime;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.types.Row;

public class CalcTestPrograms {
    static final TableTestProgram SIMPLE_CALC = TableTestProgram.of((String)"calc-simple", (String)"validates basic calc node").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"t").addSchema(new String[]{"a BIGINT", "b DOUBLE"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{420L, 42.0})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{421L, 42.1})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a BIGINT", "b DOUBLE"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{421L, 42.0})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{422L, 42.1})}).build()).runSql("INSERT INTO sink_t SELECT a + 1, b FROM t").build();
    static final TableTestProgram CALC_PROJECT_PUSHDOWN = TableTestProgram.of((String)"calc-project-pushdown", (String)"validates calc node with project pushdown").setupTableSource(((SourceTestStep.Builder)((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"a BIGINT", "b DOUBLE"})).addOption("filterable-fields", "a")).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{421L, 42.1})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{421L, 42.1})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a BIGINT", "a1 VARCHAR"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{421L, "421"})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{421L, "421"})}).build()).runSql("INSERT INTO sink_t SELECT a, CAST(a AS VARCHAR) FROM source_t WHERE a > CAST(1 AS BIGINT)").build();
    static final TableTestProgram CALC_FILTER = TableTestProgram.of((String)"calc-filter", (String)"validates calc node with filter").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"a BIGINT", "b INT", "c DOUBLE", "d VARCHAR"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{420L, 1, 42.0, "hello"})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{420L, 1, 42.0, "hello"})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a BIGINT", "b INT", "c DOUBLE", "d VARCHAR"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{420L, 1, 42.0, "hello"})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{420L, 1, 42.0, "hello"})}).build()).runSql("INSERT INTO sink_t SELECT * FROM source_t WHERE b > 0").build();
    static final TableTestProgram CALC_FILTER_PUSHDOWN = TableTestProgram.of((String)"calc-filter-pushdown", (String)"validates calc node with filter pushdown").setupTableSource(((SourceTestStep.Builder)((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"a BIGINT", "b DOUBLE"})).addOption("filterable-fields", "a")).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{421L, 42.1})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{421L, 42.1})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a BIGINT", "b DOUBLE"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{421L, 42.1})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{421L, 42.1})}).build()).runSql("INSERT INTO sink_t SELECT a, b FROM source_t WHERE a > CAST(420 AS BIGINT)").build();
    static final TableTestProgram CALC_SARG = TableTestProgram.of((String)"calc-sarg", (String)"validates calc node with Sarg").setupTableSource(((SourceTestStep.Builder)((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"a INT"})).addOption("filterable-fields", "a")).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{1})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a INT"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{1})}).build()).runSql("INSERT INTO sink_t SELECT a FROM source_t WHERE a = 1 or a = 2 or a is null").build();
    static final TableTestProgram CALC_UDF_SIMPLE = TableTestProgram.of((String)"calc-udf-simple", (String)"validates calc node with simple UDF").setupTemporaryCatalogFunction("udf1", JavaUserDefinedScalarFunctions.JavaFunc0.class).setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"a INT"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{5})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{5})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a INT", "a1 BIGINT"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{5, 6L})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{5, 6L})}).build()).runSql("INSERT INTO sink_t SELECT a, udf1(a) FROM source_t").build();
    static final TableTestProgram CALC_UDF_COMPLEX = TableTestProgram.of((String)"calc-udf-complex", (String)"validates calc node with complex UDFs").setupTemporaryCatalogFunction("udf1", JavaUserDefinedScalarFunctions.JavaFunc0.class).setupTemporaryCatalogFunction("udf2", JavaUserDefinedScalarFunctions.JavaFunc1.class).setupTemporarySystemFunction("udf3", JavaUserDefinedScalarFunctions.JavaFunc2.class).setupTemporarySystemFunction("udf4", JavaUserDefinedScalarFunctions.UdfWithOpen.class).setupCatalogFunction("udf5", JavaUserDefinedScalarFunctions.JavaFunc5.class).setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"a BIGINT, b INT NOT NULL, c VARCHAR, d TIMESTAMP(3)"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{5L, 11, "hello world", LocalDateTime.of(2023, 12, 16, 1, 1, 1, 123)})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{5L, 11, "hello world", LocalDateTime.of(2023, 12, 16, 1, 1, 1, 123)})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a BIGINT", "a1 VARCHAR", "b INT NOT NULL", "b1 VARCHAR", "c1 VARCHAR", "c2 VARCHAR", "d1 TIMESTAMP(3)"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{5L, "5", 11, "11 and 11 and 1702688461000", "hello world11", "$hello", LocalDateTime.of(2023, 12, 16, 1, 1, 0, 0)})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{5L, "5", 11, "11 and 11 and 1702688461000", "hello world11", "$hello", LocalDateTime.of(2023, 12, 16, 1, 1, 0, 0)})}).build()).runSql("INSERT INTO sink_t SELECT a, cast(a as VARCHAR) as a1, b, udf2(b, b, d) as b1, udf3(c, b) as c1, udf4(substring(c, 1, 5)) as c2, udf5(d, 1000) as d1 from source_t where (udf1(a) > 0 or (a * b) < 100) and b > 10").build();
}

