/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.types.Row;

public class JoinTestPrograms {
    static final TableTestProgram NON_WINDOW_INNER_JOIN;
    static final TableTestProgram NON_WINDOW_INNER_JOIN_WITH_NULL;
    static final TableTestProgram CROSS_JOIN;
    static final TableTestProgram JOIN_WITH_FILTER;
    static final TableTestProgram INNER_JOIN_WITH_DUPLICATE_KEY;
    static final TableTestProgram INNER_JOIN_WITH_NON_EQUI_JOIN;
    static final TableTestProgram INNER_JOIN_WITH_EQUAL_PK;
    static final TableTestProgram INNER_JOIN_WITH_PK;
    static final TableTestProgram LEFT_JOIN;
    static final TableTestProgram FULL_OUTER;
    static final TableTestProgram RIGHT_JOIN;
    static final TableTestProgram SEMI_JOIN;
    static final TableTestProgram ANTI_JOIN;
    static final TableTestProgram JOIN_WITH_STATE_TTL_HINT;
    static final SourceTestStep EMPLOYEE;
    static final SourceTestStep DEPARTMENT;
    static final SourceTestStep DEPARTMENT_NONULLS;
    static final SourceTestStep SOURCE_T1;
    static final SourceTestStep SOURCE_T2;

    static {
        EMPLOYEE = ((SourceTestStep.Builder)((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"EMPLOYEE").addSchema(new String[]{"deptno int", "salary bigint", "name varchar"})).addOption("filterable-fields", "salary")).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{null, 101L, "Adam"}), Row.of((Object[])new Object[]{1, 1L, "Baker"}), Row.of((Object[])new Object[]{2, 2L, "Charlie"}), Row.of((Object[])new Object[]{3, 2L, "Don"}), Row.of((Object[])new Object[]{7, 6L, "Victor"})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{4, 3L, "Juliet"}), Row.of((Object[])new Object[]{4, 4L, "Helena"}), Row.of((Object[])new Object[]{1, 1L, "Ivana"})}).build();
        DEPARTMENT = ((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"DEPARTMENT").addSchema(new String[]{"department_num int", "b2 bigint", "b3 int", "department_name varchar"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{null, 102L, 0, "Accounting"}), Row.of((Object[])new Object[]{1, 1L, 0, "Research"}), Row.of((Object[])new Object[]{2, 2L, 1, "Human Resources"}), Row.of((Object[])new Object[]{2, 3L, 2, "HR"}), Row.of((Object[])new Object[]{3, 1L, 2, "Sales"})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{2, 4L, 3, "People Operations"}), Row.of((Object[])new Object[]{4, 2L, 4, "Engineering"})}).build();
        DEPARTMENT_NONULLS = ((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"DEPARTMENT").addSchema(new String[]{"department_num int", "b2 bigint", "b3 int", "department_name varchar"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1, 1L, 0, "Research"}), Row.of((Object[])new Object[]{2, 2L, 1, "Human Resources"}), Row.of((Object[])new Object[]{2, 3L, 2, "HR"}), Row.of((Object[])new Object[]{3, 1L, 2, "Sales"})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{2, 4L, 3, "People Operations"})}).build();
        SOURCE_T1 = ((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"T1").addSchema(new String[]{"a int", "b bigint", "c varchar"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1, 1L, "Baker1"}), Row.of((Object[])new Object[]{1, 2L, "Baker2"}), Row.of((Object[])new Object[]{1, 2L, "Baker2"}), Row.of((Object[])new Object[]{1, 5L, "Baker3"}), Row.of((Object[])new Object[]{2, 7L, "Baker5"}), Row.of((Object[])new Object[]{1, 9L, "Baker6"}), Row.of((Object[])new Object[]{1, 8L, "Baker8"}), Row.of((Object[])new Object[]{3, 8L, "Baker9"})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{1, 1L, "PostRestore"})}).build();
        SOURCE_T2 = ((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"T2").addSchema(new String[]{"a int", "b bigint", "c varchar"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1, 1L, "BakerBaker"}), Row.of((Object[])new Object[]{2, 2L, "HeHe"}), Row.of((Object[])new Object[]{3, 2L, "HeHe"})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{2, 1L, "PostRestoreRight"})}).build();
        NON_WINDOW_INNER_JOIN = TableTestProgram.of((String)"join-non-window-inner-join", (String)"test non-window inner join").setupTableSource(SOURCE_T1).setupTableSource(SOURCE_T2).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"a int", "c1 varchar", "c2 varchar"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1, "BakerBaker", "Baker2"}), Row.of((Object[])new Object[]{1, "BakerBaker", "Baker2"}), Row.of((Object[])new Object[]{1, "BakerBaker", "Baker3"}), Row.of((Object[])new Object[]{2, "HeHe", "Baker5"}), Row.of((Object[])new Object[]{1, "BakerBaker", "Baker6"}), Row.of((Object[])new Object[]{1, "BakerBaker", "Baker8"})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{2, "PostRestoreRight", "Baker5"})}).build()).runSql("insert into MySink SELECT t2.a, t2.c, t1.c\nFROM (\n SELECT if(a = 3, cast(null as int), a) as a, b, c FROM T1\n) as t1\nJOIN (\n SELECT if(a = 3, cast(null as int), a) as a, b, c FROM T2\n) as t2\nON t1.a = t2.a AND t1.b > t2.b").build();
        NON_WINDOW_INNER_JOIN_WITH_NULL = TableTestProgram.of((String)"join-non-window-inner-join-with-null-cond", (String)"test non-window inner join").setupTableSource(SOURCE_T1).setupTableSource(SOURCE_T2).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"a int", "c1 varchar", "c2 varchar"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1, "BakerBaker", "Baker2"}), Row.of((Object[])new Object[]{1, "BakerBaker", "Baker2"}), Row.of((Object[])new Object[]{1, "BakerBaker", "Baker3"}), Row.of((Object[])new Object[]{2, "HeHe", "Baker5"}), Row.of((Object[])new Object[]{1, "BakerBaker", "Baker6"}), Row.of((Object[])new Object[]{1, "BakerBaker", "Baker8"}), Row.of((Object[])new Object[]{null, "HeHe", "Baker9"})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{2, "PostRestoreRight", "Baker5"})}).build()).runSql("insert into MySink SELECT t2.a, t2.c, t1.c\nFROM (\n SELECT if(a = 3, cast(null as int), a) as a, b, c FROM T1\n) as t1\nJOIN (\n SELECT if(a = 3, cast(null as int), a) as a, b, c FROM T2\n) as t2\nON \n  ((t1.a is null AND t2.a is null) OR\n  (t1.a = t2.a))\n  AND t1.b > t2.b").build();
        CROSS_JOIN = TableTestProgram.of((String)"join-cross-join", (String)"test cross join").setupTableSource(EMPLOYEE).setupTableSource(DEPARTMENT).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"name varchar", "department_name varchar"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"Adam", "Accounting"}), Row.of((Object[])new Object[]{"Baker", "Accounting"}), Row.of((Object[])new Object[]{"Adam", "Research"}), Row.of((Object[])new Object[]{"Baker", "Research"}), Row.of((Object[])new Object[]{"Charlie", "Accounting"}), Row.of((Object[])new Object[]{"Charlie", "Research"}), Row.of((Object[])new Object[]{"Charlie", "Human Resources"}), Row.of((Object[])new Object[]{"Adam", "Human Resources"}), Row.of((Object[])new Object[]{"Baker", "Human Resources"}), Row.of((Object[])new Object[]{"Don", "Accounting"}), Row.of((Object[])new Object[]{"Don", "Human Resources"}), Row.of((Object[])new Object[]{"Don", "Research"}), Row.of((Object[])new Object[]{"Victor", "Accounting"}), Row.of((Object[])new Object[]{"Victor", "Human Resources"}), Row.of((Object[])new Object[]{"Victor", "Research"}), Row.of((Object[])new Object[]{"Don", "HR"}), Row.of((Object[])new Object[]{"Charlie", "HR"}), Row.of((Object[])new Object[]{"Adam", "HR"}), Row.of((Object[])new Object[]{"Baker", "HR"}), Row.of((Object[])new Object[]{"Victor", "HR"}), Row.of((Object[])new Object[]{"Don", "Sales"}), Row.of((Object[])new Object[]{"Charlie", "Sales"}), Row.of((Object[])new Object[]{"Adam", "Sales"}), Row.of((Object[])new Object[]{"Baker", "Sales"}), Row.of((Object[])new Object[]{"Victor", "Sales"})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"Juliet", "Human Resources"}), Row.of((Object[])new Object[]{"Juliet", "Sales"}), Row.of((Object[])new Object[]{"Juliet", "Research"}), Row.of((Object[])new Object[]{"Juliet", "Accounting"}), Row.of((Object[])new Object[]{"Juliet", "HR"}), Row.of((Object[])new Object[]{"Juliet", "People Operations"}), Row.of((Object[])new Object[]{"Victor", "People Operations"}), Row.of((Object[])new Object[]{"Charlie", "People Operations"}), Row.of((Object[])new Object[]{"Baker", "People Operations"}), Row.of((Object[])new Object[]{"Adam", "People Operations"}), Row.of((Object[])new Object[]{"Don", "People Operations"}), Row.of((Object[])new Object[]{"Helena", "Accounting"}), Row.of((Object[])new Object[]{"Helena", "Human Resources"}), Row.of((Object[])new Object[]{"Helena", "HR"}), Row.of((Object[])new Object[]{"Helena", "People Operations"}), Row.of((Object[])new Object[]{"Helena", "Sales"}), Row.of((Object[])new Object[]{"Helena", "Research"}), Row.of((Object[])new Object[]{"Don", "Engineering"}), Row.of((Object[])new Object[]{"Adam", "Engineering"}), Row.of((Object[])new Object[]{"Victor", "Engineering"}), Row.of((Object[])new Object[]{"Baker", "Engineering"}), Row.of((Object[])new Object[]{"Charlie", "Engineering"}), Row.of((Object[])new Object[]{"Juliet", "Engineering"}), Row.of((Object[])new Object[]{"Helena", "Engineering"}), Row.of((Object[])new Object[]{"Ivana", "Accounting"}), Row.of((Object[])new Object[]{"Ivana", "Human Resources"}), Row.of((Object[])new Object[]{"Ivana", "HR"}), Row.of((Object[])new Object[]{"Ivana", "Engineering"}), Row.of((Object[])new Object[]{"Ivana", "People Operations"}), Row.of((Object[])new Object[]{"Ivana", "Sales"}), Row.of((Object[])new Object[]{"Ivana", "Research"})}).build()).runSql("insert into MySink SELECT name, department_name FROM EMPLOYEE, DEPARTMENT").build();
        JOIN_WITH_FILTER = TableTestProgram.of((String)"join-with-filter", (String)"test join with filter").setupTableSource(EMPLOYEE).setupTableSource(DEPARTMENT).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"name varchar", "department_name varchar"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"Baker", "Research"}), Row.of((Object[])new Object[]{"Baker", "Sales"})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"Ivana", "Sales"}), Row.of((Object[])new Object[]{"Ivana", "Research"})}).build()).runSql("insert into MySink SELECT name, department_name FROM EMPLOYEE, DEPARTMENT where salary = b2 and salary < CAST(2 AS BIGINT)").build();
        INNER_JOIN_WITH_DUPLICATE_KEY = TableTestProgram.of((String)"join-inner-join-with-duplicate-key", (String)"inner join with duplicate key").setupTableSource(EMPLOYEE).setupTableSource(DEPARTMENT).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"deptno int", "department_num int"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{2, 2})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{4, 4}), Row.of((Object[])new Object[]{4, 4})}).build()).runSql("insert into MySink SELECT deptno, department_num FROM EMPLOYEE JOIN DEPARTMENT ON deptno = department_num AND deptno = b3").build();
        INNER_JOIN_WITH_NON_EQUI_JOIN = TableTestProgram.of((String)"join-inner-join-with-non-equi-join", (String)"inner join with non-equi join").setupTableSource(EMPLOYEE).setupTableSource(DEPARTMENT).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"name varchar", "department_name varchar"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"Don", "Sales"})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"Helena", "Engineering"}), Row.of((Object[])new Object[]{"Juliet", "Engineering"})}).build()).runSql("insert into MySink SELECT name, department_name FROM EMPLOYEE JOIN DEPARTMENT ON deptno = department_num AND salary > b2").build();
        String query1 = "SELECT MIN(salary) AS salary, deptno FROM EMPLOYEE GROUP BY deptno";
        String query2 = "SELECT MIN(b2) AS b2, department_num FROM DEPARTMENT GROUP BY department_num";
        INNER_JOIN_WITH_EQUAL_PK = TableTestProgram.of((String)"join-inner-join-with-equal-pk", (String)"inner join with equal pk").setupTableSource(EMPLOYEE).setupTableSource(DEPARTMENT).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"deptno int", "department_num int"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1, 1}), Row.of((Object[])new Object[]{2, 2}), Row.of((Object[])new Object[]{3, 3})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{4, 4})}).build()).runSql(String.format("INSERT INTO MySink SELECT deptno, department_num FROM (%s) JOIN (%s) ON deptno = department_num", query1, query2)).build();
        INNER_JOIN_WITH_PK = TableTestProgram.of((String)"join-inner-join-with-pk", (String)"inner join with pk").setupTableSource(EMPLOYEE).setupTableSource(DEPARTMENT).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"deptno int", "department_num int"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1, 1}), Row.of((Object[])new Object[]{2, 2}), Row.of((Object[])new Object[]{3, 2}), Row.of((Object[])new Object[]{1, 3})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{3, 4}), Row.of((Object[])new Object[]{2, 4})}).testMaterializedData().build()).runSql(String.format("INSERT INTO MySink SELECT deptno, department_num FROM (%s) JOIN (%s) ON salary = b2", query1, query2)).build();
        FULL_OUTER = TableTestProgram.of((String)"join-outer-join", (String)"outer join").setupTableSource(EMPLOYEE).setupTableSource(DEPARTMENT).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"name varchar", "department_name varchar"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"Adam", null}), Row.of((Object[])new Object[]{null, "Accounting"}), Row.of((Object[])new Object[]{"Baker", "Research"}), Row.of((Object[])new Object[]{"Charlie", "Human Resources"}), Row.of((Object[])new Object[]{"Charlie", "HR"}), Row.of((Object[])new Object[]{"Don", "Sales"}), Row.of((Object[])new Object[]{"Victor", null})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"Helena", "Engineering"}), Row.of((Object[])new Object[]{"Juliet", "Engineering"}), Row.of((Object[])new Object[]{"Ivana", "Research"}), Row.of((Object[])new Object[]{"Charlie", "People Operations"})}).testMaterializedData().build()).runSql("insert into MySink SELECT name, department_name FROM EMPLOYEE FULL OUTER JOIN DEPARTMENT ON deptno = department_num").build();
        LEFT_JOIN = TableTestProgram.of((String)"join-left-join", (String)"left join").setupTableSource(EMPLOYEE).setupTableSource(DEPARTMENT).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"name varchar", "department_name varchar"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"Adam", null}), Row.of((Object[])new Object[]{"Baker", "Research"}), Row.of((Object[])new Object[]{"Charlie", "Human Resources"}), Row.of((Object[])new Object[]{"Charlie", "HR"}), Row.of((Object[])new Object[]{"Don", "Sales"}), Row.of((Object[])new Object[]{"Victor", null})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"Helena", "Engineering"}), Row.of((Object[])new Object[]{"Juliet", "Engineering"}), Row.of((Object[])new Object[]{"Ivana", "Research"}), Row.of((Object[])new Object[]{"Charlie", "People Operations"})}).testMaterializedData().build()).runSql("insert into MySink SELECT name, department_name FROM EMPLOYEE LEFT JOIN DEPARTMENT ON deptno = department_num").build();
        RIGHT_JOIN = TableTestProgram.of((String)"join-right-join", (String)"right join").setupTableSource(EMPLOYEE).setupTableSource(DEPARTMENT).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"name varchar", "department_name varchar"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{null, "Accounting"}), Row.of((Object[])new Object[]{"Baker", "Research"}), Row.of((Object[])new Object[]{"Charlie", "Human Resources"}), Row.of((Object[])new Object[]{"Charlie", "HR"}), Row.of((Object[])new Object[]{"Don", "Sales"})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"Helena", "Engineering"}), Row.of((Object[])new Object[]{"Juliet", "Engineering"}), Row.of((Object[])new Object[]{"Ivana", "Research"}), Row.of((Object[])new Object[]{"Charlie", "People Operations"})}).testMaterializedData().build()).runSql("insert into MySink SELECT name, department_name FROM EMPLOYEE RIGHT OUTER JOIN DEPARTMENT ON deptno = department_num").build();
        SEMI_JOIN = TableTestProgram.of((String)"join-semi-join", (String)"semi join").setupTableSource(EMPLOYEE).setupTableSource(DEPARTMENT).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"name varchar"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"Baker"}), Row.of((Object[])new Object[]{"Charlie"}), Row.of((Object[])new Object[]{"Don"})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"Helena"}), Row.of((Object[])new Object[]{"Juliet"}), Row.of((Object[])new Object[]{"Ivana"})}).build()).runSql("insert into MySink SELECT name FROM EMPLOYEE WHERE deptno IN (SELECT department_num FROM DEPARTMENT)").build();
        ANTI_JOIN = TableTestProgram.of((String)"join-anti-join", (String)"anti join").setupTableSource(EMPLOYEE).setupTableSource(DEPARTMENT_NONULLS).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"name varchar"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"Victor"})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"Juliet"}), Row.of((Object[])new Object[]{"Helena"})}).testMaterializedData().build()).runSql("insert into MySink SELECT name FROM EMPLOYEE WHERE deptno NOT IN (SELECT department_num FROM DEPARTMENT)").build();
        JOIN_WITH_STATE_TTL_HINT = TableTestProgram.of((String)"join-with-state-ttl-hint", (String)"join with state ttl hint").setupTableSource(EMPLOYEE).setupTableSource(DEPARTMENT).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"deptno int", "department_num int"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1, 1}), Row.of((Object[])new Object[]{2, 2}), Row.of((Object[])new Object[]{3, 3})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{4, 4})}).build()).runSql(String.format("INSERT INTO MySink SELECT /*+ STATE_TTL('v1' = '1d', 'v2' = '4d'), STATE_TTL('v2' = '8d') */deptno, department_num FROM (%s) v1 JOIN (%s) v2 ON deptno = department_num", query1, query2)).build();
    }
}

