/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.types.Row;

public class LookupJoinTestPrograms {
    static final String[] CUSTOMERS_SCHEMA = new String[]{"id INT PRIMARY KEY NOT ENFORCED", "name STRING", "age INT", "city STRING", "state STRING", "zipcode INT"};
    static final Row[] CUSTOMERS_BEFORE_DATA = new Row[]{Row.of((Object[])new Object[]{1, "Bob", 28, "Mountain View", "California", 94043}), Row.of((Object[])new Object[]{2, "Alice", 32, "San Francisco", "California", 95016}), Row.of((Object[])new Object[]{3, "Claire", 37, "Austin", "Texas", 73301}), Row.of((Object[])new Object[]{4, "Shannon", 29, "Boise", "Idaho", 83701}), Row.of((Object[])new Object[]{5, "Jake", 42, "New York City", "New York", 10001})};
    static final Row[] CUSTOMERS_AFTER_DATA = new Row[]{Row.of((Object[])new Object[]{1, "Bob", 28, "San Jose", "California", 94089}), Row.of((Object[])new Object[]{6, "Joana", 54, "Atlanta", "Georgia", 30033})};
    static final SourceTestStep CUSTOMERS = ((SourceTestStep.Builder)((SourceTestStep.Builder)((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"customers_t").addOption("disable-lookup", "false")).addOption("filterable-fields", "age")).addSchema(CUSTOMERS_SCHEMA)).producedBeforeRestore(CUSTOMERS_BEFORE_DATA).producedAfterRestore(CUSTOMERS_AFTER_DATA).build();
    static final SourceTestStep CUSTOMERS_ASYNC = ((SourceTestStep.Builder)((SourceTestStep.Builder)((SourceTestStep.Builder)((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"customers_t").addOption("disable-lookup", "false")).addOption("filterable-fields", "age")).addOption("async", "true")).addSchema(CUSTOMERS_SCHEMA)).producedBeforeRestore(CUSTOMERS_BEFORE_DATA).producedAfterRestore(CUSTOMERS_AFTER_DATA).build();
    static final SourceTestStep ORDERS = ((SourceTestStep.Builder)((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"orders_t").addOption("filterable-fields", "customer_id")).addSchema(new String[]{"order_id INT", "customer_id INT", "total DOUBLE", "order_time STRING", "proc_time AS PROCTIME()"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1, 3, 44.44, "2020-10-10 00:00:01"}), Row.of((Object[])new Object[]{2, 5, 100.02, "2020-10-10 00:00:02"}), Row.of((Object[])new Object[]{4, 2, 92.61, "2020-10-10 00:00:04"}), Row.of((Object[])new Object[]{3, 1, 23.89, "2020-10-10 00:00:03"}), Row.of((Object[])new Object[]{6, 4, 7.65, "2020-10-10 00:00:06"}), Row.of((Object[])new Object[]{5, 2, 12.78, "2020-10-10 00:00:05"})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{7, 6, 17.58, "2020-10-10 00:00:07"}), Row.of((Object[])new Object[]{9, 1, 143.21, "2020-10-10 00:00:08"})}).build();
    static final List<String> SINK_SCHEMA = Arrays.asList("order_id INT", "total DOUBLE", "id INT", "name STRING", "age INT", "city STRING", "state STRING", "zipcode INT");
    static final TableTestProgram LOOKUP_JOIN_PROJECT_PUSHDOWN = TableTestProgram.of((String)"lookup-join-project-pushdown", (String)"validates lookup join with project pushdown").setupTableSource(CUSTOMERS).setupTableSource(ORDERS).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_SCHEMA.stream().filter(field -> !field.equals("age INT")).collect(Collectors.toList()))).consumedBeforeRestore(new String[]{"+I[1, 44.44, 3, Claire, Austin, Texas, 73301]", "+I[2, 100.02, 5, Jake, New York City, New York, 10001]", "+I[4, 92.61, 2, Alice, San Francisco, California, 95016]", "+I[3, 23.89, 1, Bob, Mountain View, California, 94043]", "+I[6, 7.65, 4, Shannon, Boise, Idaho, 83701]", "+I[5, 12.78, 2, Alice, San Francisco, California, 95016]"}).consumedAfterRestore(new String[]{"+I[7, 17.58, 6, Joana, Atlanta, Georgia, 30033]", "+I[9, 143.21, 1, Bob, San Jose, California, 94089]"}).build()).runSql("INSERT INTO sink_t SELECT O.order_id, O.total, C.id, C.name, C.city, C.state, C.zipcode FROM orders_t as O JOIN customers_t FOR SYSTEM_TIME AS OF O.proc_time AS C ON O.customer_id = C.id").build();
    static final TableTestProgram LOOKUP_JOIN_FILTER_PUSHDOWN = TableTestProgram.of((String)"lookup-join-filter-pushdown", (String)"validates lookup join with filter pushdown").setupTableSource(CUSTOMERS).setupTableSource(ORDERS).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_SCHEMA)).consumedBeforeRestore(new String[]{"+I[1, 44.44, 3, Claire, 37, Austin, Texas, 73301]", "+I[2, 100.02, 5, Jake, 42, New York City, New York, 10001]", "+I[4, 92.61, 2, Alice, 32, San Francisco, California, 95016]", "+I[5, 12.78, 2, Alice, 32, San Francisco, California, 95016]"}).consumedAfterRestore(new String[]{"+I[7, 17.58, 6, Joana, 54, Atlanta, Georgia, 30033]"}).build()).runSql("INSERT INTO sink_t SELECT O.order_id, O.total, C.id, C.name, C.age, C.city, C.state, C.zipcode FROM orders_t as O JOIN customers_t FOR SYSTEM_TIME AS OF O.proc_time AS C ON O.customer_id = C.id AND C.age > 30").build();
    static final TableTestProgram LOOKUP_JOIN_PRE_FILTER = TableTestProgram.of((String)"lookup-join-pre-filter", (String)"validates lookup join with pre filter").setupTableSource(CUSTOMERS).setupTableSource(ORDERS).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_SCHEMA)).consumedBeforeRestore(new String[]{"+I[1, 44.44, 3, Claire, 37, Austin, Texas, 73301]", "+I[2, 100.02, 5, Jake, 42, New York City, New York, 10001]", "+I[4, 92.61, 2, Alice, 32, San Francisco, California, 95016]", "+I[3, 23.89, null, null, null, null, null, null]", "+I[6, 7.65, null, null, null, null, null, null]", "+I[5, 12.78, null, null, null, null, null, null]"}).consumedAfterRestore(new String[]{"+I[7, 17.58, 6, Joana, 54, Atlanta, Georgia, 30033]", "+I[9, 143.21, null, null, null, null, null, null]"}).build()).runSql("INSERT INTO sink_t SELECT O.order_id, O.total, C.id, C.name, C.age, C.city, C.state, C.zipcode FROM orders_t as O LEFT JOIN customers_t FOR SYSTEM_TIME AS OF O.proc_time AS C ON O.customer_id = C.id AND C.age > 30 AND O.total > 15.3").build();
    static final TableTestProgram LOOKUP_JOIN_POST_FILTER = TableTestProgram.of((String)"lookup-join-post-filter", (String)"validates lookup join with post filter").setupTableSource(CUSTOMERS).setupTableSource(ORDERS).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_SCHEMA)).consumedBeforeRestore(new String[]{"+I[1, 44.44, null, null, null, null, null, null]", "+I[2, 100.02, null, null, null, null, null, null]", "+I[4, 92.61, null, null, null, null, null, null]", "+I[3, 23.89, 1, Bob, 28, Mountain View, California, 94043]", "+I[6, 7.65, 4, Shannon, 29, Boise, Idaho, 83701]", "+I[5, 12.78, 2, Alice, 32, San Francisco, California, 95016]"}).consumedAfterRestore(new String[]{"+I[7, 17.58, 6, Joana, 54, Atlanta, Georgia, 30033]", "+I[9, 143.21, null, null, null, null, null, null]"}).build()).runSql("INSERT INTO sink_t SELECT O.order_id, O.total, C.id, C.name, C.age, C.city, C.state, C.zipcode FROM orders_t as O LEFT JOIN customers_t FOR SYSTEM_TIME AS OF O.proc_time AS C ON O.customer_id = C.id AND CAST(O.total AS INT) < C.age").build();
    static final TableTestProgram LOOKUP_JOIN_PRE_POST_FILTER = TableTestProgram.of((String)"lookup-join-pre-post-filter", (String)"validates lookup join with pre and post filters").setupTableSource(CUSTOMERS).setupTableSource(ORDERS).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_SCHEMA)).consumedBeforeRestore(new String[]{"+I[1, 44.44, null, null, null, null, null, null]", "+I[2, 100.02, null, null, null, null, null, null]", "+I[4, 92.61, null, null, null, null, null, null]", "+I[3, 23.89, 1, Bob, 28, Mountain View, California, 94043]", "+I[6, 7.65, null, null, null, null, null, null]", "+I[5, 12.78, null, null, null, null, null, null]"}).consumedAfterRestore(new String[]{"+I[7, 17.58, 6, Joana, 54, Atlanta, Georgia, 30033]", "+I[9, 143.21, null, null, null, null, null, null]"}).build()).runSql("INSERT INTO sink_t SELECT O.order_id, O.total, C.id, C.name, C.age, C.city, C.state, C.zipcode FROM orders_t as O LEFT JOIN customers_t FOR SYSTEM_TIME AS OF O.proc_time AS C ON O.customer_id = C.id AND O.total > 15.3 AND CAST(O.total AS INT) < C.age").build();
    static final TableTestProgram LOOKUP_JOIN_LEFT_JOIN = TableTestProgram.of((String)"lookup-join-left-join", (String)"validates lookup join with left join").setupTableSource(CUSTOMERS).setupTableSource(ORDERS).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_SCHEMA)).consumedBeforeRestore(new String[]{"+I[1, 44.44, null, null, null, null, null, null]", "+I[2, 100.02, 5, Jake, 42, New York City, New York, 10001]", "+I[4, 92.61, 2, Alice, 32, San Francisco, California, 95016]", "+I[3, 23.89, null, null, null, null, null, null]", "+I[6, 7.65, null, null, null, null, null, null]", "+I[5, 12.78, 2, Alice, 32, San Francisco, California, 95016]"}).consumedAfterRestore(new String[]{"+I[7, 17.58, 6, Joana, 54, Atlanta, Georgia, 30033]", "+I[9, 143.21, null, null, null, null, null, null]"}).build()).runSql("INSERT INTO sink_t SELECT O.order_id, O.total, C.id, C.name, C.age, C.city, C.state, C.zipcode FROM orders_t as O LEFT JOIN customers_t FOR SYSTEM_TIME AS OF O.proc_time AS C ON O.customer_id = C.id AND C.age > 30 AND O.customer_id <> 3").build();
    static final TableTestProgram LOOKUP_JOIN_ASYNC_HINT = TableTestProgram.of((String)"lookup-join-async-hint", (String)"validates lookup join with async hint").setupTableSource(CUSTOMERS_ASYNC).setupTableSource(ORDERS).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_SCHEMA)).consumedBeforeRestore(new String[]{"+I[1, 44.44, 3, Claire, 37, Austin, Texas, 73301]", "+I[2, 100.02, 5, Jake, 42, New York City, New York, 10001]", "+I[4, 92.61, 2, Alice, 32, San Francisco, California, 95016]", "+I[3, 23.89, 1, Bob, 28, Mountain View, California, 94043]", "+I[6, 7.65, 4, Shannon, 29, Boise, Idaho, 83701]", "+I[5, 12.78, 2, Alice, 32, San Francisco, California, 95016]"}).consumedAfterRestore(new String[]{"+I[7, 17.58, 6, Joana, 54, Atlanta, Georgia, 30033]", "+I[9, 143.21, 1, Bob, 28, San Jose, California, 94089]"}).build()).runSql("INSERT INTO sink_t SELECT /*+ LOOKUP('table'='C', 'async'='true', 'output-mode'='allow_unordered', 'timeout'='500s', 'capacity'='2000') */ O.order_id, O.total, C.id, C.name, C.age, C.city, C.state, C.zipcode FROM orders_t as O JOIN customers_t FOR SYSTEM_TIME AS OF O.proc_time AS C ON O.customer_id = C.id").build();
    static final TableTestProgram LOOKUP_JOIN_RETRY_HINT = TableTestProgram.of((String)"lookup-join-retry-hint", (String)"validates lookup join with retry hint").setupTableSource(CUSTOMERS).setupTableSource(ORDERS).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(SINK_SCHEMA)).consumedBeforeRestore(new String[]{"+I[1, 44.44, 3, Claire, 37, Austin, Texas, 73301]", "+I[2, 100.02, 5, Jake, 42, New York City, New York, 10001]", "+I[4, 92.61, 2, Alice, 32, San Francisco, California, 95016]", "+I[3, 23.89, 1, Bob, 28, Mountain View, California, 94043]", "+I[6, 7.65, 4, Shannon, 29, Boise, Idaho, 83701]", "+I[5, 12.78, 2, Alice, 32, San Francisco, California, 95016]"}).consumedAfterRestore(new String[]{"+I[7, 17.58, 6, Joana, 54, Atlanta, Georgia, 30033]", "+I[9, 143.21, 1, Bob, 28, San Jose, California, 94089]"}).build()).runSql("INSERT INTO sink_t SELECT /*+ LOOKUP('table'='C', 'retry-predicate'='lookup_miss', 'retry-strategy'='fixed_delay', 'fixed-delay'='10s', 'max-attempts'='3') */ O.order_id, O.total, C.id, C.name, C.age, C.city, C.state, C.zipcode FROM orders_t as O JOIN customers_t FOR SYSTEM_TIME AS OF O.proc_time AS C ON O.customer_id = C.id").build();
}

