/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.types.Row;

public class MatchRecognizeTestPrograms {
    static final Row[] SIMPLE_DATA = new Row[]{Row.of((Object[])new Object[]{1L, "a"}), Row.of((Object[])new Object[]{2L, "z"}), Row.of((Object[])new Object[]{3L, "b"}), Row.of((Object[])new Object[]{4L, "c"}), Row.of((Object[])new Object[]{5L, "d"}), Row.of((Object[])new Object[]{6L, "a"}), Row.of((Object[])new Object[]{7L, "b"}), Row.of((Object[])new Object[]{8L, "c"}), Row.of((Object[])new Object[]{9L, "a"}), Row.of((Object[])new Object[]{10L, "b"})};
    static final Row[] SIMPLE_DATA2 = new Row[]{Row.of((Object[])new Object[]{11L, "c"})};
    static final Row[] COMPLEX_DATA = new Row[]{Row.of((Object[])new Object[]{"ACME", 1L, 19, 1}), Row.of((Object[])new Object[]{"BETA", 2L, 18, 1}), Row.of((Object[])new Object[]{"ACME", 3L, 17, 2}), Row.of((Object[])new Object[]{"ACME", 4L, 13, 3}), Row.of((Object[])new Object[]{"BETA", 5L, 16, 2}), Row.of((Object[])new Object[]{"ACME", 6L, 20, 4})};
    static final Row[] COMPLEX_DATA2 = new Row[]{Row.of((Object[])new Object[]{"BETA", 7L, 22, 4})};
    static final TableTestProgram MATCH_SIMPLE = TableTestProgram.of((String)"match-simple", (String)"simple match recognize test").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"MyTable").addSchema(new String[]{"id bigint", "name varchar", "proctime as PROCTIME()"})).producedBeforeRestore(SIMPLE_DATA).producedAfterRestore(SIMPLE_DATA2).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"a bigint", "b bigint", "c bigint"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{6L, 7L, 8L})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{9L, 10L, 11L})}).build()).runSql("insert into MySink SELECT T.aid, T.bid, T.cid\n     FROM MyTable MATCH_RECOGNIZE (\n             ORDER BY proctime\n             MEASURES\n             `A\"`.id AS aid,\n             l.id AS bid,\n             C.id AS cid\n             PATTERN (`A\"` l C)\n             DEFINE\n                 `A\"` AS name = 'a',\n                 l AS name = 'b',\n                 C AS name = 'c'\n     ) AS T").build();
    static final TableTestProgram MATCH_COMPLEX = TableTestProgram.of((String)"match-complex", (String)"complex match recognize test").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"MyTable").addSchema(new String[]{"symbol string", "tstamp bigint", "price int", "tax int", "proctime as PROCTIME()"})).producedBeforeRestore(COMPLEX_DATA).producedAfterRestore(COMPLEX_DATA2).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"somestring string", "a bigint", "b bigint", "c bigint"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"ACME", 19L, 13L, null})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"BETA", 18L, 16L, null})}).build()).runSql("insert into MySink SELECT * FROM MyTable MATCH_RECOGNIZE (\n  PARTITION BY symbol\n  ORDER BY proctime\n  MEASURES\n    FIRST(DOWN.price) as first,\n    LAST(DOWN.price) as last,\n    FIRST(DOWN.price, 5) as nullPrice\n  ONE ROW PER MATCH\n  AFTER MATCH SKIP PAST LAST ROW\n  PATTERN (DOWN{2,} UP)\n  DEFINE\n    DOWN AS price < LAST(DOWN.price, 1) OR LAST(DOWN.price, 1) IS NULL,\n    UP AS price > LAST(DOWN.price)\n) AS T").build();
    static final Row[] BEFORE_DATA = new Row[]{Row.of((Object[])new Object[]{"2020-10-10 00:00:01", 10, 3}), Row.of((Object[])new Object[]{"2020-10-10 00:00:01", 8, 2}), Row.of((Object[])new Object[]{"2020-10-10 00:00:01", 9, 1}), Row.of((Object[])new Object[]{"2020-10-10 00:00:04", 7, 4}), Row.of((Object[])new Object[]{"2020-10-10 00:00:07", 8, 5}), Row.of((Object[])new Object[]{"2020-10-10 00:00:06", 5, 6}), Row.of((Object[])new Object[]{"2020-10-10 00:00:12", 3, 7}), Row.of((Object[])new Object[]{"2020-10-10 00:00:08", 4, 8}), Row.of((Object[])new Object[]{"2020-10-10 00:00:16", 4, 9}), Row.of((Object[])new Object[]{"2020-10-10 00:00:32", 7, 10}), Row.of((Object[])new Object[]{"2020-10-10 00:00:34", 5, 11})};
    static final Row[] AFTER_DATA = new Row[]{Row.of((Object[])new Object[]{"2020-10-10 00:00:33", 9, 12}), Row.of((Object[])new Object[]{"2020-10-10 00:00:41", 3, 13}), Row.of((Object[])new Object[]{"2020-10-10 00:00:42", 11, 16}), Row.of((Object[])new Object[]{"2020-10-10 00:00:43", 12, 15}), Row.of((Object[])new Object[]{"2020-10-10 00:00:44", 13, 14})};
    static final SourceTestStep SOURCE = ((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"MyEventTimeTable").addSchema(new String[]{"ts STRING", "price INT", "sequence_num INT", "`rowtime` AS TO_TIMESTAMP(`ts`)", "`proctime` AS PROCTIME()", "WATERMARK for `rowtime` AS `rowtime` - INTERVAL '2' SECOND"})).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build();
    static final TableTestProgram MATCH_ORDER_BY_EVENT_TIME = TableTestProgram.of((String)"match-order-by-event-time", (String)"complex match recognize test").setupTableSource(SOURCE).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"first bigint", "last bigint", "up bigint"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{10L, 8L, 9L}), Row.of((Object[])new Object[]{7L, 5L, 8L})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{9L, 3L, 11L})}).build()).runSql(MatchRecognizeTestPrograms.getEventTimeSql("ORDER BY rowtime")).build();
    static final TableTestProgram MATCH_ORDER_BY_INT_COLUMN = TableTestProgram.of((String)"match-order-by-int-column", (String)"complex match recognize test").setupTableSource(SOURCE).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"first bigint", "last bigint", "up bigint"})).consumedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{9L, 8L, 10L}), Row.of((Object[])new Object[]{7L, 5L, 8L})}).consumedAfterRestore(new Row[]{Row.of((Object[])new Object[]{9L, 3L, 11L})}).build()).runSql(MatchRecognizeTestPrograms.getEventTimeSql("ORDER BY rowtime, sequence_num")).build();
    static final TableTestProgram MATCH_SKIP_TO_FIRST = MatchRecognizeTestPrograms.getSkipTestProgram("match-skip-to-first", "skip to first match recognize test", "AFTER MATCH SKIP TO FIRST B", new Row[]{Row.of((Object[])new Object[]{1L, 100, 106}), Row.of((Object[])new Object[]{1L, 105, 107}), Row.of((Object[])new Object[]{1L, 101, 101})}, new Row[]{Row.of((Object[])new Object[]{1L, 100, 111})});
    static final TableTestProgram MATCH_SKIP_TO_LAST = MatchRecognizeTestPrograms.getSkipTestProgram("match-skip-to-last", "skip to last match recognize test", "AFTER MATCH SKIP TO LAST B", new Row[]{Row.of((Object[])new Object[]{1L, 100, 106}), Row.of((Object[])new Object[]{1L, 105, 107}), Row.of((Object[])new Object[]{1L, 101, 101})}, new Row[]{Row.of((Object[])new Object[]{1L, 100, 111})});
    static final TableTestProgram MATCH_SKIP_TO_NEXT_ROW = MatchRecognizeTestPrograms.getSkipTestProgram("match-skip-to-next-row", "skip to next row match recognize test", "AFTER MATCH SKIP TO NEXT ROW", new Row[]{Row.of((Object[])new Object[]{1L, 100, 106}), Row.of((Object[])new Object[]{1L, 102, 106}), Row.of((Object[])new Object[]{1L, 104, 106}), Row.of((Object[])new Object[]{1L, 106, 106}), Row.of((Object[])new Object[]{1L, 105, 107}), Row.of((Object[])new Object[]{1L, 107, 107}), Row.of((Object[])new Object[]{1L, 101, 101})}, new Row[]{Row.of((Object[])new Object[]{1L, 100, 111}), Row.of((Object[])new Object[]{1L, 110, 111}), Row.of((Object[])new Object[]{1L, 111, 111})});
    static final TableTestProgram MATCH_SKIP_PAST_LAST_ROW = MatchRecognizeTestPrograms.getSkipTestProgram("match-skip-past-last-row", "skip past last row match recognize test", "AFTER MATCH SKIP PAST LAST ROW", new Row[]{Row.of((Object[])new Object[]{1L, 100, 106}), Row.of((Object[])new Object[]{1L, 107, 107})}, new Row[]{Row.of((Object[])new Object[]{1L, 100, 111})});

    private static String getEventTimeSql(String orderByClause) {
        String sql = "insert into MySink SELECT * FROM MyEventTimeTable MATCH_RECOGNIZE (\n   %s\n  MEASURES\n    FIRST(DOWN.price) as first,\n    LAST(DOWN.price) as last,\n    UP.price as up\n  ONE ROW PER MATCH\n  AFTER MATCH SKIP PAST LAST ROW\n  PATTERN (DOWN{2,} UP)\n  DEFINE\n    DOWN AS price < LAST(DOWN.price, 1) OR LAST(DOWN.price, 1) IS NULL,\n    UP AS price > LAST(DOWN.price)\n) AS T";
        return String.format("insert into MySink SELECT * FROM MyEventTimeTable MATCH_RECOGNIZE (\n   %s\n  MEASURES\n    FIRST(DOWN.price) as first,\n    LAST(DOWN.price) as last,\n    UP.price as up\n  ONE ROW PER MATCH\n  AFTER MATCH SKIP PAST LAST ROW\n  PATTERN (DOWN{2,} UP)\n  DEFINE\n    DOWN AS price < LAST(DOWN.price, 1) OR LAST(DOWN.price, 1) IS NULL,\n    UP AS price > LAST(DOWN.price)\n) AS T", orderByClause);
    }

    private static TableTestProgram getSkipTestProgram(String name, String description, String skipClause, Row[] beforeRows, Row[] afterRows) {
        return TableTestProgram.of((String)name, (String)description).setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"MyTable").addSchema(new String[]{"  vehicle_id bigint,\n  engine_temperature int,\n  proctime as PROCTIME()"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1L, 100}), Row.of((Object[])new Object[]{1L, 102}), Row.of((Object[])new Object[]{1L, 104}), Row.of((Object[])new Object[]{1L, 106}), Row.of((Object[])new Object[]{1L, 105}), Row.of((Object[])new Object[]{1L, 107}), Row.of((Object[])new Object[]{1L, 101}), Row.of((Object[])new Object[]{1L, 100})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{1L, 110}), Row.of((Object[])new Object[]{1L, 111}), Row.of((Object[])new Object[]{1L, 99})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"  vehicle_id bigint,\n  Initial_Temp int,\n  Final_Temp int\n"})).consumedBeforeRestore(beforeRows).consumedAfterRestore(afterRows).build()).runSql(MatchRecognizeTestPrograms.getSql(skipClause)).build();
    }

    private static String getSql(String afterClause) {
        String sql = "insert into MySink SELECT * FROM\n MyTable\n   MATCH_RECOGNIZE(\n   PARTITION BY vehicle_id\n   ORDER BY `proctime`\n   MEASURES \n       FIRST(A.engine_temperature) as Initial_Temp,\n       LAST(A.engine_temperature) as Final_Temp\n   ONE ROW PER MATCH\n   %s\n   PATTERN (A+ B)\n   DEFINE\n       A as LAST(A.engine_temperature,1) is NULL OR A.engine_temperature > LAST(A.engine_temperature,1),\n       B as B.engine_temperature < LAST(A.engine_temperature)\n   )MR;";
        return String.format("insert into MySink SELECT * FROM\n MyTable\n   MATCH_RECOGNIZE(\n   PARTITION BY vehicle_id\n   ORDER BY `proctime`\n   MEASURES \n       FIRST(A.engine_temperature) as Initial_Temp,\n       LAST(A.engine_temperature) as Final_Temp\n   ONE ROW PER MATCH\n   %s\n   PATTERN (A+ B)\n   DEFINE\n       A as LAST(A.engine_temperature,1) is NULL OR A.engine_temperature > LAST(A.engine_temperature,1),\n       B as B.engine_temperature < LAST(A.engine_temperature)\n   )MR;", afterClause);
    }
}

