/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.time.Duration;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.types.Row;

public class MiniBatchAssignerTestPrograms {
    static final String[] ROW_TIME_SCHEMA = new String[]{"ts STRING", "id STRING", "num INT", "name STRING", "row_time AS TO_TIMESTAMP(`ts`)", "WATERMARK for `row_time` AS `row_time` - INTERVAL '1' SECOND"};
    static final TableTestProgram MINI_BATCH_ASSIGNER_ROW_TIME = TableTestProgram.of((String)"mini-batch-assigner-row-time", (String)"validates mini batch assigner with row time").setupConfig(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)true).setupConfig(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L)).setupConfig(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)5L).setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_one_t").addSchema(ROW_TIME_SCHEMA)).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"2020-10-10 00:00:01", "L1", 1, "a"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:02", "L2", 2, "c"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:03", "L3", 2, "x"})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"2020-10-10 00:00:41", "L41", 10, "a"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:42", "L42", 11, "c"})}).build()).setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_two_t").addSchema(ROW_TIME_SCHEMA)).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"2020-10-10 00:00:01", "R1", 5, "a"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:02", "R2", 7, "b"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:03", "R3", 7, "f"})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"2020-10-10 00:00:41", "R41", 10, "y"}), Row.of((Object[])new Object[]{"2020-10-10 00:00:42", "R42", 11, "c"})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"window_start TIMESTAMP(3)", "window_end TIMESTAMP(3)", "name STRING", "L_id STRING", "L_num INT", "R_id STRING", "R_num INT"})).consumedBeforeRestore(new String[]{"+I[2020-10-10T00:00:01, 2020-10-10T00:00:02, a, L1, 1, R1, 5]"}).consumedAfterRestore(new String[]{"+I[2020-10-10T00:00:42, 2020-10-10T00:00:43, c, L42, 11, R42, 11]"}).build()).runSql("INSERT INTO sink_t SELECT\nL.window_start AS window_start,\nL.window_end AS window_end,\nL.name AS name,\nL.id AS L_id,\nL.num AS L_num,\nR.id AS R_id,\nR.num AS R_num\nFROM\n(\n    SELECT * FROM TABLE(TUMBLE(TABLE source_one_t, DESCRIPTOR(row_time), INTERVAL '1' SECOND))\n) L\nJOIN\n(\n    SELECT * FROM TABLE(TUMBLE(TABLE source_two_t, DESCRIPTOR(row_time), INTERVAL '1' SECOND))\n) R\nON L.name = R.name\nAND L.window_start = R.window_start\nAND L.window_end = R.window_end").build();
    static final TableTestProgram MINI_BATCH_ASSIGNER_PROC_TIME = TableTestProgram.of((String)"mini-batch-assigner-proc-time", (String)"validates mini batch assigner with proc time").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"a INT", "b BIGINT", "c VARCHAR"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{1, 1L, "hi"}), Row.of((Object[])new Object[]{2, 2L, "hello"}), Row.of((Object[])new Object[]{3, 2L, "hello world"})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{3, 2L, "foo"}), Row.of((Object[])new Object[]{4, 4L, "bar"}), Row.of((Object[])new Object[]{5, 2L, "foo bar"})}).build()).setupConfig(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)true).setupConfig(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L)).setupConfig(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)5L).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"b BIGINT", "a BIGINT"})).consumedBeforeRestore(new String[]{"+I[1, 1]", "+I[2, 2]"}).consumedAfterRestore(new String[]{"-U[2, 2]", "+U[2, 3]", "+I[4, 1]"}).build()).runSql("INSERT INTO sink_t\n     SELECT\n         b,\n         COUNT(DISTINCT a) AS a\n     FROM source_t\n     GROUP BY b").build();
}

