/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import org.apache.flink.table.factories.TestFormatFactory;
import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.types.Row;

public class RankTestPrograms {
    static final TableTestProgram RANK_TEST_APPEND_FAST_STRATEGY = RankTestPrograms.getTableTestProgram("rank-test-append-fast-strategy", "I", new String[]{"+I[2, a, 1]", "+I[4, b, 1]", "+I[6, c, 1]", "-U[2, a, 1]", "+U[1, a, 1]", "-U[4, b, 1]", "+U[3, b, 1]", "-U[6, c, 1]", "+U[5, c, 1]"}, new String[]{"+I[4, d, 1]", "+I[3, e, 1]"});
    static final TableTestProgram RANK_TEST_RETRACT_STRATEGY = RankTestPrograms.getTableTestProgram("rank-test-retract-strategy", "I,UA,UB", new String[]{"+I[2, a, 1]", "+I[4, b, 1]", "+I[6, c, 1]", "-D[2, a, 1]", "+I[1, a, 1]", "-D[4, b, 1]", "+I[3, b, 1]", "-D[6, c, 1]", "+I[5, c, 1]"}, new String[]{"+I[4, d, 1]", "+I[3, e, 1]"});
    static final TableTestProgram RANK_TEST_UPDATE_FAST_STRATEGY = TableTestProgram.of((String)"rank-test-update-fast-strategy", (String)"validates rank exec node").setupTableSource(((SourceTestStep.Builder)((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"MyTable").addSchema(new String[]{"a INT primary key not enforced", "b VARCHAR", "c INT"})).addOption(TestFormatFactory.CHANGELOG_MODE, "I")).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{2, "a", 6}), Row.of((Object[])new Object[]{4, "b", 8}), Row.of((Object[])new Object[]{6, "c", 10}), Row.of((Object[])new Object[]{1, "a", 5}), Row.of((Object[])new Object[]{3, "b", 7}), Row.of((Object[])new Object[]{5, "c", 9})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{4, "d", 7}), Row.of((Object[])new Object[]{0, "a", 8})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a INT NOT NULL", "b STRING", "count_c BIGINT NOT NULL", "row_num BIGINT NOT NULL"})).consumedBeforeRestore(new String[]{"+I[2, a, 1, 1]", "+I[4, b, 1, 1]", "+I[6, c, 1, 1]", "-U[2, a, 1, 1]", "+U[1, a, 1, 1]", "+I[2, a, 1, 2]", "-U[4, b, 1, 1]", "+U[3, b, 1, 1]", "+I[4, b, 1, 2]", "-U[6, c, 1, 1]", "+U[5, c, 1, 1]", "+I[6, c, 1, 2]"}).consumedAfterRestore(new String[]{"+I[4, d, 1, 1]", "-U[1, a, 1, 1]", "+U[0, a, 1, 1]", "-U[2, a, 1, 2]", "+U[1, a, 1, 2]", "+I[2, a, 1, 3]"}).build()).runSql("INSERT INTO sink_t SELECT * FROM (SELECT a, b, count_c, ROW_NUMBER()    OVER (PARTITION BY b ORDER BY count_c DESC, a ASC) AS row_num   FROM (       SELECT a, b, COUNT(*) AS count_c       FROM MyTable       GROUP BY a, b   )) WHERE row_num <= 10").build();
    static final TableTestProgram RANK_N_TEST = TableTestProgram.of((String)"rank-n-test", (String)"validates rank node can handle multiple outputs").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"MyTable1").addSchema(new String[]{"a STRING", "b INT", "c INT", "t as proctime()"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"book", 1, 12}), Row.of((Object[])new Object[]{"book", 2, 19}), Row.of((Object[])new Object[]{"book", 4, 11}), Row.of((Object[])new Object[]{"fruit", 4, 33})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"cereal", 6, 21}), Row.of((Object[])new Object[]{"cereal", 7, 23}), Row.of((Object[])new Object[]{"apple", 8, 31}), Row.of((Object[])new Object[]{"fruit", 9, 41})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"result1").addSchema(new String[]{"a varchar", "b int", "c bigint"})).consumedBeforeRestore(new String[]{"+I[book, 1, 1]", "+I[book, 2, 2]", "+I[fruit, 4, 1]"}).consumedAfterRestore(new String[]{"+I[cereal, 6, 1]", "+I[cereal, 7, 2]", "+I[apple, 8, 1]", "+I[fruit, 9, 2]"}).build()).runSql("insert into `result1` select * from (select a, b, row_number() over(partition by a order by t asc) as c from MyTable1) where c <= 2").build();

    private static TableTestProgram getTableTestProgram(String name, String changelogMode, String[] resultsBeforeRestore, String[] resultsAfterRestore) {
        return TableTestProgram.of((String)name, (String)"validates rank exec node").setupTableSource(((SourceTestStep.Builder)((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"MyTable").addSchema(new String[]{"a INT", "b VARCHAR", "c INT primary key not enforced"})).addOption(TestFormatFactory.CHANGELOG_MODE, changelogMode)).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{2, "a", 6}), Row.of((Object[])new Object[]{4, "b", 8}), Row.of((Object[])new Object[]{6, "c", 10}), Row.of((Object[])new Object[]{1, "a", 5}), Row.of((Object[])new Object[]{3, "b", 7}), Row.of((Object[])new Object[]{5, "c", 9})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{4, "d", 7}), Row.of((Object[])new Object[]{3, "e", 8})}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a INT", "b VARCHAR", "c BIGINT"})).consumedBeforeRestore(resultsBeforeRestore).consumedAfterRestore(resultsAfterRestore).build()).runSql("insert into `sink_t` select * from (select a, b, row_number() over(partition by b order by c) as c from MyTable) where c = 1").build();
    }
}

