/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.flink.types.Row;

public class TableSourceScanTestPrograms {
    static final Row[] BEFORE_DATA = new Row[]{Row.of((Object[])new Object[]{1, 1L, "hi", DateTimeUtils.toLocalDateTime((long)1586937601000L)}), Row.of((Object[])new Object[]{2, 2L, "hello", DateTimeUtils.toLocalDateTime((long)1586937602000L)}), Row.of((Object[])new Object[]{3, 2L, "hello world", DateTimeUtils.toLocalDateTime((long)1586937603000L)})};
    static final Row[] AFTER_DATA = new Row[]{Row.of((Object[])new Object[]{4, 4L, "foo", DateTimeUtils.toLocalDateTime((long)1586937614000L)}), Row.of((Object[])new Object[]{5, 2L, "foo bar", DateTimeUtils.toLocalDateTime((long)1586937615000L)})};
    static final TableTestProgram PROJECT_PUSHDOWN = TableTestProgram.of((String)"table-source-scan-project-pushdown", (String)"validates table source scan with project pushdown").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"a INT", "b BIGINT", "c VARCHAR"})).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a INT", "b VARCHAR"})).consumedBeforeRestore(new String[]{"+I[1, hi]", "+I[2, hello]", "+I[3, hello world]"}).consumedAfterRestore(new String[]{"+I[4, foo]", "+I[5, foo bar]"}).build()).runSql("INSERT INTO sink_t SELECT a, c FROM source_t").build();
    static final TableTestProgram PROJECT_PUSHDOWN_DISABLED = TableTestProgram.of((String)"table-source-scan-project-push-down-disabled", (String)"validates table source scan with project pushdown disabled").setupTableSource(((SourceTestStep.Builder)((SourceTestStep.Builder)((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"a INT", "b BIGINT", "c VARCHAR", "ts TIMESTAMP(3) METADATA"})).addOption("readable-metadata", "ts:TIMESTAMP(3)")).addOption("enable-projection-push-down", "false")).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a INT", "c VARCHAR"})).consumedBeforeRestore(new String[]{"+I[1, hi]", "+I[2, hello]", "+I[3, hello world]"}).consumedAfterRestore(new String[]{"+I[4, foo]", "+I[5, foo bar]"}).build()).runSql("INSERT INTO sink_t SELECT a, c FROM source_t").build();
    static final TableTestProgram FILTER_PUSHDOWN = TableTestProgram.of((String)"table-source-scan-filter-pushdown", (String)"validates table source scan with filter pushdown").setupTableSource(((SourceTestStep.Builder)((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"a INT", "b BIGINT", "c VARCHAR"})).addOption("filterable-fields", "a")).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a INT", "b BIGINT", "c VARCHAR"})).consumedBeforeRestore(new String[]{"+I[2, 2, hello]", "+I[3, 2, hello world]"}).consumedAfterRestore(new String[]{"+I[4, 4, foo]", "+I[5, 2, foo bar]"}).build()).runSql("INSERT INTO sink_t SELECT * FROM source_t WHERE a > 1").build();
    static final TableTestProgram LIMIT_PUSHDOWN = TableTestProgram.of((String)"table-source-scan-limit-pushdown", (String)"validates table source scan with limit pushdown").setupTableSource(((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"a INT", "b BIGINT", "c VARCHAR"})).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a INT", "b BIGINT", "c VARCHAR"})).consumedBeforeRestore(new String[]{"+I[1, 1, hi]", "+I[2, 2, hello]"}).consumedAfterRestore(new String[0]).build()).runSql("INSERT INTO sink_t SELECT a, b, c FROM source_t LIMIT 2").build();
    static final TableTestProgram PARTITION_PUSHDOWN = TableTestProgram.of((String)"table-source-scan-partition-pushdown", (String)"validates table source scan with partition pushdown").setupTableSource(((SourceTestStep.Builder)((SourceTestStep.Builder)((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"a INT", "b BIGINT", "c VARCHAR"})).addPartitionKeys(new String[]{"b"})).addOption("partition-list", "b:1,b:2")).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a INT", "b BIGINT", "c VARCHAR"})).consumedBeforeRestore(new String[]{"+I[2, 2, hello]", "+I[3, 2, hello world]"}).consumedAfterRestore(new String[]{"+I[5, 2, foo bar]"}).build()).runSql("INSERT INTO sink_t SELECT a, b, c FROM source_t WHERE b = 2").build();
    static final TableTestProgram READING_METADATA = TableTestProgram.of((String)"table-source-scan-reading-metadata", (String)"validates table source scan by reading metadata").setupTableSource(((SourceTestStep.Builder)((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"a INT", "b BIGINT", "c VARCHAR", "d TIMESTAMP(3) METADATA"})).addOption("readable-metadata", "d:TIMESTAMP(3)")).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a INT", "c VARCHAR", "d TIMESTAMP(3)"})).consumedBeforeRestore(new String[]{"+I[1, hi, 2020-04-15T08:00:01]", "+I[2, hello, 2020-04-15T08:00:02]", "+I[3, hello world, 2020-04-15T08:00:03]"}).consumedAfterRestore(new String[]{"+I[4, foo, 2020-04-15T08:00:14]", "+I[5, foo bar, 2020-04-15T08:00:15]"}).build()).runSql("INSERT INTO sink_t SELECT a, c, d FROM source_t").build();
    static final TableTestProgram MULTIPLE_PUSHDOWNS = TableTestProgram.of((String)"table-source-scan-multiple-pushdowns", (String)"validates table source scan with multiple pushdowns").setupTableSource(((SourceTestStep.Builder)((SourceTestStep.Builder)((SourceTestStep.Builder)((SourceTestStep.Builder)((SourceTestStep.Builder)((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"a INT", "b BIGINT", "c VARCHAR", "ts TIMESTAMP(3) METADATA", "watermark for ts as ts - interval '1' second"})).addOption("readable-metadata", "ts:TIMESTAMP(3)")).addOption("filterable-fields", "a")).addOption("enable-watermark-push-down", "true")).addOption("disable-lookup", "true")).addOption("partition-list", "b:1;b:2;b:3;b:4;b:5;b:6")).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a INT"})).consumedBeforeRestore(new String[]{"+I[3]"}).consumedAfterRestore(new String[]{"+I[5]"}).build()).runSql("INSERT INTO sink_t SELECT a FROM source_t WHERE b = 2 AND a > 2").build();
    static final TableTestProgram SOURCE_WATERMARK = TableTestProgram.of((String)"table-source-scan-source-watermark", (String)"validates table source scan using source watermark").setupTableSource(((SourceTestStep.Builder)((SourceTestStep.Builder)((SourceTestStep.Builder)((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"a INT", "b BIGINT", "c VARCHAR", "ts TIMESTAMP(3) METADATA", "watermark for ts as SOURCE_WATERMARK()"})).addOption("readable-metadata", "ts:TIMESTAMP(3)")).addOption("enable-watermark-push-down", "true")).addOption("disable-lookup", "true")).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_t").addSchema(new String[]{"a INT", "c VARCHAR"})).consumedBeforeRestore(new String[]{"+I[1, hi]", "+I[2, hello]", "+I[3, hello world]"}).consumedAfterRestore(new String[]{"+I[4, foo]", "+I[5, foo bar]"}).build()).runSql("INSERT INTO sink_t SELECT a, c FROM source_t").build();
    static final TableTestProgram REUSE_SOURCE = TableTestProgram.of((String)"table-source-scan-reuse-source", (String)"validates table source scan by verifying if source is resused").setupTableSource(((SourceTestStep.Builder)((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"source_t").addSchema(new String[]{"a INT", "b BIGINT", "c VARCHAR", "d TIMESTAMP(3)"})).addOption("enable-projection-push-down", "false")).producedBeforeRestore(BEFORE_DATA).producedAfterRestore(AFTER_DATA).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_one_t").addSchema(new String[]{"a INT", "c VARCHAR"})).consumedBeforeRestore(new String[]{"+I[1, hi]", "+I[2, hello]", "+I[3, hello world]"}).consumedAfterRestore(new String[]{"+I[4, foo]", "+I[5, foo bar]"}).build()).setupTableSink(((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"sink_two_t").addSchema(new String[]{"a INT", "b BIGINT"})).consumedBeforeRestore(new String[]{"+I[1, 1]", "+I[2, 2]", "+I[3, 2]"}).consumedAfterRestore(new String[]{"+I[4, 4]", "+I[5, 2]"}).build()).runStatementSet(new String[]{"INSERT INTO sink_one_t SELECT a, c FROM source_t", "INSERT INTO sink_two_t SELECT a, b FROM source_t"}).build();
}

