/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.TableTestProgram;
import org.apache.flink.types.Row;

public class TemporalJoinTestPrograms {
    static final SourceTestStep ORDERS = ((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"Orders").addSchema(new String[]{"amount bigint", "currency STRING", "order_time STRING", "rowtime as TO_TIMESTAMP(order_time) ", "WATERMARK FOR rowtime AS rowtime"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{2L, "Euro", "2020-10-10 00:00:42"}), Row.of((Object[])new Object[]{1L, "USD", "2020-10-10 00:00:43"}), Row.of((Object[])new Object[]{50L, "Yen", "2020-10-10 00:00:44"}), Row.of((Object[])new Object[]{3L, "Euro", "2020-10-10 00:00:45"})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{1L, "Euro", "2020-10-10 00:00:58"}), Row.of((Object[])new Object[]{1L, "USD", "2020-10-10 00:00:58"})}).build();
    static final SourceTestStep RATES = ((SourceTestStep.Builder)SourceTestStep.newBuilder((String)"RatesHistory").addSchema(new String[]{"currency STRING", "rate bigint", "rate_time STRING", "rowtime as TO_TIMESTAMP(rate_time) ", "WATERMARK FOR rowtime AS rowtime", "PRIMARY KEY(currency) NOT ENFORCED"})).producedBeforeRestore(new Row[]{Row.of((Object[])new Object[]{"USD", 102L, "2020-10-10 00:00:41"}), Row.of((Object[])new Object[]{"Euro", 114L, "2020-10-10 00:00:41"}), Row.of((Object[])new Object[]{"Yen", 1L, "2020-10-10 00:00:41"}), Row.of((Object[])new Object[]{"Euro", 116L, "2020-10-10 00:00:45"}), Row.of((Object[])new Object[]{"Euro", 119L, "2020-10-10 00:00:47"})}).producedAfterRestore(new Row[]{Row.of((Object[])new Object[]{"USD", 103L, "2020-10-10 00:00:58"}), Row.of((Object[])new Object[]{"Euro", 120L, "2020-10-10 00:00:59"})}).build();
    static final SinkTestStep AMOUNTS = ((SinkTestStep.Builder)SinkTestStep.newBuilder((String)"MySink").addSchema(new String[]{"amount bigint"})).consumedBeforeRestore(new String[]{"+I[102]", "+I[228]", "+I[348]", "+I[50]"}).consumedAfterRestore(new String[]{"+I[103]", "+I[119]"}).build();
    static final TableTestProgram TEMPORAL_JOIN_TABLE_JOIN = TableTestProgram.of((String)"temporal-join-table-join", (String)"validates temporal join with a table").setupTableSource(ORDERS).setupTableSource(RATES).setupTableSink(AMOUNTS).runSql("INSERT INTO MySink SELECT amount * r.rate FROM Orders AS o JOIN RatesHistory FOR SYSTEM_TIME AS OF o.rowtime AS r ON o.currency = r.currency ").build();
    static final TableTestProgram TEMPORAL_JOIN_TEMPORAL_FUNCTION = TableTestProgram.of((String)"temporal-join-temporal-function", (String)"validates temporal join with a temporal function").setupTableSource(ORDERS).setupTableSource(RATES).setupTemporarySystemTemporalTableFunction("Rates", "RatesHistory", (Expression)Expressions.$((String)"rowtime"), (Expression)Expressions.$((String)"currency")).setupTableSink(AMOUNTS).runSql("INSERT INTO MySink SELECT amount * r.rate FROM Orders AS o,  LATERAL TABLE (Rates(o.rowtime)) AS r WHERE o.currency = r.currency ").build();
}

