/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.internal.StatementSetImpl;
import org.apache.flink.table.planner.hint.JoinStrategy;
import org.apache.flink.table.planner.plan.hints.batch.JoinHintTestBase;
import org.apache.flink.table.planner.plan.optimize.QueryHintsResolver;
import org.apache.flink.table.planner.utils.TableTestUtil;

public class QueryHintsResolverTest
extends JoinHintTestBase {
    @Override
    protected String getTestSingleJoinHint() {
        return JoinStrategy.BROADCAST.getJoinHintName();
    }

    @Override
    protected String getDisabledOperatorName() {
        return "HashJoin";
    }

    @Override
    protected void verifyRelPlanByCustom(String sql) {
        Table table = this.util.tableEnv().sqlQuery(sql);
        RelNode relNode = TableTestUtil.toRelNode(table);
        this.verifyRelPlanAfterResolverWithSql(sql, Collections.singletonList(relNode));
    }

    @Override
    protected void verifyRelPlanByCustom(StatementSet set) {
        StatementSetImpl testStmtSet = (StatementSetImpl)set;
        List<RelNode> relNodes = testStmtSet.getOperations().stream().map(node -> this.util.getPlanner().translateToRel(node)).collect(Collectors.toList());
        this.verifyRelPlanAfterResolverWithStatementSet(relNodes);
    }

    private void verifyRelPlanAfterResolverWithSql(String sql, List<RelNode> relNodes) {
        relNodes = this.resolveQueryHints(relNodes);
        String astPlan = this.buildAstPlanWithQueryBlockAlias(relNodes);
        this.util.assertEqualsOrExpand("sql", sql, true);
        this.util.assertEqualsOrExpand("ast", astPlan, false);
    }

    private void verifyRelPlanAfterResolverWithStatementSet(List<RelNode> relNodes) {
        relNodes = this.resolveQueryHints(relNodes);
        String astPlan = this.buildAstPlanWithQueryBlockAlias(relNodes);
        this.util.assertEqualsOrExpand("ast", astPlan, false);
    }

    private List<RelNode> resolveQueryHints(List<RelNode> relNodes) {
        QueryHintsResolver resolver = new QueryHintsResolver();
        return resolver.resolve(relNodes);
    }
}

