/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize.program;

import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DynamicPartitionPruningProgramTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(TableConfig.getDefault());
    private final TestValuesCatalog catalog = new TestValuesCatalog("testCatalog", "test_database", true);

    DynamicPartitionPruningProgramTest() {
    }

    @BeforeEach
    void setup() {
        this.catalog.open();
        this.util.tableEnv().registerCatalog("testCatalog", (Catalog)this.catalog);
        this.util.tableEnv().useCatalog("testCatalog");
        TableConfig tableConfig = this.util.tableEnv().getConfig();
        tableConfig.set(OptimizerConfigOptions.TABLE_OPTIMIZER_DYNAMIC_FILTERING_ENABLED, (Object)true);
        this.util.tableEnv().executeSql("CREATE TABLE fact_part (\n  id BIGINT,\n  name STRING,\n  amount BIGINT,\n  price BIGINT,\n  fact_date_sk BIGINT\n) PARTITIONED BY (fact_date_sk)\nWITH (\n 'connector' = 'values',\n 'runtime-source' = 'NewSource',\n 'partition-list' = 'fact_date_sk:1990;fact_date_sk:1991;fact_date_sk:1992',\n 'dynamic-filtering-fields' = 'fact_date_sk;amount',\n 'bounded' = 'true'\n)");
        this.util.tableEnv().executeSql("CREATE TABLE dim (\n  id BIGINT,\n  male BOOLEAN,\n  amount BIGINT,\n  price BIGINT,\n  dim_date_sk BIGINT\n) WITH (\n 'connector' = 'values',\n 'runtime-source' = 'NewSource',\n 'bounded' = 'true'\n)");
    }

    @Test
    void testDimTableFilteringFieldsNotInJoinKey() {
        String query = "Select * from dim, fact_part where fact_part.id = dim.id and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDimTableWithoutFilter() {
        String query = "Select * from dim, fact_part where fact_part.fact_date_sk = dim.dim_date_sk and fact_part.price > 100";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDimTableWithUnsuitableFilter() {
        String query = "Select * from dim join fact_part on fact_part.fact_date_sk = dim.dim_date_sk where dim.id is not null";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testFactTableIsNotPartitionTable() {
        this.util.tableEnv().executeSql("CREATE TABLE none_part_fact (\n  id BIGINT,\n  name STRING,\n  amount BIGINT,\n  price BIGINT,\n  fact_date_sk BIGINT\n) WITH (\n 'connector' = 'values',\n 'runtime-source' = 'NewSource',\n 'dynamic-filtering-fields' = 'fact_date_sk;amount',\n 'bounded' = 'true'\n)");
        String query = "Select * from dim, none_part_fact where none_part_fact.fact_date_sk = dim.dim_date_sk and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testFactTableIsLegacySource() {
        this.util.tableEnv().executeSql("CREATE TABLE legacy_source (\n  id BIGINT,\n  name STRING,\n  amount BIGINT,\n  price BIGINT,\n  fact_date_sk BIGINT\n) PARTITIONED BY (fact_date_sk)\nWITH (\n 'connector' = 'values',\n 'runtime-source' = 'SourceFunction',\n 'partition-list' = 'fact_date_sk:1990;fact_date_sk:1991;fact_date_sk:1992',\n 'dynamic-filtering-fields' = 'fact_date_sk;amount',\n 'bounded' = 'true'\n)");
        String query = "Select * from dim, legacy_source where legacy_source.fact_date_sk = dim.dim_date_sk and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDimTableWithFilterPushDown() {
        String query = "Select * from fact_part join (Select * from dim) t1 on fact_part.fact_date_sk = dim_date_sk where t1.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testJoinKeyIsDynamicFilterFieldNotPartitionKey() {
        String query = "Select * from dim, fact_part where fact_part.amount = dim.amount and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDynamicFilteringFactInRightRule() throws TableNotExistException {
        CatalogTableStatistics tableStatistics = new CatalogTableStatistics(1L, 1, 1L, 1L);
        this.catalog.alterTableStatistics(new ObjectPath("test_database", "dim"), tableStatistics, false);
        String query = "Select * from dim, fact_part where fact_part.fact_date_sk = dim.dim_date_sk and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDynamicFilteringFactInLeftRule() throws TableNotExistException {
        CatalogTableStatistics tableStatistics = new CatalogTableStatistics(1L, 1, 1L, 1L);
        this.catalog.alterTableStatistics(new ObjectPath("test_database", "dim"), tableStatistics, false);
        String query = "Select * from fact_part, dim where fact_part.fact_date_sk = dim.dim_date_sk and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDynamicFilteringFactInRightWithExchangeRule() {
        String query = "Select * from dim, fact_part where fact_part.fact_date_sk = dim.dim_date_sk and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDynamicFilteringFactInLeftWithExchangeRule() {
        String query = "Select * from fact_part, dim where fact_part.fact_date_sk = dim.dim_date_sk and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDynamicFilteringFactInRightWithCalcRule() throws TableNotExistException {
        CatalogTableStatistics tableStatistics = new CatalogTableStatistics(1L, 1, 1L, 1L);
        this.catalog.alterTableStatistics(new ObjectPath("test_database", "dim"), tableStatistics, false);
        String query = "Select * from dim, fact_part where fact_part.fact_date_sk = dim.dim_date_sk and fact_part.price > 200 and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDynamicFilteringFactInLeftWithCalcRule() throws TableNotExistException {
        CatalogTableStatistics tableStatistics = new CatalogTableStatistics(1L, 1, 1L, 1L);
        this.catalog.alterTableStatistics(new ObjectPath("test_database", "dim"), tableStatistics, false);
        String query = "Select * from fact_part, dim where fact_part.fact_date_sk = dim.dim_date_sk and fact_part.price > 200 and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDynamicFilteringFactInRightWithExchangeAndCalcRule() {
        String query = "Select * from dim, fact_part where fact_part.fact_date_sk = dim.dim_date_sk and fact_part.price > 200 and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDynamicFilteringFactInLeftWithExchangeAndCalcRule() {
        String query = "Select * from fact_part, dim where fact_part.fact_date_sk = dim.dim_date_sk and fact_part.price > 200 and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testComplexCalcInFactSide() {
        String query = "Select * from dim join (select fact_date_sk as fact_date_sk1, price + 1 as price1 from fact_part) t1 on t1.fact_date_sk1 = dim_date_sk and t1.price1 > 200 and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testPartitionKeysIsComputeColumnsInFactSide() {
        String query = "Select * from dim join (select fact_date_sk + 1 as fact_date_sk1, price + 1 as price1 from fact_part) t1 on t1.fact_date_sk1 = dim_date_sk and t1.price1 > 200 and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testPartitionKeysOrderIsChangedInFactSide() {
        String query = "Select * from dim join (select fact_date_sk, id, name, amount, price from fact_part) t1 on t1.fact_date_sk = dim_date_sk and t1.price > 200 and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testPartitionKeysNameIsChangedInFactSide() {
        String query = "Select * from dim join (select id, name, amount, price, fact_date_sk as fact_date_sk1 from fact_part) t1 on t1.fact_date_sk1 = dim_date_sk and t1.price > 200 and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDynamicFilteringFieldIsComputeColumnsInFactSide() throws TableNotExistException {
        CatalogTableStatistics tableStatistics = new CatalogTableStatistics(1L, 1, 1L, 1L);
        this.catalog.alterTableStatistics(new ObjectPath("test_database", "dim"), tableStatistics, false);
        String query = "Select * from dim join (select fact_date_sk, amount + 1 as amount from fact_part) t1 on fact_date_sk = dim_date_sk and t1.amount = dim.amount where dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testLeftOuterJoinWithFactInLeft() {
        String query = "Select * from fact_part left outer join dim on fact_part.fact_date_sk = dim.dim_date_sk where dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testLeftOutJoinWithFactInRight() {
        String query = "Select * from dim left outer join fact_part on fact_part.fact_date_sk = dim.dim_date_sk where dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testSemiJoin() {
        String query = "Select * from fact_part where fact_part.fact_date_sk in (select dim_date_sk from dim where dim.price < 500)";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testFullOuterJoin() {
        String query = "Select * from fact_part full outer join (select *  from dim where dim.price < 500) on fact_date_sk = dim_date_sk";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testAntiJoin() {
        String query = "Select * from fact_part where not exists (select dim_date_sk from dim where dim.price < 500)";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testMultiJoin() {
        this.util.tableEnv().executeSql("CREATE TABLE sales (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        String query = "Select * from fact_part, dim, sales where fact_part.id = sales.id and fact_part.fact_date_sk = dim.dim_date_sk and dim.price < 500 and dim.amount > 100";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testComplexDimSideWithJoinInDimSide() {
        this.util.tableEnv().executeSql("CREATE TABLE sales (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        this.util.tableEnv().executeSql("CREATE TABLE item (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        String query = "Select * from fact_part join (select * from dim, sales, item where dim.id = sales.id and sales.id = item.id and dim.price < 500 and sales.price > 300) dimSide on fact_part.fact_date_sk = dimSide.dim_date_sk";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testComplexDimSideWithAggInDimSide() {
        this.util.tableEnv().executeSql("CREATE TABLE sales (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        String query = "Select * from fact_part join (select dim_date_sk, sum(dim.price) from dim where  dim.price < 500 group by dim_date_sk) dimSide on fact_part.fact_date_sk = dimSide.dim_date_sk";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDppWithoutJoinReorder() {
        String ddl = "CREATE TABLE test_database.item (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl);
        TableConfig tableConfig = this.util.tableEnv().getConfig();
        tableConfig.set(OptimizerConfigOptions.TABLE_OPTIMIZER_JOIN_REORDER_ENABLED, (Object)false);
        String query = "Select * from fact_part, item, dim where fact_part.fact_date_sk = dim.dim_date_sk and fact_part.id = item.id and dim.id = item.id  and dim.price < 500 and dim.price > 300";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDppWithSubQuery() {
        String ddl = "CREATE TABLE test_database.item (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl);
        TableConfig tableConfig = this.util.tableEnv().getConfig();
        tableConfig.set(OptimizerConfigOptions.TABLE_OPTIMIZER_JOIN_REORDER_ENABLED, (Object)false);
        String query = "Select * from fact_part, item, dim where fact_part.id = item.id and dim.price in (select price from dim where amount = (select amount from dim where amount = 2000)) and fact_part.fact_date_sk = dim.dim_date_sk";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDppWithUnionInFactSide() {
        String ddl = "CREATE TABLE test_database.item (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl);
        String query = "Select * from (select id, fact_date_sk, amount + 1 as amount1 from fact_part where price = 1 union all select id, fact_date_sk, amount + 1 from fact_part where price = 2) fact_part2, item, dim where fact_part2.fact_date_sk = dim.dim_date_sk and fact_part2.id = item.id and dim.price < 500 and dim.price > 300";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDppWithAggInFactSideAndJoinKeyInGrouping() {
        String ddl = "CREATE TABLE test_database.item (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl);
        String query = "Select * from (Select fact_date_sk, item.amount, sum(fact_part.price) from fact_part join item on fact_part.id = item.id group by fact_date_sk, item.amount) t1 join dim on t1.fact_date_sk = dim.dim_date_sk where dim.price < 500 and dim.price > 300 ";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDppWithAggInFactSideAndJoinKeyInGroupFunction() {
        String ddl = "CREATE TABLE test_database.item (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl);
        String query = "Select * from (Select fact_part.id, item.amount, fact_part.name, sum(fact_part.price), sum(item.price), sum(fact_date_sk) as fact_date_sk1 from fact_part join item on fact_part.id = item.id group by fact_part.id, fact_part.name, item.amount) t1 join dim on t1.fact_date_sk1 = dim.dim_date_sk where dim.price < 500 and dim.price > 300 ";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDppWithAggInFactSideWithAggPushDownEnable() {
        String ddl = "CREATE TABLE test_database.item (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl);
        String query = "Select * from (Select id, amount, fact_date_sk, count(name), sum(price) from fact_part where fact_date_sk > 100 group by id, amount, fact_date_sk) t1 join dim on t1.fact_date_sk = dim.dim_date_sk where dim.price < 500 and dim.price > 300 ";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDppWithAggInFactSideWithAggPushDownDisable() {
        TableConfig tableConfig = this.util.tableEnv().getConfig();
        tableConfig.set(OptimizerConfigOptions.TABLE_OPTIMIZER_SOURCE_AGGREGATE_PUSHDOWN_ENABLED, (Object)false);
        String ddl = "CREATE TABLE test_database.item (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl);
        String query = "Select * from (Select id, amount, fact_date_sk, count(name), sum(price) from fact_part where fact_date_sk > 100 group by id, amount, fact_date_sk) t1 join dim on t1.fact_date_sk = dim.dim_date_sk where dim.price < 500 and dim.price > 300 ";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDPPWithFactSideJoinKeyChanged() {
        String ddl = "CREATE TABLE test_database.item (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl);
        String query = "Select * from (select fact_date_sk + 1 as fact_date_sk, id from fact_part) fact_part1 join item on fact_part1.id = item.id join dim on fact_part1.fact_date_sk = dim.dim_date_sk where dim.price < 500 and dim.price > 300";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDPPWithDimSideJoinKeyChanged() {
        String ddl = "CREATE TABLE test_database.item (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl);
        String query = "Select * from fact_part join item on fact_part.id = item.id join (select dim_date_sk + 1 as dim_date_sk, price from dim) dim1 on fact_part.fact_date_sk = dim1.dim_date_sk where dim1.price < 500 and dim1.price > 300";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDPPWithJoinKeysNotIncludePartitionKeys() {
        String ddl = "CREATE TABLE test_database.item (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl);
        String query = "Select * from fact_part, item, dim where fact_part.id = dim.id and fact_part.id = item.id and dim.id = item.id  and dim.price < 500 and dim.price > 300";
        this.util.verifyRelPlan(query);
    }

    @Test
    void testDppFactSideCannotReuseWithSameCommonSource() {
        String query = "SELECT * FROM(\n Select fact_part.id, fact_part.price, fact_part.amount from fact_part join (Select * from dim) t1 on fact_part.fact_date_sk = dim_date_sk where t1.price < 500\n UNION ALL Select fact_part.id, fact_part.price, fact_part.amount from fact_part)";
        this.util.verifyExecPlan(query);
    }

    @Test
    void testDimSideReuseAfterProjectionPushdown() {
        this.util.tableEnv().executeSql("CREATE TABLE fact_part2 (\n  id BIGINT,\n  name STRING,\n  amount BIGINT,\n  price BIGINT,\n  fact_date_sk BIGINT\n) PARTITIONED BY (fact_date_sk)\nWITH (\n 'connector' = 'values',\n 'runtime-source' = 'NewSource',\n 'partition-list' = 'fact_date_sk:1990;fact_date_sk:1991;fact_date_sk:1992',\n 'dynamic-filtering-fields' = 'fact_date_sk;amount',\n 'bounded' = 'true'\n)");
        String query = "SELECT /*+ BROADCAST(dim) */ fact3.* FROM\n(SELECT /*+ BROADCAST(dim) */ fact.id, fact.price, fact.amount FROM (\n SELECT id, price, amount, fact_date_sk FROM fact_part  UNION ALL SELECT id, price, amount, fact_date_sk FROM fact_part2) fact, dim\n WHERE fact_date_sk = dim_date_sk and dim.price < 500 and dim.price > 300)\n fact3 JOIN dim ON fact3.amount = dim.id AND dim.amount < 10";
        this.util.verifyExecPlan(query);
    }
}

