/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize.program;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}2A!\u0001\u0002\u0001'\tQb\t\\5oW\"+\u0007OU;mKN+G\u000f\u0015:pOJ\fW\u000eV3ti*\u00111\u0001B\u0001\baJ|wM]1n\u0015\t)a!\u0001\u0005paRLW.\u001b>f\u0015\t9\u0001\"\u0001\u0003qY\u0006t'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001aDQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000b\u0001\u0002A\u0011A\u0011\u0002?Q,7\u000f\u001e\"vS2$g\t\\5oW\"+\u0007OU;mKN+G\u000f\u0015:pOJ\fW\u000eF\u0001#!\t)2%\u0003\u0002%-\t!QK\\5uQ\tyb\u0005\u0005\u0002(]5\t\u0001F\u0003\u0002*U\u0005\u0019\u0011\r]5\u000b\u0005-b\u0013a\u00026va&$XM\u001d\u0006\u0003[A\tQA[;oSRL!a\f\u0015\u0003\tQ+7\u000f\u001e\u0005\u0006c\u0001!\t!I\u0001\u0018i\u0016\u001cH/T1uG\"d\u0015.\\5u\u0019\u0016\u001c8\u000f\u00165b]FB#\u0001\r\u0014\t\u000bQ\u0002A\u0011A\u0011\u0002+Q,7\u000f\u001e(vY2DU\r]'bi\u000eDwJ\u001d3fe\"\u00121G\n\u0005\u0006o\u0001!\t!I\u0001\u001ei\u0016\u001cHOT;mY\"+\u0007OU;mKN,\u00050Z2vi&|g\u000eV=qK\"\u0012aG\n\u0005\u0006u\u0001!\t!I\u0001\u0013i\u0016\u001cHOU;mK>\u0003XM]1uS>t7\u000f\u000b\u0002:M!)Q\b\u0001C\u0001C\u0005\u0001B/Z:u\u001dVdGNU;mKN+Go\u001d\u0015\u0003y\u0019\u0002")
public class FlinkHepRuleSetProgramTest {
    @Test
    public void testBuildFlinkHepRuleSetProgram() {
        FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_REDUCE_EXPRESSIONS, CoreRules.PROJECT_REDUCE_EXPRESSIONS, CoreRules.CALC_REDUCE_EXPRESSIONS, CoreRules.JOIN_REDUCE_EXPRESSIONS})).setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setMatchLimit(10).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).build();
    }

    @Test
    public void testMatchLimitLessThan1() {
        Assertions.assertThatThrownBy(() -> FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setMatchLimit(0)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testNullHepMatchOrder() {
        Assertions.assertThatThrownBy(() -> FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepMatchOrder(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void testNullHepRulesExecutionType() {
        Assertions.assertThatThrownBy(() -> FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void testRuleOperations() {
        FlinkHepRuleSetProgram program = FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_REDUCE_EXPRESSIONS, CoreRules.PROJECT_REDUCE_EXPRESSIONS, CoreRules.CALC_REDUCE_EXPRESSIONS, CoreRules.JOIN_REDUCE_EXPRESSIONS})).build();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)program.contains((RelOptRule)CoreRules.FILTER_REDUCE_EXPRESSIONS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)program.contains((RelOptRule)CoreRules.PROJECT_REDUCE_EXPRESSIONS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)program.contains((RelOptRule)CoreRules.CALC_REDUCE_EXPRESSIONS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)program.contains((RelOptRule)CoreRules.JOIN_REDUCE_EXPRESSIONS));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)program.contains((RelOptRule)CoreRules.FILTER_SUB_QUERY_TO_CORRELATE));
        program.remove(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_REDUCE_EXPRESSIONS, CoreRules.PROJECT_REDUCE_EXPRESSIONS}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)program.contains((RelOptRule)CoreRules.FILTER_REDUCE_EXPRESSIONS));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)program.contains((RelOptRule)CoreRules.PROJECT_REDUCE_EXPRESSIONS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)program.contains((RelOptRule)CoreRules.CALC_REDUCE_EXPRESSIONS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)program.contains((RelOptRule)CoreRules.JOIN_REDUCE_EXPRESSIONS));
        program.replaceAll(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_SUB_QUERY_TO_CORRELATE}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)program.contains((RelOptRule)CoreRules.CALC_REDUCE_EXPRESSIONS));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)program.contains((RelOptRule)CoreRules.JOIN_REDUCE_EXPRESSIONS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)program.contains((RelOptRule)CoreRules.FILTER_SUB_QUERY_TO_CORRELATE));
        program.add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.PROJECT_SUB_QUERY_TO_CORRELATE, CoreRules.JOIN_SUB_QUERY_TO_CORRELATE}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)program.contains((RelOptRule)CoreRules.FILTER_SUB_QUERY_TO_CORRELATE));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)program.contains((RelOptRule)CoreRules.PROJECT_SUB_QUERY_TO_CORRELATE));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)program.contains((RelOptRule)CoreRules.JOIN_SUB_QUERY_TO_CORRELATE));
    }

    @Test
    public void testNullRuleSets() {
        Assertions.assertThatThrownBy(() -> FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().add(null)).isInstanceOf(NullPointerException.class);
    }
}

