/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.FlinkStreamProgram$;
import org.apache.flink.table.planner.plan.rules.logical.CalcRankTransposeRuleTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0001\u0002\u0001'\tI2)\u00197d%\u0006t7\u000e\u0016:b]N\u0004xn]3Sk2,G+Z:u\u0015\t\u0019A!A\u0004m_\u001eL7-\u00197\u000b\u0005\u00151\u0011!\u0002:vY\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0011\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%I!I\u0001\u0005kRLG.F\u0001#!\t)2%\u0003\u0002%-\t\u00192\u000b\u001e:fC6$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\"1a\u0005\u0001Q\u0001\n\t\nQ!\u001e;jY\u0002BQ\u0001\u000b\u0001\u0005\u0002%\nQa]3ukB$\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0005+:LG\u000f\u000b\u0002(cA\u0011!'O\u0007\u0002g)\u0011A'N\u0001\u0004CBL'B\u0001\u001c8\u0003\u001dQW\u000f]5uKJT!\u0001\u000f\t\u0002\u000b),h.\u001b;\n\u0005i\u001a$A\u0003\"fM>\u0014X-R1dQ\")A\b\u0001C\u0001S\u0005\u0011B/Z:u!J,h.Z(sI\u0016\u00148*Z=tQ\tYd\b\u0005\u00023\u007f%\u0011\u0001i\r\u0002\u0005)\u0016\u001cH\u000fC\u0003C\u0001\u0011\u0005\u0011&\u0001\fuKN$\bK];oKB\u000b'\u000f^5uS>t7*Z=tQ\t\te\bC\u0003F\u0001\u0011\u0005\u0011&A\nuKN$\bK];oKVs\u0017.];f\u0017\u0016L8\u000f\u000b\u0002E}!)\u0001\n\u0001C\u0001S\u0005\u0001B/Z:u\u001d>$HK]1ogB|7/\u001a\u0015\u0003\u000fzBQa\u0013\u0001\u0005\u0002%\n1\u0003^3tiB\u0013XO\\3SC:\\g*^7cKJD#A\u0013 \t\u000b9\u0003A\u0011A\u0015\u0002+Q,7\u000f\u001e)s_*,7\r\u001e*b].tU/\u001c2fe\"\u0012QJ\u0010\u0005\u0006#\u0002!\t!K\u0001\u0019i\u0016\u001cH\u000f\u0016:jm&\fGnQ1mG&\u001b(+Z7pm\u0016$\u0007F\u0001)?\u0011\u0015!\u0006\u0001\"\u0001*\u0003\u0005\"Xm\u001d;QkND7)\u00197d/&$\bnQ8oI&$\u0018n\u001c8J]R|'+\u00198lQ\t\u0019f\bC\u0003X\u0001\u0011\u0005\u0011&\u0001\fuKN$\bK];oKVsWo]3e!J|'.Z2uQ\t1f\b")
public class CalcRankTransposeRuleTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().buildStreamProgram(FlinkStreamProgram$.MODULE$.PHYSICAL());
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.CalcRankTransposeRuleTest$$anon$3 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "category")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "shopId")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price"))}), new CaseClassTypeInfo<Tuple3<String, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, String>>(this, fieldSerializers){

                    public Tuple3<String, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<String, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.rules.logical.CalcRankTransposeRuleTest$$anon$4 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testPruneOrderKeys() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 1\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPrunePartitionKeys() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rowtime FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 1\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPruneUniqueKeys() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT category, max_price, rank_num FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY category ORDER BY max_price ASC) as rank_num\n        |  FROM (\n        |     SELECT category, shopId, max(price) as max_price, min(price) as min_price\n        |     FROM T\n        |     GROUP BY category, shopId\n        |  ))\n        |WHERE rank_num <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testNotTranspose() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT category, max_price, rank_num FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY category ORDER BY max_price ASC) as rank_num\n        |  FROM (\n        |     SELECT category, shopId, max(price) as max_price\n        |     FROM T\n        |     GROUP BY category, shopId\n        |  ))\n        |WHERE rank_num <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPruneRankNumber() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, rowtime FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num <= 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testProjectRankNumber() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rank_num, rowtime, a, rank_num, a, rank_num FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE  rank_num <= 2\n    ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testTrivialCalcIsRemoved() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, rowtime, rank_num FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE  rank_num <= 2\n    ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPushCalcWithConditionIntoRank() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT rowtime, c FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE  rank_num <= 2 AND a > 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testPruneUnusedProject() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT category, shopId, max_price, rank_num\n        |FROM (\n        |  SELECT category, shopId, max_price,\n        |      ROW_NUMBER() OVER (PARTITION BY category ORDER BY max_price ASC) as rank_num\n        |  FROM (\n        |     SELECT category, shopId, max(price) as max_price, min(price) as min_price\n        |     FROM T\n        |     GROUP BY category, shopId\n        |  ))\n        |WHERE rank_num <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }
}

