/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.ConvertToNotInOrInRule$;
import org.apache.flink.table.planner.plan.rules.logical.ConvertToNotInOrInRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\u0001\u0003\u0001M\u0011!dQ8om\u0016\u0014H\u000fV8O_RLen\u0014:J]J+H.\u001a+fgRT!a\u0001\u0003\u0002\u000f1|w-[2bY*\u0011QAB\u0001\u0006eVdWm\u001d\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\tYA\"A\u0003uC\ndWM\u0003\u0002\u000e\u001d\u0005)a\r\\5oW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0005]A\u0011!B;uS2\u001c\u0018BA\r\u0017\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003\u0011)H/\u001b7\u0016\u0003\t\u0002\"!F\u0012\n\u0005\u00112\"A\u0005\"bi\u000eDG+\u00192mKR+7\u000f^+uS2DaA\n\u0001!\u0002\u0013\u0011\u0013!B;uS2\u0004\u0003\"\u0002\u0015\u0001\t\u0003I\u0013!B:fiV\u0004H#\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0003OE\u0002\"AM\u001d\u000e\u0003MR!\u0001N\u001b\u0002\u0007\u0005\u0004\u0018N\u0003\u00027o\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001d\u0011\u0003\u0015QWO\\5u\u0013\tQ4G\u0001\u0006CK\u001a|'/Z#bG\"DQ\u0001\u0010\u0001\u0005\u0002%\nQ\u0005^3ti\u000e{gN^3siR{\u0017J\\0MKN\u001cH\u000b[1o)\"\u0014Xm\u001d5pY\u0012|\u0016J\u001c;)\u0005mr\u0004C\u0001\u001a@\u0013\t\u00015G\u0001\u0003UKN$\b\"\u0002\"\u0001\t\u0003I\u0013!\n;fgR\u001cuN\u001c<feR$v.\u00138`\u000bF,\u0018\r\\:U_RC'/Z:i_2$w,\u00138uQ\t\te\bC\u0003F\u0001\u0011\u0005\u0011&\u0001\u0015uKN$8i\u001c8wKJ$Hk\\%o?\u001e\u0013X-\u0019;feRC\u0017M\u001c+ie\u0016\u001c\bn\u001c7e?&sG\u000f\u000b\u0002E}!)\u0001\n\u0001C\u0001S\u0005AC/Z:u\u0007>tg/\u001a:u)>Len\u0018'fgN$\u0006.\u00198UQJ,7\u000f[8mI~#u.\u001e2mK\"\u0012qI\u0010\u0005\u0006\u0017\u0002!\t!K\u0001,i\u0016\u001cHoQ8om\u0016\u0014H\u000fV8J]~;%/Z1uKJ$\u0006.\u00198UQJ,7\u000f[8mI~#u.\u001e2mK\"\u0012!J\u0010\u0005\u0006\u001d\u0002!\t!K\u0001\u0018i\u0016\u001cHoQ8om\u0016\u0014H\u000fV8J]~;\u0016\u000e\u001e5PeFB#!\u0014 \t\u000bE\u0003A\u0011A\u0015\u0002/Q,7\u000f^\"p]Z,'\u000f\u001e+p\u0013:|v+\u001b;i\u001fJ\u0014\u0004F\u0001)?\u0011\u0015!\u0006\u0001\"\u0001*\u0003a!Xm\u001d;D_:4XM\u001d;U_&swlV5uQ\u0006sG-\r\u0015\u0003'zBQa\u0016\u0001\u0005\u0002%\n\u0001\u0004^3ti\u000e{gN^3siR{\u0017J\\0XSRD\u0017I\u001c33Q\t1f\bC\u0003[\u0001\u0011\u0005\u0011&\u0001\u0015uKN$8i\u001c8wKJ$Hk\u001c(pi&sw\fT3tgRC\u0017M\u001c+ie\u0016\u001c\bn\u001c7e?&sG\u000f\u000b\u0002Z}!)Q\f\u0001C\u0001S\u0005AC/Z:u\u0007>tg/\u001a:u)>tu\u000e^%o?\u0016\u000bX/\u00197t)>$\u0006N]3tQ>dGmX%oi\"\u0012AL\u0010\u0005\u0006A\u0002!\t!K\u0001,i\u0016\u001cHoQ8om\u0016\u0014H\u000fV8O_RLenX$sK\u0006$XM\u001d+iC:$\u0006N]3tQ>dGmX%oi\"\u0012qL\u0010\u0005\u0006G\u0002!\t!K\u0001,i\u0016\u001cHoQ8om\u0016\u0014H\u000fV8O_RLen\u0018'fgN$\u0006.\u00198UQJ,7\u000f[8mI~#u.\u001e2mK\"\u0012!M\u0010\u0005\u0006M\u0002!\t!K\u0001/i\u0016\u001cHoQ8om\u0016\u0014H\u000fV8O_RLenX$sK\u0006$XM\u001d+iC:$\u0006N]3tQ>dGm\u0018#pk\ndW\r\u000b\u0002f}!)\u0011\u000e\u0001C\u0001S\u0005QB/Z:u\u0007>tg/\u001a:u)>tu\u000e^%o?^KG\u000f[(sc!\u0012\u0001N\u0010\u0005\u0006Y\u0002!\t!K\u0001\u001bi\u0016\u001cHoQ8om\u0016\u0014H\u000fV8O_RLenX,ji\"|%O\r\u0015\u0003WzBQa\u001c\u0001\u0005\u0002%\n!\u0004^3ti\u000e{gN^3siR{gj\u001c;J]~;\u0016\u000e\u001e5PeNB#A\u001c \t\u000bI\u0004A\u0011A\u0015\u00027Q,7\u000f^\"p]Z,'\u000f\u001e+p\u001d>$\u0018J\\0XSRD\u0017I\u001c32Q\t\th\bC\u0003v\u0001\u0011\u0005\u0011&A\u000euKN$8i\u001c8wKJ$Hk\u001c(pi&swlV5uQ\u0006sGM\r\u0015\u0003izBQ\u0001\u001f\u0001\u0005\u0002%\n\u0001\u0004^3ti\u000e{gN^3siR{\u0017J\\!oI:{G/\u001382Q\t9h\bC\u0003|\u0001\u0011\u0005\u0011&\u0001\ruKN$8i\u001c8wKJ$Hk\\%o\u0003:$gj\u001c;J]JB#A\u001f \t\u000by\u0004A\u0011A\u0015\u00021Q,7\u000f^\"p]Z,'\u000f\u001e+p\u0013:\fe\u000e\u001a(pi&s7\u0007\u000b\u0002~}!1\u00111\u0001\u0001\u0005\u0002%\n\u0011\u0004^3ti\u000e{gN^3siR{7+Z1sG\"\u001cFO]5oO\"\u001a\u0011\u0011\u0001 \t\r\u0005%\u0001\u0001\"\u0001*\u0003\u0005\"Xm\u001d;D_:4XM\u001d;U_N+\u0017M]2i'R\u0014\u0018N\\4XSRDg*\u001e7mQ\r\t9A\u0010\u0005\u0007\u0003\u001f\u0001A\u0011A\u0015\u0002AQ,7\u000f^\"p]Z,'\u000f\u001e+p'\u0016\f'o\u00195XSRDW*\u001b=fIRK\b/\u001a\u0015\u0004\u0003\u001bq\u0004")
public class ConvertToNotInOrInRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{ConvertToNotInOrInRule$.MODULE$.INSTANCE()})).build());
        this.util().replaceBatchProgram((FlinkChainedProgram<BatchOptimizeContext>)programs);
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}), new CaseClassTypeInfo<Tuple5<Object, Object, Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, Object, Object, String>>(this, fieldSerializers){

                    public Tuple5<Object, Object, Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[2])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[3])), (Object)((String)fields[4]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple5<Object, Object, Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.ConvertToNotInOrInRuleTest$$anon$2 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testConvertToIn_LessThanThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3");
    }

    @Test
    public void testConvertToIn_EqualsToThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3 OR a = 4");
    }

    @Test
    public void testConvertToIn_GreaterThanThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3 OR a = 4 OR a = 5");
    }

    @Test
    public void testConvertToIn_LessThanThreshold_Double() {
        String where = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 20).map((Function1 & Serializable & scala.Serializable)i -> ConvertToNotInOrInRuleTest.$anonfun$testConvertToIn_LessThanThreshold_Double$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(" OR ");
        this.util().verifyRelPlan(new StringBuilder(28).append("SELECT * FROM MyTable WHERE ").append(where).toString());
    }

    @Test
    public void testConvertToIn_GreaterThanThreshold_Double() {
        String where = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 21).map((Function1 & Serializable & scala.Serializable)i -> ConvertToNotInOrInRuleTest.$anonfun$testConvertToIn_GreaterThanThreshold_Double$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(" OR ");
        this.util().verifyRelPlan(new StringBuilder(28).append("SELECT * FROM MyTable WHERE ").append(where).toString());
    }

    @Test
    public void testConvertToIn_WithOr1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3 OR a = 4 OR b = 1");
    }

    @Test
    public void testConvertToIn_WithOr2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR b = 1 OR a = 3 OR a = 4");
    }

    @Test
    public void testConvertToIn_WithAnd1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE (a = 1 OR a = 2 OR a = 3 OR a = 4) AND b = 1");
    }

    @Test
    public void testConvertToIn_WithAnd2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3 OR a = 4 AND b = 1");
    }

    @Test
    public void testConvertToNotIn_LessThanThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 AND a <> 2 AND a <> 3");
    }

    @Test
    public void testConvertToNotIn_EqualsToThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 AND a <> 2 AND a <> 3 AND a <> 4");
    }

    @Test
    public void testConvertToNotIn_GreaterThanThreshold_Int() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 AND a <> 2 AND a <> 3 AND a <> 4 AND a = 5");
    }

    @Test
    public void testConvertToNotIn_LessThanThreshold_Double() {
        String where = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 20).map((Function1 & Serializable & scala.Serializable)i -> ConvertToNotInOrInRuleTest.$anonfun$testConvertToNotIn_LessThanThreshold_Double$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(" AND ");
        this.util().verifyRelPlan(new StringBuilder(28).append("SELECT * FROM MyTable WHERE ").append(where).toString());
    }

    @Test
    public void testConvertToNotIn_GreaterThanThreshold_Double() {
        String where = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 21).map((Function1 & Serializable & scala.Serializable)i -> ConvertToNotInOrInRuleTest.$anonfun$testConvertToNotIn_GreaterThanThreshold_Double$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(" AND ");
        this.util().verifyRelPlan(new StringBuilder(28).append("SELECT * FROM MyTable WHERE ").append(where).toString());
    }

    @Test
    public void testConvertToNotIn_WithOr1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE (a <> 1 AND a <> 2 AND a <> 3 AND a <> 4) OR b = 1");
    }

    @Test
    public void testConvertToNotIn_WithOr2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 AND a <> 2 AND a <> 3 AND a <> 4 OR b = 1");
    }

    @Test
    public void testConvertToNotIn_WithOr3() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 OR a <> 2 OR a <> 3 OR a <> 4 OR b = 1");
    }

    @Test
    public void testConvertToNotIn_WithAnd1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a <> 1 AND a <> 2 AND a <> 3 AND a <> 4 AND b = 1");
    }

    @Test
    public void testConvertToNotIn_WithAnd2() {
        String sqlQuery = "SELECT * FROM MyTable WHERE a <> 1 AND a <> 2  AND b = 1 AND a <> 3 AND a <> 4";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testConvertToInAndNotIn1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 2 OR a = 3 OR a = 4 OR b = 1 OR (a <> 1 AND a <> 2 AND a <> 3 AND a <> 4)");
    }

    @Test
    public void testConvertToInAndNotIn2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE b = 1 OR a = 1 OR a = 2 OR a = 3 OR a = 4  AND (a <> 1 AND a <> 2 AND a <> 3 AND a <> 4)");
    }

    @Test
    public void testConvertToInAndNotIn3() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE b = 1 OR b = 2 OR (a <> 1 AND a <> 2 AND a <> 3 AND a <> 4 AND c = 1) OR b = 3 OR b = 4 OR c = 1");
    }

    @Test
    public void testConvertToSearchString() {
        this.util().verifyRelPlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * from MyTable where e in (\n        |'CTNBSmokeSensor',\n        |'H388N',\n        |'H389N     ',\n        |'GHL-IRD',\n        |'JY-BF-20YN',\n        |'HC809',\n        |'DH-9908N-AEP',\n        |'DH-9908N'\n        |)\n        |")).stripMargin());
    }

    @Test
    public void testConvertToSearchStringWithNull() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE e = 'a' or e = 'b' or e = 'c' or e = 'd' or e = 'e' or e = 'f' or e = NULL or e = 'HELLO WORLD!'");
    }

    @Test
    public void testConvertToSearchWithMixedType() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE a is null or a = 1 OR a = 2 OR a = 3.0 OR a = 4.0 OR a = 5 OR a = 7 OR a = CAST(8 AS BIGINT)");
    }

    public static final /* synthetic */ String $anonfun$testConvertToIn_LessThanThreshold_Double$1(int i) {
        return new StringBuilder(4).append("d = ").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$testConvertToIn_GreaterThanThreshold_Double$1(int i) {
        return new StringBuilder(4).append("d = ").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$testConvertToNotIn_LessThanThreshold_Double$1(int i) {
        return new StringBuilder(5).append("d <> ").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$testConvertToNotIn_GreaterThanThreshold_Double$1(int i) {
        return new StringBuilder(5).append("d <> ").append(i).toString();
    }
}

