/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.optimize.program.StreamOptimizeContext;
import org.apache.flink.table.planner.plan.rules.logical.CorrelateSortToRankRule$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0001\u0002\u0001'\tY2i\u001c:sK2\fG/Z*peR$vNU1oWJ+H.\u001a+fgRT!a\u0001\u0003\u0002\u000f1|w-[2bY*\u0011QAB\u0001\u0006eVdWm\u001d\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\tYA\"A\u0003uC\ndWM\u0003\u0002\u000e\u001d\u0005)a\r\\5oW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0005]A\u0011!B;uS2\u001c\u0018BA\r\u0017\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003\u0011)H/\u001b7\u0016\u0003\t\u0002\"!F\u0012\n\u0005\u00112\"aE*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0014\u0001A\u0003%!%A\u0003vi&d\u0007\u0005C\u0003)\u0001\u0011\u0005\u0011&A\u0003tKR,\b\u000fF\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0011)f.\u001b;)\u0005\u001d\n\u0004C\u0001\u001a:\u001b\u0005\u0019$B\u0001\u001b6\u0003\r\t\u0007/\u001b\u0006\u0003m]\nqA[;qSR,'O\u0003\u00029!\u0005)!.\u001e8ji&\u0011!h\r\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0007\"\u0002\u001f\u0001\t\u0003I\u0013a\u0006;fgR\u001cuN\u001d:fY\u0006$XmU8siR{'+\u00198lQ\tYd\b\u0005\u00023\u007f%\u0011\u0001i\r\u0002\u0005)\u0016\u001cH\u000fC\u0003C\u0001\u0011\u0005\u0011&\u0001\u000fuKN$hj\u001c8J]:,'OS8j]:{GoU;qa>\u0014H/\u001a3)\u0005\u0005s\u0004\"B#\u0001\t\u0003I\u0013a\u0006;fgR\fumZ\"bY2tu\u000e^*vaB|'\u000f^3eQ\t!e\bC\u0003I\u0001\u0011\u0005\u0011&\u0001\u0017uKN$8i\u001c:sK2\fG/Z*peR$vNU1oW^KG\u000f['vYRL\u0007\u000f\\3He>,\boS3zg\"\u0012qI\u0010\u0005\u0006\u0017\u0002!\t!K\u0001#i\u0016\u001cH/Q4h\u0013:\u0004X\u000f\u001e(p]6\u000b\u0007\u000f]5oO:{GoU;qa>\u0014H/\u001a3)\u0005)s\u0004\"\u0002(\u0001\t\u0003I\u0013A\b;fgR\u001cvN\u001d;XSRDwJ\u001a4tKRtu\u000e^*vaB|'\u000f^3eQ\tie\bC\u0003R\u0001\u0011\u0005\u0011&A\u0011uKN$hj\u001c8FcV\fGnQ8oI&$\u0018n\u001c8O_R\u001cV\u000f\u001d9peR,G\r\u000b\u0002Q}!)A\u000b\u0001C\u0001S\u0005\u0019C/Z:u\r&dG/\u001a:D_:$\u0017\u000e^5p]:{GoQ8se\u0016d\u0017\r^5p]&#\u0005FA*?\u0011\u00159\u0006\u0001\"\u0001*\u00039\"Xm\u001d;Nk2$\u0018\u000e\u001d7f\u000fJ|W\u000f]5oON<\u0016\u000e\u001e5D_:\u001cH/\u00198u\u001d>$8+\u001e9q_J$X\rZ\u0019)\u0005Ys\u0004\"\u0002.\u0001\t\u0003I\u0013A\f;fgRlU\u000f\u001c;ja2,wI]8va&twm],ji\"\u001cuN\\:uC:$hj\u001c;TkB\u0004xN\u001d;fIJB#!\u0017 ")
public class CorrelateSortToRankRuleTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CorrelateSortToRankRule$.MODULE$.INSTANCE()})).build());
        this.util().replaceStreamProgram((FlinkChainedProgram<StreamOptimizeContext>)programs);
        String createTable = new StringOps(Predef$.MODULE$.augmentString("\n         |create table t1(\n         |  f0 int,\n         |  f1 bigint,\n         |  f2 varchar(20)\n         |) with (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n         |")).stripMargin();
        this.util().tableEnv().executeSql(createTable);
    }

    @Test
    public void testCorrelateSortToRank() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT f0, f1\n         |FROM\n         |  (SELECT DISTINCT f0 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE f0 = t2.f0\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      ")).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testNonInnerJoinNotSupported() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT f0, f1\n         |FROM\n         |  (SELECT DISTINCT f0 FROM t1) t2\n         |  NATURAL LEFT JOIN\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE f0 = t2.f0\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      ")).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testAggCallNotSupported() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT mf0, f1\n         |FROM\n         |  (SELECT max(f0) as mf0 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE f0 = t2.mf0\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      ")).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testCorrelateSortToRankWithMultipleGroupKeys() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT f0, f2\n         |FROM\n         |  (SELECT DISTINCT f0, f1 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f2\n         |    FROM t1\n         |    WHERE f0 = t2.f0 AND f1 = t2.f1\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      ")).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testAggInputNonMappingNotSupported() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT f0, f1\n         |FROM\n         |  (SELECT DISTINCT f0 FROM (SELECT f0 + f1 as f0 from t1)) t2,\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE f0 = t2.f0\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      ")).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testSortWithOffsetNotSupported() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT f0, f1\n         |FROM\n         |  (SELECT DISTINCT f0 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE f0 = t2.f0\n         |    ORDER BY f2 DESC\n         |    OFFSET 2 ROWS\n         |    FETCH NEXT 3 ROWS ONLY\n         |  )\n      ")).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testNonEqualConditionNotSupported() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT f0, f1\n         |FROM\n         |  (SELECT DISTINCT f0 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE f0 > t2.f0\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      ")).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testFilterConditionNotCorrelationID() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT f0, f1\n         |FROM\n         |  (SELECT DISTINCT f0 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f1, f2\n         |    FROM t1\n         |    WHERE t2.f0 = f0 + 1\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      ")).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testMultipleGroupingsWithConstantNotSupported1() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT f0, f2\n         |FROM\n         |  (SELECT DISTINCT f0, f1 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f2\n         |    FROM t1\n         |    WHERE f0 = 1 AND f1 = t2.f1\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      ")).stripMargin();
        this.util().verifyRelPlan(query);
    }

    @Test
    public void testMultipleGroupingsWithConstantNotSupported2() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT f0, f2\n         |FROM\n         |  (SELECT DISTINCT f0, f1 FROM t1) t2,\n         |  LATERAL (\n         |    SELECT f2\n         |    FROM t1\n         |    WHERE 1 = t2.f0 AND f1 = t2.f1\n         |    ORDER BY f2\n         |    DESC LIMIT 3\n         |  )\n      ")).stripMargin();
        this.util().verifyRelPlan(query);
    }
}

