/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.rules.logical.DecomposeGroupingSetsRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001A3A!\u0001\u0002\u0001'\tiB)Z2p[B|7/Z$s_V\u0004\u0018N\\4TKR\u001c(+\u001e7f)\u0016\u001cHO\u0003\u0002\u0004\t\u00059An\\4jG\u0006d'BA\u0003\u0007\u0003\u0015\u0011X\u000f\\3t\u0015\t9\u0001\"\u0001\u0003qY\u0006t'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003C\u0001\u0006kRLGn]\u0005\u00033Y\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\n\u0005\nA!\u001e;jYV\t!\u0005\u0005\u0002\u0016G%\u0011AE\u0006\u0002\u0013\u0005\u0006$8\r\u001b+bE2,G+Z:u+RLG\u000e\u0003\u0004'\u0001\u0001\u0006IAI\u0001\u0006kRLG\u000e\t\u0005\u0006Q\u0001!\t!K\u0001\u0011i\u0016\u001cHo\u0012:pkBLgnZ*fiN$\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0005+:LG\u000f\u000b\u0002(cA\u0011!'O\u0007\u0002g)\u0011A'N\u0001\u0004CBL'B\u0001\u001c8\u0003\u001dQW\u000f]5uKJT!\u0001\u000f\t\u0002\u000b),h.\u001b;\n\u0005i\u001a$\u0001\u0002+fgRDQ\u0001\u0010\u0001\u0005\u0002%\n\u0001\u0002^3ti\u000e+(-\u001a\u0015\u0003wEBQa\u0010\u0001\u0005\u0002%\n!\u0002^3tiJ{G\u000e\\;qQ\tq\u0014\u0007C\u0003C\u0001\u0011\u0005\u0011&A\u0010uKN$xI]8va&twmU3ug^KG\u000f[(oK\u001e\u0013x.\u001e9j]\u001eD#!Q\u0019\t\u000b\u0015\u0003A\u0011A\u0015\u0002IQ,7\u000f^$s_V\u0004\u0018N\\4TKR\u001cx+\u001b;i\tV\u0004H.[2bi\u00164\u0015.\u001a7egFB#\u0001R\u0019\t\u000b!\u0003A\u0011A\u0015\u0002IQ,7\u000f^$s_V\u0004\u0018N\\4TKR\u001cx+\u001b;i\tV\u0004H.[2bi\u00164\u0015.\u001a7egJB#aR\u0019\t\u000b-\u0003A\u0011A\u0015\u0002\u001fQ,7\u000f^\"B\u0019\u000eKE+R\u00199eQB#AS\u0019\t\u000b9\u0003A\u0011A\u0015\u00023Q,7\u000f\u001e+p_6\u000bg._$s_V\u0004\u0018N\\4GS\u0016dGm\u001d\u0015\u0003\u001bF\u0002")
public class DecomposeGroupingSetsRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testGroupingSets() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c, avg(a) AS a, GROUP_ID() AS g FROM MyTable\n        |GROUP BY GROUPING SETS (b, c)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCube() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY CUBE (b, c)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRollup() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) as gid\n        |FROM MyTable\n        |     GROUP BY ROLLUP (b, c)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testGroupingSetsWithOneGrouping() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b,\n        |    AVG(a) AS a,\n        |    GROUP_ID() as g,\n        |    GROUPING(b) as gb,\n        |    GROUPING_ID(b) as gib\n        |FROM MyTable\n        |    GROUP BY GROUPING SETS (b)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testGroupingSetsWithDuplicateFields1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT count(b) as b, count(c) as c FROM MyTable GROUP BY GROUPING SETS (b, c)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testGroupingSetsWithDuplicateFields2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT count(a) as a, count(b) as b, count(c) as c FROM MyTable\n        |GROUP BY GROUPING SETS ((a, b), (a, c))\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testCALCITE1824() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, GROUP_ID() AS g, COUNT(*) as c FROM MyTable GROUP BY GROUPING SETS (a, (), ())\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testTooManyGroupingFields() {
        String[] fieldNames = (String[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 64).map((Function1 & Serializable & scala.Serializable)i -> DecomposeGroupingSetsRuleTest.$anonfun$testTooManyGroupingFields$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        TypeInformation[] fieldTypes = (TypeInformation[])Array$.MODULE$.fill(fieldNames.length, (Function0 & Serializable & scala.Serializable)() -> Types.INT(), ClassTag$.MODULE$.apply(TypeInformation.class));
        this.util().addTableSource("MyTable64", fieldTypes, fieldNames);
        String fields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).mkString(",");
        String sqlQuery = new StringBuilder(48).append("SELECT ").append(fields).append(" FROM MyTable64 GROUP BY GROUPING SETS (").append(fields).append(")").toString();
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.util().verifyRelPlan(sqlQuery));
    }

    public static final /* synthetic */ String $anonfun$testTooManyGroupingFields$1(int i) {
        return new StringBuilder(1).append("f").append(i).toString();
    }

    public DecomposeGroupingSetsRuleTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.DecomposeGroupingSetsRuleTest$$anon$2 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().buildBatchProgram(FlinkBatchProgram$.MODULE$.PHYSICAL());
    }
}

