/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.expressions.utils.RichFunc1;
import org.apache.flink.table.planner.plan.rules.logical.DeterministicPythonFunc$;
import org.apache.flink.table.planner.plan.rules.logical.ExpressionReductionRulesTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u001d3A!\u0001\u0002\u0001'\taR\t\u001f9sKN\u001c\u0018n\u001c8SK\u0012,8\r^5p]J+H.Z:UKN$(BA\u0002\u0005\u0003\u001dawnZ5dC2T!!\u0002\u0004\u0002\u000bI,H.Z:\u000b\u0005\u001dA\u0011\u0001\u00029mC:T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9\u0002\"A\u0003vi&d7/\u0003\u0002\u001a-\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000f\u0001\u0002!\u0019!C\u0005C\u0005!Q\u000f^5m+\u0005\u0011\u0003CA\u000b$\u0013\t!cC\u0001\nCCR\u001c\u0007\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0014\u0001A\u0003%!%A\u0003vi&d\u0007\u0005C\u0003)\u0001\u0011\u0005\u0011&\u0001\u0010uKN$X\t\u001f9sKN\u001c\u0018n\u001c8SK\u0012,8\r^5p]^KG\u000f[+E\rR\t!\u0006\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0003V]&$\bFA\u00142!\t\u0011\u0014(D\u00014\u0015\t!T'A\u0002ba&T!AN\u001c\u0002\u000f),\b/\u001b;fe*\u0011\u0001\bE\u0001\u0006UVt\u0017\u000e^\u0005\u0003uM\u0012A\u0001V3ti\")A\b\u0001C\u0001S\u0005\u0011C/Z:u\u000bb\u0004(/Z:tS>t'+\u001a3vGRLwN\\,ji\"\u0014\u0016n\u00195V\t\u001aC#aO\u0019\t\u000b}\u0002A\u0011A\u0015\u0002aQ,7\u000f^#yaJ,7o]5p]J+G-^2uS>tw+\u001b;i%&\u001c\u0007.\u0016#G\u0003:$\u0017J\u001c<bY&$w\n]3oQ\tq\u0014\u0007C\u0003C\u0001\u0011\u0005\u0011&\u0001\u0013uKN$X\t\u001f9sKN\u001c\u0018n\u001c8SK\u0012,8\r^5p]^KG\u000f\u001b)zi\"|g.\u0016#GQ\t\t\u0015\u0007C\u0003F\u0001\u0011\u0005\u0011&A\u0010uKN$X\t\u001f9sKN\u001c\u0018n\u001c8SK\u0012,8\r^5p]^KG\u000f\u001b*b]\u0012D#\u0001R\u0019")
public class ExpressionReductionRulesTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testExpressionReductionWithUDF() {
        this.util().addTemporarySystemFunction("MyUdf", (UserDefinedFunction)Func1$.MODULE$);
        this.util().verifyRelPlan("SELECT MyUdf(1) FROM MyTable");
    }

    @Test
    public void testExpressionReductionWithRichUDF() {
        this.util().addTemporarySystemFunction("MyUdf", (UserDefinedFunction)new RichFunc1());
        this.util().getTableEnv().getConfig().addJobParameter("int.value", "10");
        this.util().verifyRelPlan("SELECT myUdf(1) FROM MyTable");
    }

    @Test
    public void testExpressionReductionWithRichUDFAndInvalidOpen() {
        this.util().addTemporarySystemFunction("MyUdf", (UserDefinedFunction)new RichFunc1());
        this.util().getTableEnv().getConfig().addJobParameter("fail-for-cached-file", "true");
        this.util().verifyRelPlan("SELECT myUdf(1 + 1) FROM MyTable");
    }

    @Test
    public void testExpressionReductionWithPythonUDF() {
        this.util().addTemporarySystemFunction("PyUdf", (UserDefinedFunction)DeterministicPythonFunc$.MODULE$);
        this.util().addTemporarySystemFunction("MyUdf", (UserDefinedFunction)Func1$.MODULE$);
        this.util().verifyExecPlan("SELECT PyUdf(), MyUdf(1) FROM MyTable");
    }

    @Test
    public void testExpressionReductionWithRand() {
        this.util().verifyExecPlan("SELECT RAND(), RAND(), RAND(1), RAND(1), RAND_INTEGER(3), RAND_INTEGER(3) FROM MyTable");
    }

    public ExpressionReductionRulesTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.ExpressionReductionRulesTest$$anon$2 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

