/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.rules.logical.FlinkLogicalRankRuleForConstantRangeTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0001\u0002\u0001'\tAc\t\\5oW2{w-[2bYJ\u000bgn\u001b*vY\u00164uN]\"p]N$\u0018M\u001c;SC:<W\rV3ti*\u00111\u0001B\u0001\bY><\u0017nY1m\u0015\t)a!A\u0003sk2,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/!\tQ!\u001e;jYNL!!\u0007\f\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0004!\u0001\t\u0007I\u0011B\u0011\u0002\tU$\u0018\u000e\\\u000b\u0002EA\u0011QcI\u0005\u0003IY\u0011!CQ1uG\"$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\"1a\u0005\u0001Q\u0001\n\t\nQ!\u001e;jY\u0002BQ\u0001\u000b\u0001\u0005\u0002%\n\u0011\u0003^3tiJ{wOT;nE\u0016\u0014h)\u001e8d)\u0005Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#\u0001B+oSRD#aJ\u0019\u0011\u0005IJT\"A\u001a\u000b\u0005Q*\u0014aA1qS*\u0011agN\u0001\bUV\u0004\u0018\u000e^3s\u0015\tA\u0004#A\u0003kk:LG/\u0003\u0002;g\t!A+Z:u\u0011\u0015a\u0004\u0001\"\u0001*\u0003E!Xm\u001d;XSRDw.\u001e;GS2$XM\u001d\u0015\u0003wEBQa\u0010\u0001\u0005\u0002%\n\u0011\u0005^3tiJ\u000bgn\u001b,bYV,g)\u001b7uKJ<\u0016\u000e\u001e5VaB,'OV1mk\u0016D#AP\u0019\t\u000b\t\u0003A\u0011A\u0015\u00029Q,7\u000f\u001e*b].4\u0016\r\\;f\r&dG/\u001a:XSRD'+\u00198hK\"\u0012\u0011)\r\u0005\u0006\u000b\u0002!\t!K\u0001\"i\u0016\u001cHOU1oWZ\u000bG.^3GS2$XM],ji\"dun^3s-\u0006dW/\u001a\u0015\u0003\tFBQ\u0001\u0013\u0001\u0005\u0002%\nQ\u0004^3tiJ\u000bgn\u001b,bYV,g)\u001b7uKJ<\u0016\u000e\u001e5FcV\fGn\u001d\u0015\u0003\u000fFBQa\u0013\u0001\u0005\u0002%\nQ\u0005^3tiJ\u000bgn\u001b,bYV,g)\u001b7uKJ<\u0016\u000e\u001e5WCJL\u0017M\u00197f\r&,G\u000eZ\u0019)\u0005)\u000b\u0004\"\u0002(\u0001\t\u0003I\u0013!\n;fgR\u0014\u0016M\\6WC2,XMR5mi\u0016\u0014x+\u001b;i-\u0006\u0014\u0018.\u00192mK\u001aKW\r\u001c33Q\ti\u0015\u0007C\u0003R\u0001\u0011\u0005\u0011&A\u0013uKN$(+\u00198l-\u0006dW/\u001a$jYR,'oV5uQZ\u000b'/[1cY\u00164\u0015.\u001a7eg!\u0012\u0001+\r\u0005\u0006)\u0002!\t!K\u0001&i\u0016\u001cHOU1oWZ\u000bG.^3GS2$XM],ji\"4\u0016M]5bE2,g)[3mIRB#aU\u0019\t\u000b]\u0003A\u0011A\u0015\u0002-Q,7\u000f^,ji\"|W\u000f\u001e)beRLG/[8o\u0005fD#AV\u0019\t\u000bi\u0003A\u0011A\u0015\u0002OQ,7\u000f^'vYRL7+Y7f%\u0006t7NR;oGRLwN\\:XSRD7+Y7f\u000fJ|W\u000f\u001d\u0015\u00033FBQ!\u0018\u0001\u0005\u0002%\nq\u0005^3ti6+H\u000e^5TC6,'+\u00198l\rVt7\r^5p]N<\u0016\u000e\u001e5ES\u001a4wI]8va\"\u0012A,\r\u0005\u0006A\u0002!\t!K\u0001\u001bi\u0016\u001cH/T;mi&$\u0015N\u001a4SC:\\g)\u001e8di&|gn\u001d\u0015\u0003?FBQa\u0019\u0001\u0005\u0002%\n1\u0005^3ti\u0012+\b\u000f\\5dCR,'+\u00198l\rVt7\r^5p]\u000e{G.^7o\u001d\u0006lW\r\u000b\u0002cc\u0001")
public class FlinkLogicalRankRuleForConstantRangeTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testRowNumberFunc() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, ROW_NUMBER() OVER (PARTITION BY b ORDER BY a) rn FROM MyTable) t\n        |WHERE rn <= 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testWithoutFilter() {
        this.util().verifyRelPlan("SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a) rk FROM MyTable");
    }

    @Test
    public void testRankValueFilterWithUpperValue() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a) rk FROM MyTable) t\n        |WHERE rk <= 2 AND a > 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithRange() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b, c ORDER BY a) rk FROM MyTable) t\n        |WHERE rk <= 2 AND rk > -2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithLowerValue() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a, c) rk FROM MyTable) t\n        |WHERE rk > 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithEquals() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a, c) rk FROM MyTable) t\n        |WHERE rk = 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithVariableField1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY c) rk FROM MyTable) t\n        |WHERE rk < a\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithVariableField2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY c) rk FROM MyTable) t\n        |WHERE rk > a\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithVariableField3() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY c) rk FROM MyTable) t\n        |WHERE rk < a and b > 5\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithVariableField4() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY a ORDER BY c) rk FROM MyTable) t\n        |WHERE rk = b\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testWithoutPartitionBy() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (ORDER BY a) rk FROM MyTable) t\n        |WHERE rk < 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiSameRankFunctionsWithSameGroup() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b,\n        |        RANK() OVER (PARTITION BY b ORDER BY a) rk1,\n        |        RANK() OVER (PARTITION BY b ORDER BY a) rk2 FROM MyTable) t\n        |WHERE rk1 < 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiSameRankFunctionsWithDiffGroup() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b,\n        |        RANK() OVER (PARTITION BY b ORDER BY a) rk1,\n        |        RANK() OVER (PARTITION BY c ORDER BY a) rk2 FROM MyTable) t\n        |WHERE rk1 < 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiDiffRankFunctions() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b,\n        |        RANK() OVER (PARTITION BY b ORDER BY a) rk,\n        |        ROW_NUMBER() OVER (PARTITION BY b ORDER BY a) rn FROM MyTable) t\n        |WHERE rk < 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testDuplicateRankFunctionColumnName() {
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rk"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.rules.logical.FlinkLogicalRankRuleForConstantRangeTest$$anon$4 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a) rk FROM MyTable2) t\n        |WHERE rk < 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    public FlinkLogicalRankRuleForConstantRangeTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.FlinkLogicalRankRuleForConstantRangeTest$$anon$3 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().buildBatchProgram(FlinkBatchProgram$.MODULE$.PHYSICAL());
    }
}

