/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.FlinkStreamProgram$;
import org.apache.flink.table.planner.plan.rules.logical.FlinkLogicalRankRuleForRangeEndTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001'\t\u0019c\t\\5oW2{w-[2bYJ\u000bgn\u001b*vY\u00164uN\u001d*b]\u001e,WI\u001c3UKN$(BA\u0002\u0005\u0003\u001dawnZ5dC2T!!\u0002\u0004\u0002\u000bI,H.Z:\u000b\u0005\u001dA\u0011\u0001\u00029mC:T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9\u0002\"A\u0003vi&d7/\u0003\u0002\u001a-\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000f\u0001\u0002!\u0019!C\u0005C\u0005!Q\u000f^5m+\u0005\u0011\u0003CA\u000b$\u0013\t!cCA\nTiJ,\u0017-\u001c+bE2,G+Z:u+RLG\u000e\u0003\u0004'\u0001\u0001\u0006IAI\u0001\u0006kRLG\u000e\t\u0005\u0006Q\u0001!\t!K\u0001\u0012i\u0016\u001cHOU8x\u001dVl'-\u001a:Gk:\u001cG#\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0003OE\u0002\"AM\u001d\u000e\u0003MR!\u0001N\u001b\u0002\u0007\u0005\u0004\u0018N\u0003\u00027o\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001d\u0011\u0003\u0015QWO\\5u\u0013\tQ4G\u0001\u0003UKN$\b\"\u0002\u001f\u0001\t\u0003I\u0013!\u0005;fgR<\u0016\u000e\u001e5pkR4\u0015\u000e\u001c;fe\"\u00121(\r\u0005\u0006\u007f\u0001!\t!K\u0001\"i\u0016\u001cHOU1oWZ\u000bG.^3GS2$XM],ji\",\u0006\u000f]3s-\u0006dW/\u001a\u0015\u0003}EBQA\u0011\u0001\u0005\u0002%\nA\u0004^3tiJ\u000bgn\u001b,bYV,g)\u001b7uKJ<\u0016\u000e\u001e5SC:<W\r\u000b\u0002Bc!)Q\t\u0001C\u0001S\u0005\tC/Z:u%\u0006t7NV1mk\u00164\u0015\u000e\u001c;fe^KG\u000f\u001b'po\u0016\u0014h+\u00197vK\"\u0012A)\r\u0005\u0006\u0011\u0002!\t!K\u0001\u001ei\u0016\u001cHOU1oWZ\u000bG.^3GS2$XM],ji\",\u0015/^1mg\"\u0012q)\r\u0005\u0006\u0017\u0002!\t!K\u0001&i\u0016\u001cHOU1oWZ\u000bG.^3GS2$XM],ji\"4\u0016M]5bE2,g)[3mIFB#AS\u0019\t\u000b9\u0003A\u0011A\u0015\u0002KQ,7\u000f\u001e*b].4\u0016\r\\;f\r&dG/\u001a:XSRDg+\u0019:jC\ndWMR5fY\u0012\u0014\u0004FA'2\u0011\u0015\t\u0006\u0001\"\u0001*\u0003\u0015\"Xm\u001d;SC:\\g+\u00197vK\u001aKG\u000e^3s/&$\bNV1sS\u0006\u0014G.\u001a$jK2$7\u0007\u000b\u0002Qc!)A\u000b\u0001C\u0001S\u0005)C/Z:u%\u0006t7NV1mk\u00164\u0015\u000e\u001c;fe^KG\u000f\u001b,be&\f'\r\\3GS\u0016dG\r\u000e\u0015\u0003'FBQa\u0016\u0001\u0005\u0002%\na\u0003^3ti^KG\u000f[8viB\u000b'\u000f^5uS>t')\u001f\u0015\u0003-FBQA\u0017\u0001\u0005\u0002%\nq\u0005^3ti6+H\u000e^5TC6,'+\u00198l\rVt7\r^5p]N<\u0016\u000e\u001e5TC6,wI]8va\"\u0012\u0011,\r\u0005\u0006;\u0002!\t!K\u0001(i\u0016\u001cH/T;mi&\u001c\u0016-\\3SC:\\g)\u001e8di&|gn],ji\"$\u0015N\u001a4He>,\b\u000f\u000b\u0002]c!)\u0001\r\u0001C\u0001S\u0005QB/Z:u\u001bVdG/\u001b#jM\u001a\u0014\u0016M\\6Gk:\u001cG/[8og\"\u0012q,\r")
public class FlinkLogicalRankRuleForRangeEndTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testRowNumberFunc() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, ROW_NUMBER() OVER (PARTITION BY b ORDER BY a) rn FROM MyTable) t\n        |WHERE rn <= 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testWithoutFilter() {
        this.util().verifyRelPlan("SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a) rk FROM MyTable");
    }

    @Test
    public void testRankValueFilterWithUpperValue() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a) rk FROM MyTable) t\n        |WHERE rk <= 2 AND a > 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithRange() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b, c ORDER BY a) rk FROM MyTable) t\n        |WHERE rk <= 2 AND rk > -2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithLowerValue() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a, c) rk FROM MyTable) t\n        |WHERE rk > 2\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(sqlQuery)).hasMessageContaining("Rank end is not specified.") instanceof TableException;
    }

    @Test
    public void testRankValueFilterWithEquals() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY a, c) rk FROM MyTable) t\n        |WHERE rk = 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithVariableField1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY c) rk FROM MyTable) t\n        |WHERE rk < a\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithVariableField2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY c) rk FROM MyTable) t\n        |WHERE rk > a\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithVariableField3() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY b ORDER BY c) rk FROM MyTable) t\n        |WHERE rk < a and b > 5\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testRankValueFilterWithVariableField4() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (PARTITION BY a ORDER BY c) rk FROM MyTable) t\n        |WHERE rk = b\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testWithoutPartitionBy() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b, RANK() OVER (ORDER BY a) rk FROM MyTable) t\n        |WHERE rk < 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiSameRankFunctionsWithSameGroup() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b,\n        |        RANK() OVER (PARTITION BY b ORDER BY a) rk1,\n        |        RANK() OVER (PARTITION BY b ORDER BY a) rk2 FROM MyTable) t\n        |WHERE rk1 < 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiSameRankFunctionsWithDiffGroup() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b,\n        |        RANK() OVER (PARTITION BY b ORDER BY a) rk1,\n        |        RANK() OVER (PARTITION BY c ORDER BY a) rk2 FROM MyTable) t\n        |WHERE rk1 < 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiDiffRankFunctions() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        | SELECT a, b,\n        |        RANK() OVER (PARTITION BY b ORDER BY a) rk,\n        |        ROW_NUMBER() OVER (PARTITION BY b ORDER BY a) rn FROM MyTable) t\n        |WHERE rk < 10\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    public FlinkLogicalRankRuleForRangeEndTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.FlinkLogicalRankRuleForRangeEndTest$$anon$2 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().buildStreamProgram(FlinkStreamProgram$.MODULE$.PHYSICAL());
    }
}

