/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.JoinDeriveNullFilterRule$;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0001\u0002\u0001'\ta\"j\\5o\t\u0016\u0014\u0018N^3Ok2dg)\u001b7uKJ\u0014V\u000f\\3UKN$(BA\u0002\u0005\u0003\u001dawnZ5dC2T!!\u0002\u0004\u0002\u000bI,H.Z:\u000b\u0005\u001dA\u0011\u0001\u00029mC:T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9\u0002\"A\u0003vi&d7/\u0003\u0002\u001a-\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000f\u0001\u0002!\u0019!C\u0005C\u0005!Q\u000f^5m+\u0005\u0011\u0003CA\u000b$\u0013\t!cC\u0001\nCCR\u001c\u0007\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0014\u0001A\u0003%!%A\u0003vi&d\u0007\u0005C\u0003)\u0001\u0011\u0005\u0011&A\u0003tKR,\b\u000fF\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0011)f.\u001b;)\u0005\u001d\n\u0004C\u0001\u001a:\u001b\u0005\u0019$B\u0001\u001b6\u0003\r\t\u0007/\u001b\u0006\u0003m]\nqA[;qSR,'O\u0003\u00029!\u0005)!.\u001e8ji&\u0011!h\r\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0007\"\u0002\u001f\u0001\t\u0003I\u0013A\b;fgRLeN\\3s\u0015>Lgn\u0018(p]\u0016,\u0015/^5K_&t7*Z=tQ\tYd\b\u0005\u00023\u007f%\u0011\u0001i\r\u0002\u0005)\u0016\u001cH\u000fC\u0003C\u0001\u0011\u0005\u0011&A\u0013uKN$\u0018J\u001c8fe*{\u0017N\\0Ok2d7i\\;oi>sG*\u001a4u\u0015>LgnS3zg\"\u0012\u0011I\u0010\u0005\u0006\u000b\u0002!\t!K\u0001'i\u0016\u001cH/\u00138oKJTu.\u001b8`\u001dVdGnQ8v]R|eNU5hQRTu.\u001b8LKf\u001c\bF\u0001#?\u0011\u0015A\u0005\u0001\"\u0001*\u0003)\"Xm\u001d;J]:,'OS8j]~sU\u000f\u001c7D_VtGo\u00148MK\u001a$(+[4ii*{\u0017N\\&fsND#a\u0012 \t\u000b-\u0003A\u0011A\u0015\u00023Q,7\u000f^%o]\u0016\u0014(j\\5o?:{g*\u001e7m\u0007>,h\u000e\u001e\u0015\u0003\u0015zBQA\u0014\u0001\u0005\u0002%\n\u0001\u0006^3ti&sg.\u001a:K_&twLT;mY\u000e{WO\u001c;MKN\u001cH\u000b[1o)\"\u0014Xm\u001d5pY\u0012D#!\u0014 \t\u000bE\u0003A\u0011A\u0015\u0002\u0019Q,7\u000f\u001e'fMRTu.\u001b8)\u0005As\u0004\"\u0002+\u0001\t\u0003I\u0013!\u0004;fgR\u0014\u0016n\u001a5u\u0015>Lg\u000e\u000b\u0002T}!)q\u000b\u0001C\u0001S\u0005aA/Z:u\rVdGNS8j]\"\u0012aK\u0010")
public class JoinDeriveNullFilterRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().buildBatchProgram(FlinkBatchProgram$.MODULE$.DEFAULT_REWRITE());
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.util().tableEnv().getConfig());
        ((FlinkChainedProgram)calciteConfig.getBatchProgram().get()).addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{JoinDeriveNullFilterRule$.MODULE$.INSTANCE()})).build());
        this.util().tableEnv().getConfig().set(JoinDeriveNullFilterRule$.MODULE$.TABLE_OPTIMIZER_JOIN_NULL_FILTER_THRESHOLD(), (Object)BoxesRunTime.boxToLong((long)2000000L));
        this.util().addTableSource("MyTable1", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING(), Types.INT(), Types.LONG()}), (String[])((Object[])new String[]{"a1", "b1", "c1", "d1", "e1"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(1000000000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a1"), (Object)new ColumnStats(null, Predef$.MODULE$.long2Long(10000000L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c1"), (Object)new ColumnStats(null, Predef$.MODULE$.long2Long(5000000L), Predef$.MODULE$.double2Double(10.2), Predef$.MODULE$.int2Integer(16), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"e1"), (Object)new ColumnStats(null, Predef$.MODULE$.long2Long(500000L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().addTableSource("MyTable2", (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING(), Types.INT(), Types.LONG()}), (String[])((Object[])new String[]{"a2", "b2", "c2", "d2", "e2"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(2000000000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b2"), (Object)new ColumnStats(null, Predef$.MODULE$.long2Long(10000000L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c2"), (Object)new ColumnStats(null, Predef$.MODULE$.long2Long(3000000L), Predef$.MODULE$.double2Double(18.6), Predef$.MODULE$.int2Integer(32), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"e2"), (Object)new ColumnStats(null, Predef$.MODULE$.long2Long(1500000L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
    }

    @Test
    public void testInnerJoin_NoneEquiJoinKeys() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a1 > a2");
    }

    @Test
    public void testInnerJoin_NullCountOnLeftJoinKeys() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a1 = a2");
    }

    @Test
    public void testInnerJoin_NullCountOnRightJoinKeys() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON b1 = b2");
    }

    @Test
    public void testInnerJoin_NullCountOnLeftRightJoinKeys() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON c1 = c2");
    }

    @Test
    public void testInnerJoin_NoNullCount() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON d1 = d2");
    }

    @Test
    public void testInnerJoin_NullCountLessThanThreshold() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON e1 = e2");
    }

    @Test
    public void testLeftJoin() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 LEFT JOIN MyTable2 ON c1 = c2");
    }

    @Test
    public void testRightJoin() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 RIGHT JOIN MyTable2 ON c1 = c2");
    }

    @Test
    public void testFullJoin() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 FULL JOIN MyTable2 ON c1 = c2");
    }
}

