/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.optimize.program.StreamOptimizeContext;
import org.apache.flink.table.planner.plan.rules.logical.LogicalCorrelateToJoinFromTemporalTableRule$;
import org.apache.flink.table.planner.plan.rules.logical.LogicalCorrelateToJoinFromTemporalTableRuleTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001'\tyCj\\4jG\u0006d7i\u001c:sK2\fG/\u001a+p\u0015>LgN\u0012:p[R+W\u000e]8sC2$\u0016M\u00197f%VdW\rV3ti*\u00111\u0001B\u0001\bY><\u0017nY1m\u0015\t)a!A\u0003sk2,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/!\tQ!\u001e;jYNL!!\u0007\f\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0004!\u0001\t\u0007I\u0011C\u0011\u0002\tU$\u0018\u000e\\\u000b\u0002EA\u0011QcI\u0005\u0003IY\u00111c\u0015;sK\u0006lG+\u00192mKR+7\u000f^+uS2DaA\n\u0001!\u0002\u0013\u0011\u0013!B;uS2\u0004\u0003\"\u0002\u0015\u0001\t\u0003I\u0013!B:fiV\u0004H#\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0003OE\u0002\"AM\u001d\u000e\u0003MR!\u0001N\u001b\u0002\u0007\u0005\u0004\u0018N\u0003\u00027o\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001d\u0011\u0003\u0015QWO\\5u\u0013\tQ4G\u0001\u0006CK\u001a|'/Z#bG\"DQ\u0001\u0010\u0001\u0005\u0002%\n\u0001\u0004^3ti2{wn[;q\u0015>LgnV5uQ\u001aKG\u000e^3sQ\tYd\b\u0005\u00023\u007f%\u0011\u0001i\r\u0002\u0005)\u0016\u001cH\u000fC\u0003C\u0001\u0011\u0005\u0011&\u0001\ruKN$H*\u001a4u\u0019>|7.\u001e9K_&twJ\u001c+sk\u0016D#!\u0011 \t\u000b\u0015\u0003A\u0011A\u0015\u0002EQ,7\u000f\u001e)s_\u000e$\u0016.\\3UK6\u0004xN]1m\u0015>LgnV5uQ\u001aKG\u000e^3sQ\t!e\bC\u0003I\u0001\u0011\u0005\u0011&A\u0011uKN$(k\\<US6,G+Z7q_J\fGNS8j]^KG\u000f\u001b$jYR,'\u000f\u000b\u0002H}!)1\n\u0001C\u0001S\u0005)C/Z:u%><H+[7f\u0019\u00164G\u000fV3na>\u0014\u0018\r\u001c&pS:<\u0016\u000e\u001e5GS2$XM\u001d\u0015\u0003\u0015zBQA\u0014\u0001\u0005\u0002%\nA\u0003^3ti2{wn[;q\u0015>Lgn\u00148UeV,\u0007FA'?\u0011\u0015\t\u0006\u0001\"\u0001*\u0003y!Xm\u001d;Qe>\u001cG+[7f)\u0016l\u0007o\u001c:bY*{\u0017N\\(o)J,X\r\u000b\u0002Q}!)A\u000b\u0001C\u0001S\u0005iB/Z:u%><H+[7f)\u0016l\u0007o\u001c:bY*{\u0017N\\(o)J,X\r\u000b\u0002T}!)q\u000b\u0001C\u0001S\u0005)B/Z:u%&<\u0007\u000e\u001e+f[B|'/\u00197K_&t\u0007F\u0001,?\u0011\u0015Q\u0006\u0001\"\u0001*\u0003Q!Xm\u001d;Gk2dG+Z7q_J\fGNS8j]\"\u0012\u0011L\u0010\u0005\u0006;\u0002!\tAX\u0001\u0011g\u0016$X\u000b]\"veJ,g\u000e\u001e*vY\u0016$\"AK0\t\u000b\u0001d\u0006\u0019A1\u0002\tI,H.\u001a\t\u0003E\u001al\u0011a\u0019\u0006\u0003\u000f\u0011T!!\u001a\b\u0002\u000f\r\fGnY5uK&\u0011qm\u0019\u0002\u000b%\u0016dw\n\u001d;Sk2,\u0007")
public class LogicalCorrelateToJoinFromTemporalTableRuleTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    public StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE T1 (\n                    | id STRING,\n                    | mount INT,\n                    | proctime as PROCTIME(),\n                    | rowtime TIMESTAMP(3),\n                    | WATERMARK FOR rowtime AS rowtime\n                    |) WITH (\n                    | 'connector' = 'COLLECTION',\n                    | 'is-bounded' = 'false'\n                    |)\n      ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE T2 (\n                    | id STRING,\n                    | rate INT,\n                    | PRIMARY KEY(id) NOT ENFORCED\n                    |) WITH (\n                    | 'connector' = 'COLLECTION',\n                    | 'is-bounded' = 'false'\n                    |)\n      ")).stripMargin());
        this.util().addTableSource("T3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.LogicalCorrelateToJoinFromTemporalTableRuleTest$$anon$2 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testLookupJoinWithFilter() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.LOOKUP_JOIN_WITH_FILTER());
        this.util().verifyRelPlan("SELECT * FROM T1 JOIN T2 FOR SYSTEM_TIME AS OF T1.proctime AS dimTable ON T1.id = dimTable.id AND dimTable.rate > 10");
    }

    @Test
    public void testLeftLookupJoinOnTrue() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.LOOKUP_JOIN_WITHOUT_FILTER());
        this.util().verifyRelPlan("SELECT * FROM T1 LEFT JOIN T2 FOR SYSTEM_TIME AS OF T1.proctime AS dimTable ON TRUE");
    }

    @Test
    public void testProcTimeTemporalJoinWithFilter() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITH_FILTER());
        this.util().verifyRelPlan("SELECT * FROM T1 JOIN T3 FOR SYSTEM_TIME AS OF T1.proctime AS dimTable ON T1.id = dimTable.id AND dimTable.rate > 10");
    }

    @Test
    public void testRowTimeTemporalJoinWithFilter() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITH_FILTER());
        this.util().verifyRelPlan("SELECT * FROM T1 JOIN T3 FOR SYSTEM_TIME AS OF T1.rowtime AS dimTable ON T1.id = dimTable.id AND dimTable.rate > 10");
    }

    @Test
    public void testRowTimeLeftTemporalJoinWithFilter() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITH_FILTER());
        this.util().verifyRelPlan("SELECT * FROM T1 LEFT JOIN T3 FOR SYSTEM_TIME AS OF T1.rowtime AS dimTable ON T1.id = dimTable.id AND dimTable.rate > 10");
    }

    @Test
    public void testLookupJoinOnTrue() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.LOOKUP_JOIN_WITHOUT_FILTER());
        this.util().verifyRelPlan("SELECT * FROM T1 JOIN T2 FOR SYSTEM_TIME AS OF T1.proctime AS dimTable ON TRUE");
    }

    @Test
    public void testProcTimeTemporalJoinOnTrue() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITHOUT_FILTER());
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan("SELECT * FROM T1 JOIN T3 FOR SYSTEM_TIME AS OF T1.rowtime AS dimTable ON TRUE")).hasMessageContaining("Currently the join key in Temporal Table Join can not be empty.") instanceof ValidationException;
    }

    @Test
    public void testRowTimeTemporalJoinOnTrue() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITHOUT_FILTER());
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan("SELECT * FROM T1 JOIN T3 FOR SYSTEM_TIME AS OF T1.proctime AS dimTable ON TRUE")).hasMessageContaining("Currently the join key in Temporal Table Join can not be empty.") instanceof ValidationException;
    }

    @Test
    public void testRightTemporalJoin() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITH_FILTER());
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan("SELECT * FROM T1 RIGHT JOIN T3 FOR SYSTEM_TIME AS OF T1.proctime AS dimTable ON T1.id = dimTable.id AND dimTable.rate > 10")).hasMessageContaining("Correlate has invalid join type RIGHT") instanceof AssertionError;
    }

    @Test
    public void testFullTemporalJoin() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITH_FILTER());
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan("SELECT * FROM T1 FULL JOIN T3 FOR SYSTEM_TIME AS OF T1.proctime AS dimTable ON T1.id = dimTable.id AND dimTable.rate > 10")).hasMessageContaining("Correlate has invalid join type FULL") instanceof AssertionError;
    }

    public void setUpCurrentRule(RelOptRule rule) {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{rule})).build());
        this.util().replaceStreamProgram((FlinkChainedProgram<StreamOptimizeContext>)programs);
    }
}

