/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.jupiter.api.Test;

abstract class PushFilterIntoTableSourceScanRuleTestBase
extends TableTestBase {
    protected TableTestUtil util;

    PushFilterIntoTableSourceScanRuleTestBase() {
    }

    @Test
    void testCanPushDown() {
        this.util.verifyRelPlan("SELECT * FROM MyTable WHERE amount > 2");
    }

    @Test
    void testCanPushDownWithCastConstant() {
        this.util.verifyRelPlan("SELECT * FROM MyTable WHERE amount > cast(1.1 as int)");
    }

    @Test
    void testCanPushDownWithVirtualColumn() {
        this.util.verifyRelPlan("SELECT * FROM VirtualTable WHERE amount > 2");
    }

    @Test
    void testCannotPushDown() {
        this.util.verifyRelPlan("SELECT * FROM MyTable WHERE price > 10");
    }

    @Test
    void testCannotPushDownWithCastConstant() {
        this.util.verifyRelPlan("SELECT * FROM MyTable WHERE price > cast(10.1 as int)");
    }

    @Test
    void testCannotPushDownWithVirtualColumn() {
        this.util.verifyRelPlan("SELECT * FROM VirtualTable WHERE price > 10");
    }

    @Test
    void testPartialPushDown() {
        this.util.verifyRelPlan("SELECT * FROM MyTable WHERE amount > 2 AND price > 10");
    }

    @Test
    void testPartialPushDownWithVirtualColumn() {
        this.util.verifyRelPlan("SELECT * FROM VirtualTable WHERE amount > 2 AND price > 10");
    }

    @Test
    void testFullyPushDown() {
        this.util.verifyRelPlan("SELECT * FROM MyTable WHERE amount > 2 AND amount < 10");
    }

    @Test
    void testFullyPushDownWithVirtualColumn() {
        this.util.verifyRelPlan("SELECT * FROM VirtualTable WHERE amount > 2 AND amount < 10");
    }

    @Test
    void testPartialPushDown2() {
        this.util.verifyRelPlan("SELECT * FROM MyTable WHERE amount > 2 OR price > 10");
    }

    @Test
    void testPartialPushDown2WithVirtualColumn() {
        this.util.verifyRelPlan("SELECT * FROM VirtualTable WHERE amount > 2 OR price > 10");
    }

    @Test
    void testCannotPushDown3() {
        this.util.verifyRelPlan("SELECT * FROM MyTable WHERE amount > 2 OR amount < 10");
    }

    @Test
    void testCannotPushDown3WithVirtualColumn() {
        this.util.verifyRelPlan("SELECT * FROM VirtualTable WHERE amount > 2 OR amount < 10");
    }

    @Test
    void testUnconvertedExpression() {
        this.util.verifyRelPlan("SELECT * FROM MyTable WHERE\n    amount > 2 AND id < 100 AND CAST(amount AS BIGINT) > 10");
    }

    @Test
    void testWithUdf() {
        this.util.addTemporarySystemFunction("myUdf", (UserDefinedFunction)Func1$.MODULE$);
        this.util.verifyRelPlan("SELECT * FROM MyTable WHERE amount > 2 AND myUdf(amount) < 32");
    }

    @Test
    void testLowerUpperPushdown() {
        this.util.verifyRelPlan("SELECT * FROM MTable WHERE LOWER(a) = 'foo' AND UPPER(b) = 'bar'");
    }

    @Test
    void testWithInterval() {
        this.util.verifyRelPlan("SELECT * FROM MTable\nWHERE TIMESTAMPADD(HOUR, 5, a) >= b\nOR\nTIMESTAMPADD(YEAR, 2, b) >= a");
    }

    @Test
    void testCannotPushDownIn() {
        this.util.verifyRelPlan("SELECT * FROM MyTable WHERE name IN ('Alice', 'Bob', 'Dave')");
    }

    @Test
    void testWithNullLiteral() {
        this.util.verifyRelPlan("WITH MyView AS (SELECT CASE\n  WHEN amount > 0 THEN name\n  ELSE CAST(NULL AS STRING)\n  END AS a\n  FROM MyTable)\nSELECT a FROM MyView WHERE a IS NOT NULL\n");
    }
}

