/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalLegacyTableSourceScan$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalSort$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.PushLimitIntoLegacyTableSourceScanRule$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0001\u0002\u0001'\tQ\u0003+^:i\u0019&l\u0017\u000e^%oi>dUmZ1dsR\u000b'\r\\3T_V\u00148-Z*dC:\u0014V\u000f\\3UKN$(BA\u0002\u0005\u0003\u001dawnZ5dC2T!!\u0002\u0004\u0002\u000bI,H.Z:\u000b\u0005\u001dA\u0011\u0001\u00029mC:T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9\u0002\"A\u0003vi&d7/\u0003\u0002\u001a-\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000f\u0001\u0002!\u0019!C\tC\u0005!Q\u000f^5m+\u0005\u0011\u0003CA\u000b$\u0013\t!cC\u0001\nCCR\u001c\u0007\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0014\u0001A\u0003%!%A\u0003vi&d\u0007\u0005C\u0003)\u0001\u0011\u0005\u0011&A\u0003tKR,\b\u000fF\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0011)f.\u001b;)\u0005\u001d\n\u0004C\u0001\u001a:\u001b\u0005\u0019$B\u0001\u001b6\u0003\r\t\u0007/\u001b\u0006\u0003m]\nqA[;qSR,'O\u0003\u00029!\u0005)!.\u001e8ji&\u0011!h\r\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0007\"\u0002\u001f\u0001\t\u0003I\u0013a\u0007;fgRd\u0015.\\5u/&$\bNT3hCRLg/Z(gMN,G\u000f\u000b\u0002<}A\u0011!gP\u0005\u0003\u0001N\u0012A\u0001V3ti\")!\t\u0001C\u0001S\u0005qB/Z:u\u001d\u0016<\u0017\r^5wK2KW.\u001b;XSRDw.\u001e;PM\u001a\u001cX\r\u001e\u0015\u0003\u0003zBQ!\u0012\u0001\u0005\u0002%\na\u0002^3ti6K8/\u001d7MS6LG\u000f\u000b\u0002E}!)\u0001\n\u0001C\u0001S\u0005\tC/Z:u\u0007\u0006t\u0007+^:iI><h\u000eT5nSR<\u0016\u000e\u001e5pkR|eMZ:fi\"\u0012qI\u0010\u0005\u0006\u0017\u0002!\t!K\u0001\u001fi\u0016\u001cHoQ1o!V\u001c\b\u000eZ8x]2KW.\u001b;XSRDwJ\u001a4tKRD#A\u0013 \t\u000b9\u0003A\u0011A\u0015\u0002=Q,7\u000f^\"b]B+8\u000f\u001b3po:4U\r^2i/&$\bn\u00144gg\u0016$\bFA'?\u0011\u0015\t\u0006\u0001\"\u0001*\u0003\u0005\"Xm\u001d;DC:\u0004Vo\u001d5e_^tg)\u001a;dQ^KG\u000f[8vi>3gm]3uQ\t\u0001f\bC\u0003U\u0001\u0011\u0005\u0011&\u0001\u0010uKN$8)\u00198o_R\u0004Vo\u001d5E_^tw+\u001b;i_V$H*[7ji\"\u00121K\u0010\u0005\u0006/\u0002!\t!K\u0001\u001fi\u0016\u001cHoQ1o]>$\b+^:i\t><hnV5uQ>,HOR3uG\"D#A\u0016 \t\u000bi\u0003A\u0011A\u0015\u0002;Q,7\u000f^\"b]:|G\u000fU;tQ\u0012{wO\\,ji\"|%\u000fZ3s\u0005fD#!\u0017 ")
public class PushLimitIntoLegacyTableSourceScanRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    public BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().buildBatchProgram(FlinkBatchProgram$.MODULE$.DEFAULT_REWRITE());
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.util().tableEnv().getConfig());
        ((FlinkChainedProgram)calciteConfig.getBatchProgram().get()).addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_COLLECTION()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{PushLimitIntoLegacyTableSourceScanRule$.MODULE$.INSTANCE(), CoreRules.SORT_PROJECT_TRANSPOSE, FlinkLogicalSort$.MODULE$.BATCH_CONVERTER(), FlinkLogicalLegacyTableSourceScan$.MODULE$.CONVERTER()})).build());
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE LimitTable (\n         |  a int,\n         |  b bigint,\n         |  c string\n         |) WITH (\n         |  'connector.type' = 'TestLimitableTableSource',\n         |  'is-bounded' = 'true'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
    }

    @Test
    public void testLimitWithNegativeOffset() {
        Assertions.assertThatExceptionOfType(SqlParserException.class).isThrownBy(() -> this.util().verifyRelPlan("SELECT a, c FROM LimitTable LIMIT 10 OFFSET -1"));
    }

    @Test
    public void testNegativeLimitWithoutOffset() {
        Assertions.assertThatExceptionOfType(SqlParserException.class).isThrownBy(() -> this.util().verifyRelPlan("SELECT a, c FROM LimitTable LIMIT -1"));
    }

    @Test
    public void testMysqlLimit() {
        Assertions.assertThatExceptionOfType(SqlParserException.class).isThrownBy(() -> this.util().verifyRelPlan("SELECT a, c FROM LimitTable LIMIT 1, 10"));
    }

    @Test
    public void testCanPushdownLimitWithoutOffset() {
        this.util().verifyRelPlan("SELECT a, c FROM LimitTable LIMIT 5");
    }

    @Test
    public void testCanPushdownLimitWithOffset() {
        this.util().verifyRelPlan("SELECT a, c FROM LimitTable LIMIT 10 OFFSET 1");
    }

    @Test
    public void testCanPushdownFetchWithOffset() {
        this.util().verifyRelPlan("SELECT a, c FROM LimitTable OFFSET 10 ROWS FETCH NEXT 10 ROWS ONLY");
    }

    @Test
    public void testCanPushdownFetchWithoutOffset() {
        this.util().verifyRelPlan("SELECT a, c FROM LimitTable FETCH FIRST 10 ROWS ONLY");
    }

    @Test
    public void testCannotPushDownWithoutLimit() {
        this.util().verifyRelPlan("SELECT a, c FROM LimitTable OFFSET 10");
    }

    @Test
    public void testCannotPushDownWithoutFetch() {
        this.util().verifyRelPlan("SELECT a, c FROM LimitTable OFFSET 10 ROWS");
    }

    @Test
    public void testCannotPushDownWithOrderBy() {
        String sqlQuery = "SELECT a, c FROM LimitTable ORDER BY c LIMIT 10";
        this.util().verifyRelPlan(sqlQuery);
    }
}

