/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.utils.ResolvedExpressionMock;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.PushPartitionIntoLegacyTableSourceScanRule$;
import org.apache.flink.table.planner.plan.rules.logical.PushPartitionIntoLegacyTableSourceScanRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TestPartitionableSourceFactory$;
import org.apache.flink.table.types.DataType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.reflect.ScalaSignature;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0001\u0003\u0001M\u0011a\u0006U;tQB\u000b'\u000f^5uS>t\u0017J\u001c;p\u0019\u0016<\u0017mY=UC\ndWmU8ve\u000e,7kY1o%VdW\rV3ti*\u00111\u0001B\u0001\bY><\u0017nY1m\u0015\t)a!A\u0003sk2,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/!\tQ!\u001e;jYNL!!\u0007\f\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011!Y\u0002A!b\u0001\n\u0003a\u0012!F:pkJ\u001cWMR3uG\"\u0004\u0016M\u001d;ji&|gn]\u000b\u0002;A\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t9!i\\8mK\u0006t\u0007\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002-M|WO]2f\r\u0016$8\r\u001b)beRLG/[8og\u0002B\u0001B\n\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u0011kN,7)\u0019;bY><g)\u001b7uKJD\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!H\u0001\u0012kN,7)\u0019;bY><g)\u001b7uKJ\u0004\u0003\"\u0002\u0016\u0001\t\u0003Y\u0013A\u0002\u001fj]&$h\bF\u0002-]=\u0002\"!\f\u0001\u000e\u0003\tAQaG\u0015A\u0002uAQAJ\u0015A\u0002uAq!\r\u0001C\u0002\u0013E!'\u0001\u0003vi&dW#A\u001a\u0011\u0005U!\u0014BA\u001b\u0017\u0005I\u0011\u0015\r^2i)\u0006\u0014G.\u001a+fgR,F/\u001b7\t\r]\u0002\u0001\u0015!\u00034\u0003\u0015)H/\u001b7!\u0011\u0015I\u0004\u0001\"\u0001;\u0003\u0015\u0019X\r^;q)\u0005Y\u0004C\u0001\u0010=\u0013\titD\u0001\u0003V]&$\bF\u0001\u001d@!\t\u0001u)D\u0001B\u0015\t\u00115)A\u0002ba&T!\u0001R#\u0002\u000f),\b/\u001b;fe*\u0011a\tE\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0011\u0006\u0013!BQ3g_J,W)Y2iQ\rA$*\u0017\t\u0004=-k\u0015B\u0001' \u0005\u0019!\bN]8xgB\u0011aJ\u0016\b\u0003\u001fRs!\u0001U*\u000e\u0003ES!A\u0015\n\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0013BA+ \u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0016-\u0003\u0013\u0015C8-\u001a9uS>t'BA+ G\u0005i\u0005\"B.\u0001\t\u0003Q\u0014!\b;fgRtu\u000eU1si&$\u0018n\u001c8GS\u0016dG\r\u0015:fI&\u001c\u0017\r^3)\u0005ik\u0006C\u0001!_\u0013\ty\u0016I\u0001\u0007UKN$H+Z7qY\u0006$X\rC\u0003b\u0001\u0011\u0005!(\u0001\u0018uKN$hj\u001c)beRLG/[8o\r&,G\u000e\u001a)sK\u0012L7-\u0019;f/&$\bNV5siV\fGnQ8mk6t\u0007F\u00011^\u0011\u0015!\u0007\u0001\"\u0001;\u0003\u0001\"Xm\u001d;P]2L\b+\u0019:uSRLwN\u001c$jK2$\u0007K]3eS\u000e\fG/Z\u0019)\u0005\rl\u0006\"B4\u0001\t\u0003Q\u0014!\r;fgR|e\u000e\\=QCJ$\u0018\u000e^5p]\u001aKW\r\u001c3Qe\u0016$\u0017nY1uKF:\u0016\u000e\u001e5WSJ$X/\u00197D_2,XN\u001c\u0015\u0003MvCQA\u001b\u0001\u0005\u0002i\n\u0001\u0005^3ti>sG.\u001f)beRLG/[8o\r&,G\u000e\u001a)sK\u0012L7-\u0019;fe!\u0012\u0011.\u0018\u0005\u0006[\u0002!\tAO\u00012i\u0016\u001cHo\u00148msB\u000b'\u000f^5uS>tg)[3mIB\u0013X\rZ5dCR,'gV5uQZK'\u000f^;bY\u000e{G.^7oQ\taW\fC\u0003q\u0001\u0011\u0005!(\u0001\u0011uKN$xJ\u001c7z!\u0006\u0014H/\u001b;j_:4\u0015.\u001a7e!J,G-[2bi\u0016\u001c\u0004FA8^\u0011\u0015\u0019\b\u0001\"\u0001;\u0003E\"Xm\u001d;P]2L\b+\u0019:uSRLwN\u001c$jK2$\u0007K]3eS\u000e\fG/Z\u001aXSRDg+\u001b:uk\u0006d7i\u001c7v[:D#A]/\t\u000bY\u0004A\u0011\u0001\u001e\u0002AQ,7\u000f^(oYf\u0004\u0016M\u001d;ji&|gNR5fY\u0012\u0004&/\u001a3jG\u0006$X\r\u000e\u0015\u0003kvCQ!\u001f\u0001\u0005\u0002i\n\u0011\u0007^3ti>sG.\u001f)beRLG/[8o\r&,G\u000e\u001a)sK\u0012L7-\u0019;fi]KG\u000f\u001b,jeR,\u0018\r\\\"pYVlg\u000e\u000b\u0002y;\")A\u0010\u0001C\u0001u\u0005aC/Z:u!\u0006\u0014H/\u001b;j_:4\u0015.\u001a7e!J,G-[2bi\u0016\fe\u000eZ(uQ\u0016\u0014\bK]3eS\u000e\fG/\u001a\u0015\u0003wvCQa \u0001\u0005\u0002i\nQ\b^3tiB\u000b'\u000f^5uS>tg)[3mIB\u0013X\rZ5dCR,\u0017I\u001c3Pi\",'\u000f\u0015:fI&\u001c\u0017\r^3XSRDg+\u001b:uk\u0006d7i\u001c7v[:D#A`/\t\r\u0005\u0015\u0001\u0001\"\u0001;\u0003-\"Xm\u001d;QCJ$\u0018\u000e^5p]\u001aKW\r\u001c3Qe\u0016$\u0017nY1uK>\u0013x\n\u001e5feB\u0013X\rZ5dCR,\u0007fAA\u0002;\"1\u00111\u0002\u0001\u0005\u0002i\nA\b^3tiB\u000b'\u000f^5uS>tg)[3mIB\u0013X\rZ5dCR,wJ](uQ\u0016\u0014\bK]3eS\u000e\fG/Z,ji\"4\u0016N\u001d;vC2\u001cu\u000e\\;n]\"\u001a\u0011\u0011B/\t\r\u0005E\u0001\u0001\"\u0001;\u0003)\"Xm\u001d;QCJ$\u0018.\u00197QCJ$\u0018\u000e^5p]\u001aKW\r\u001c3Qe\u0016$\u0017nY1uKB+8\u000f\u001b#po:D3!a\u0004^\u0011\u0019\t9\u0002\u0001C\u0001u\u0005YD/Z:u!\u0006\u0014H/[1m!\u0006\u0014H/\u001b;j_:4\u0015.\u001a7e!J,G-[2bi\u0016\u0004Vo\u001d5E_^tw+\u001b;i-&\u0014H/^1m\u0007>dW/\u001c8)\u0007\u0005UQ\f\u0003\u0004\u0002\u001e\u0001!\tAO\u0001\fi\u0016\u001cHoV5uQV#g\rK\u0002\u0002\u001cuCa!a\t\u0001\t\u0003Q\u0014a\u0007;fgR<\u0016\u000e\u001e5VI\u001a\fe\u000e\u001a,jeR,\u0018\r\\\"pYVlg\u000eK\u0002\u0002\"uCs\u0001AA\u0015\u0003k\t9\u0004\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r\ty#Q\u0001\nKb$XM\\:j_:LA!a\r\u0002.\tQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5\u0002\u000bY\fG.^3-\u0005\u0005e2EAA\u001e!\u0011\ti$!\u0014\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\nQ\u0002]1sC6,G/\u001a:ju\u0016$'\u0002BA#\u0003\u000f\n!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\r1\u0015\u0011\n\u0006\u0004\u0003\u0017b\u0011!\u0003;fgR,H/\u001b7t\u0013\u0011\ty%a\u0010\u00035A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8\b\u000f\u0005M#\u0001#\u0001\u0002V\u0005q\u0003+^:i!\u0006\u0014H/\u001b;j_:Le\u000e^8MK\u001e\f7-\u001f+bE2,7k\\;sG\u0016\u001c6-\u00198Sk2,G+Z:u!\ri\u0013q\u000b\u0004\u0007\u0003\tA\t!!\u0017\u0014\t\u0005]\u00131\f\t\u0004=\u0005u\u0013bAA0?\t1\u0011I\\=SK\u001aDqAKA,\t\u0003\t\u0019\u0007\u0006\u0002\u0002V!A\u0011qMA,\t\u0003\tI'\u0001\u0006qCJ\fW.\u001a;feN$\"!a\u001b\u0011\r\u00055\u0014QOA=\u001b\t\tyGC\u00022\u0003cR!!a\u001d\u0002\t)\fg/Y\u0005\u0005\u0003o\nyG\u0001\u0006D_2dWm\u0019;j_:\u0004RAHA>\u0003\u007fJ1!!  \u0005\u0015\t%O]1z!\rq\u0012\u0011Q\u0005\u0004\u0003\u0007{\"aA!os\"B\u0011QMAD\u0003\u001b\u000by\t\u0005\u0003\u0002>\u0005%\u0015\u0002BAF\u0003\u007f\u0011!\u0002U1sC6,G/\u001a:t\u0003\u0011q\u0017-\\3\"\u0005\u0005E\u0015aL:pkJ\u001cWMR3uG\"\u0004\u0016M\u001d;ji&|gn]\u001f|aud\u0003%^:f\u0007\u0006$\u0018\r\\8h\r&dG/\u001a:>wFj\b")
public class PushPartitionIntoLegacyTableSourceScanRuleTest
extends TableTestBase {
    private final boolean sourceFetchPartitions;
    private final boolean useCatalogFilter;
    private final BatchTableTestUtil util;

    @Parameters(name="sourceFetchPartitions={0}, useCatalogFilter={1}")
    public static Collection<Object[]> parameters() {
        return PushPartitionIntoLegacyTableSourceScanRuleTest$.MODULE$.parameters();
    }

    public boolean sourceFetchPartitions() {
        return this.sourceFetchPartitions;
    }

    public boolean useCatalogFilter() {
        return this.useCatalogFilter;
    }

    public BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() throws Exception {
        this.util().buildBatchProgram(FlinkBatchProgram$.MODULE$.DEFAULT_REWRITE());
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.util().tableEnv().getConfig());
        ((FlinkChainedProgram)calciteConfig.getBatchProgram().get()).addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_COLLECTION()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{PushPartitionIntoLegacyTableSourceScanRule$.MODULE$.INSTANCE(), CoreRules.FILTER_PROJECT_TRANSPOSE})).build());
        Schema tableSchema = Schema.newBuilder().fromResolvedSchema(ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.INT()), Column.physical((String)"name", (DataType)DataTypes.STRING()), Column.physical((String)"part1", (DataType)DataTypes.STRING()), Column.physical((String)"part2", (DataType)DataTypes.INT())})).build();
        Schema tableSchema2 = Schema.newBuilder().fromResolvedSchema(ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.INT()), Column.physical((String)"name", (DataType)DataTypes.STRING()), Column.physical((String)"part1", (DataType)DataTypes.STRING()), Column.physical((String)"part2", (DataType)DataTypes.INT()), Column.computed((String)"virtualField", (ResolvedExpression)ResolvedExpressionMock.of((DataType)DataTypes.INT(), (String)"`part2` + 1"))})).build();
        TableEnvironment x$1 = this.util().tableEnv();
        String x$2 = "MyTable";
        Schema x$3 = tableSchema;
        boolean x$4 = true;
        List<Map<String, String>> x$5 = TestPartitionableSourceFactory$.MODULE$.createTemporaryTable$default$5();
        boolean x$6 = TestPartitionableSourceFactory$.MODULE$.createTemporaryTable$default$6();
        TestPartitionableSourceFactory$.MODULE$.createTemporaryTable(x$1, x$2, x$4, x$3, x$5, x$6);
        TableEnvironment x$7 = this.util().tableEnv();
        String x$8 = "VirtualTable";
        Schema x$9 = tableSchema2;
        boolean x$10 = true;
        List<Map<String, String>> x$11 = TestPartitionableSourceFactory$.MODULE$.createTemporaryTable$default$5();
        boolean x$12 = TestPartitionableSourceFactory$.MODULE$.createTemporaryTable$default$6();
        TestPartitionableSourceFactory$.MODULE$.createTemporaryTable(x$7, x$8, x$10, x$9, x$11, x$12);
    }

    @TestTemplate
    public void testNoPartitionFieldPredicate() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE id > 2");
    }

    @TestTemplate
    public void testNoPartitionFieldPredicateWithVirtualColumn() {
        this.util().verifyRelPlan("SELECT * FROM VirtualTable WHERE id > 2");
    }

    @TestTemplate
    public void testOnlyPartitionFieldPredicate1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE part1 = 'A'");
    }

    @TestTemplate
    public void testOnlyPartitionFieldPredicate1WithVirtualColumn() {
        this.util().verifyRelPlan("SELECT * FROM VirtualTable WHERE part1 = 'A'");
    }

    @TestTemplate
    public void testOnlyPartitionFieldPredicate2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE part2 > 1");
    }

    @TestTemplate
    public void testOnlyPartitionFieldPredicate2WithVirtualColumn() {
        this.util().verifyRelPlan("SELECT * FROM VirtualTable WHERE part2 > 1");
    }

    @TestTemplate
    public void testOnlyPartitionFieldPredicate3() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE part1 = 'A' AND part2 > 1");
    }

    @TestTemplate
    public void testOnlyPartitionFieldPredicate3WithVirtualColumn() {
        this.util().verifyRelPlan("SELECT * FROM VirtualTable WHERE part1 = 'A' AND part2 > 1");
    }

    @TestTemplate
    public void testOnlyPartitionFieldPredicate4() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE part1 = 'A' OR part2 > 1");
    }

    @TestTemplate
    public void testOnlyPartitionFieldPredicate4WithVirtualColumn() {
        this.util().verifyRelPlan("SELECT * FROM VirtualTable WHERE part1 = 'A' OR part2 > 1");
    }

    @TestTemplate
    public void testPartitionFieldPredicateAndOtherPredicate() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE id > 2 AND part1 = 'A'");
    }

    @TestTemplate
    public void testPartitionFieldPredicateAndOtherPredicateWithVirtualColumn() {
        this.util().verifyRelPlan("SELECT * FROM VirtualTable WHERE id > 2 AND part1 = 'A'");
    }

    @TestTemplate
    public void testPartitionFieldPredicateOrOtherPredicate() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE id > 2 OR part1 = 'A'");
    }

    @TestTemplate
    public void testPartitionFieldPredicateOrOtherPredicateWithVirtualColumn() {
        this.util().verifyRelPlan("SELECT * FROM VirtualTable WHERE id > 2 OR part1 = 'A'");
    }

    @TestTemplate
    public void testPartialPartitionFieldPredicatePushDown() {
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE (id > 2 OR part1 = 'A') AND part2 > 1");
    }

    @TestTemplate
    public void testPartialPartitionFieldPredicatePushDownWithVirtualColumn() {
        this.util().verifyRelPlan("SELECT * FROM VirtualTable WHERE (id > 2 OR part1 = 'A') AND part2 > 1");
    }

    @TestTemplate
    public void testWithUdf() {
        this.util().addTemporarySystemFunction("MyUdf", (UserDefinedFunction)Func1$.MODULE$);
        this.util().verifyRelPlan("SELECT * FROM MyTable WHERE id > 2 AND MyUdf(part2) < 3");
    }

    @TestTemplate
    public void testWithUdfAndVirtualColumn() {
        this.util().addTemporarySystemFunction("MyUdf", (UserDefinedFunction)Func1$.MODULE$);
        this.util().verifyRelPlan("SELECT * FROM VirtualTable WHERE id > 2 AND MyUdf(part2) < 3");
    }

    public PushPartitionIntoLegacyTableSourceScanRuleTest(boolean sourceFetchPartitions, boolean useCatalogFilter) {
        this.sourceFetchPartitions = sourceFetchPartitions;
        this.useCatalogFilter = useCatalogFilter;
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

