/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE;
import org.apache.flink.table.planner.plan.rules.logical.PushPartitionIntoLegacyTableSourceScanRuleTest;
import org.apache.flink.table.planner.plan.rules.logical.PushPartitionIntoTableSourceScanRule;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

class PushPartitionIntoTableSourceScanRuleTest
extends PushPartitionIntoLegacyTableSourceScanRuleTest {
    PushPartitionIntoTableSourceScanRuleTest(boolean sourceFetchPartitions, boolean useFilter) {
        super(sourceFetchPartitions, useFilter);
    }

    @Override
    @BeforeEach
    public void setup() throws Exception {
        this.util().buildBatchProgram(FlinkBatchProgram.DEFAULT_REWRITE());
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.util().tableEnv().getConfig());
        ((FlinkChainedProgram)calciteConfig.getBatchProgram().get()).addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_PROJECT_TRANSPOSE, PushPartitionIntoTableSourceScanRule.INSTANCE})).build());
        String ddlTemp = "CREATE TABLE MyTable (\n  id int,\n  name string,\n  part1 string,\n  part2 int)\n  partitioned by (part1, part2)\n  WITH (\n 'connector' = 'values',\n 'bounded' = 'true',\n 'partition-list' = '%s')";
        String ddlTempWithVirtualColumn = "CREATE TABLE VirtualTable (\n  id int,\n  name string,\n  part1 string,\n  part2 int,\n  virtualField AS part2 + 1)\n  partitioned by (part1, part2)\n  WITH (\n 'connector' = 'values',\n 'bounded' = 'true',\n 'partition-list' = '%s')";
        if (this.sourceFetchPartitions()) {
            String partitionString = "part1:A,part2:1;part1:A,part2:2;part1:B,part2:3;part1:C,part2:1";
            this.util().tableEnv().executeSql(String.format(ddlTemp, partitionString));
            this.util().tableEnv().executeSql(String.format(ddlTempWithVirtualColumn, partitionString));
        } else {
            TestValuesCatalog catalog = new TestValuesCatalog("test_catalog", "test_database", this.useCatalogFilter());
            this.util().tableEnv().registerCatalog("test_catalog", (Catalog)catalog);
            this.util().tableEnv().useCatalog("test_catalog");
            this.util().tableEnv().executeSql(String.format(ddlTemp, ""));
            this.util().tableEnv().executeSql(String.format(ddlTempWithVirtualColumn, ""));
            ObjectPath mytablePath = ObjectPath.fromString((String)"test_database.MyTable");
            ObjectPath virtualTablePath = ObjectPath.fromString((String)"test_database.VirtualTable");
            List<Map> partitions = Arrays.asList(new HashMap<String, String>(){
                {
                    this.put("part1", "A");
                    this.put("part2", "1");
                }
            }, new HashMap<String, String>(){
                {
                    this.put("part1", "A");
                    this.put("part2", "2");
                }
            }, new HashMap<String, String>(){
                {
                    this.put("part1", "B");
                    this.put("part2", "3");
                }
            }, new HashMap<String, String>(){
                {
                    this.put("part1", "C");
                    this.put("part2", "1");
                }
            });
            for (Map partition : partitions) {
                CatalogPartitionSpec catalogPartitionSpec = new CatalogPartitionSpec(partition);
                CatalogPartitionImpl catalogPartition = new CatalogPartitionImpl(new HashMap(), "");
                catalog.createPartition(mytablePath, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
                catalog.createPartition(virtualTablePath, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
            }
        }
    }

    @TestTemplate
    void testUnconvertedExpression() {
        String sql = "select * from MyTable where trim(part1) = 'A' and part2 > 1";
        this.util().verifyRelPlan(sql);
    }
}

