/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.expressions.utils.Func0$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.PushProjectIntoLegacyTableSourceScanRule$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TestNestedProjectableTableSource;
import org.apache.flink.table.planner.utils.TestNestedProjectableTableSource$;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0001\u0002\u0001'\ta\u0003+^:i!J|'.Z2u\u0013:$x\u000eT3hC\u000eLH+\u00192mKN{WO]2f'\u000e\fgNU;mKR+7\u000f\u001e\u0006\u0003\u0007\u0011\tq\u0001\\8hS\u000e\fGN\u0003\u0002\u0006\r\u0005)!/\u001e7fg*\u0011q\u0001C\u0001\u0005a2\fgN\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0005\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!9\u0001\u0005\u0001b\u0001\n#\t\u0013\u0001B;uS2,\u0012A\t\t\u0003+\rJ!\u0001\n\f\u0003%\t\u000bGo\u00195UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007M\u0001\u0001\u000b\u0011\u0002\u0012\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b!\u0002A\u0011A\u0015\u0002\u000bM,G/\u001e9\u0015\u0003)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012A!\u00168ji\"\u0012q%\r\t\u0003eej\u0011a\r\u0006\u0003iU\n1!\u00199j\u0015\t1t'A\u0004kkBLG/\u001a:\u000b\u0005a\u0002\u0012!\u00026v]&$\u0018B\u0001\u001e4\u0005)\u0011UMZ8sK\u0016\u000b7\r\u001b\u0005\u0006y\u0001!\t!K\u0001\u0012i\u0016\u001cHoU5na2,\u0007K]8kK\u000e$\bFA\u001e?!\t\u0011t(\u0003\u0002Ag\t!A+Z:u\u0011\u0015\u0011\u0005\u0001\"\u0001*\u0003\t\"Xm\u001d;TS6\u0004H.\u001a)s_*,7\r^,ji\"4\u0016N\u001d;vC2\u001cu\u000e\\;n]\"\u0012\u0011I\u0010\u0005\u0006\u000b\u0002!\t!K\u0001\u0012i\u0016\u001cHoQ1o]>$\bK]8kK\u000e$\bF\u0001#?\u0011\u0015A\u0005\u0001\"\u0001*\u0003\t\"Xm\u001d;DC:tw\u000e\u001e)s_*,7\r^,ji\"4\u0016N\u001d;vC2\u001cu\u000e\\;n]\"\u0012qI\u0010\u0005\u0006\u0017\u0002!\t!K\u0001\u0013i\u0016\u001cH\u000f\u0015:pU\u0016\u001cGoV5uQV#g\r\u000b\u0002K}!)a\n\u0001C\u0001S\u0005\u0019C/Z:u!J|'.Z2u/&$\b.\u00163g/&$\bNV5siV\fGnQ8mk6t\u0007FA'?\u0011\u0015\t\u0006\u0001\"\u0001*\u0003i!Xm\u001d;Qe>TWm\u0019;XSRDw.\u001e;J]B,HOU3gQ\t\u0001f\bC\u0003U\u0001\u0011\u0005\u0011&A\tuKN$h*Z:uK\u0012\u0004&o\u001c6fGRD#a\u0015 ")
public class PushProjectIntoLegacyTableSourceScanRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    public BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().buildBatchProgram(FlinkBatchProgram$.MODULE$.DEFAULT_REWRITE());
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.util().tableEnv().getConfig());
        ((FlinkChainedProgram)calciteConfig.getBatchProgram().get()).addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{PushProjectIntoLegacyTableSourceScanRule$.MODULE$.INSTANCE()})).build());
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE MyTable (\n         |  a int,\n         |  b bigint,\n         |  c string\n         |) WITH (\n         |  'connector.type' = 'TestProjectableSource',\n         |  'is-bounded' = 'true'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl1);
        String ddl2 = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE VirtualTable (\n         |  a int,\n         |  b bigint,\n         |  c string,\n         |  d as a + 1\n         |) WITH (\n         |  'connector.type' = 'TestProjectableSource',\n         |  'is-bounded' = 'true'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl2);
    }

    @Test
    public void testSimpleProject() {
        this.util().verifyRelPlan("SELECT a, c FROM MyTable");
    }

    @Test
    public void testSimpleProjectWithVirtualColumn() {
        this.util().verifyRelPlan("SELECT a, d FROM VirtualTable");
    }

    @Test
    public void testCannotProject() {
        this.util().verifyRelPlan("SELECT a, c, b + 1 FROM MyTable");
    }

    @Test
    public void testCannotProjectWithVirtualColumn() {
        this.util().verifyRelPlan("SELECT a, c, d, b + 1 FROM VirtualTable");
    }

    @Test
    public void testProjectWithUdf() {
        this.util().verifyRelPlan("SELECT a, TRIM(c) FROM MyTable");
    }

    @Test
    public void testProjectWithUdfWithVirtualColumn() {
        this.util().addTemporarySystemFunction("my_udf", (UserDefinedFunction)Func0$.MODULE$);
        this.util().verifyRelPlan("SELECT a, my_udf(d) FROM VirtualTable");
    }

    @Test
    public void testProjectWithoutInputRef() {
        this.util().verifyRelPlan("SELECT COUNT(1) FROM MyTable");
    }

    @Test
    public void testNestedProject() {
        RowTypeInfo nested1 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.INT()}), (String[])((Object[])new String[]{"name", "value"}));
        RowTypeInfo nested2 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.BOOLEAN()}), (String[])((Object[])new String[]{"num", "flag"}));
        RowTypeInfo deepNested = new RowTypeInfo((TypeInformation[])new RowTypeInfo[]{nested1, nested2}, (String[])((Object[])new String[]{"nested1", "nested2"}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), deepNested, nested1, Types.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), deepNested, nested1, Types.STRING()}), (String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSourceInternal("T", (TableSource)new TestNestedProjectableTableSource(true, tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$5(), TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id,\n        |    deepNested.nested1.name AS nestedName,\n        |    nested.`value` AS nestedValue,\n        |    deepNested.nested2.flag AS nestedFlag,\n        |    deepNested.nested2.num AS nestedNum\n        |FROM T\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }
}

