/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.FlinkStreamProgram$;
import org.apache.flink.table.planner.plan.rules.logical.SplitAggregateRuleTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001'\t12\u000b\u001d7ji\u0006;wM]3hCR,'+\u001e7f)\u0016\u001cHO\u0003\u0002\u0004\t\u00059An\\4jG\u0006d'BA\u0003\u0007\u0003\u0015\u0011X\u000f\\3t\u0015\t9\u0001\"\u0001\u0003qY\u0006t'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003C\u0001\u0006kRLGn]\u0005\u00033Y\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\n\u0005\nA!\u001e;jYV\t!\u0005\u0005\u0002\u0016G%\u0011AE\u0006\u0002\u0014'R\u0014X-Y7UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007M\u0001\u0001\u000b\u0011\u0002\u0012\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b!\u0002A\u0011A\u0015\u0002+Q,7\u000f^*j]\u001edW\rR5ti&t7\r^!hOR\t!\u0006\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0003V]&$\bFA\u00142!\t\u0011\u0014(D\u00014\u0015\t!T'A\u0002ba&T!AN\u001c\u0002\u000f),\b/\u001b;fe*\u0011\u0001\bE\u0001\u0006UVt\u0017\u000e^\u0005\u0003uM\u0012A\u0001V3ti\")A\b\u0001C\u0001S\u0005\u0001B/Z:u'&tw\r\\3NS:\fum\u001a\u0015\u0003wEBQa\u0010\u0001\u0005\u0002%\nq\u0003^3tiNKgn\u001a7f\r&\u00148\u000f\u001e,bYV,\u0017iZ4)\u0005y\n\u0004\"\u0002\"\u0001\t\u0003I\u0013!\u0006;fgRlU\u000f\u001c;j\t&\u001cH/\u001b8di\u0006;wm\u001d\u0015\u0003\u0003FBQ!\u0012\u0001\u0005\u0002%\nA\u0004^3tiNKgn\u001a7f\u001b\u0006Dx+\u001b;i\t&\u001cH/\u001b8di\u0006;w\r\u000b\u0002Ec!)\u0001\n\u0001C\u0001S\u0005\u0019C/Z:u'&tw\r\\3GSJ\u001cHOV1mk\u0016<\u0016\u000e\u001e5ESN$\u0018N\\2u\u0003\u001e<\u0007FA$2\u0011\u0015Y\u0005\u0001\"\u0001*\u0003\t\"Xm\u001d;TS:<G.\u001a'bgR4\u0016\r\\;f/&$\b\u000eR5ti&t7\r^!hO\"\u0012!*\r\u0005\u0006\u001d\u0002!\t!K\u0001!i\u0016\u001cHoU5oO2,G*[:u\u0003\u001e<w+\u001b;i\t&\u001cH/\u001b8di\u0006;w\r\u000b\u0002Nc!)\u0011\u000b\u0001C\u0001S\u0005QC/Z:u'&tw\r\\3ESN$\u0018N\\2u\u0003\u001e<w+\u001b;i\u00032dgj\u001c8ESN$\u0018N\\2u\u0003\u001e<\u0007F\u0001)2\u0011\u0015!\u0006\u0001\"\u0001*\u0003\u0001\"Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;BO\u001e<\u0016\u000e\u001e5He>,\bOQ=)\u0005M\u000b\u0004\"B,\u0001\t\u0003I\u0013A\u000e;fgR\u001c\u0016N\\4mK\u0012K7\u000f^5oGR\fumZ,ji\"\fe\u000e\u001a(p]\u0012K7\u000f^5oGR\fumZ(o'\u0006lWmQ8mk6t\u0007F\u0001,2\u0011\u0015Q\u0006\u0001\"\u0001*\u0003)\"Xm\u001d;T_6,7i\u001c7v[:\u001c(i\u001c;i\u0013:$\u0015n\u001d;j]\u000e$\u0018iZ4B]\u0012<%o\\;q\u0005fD#!W\u0019\t\u000bu\u0003A\u0011A\u0015\u0002/Q,7\u000f^!hO^KG\u000f\u001b$jYR,'o\u00117bkN,\u0007F\u0001/2\u0011\u0015\u0001\u0007\u0001\"\u0001*\u0003E!Xm\u001d;Nk2$\u0018n\u0012:pkB\u0014\u0015p\u001d\u0015\u0003?FBQa\u0019\u0001\u0005\u0002%\nq\u0002^3ti\u0006;wmV5uQ*{\u0017N\u001c\u0015\u0003EFBQA\u001a\u0001\u0005\u0002%\n\u0001\u0004^3ti\n+8m[3ug\u000e{gNZ5hkJ\fG/[8oQ\t)\u0017\u0007C\u0003j\u0001\u0011\u0005\u0011&A\u0012uKN$X*\u001e7uSBdW\rR5ti&t7\r^!hO>s7+Y7f\u0007>dW/\u001c8)\u0005!\f\u0004\"\u00027\u0001\t\u0003I\u0013A\n;fgR\fum\u001a$jYR,'o\u00117bkN,'i\u001c;i/&$\b.\u0011<h\u0003:$7i\\;oi\"\u00121.\r")
public class SplitAggregateRuleTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testSingleDistinctAgg() {
        this.util().verifyRelPlan("SELECT COUNT(DISTINCT c) FROM MyTable");
    }

    @Test
    public void testSingleMinAgg() {
        this.util().verifyRelPlan("SELECT MIN(c) FROM MyTable");
    }

    @Test
    public void testSingleFirstValueAgg() {
        this.util().verifyRelPlan("SELECT FIRST_VALUE(c) FROM MyTable GROUP BY a");
    }

    @Test
    public void testMultiDistinctAggs() {
        this.util().verifyRelPlan("SELECT COUNT(DISTINCT a), SUM(DISTINCT b) FROM MyTable");
    }

    @Test
    public void testSingleMaxWithDistinctAgg() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, COUNT(DISTINCT b), MAX(c)\n        |FROM MyTable\n        |GROUP BY a\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSingleFirstValueWithDistinctAgg() {
        this.util().verifyRelPlan("SELECT a, FIRST_VALUE(c), COUNT(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSingleLastValueWithDistinctAgg() {
        this.util().verifyRelPlan("SELECT a, LAST_VALUE(c), COUNT(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSingleListAggWithDistinctAgg() {
        this.util().verifyRelPlan("SELECT a, LISTAGG(c), COUNT(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSingleDistinctAggWithAllNonDistinctAgg() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, COUNT(DISTINCT c), SUM(b), AVG(b), MAX(b), MIN(b), COUNT(b), COUNT(*)\n        |FROM MyTable\n        |GROUP BY a\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSingleDistinctAggWithGroupBy() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT c) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSingleDistinctAggWithAndNonDistinctAggOnSameColumn() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT b), SUM(b), AVG(b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSomeColumnsBothInDistinctAggAndGroupBy() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT a), COUNT(b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testAggWithFilterClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  a,\n         |  COUNT(DISTINCT b) FILTER (WHERE NOT b = 2),\n         |  SUM(b) FILTER (WHERE NOT b = 5),\n         |  SUM(b) FILTER (WHERE NOT b = 2)\n         |FROM MyTable\n         |GROUP BY a\n       ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiGroupBys() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  c, MIN(b), MAX(b), SUM(b), COUNT(*), COUNT(DISTINCT a)\n         |FROM(\n         |  SELECT\n         |    a, AVG(b) as b, MAX(c) as c\n         |  FROM MyTable\n         |  GROUP BY a\n         |) GROUP BY c\n       ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testAggWithJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM(\n         |  SELECT\n         |    c, SUM(b) as b, SUM(b) as d, COUNT(DISTINCT a) as a\n         |  FROM(\n         |    SELECT\n         |      a, COUNT(DISTINCT b) as b, SUM(b) as c, SUM(b) as d\n         |    FROM MyTable\n         |    GROUP BY a)\n         |  GROUP BY c\n         |) as MyTable1 JOIN MyTable ON MyTable1.b = MyTable.a\n       ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testBucketsConfiguration() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_BUCKET_NUM, (Object)100);
        String sqlQuery = "SELECT COUNT(DISTINCT c) FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultipleDistinctAggOnSameColumn() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  a,\n         |  COUNT(DISTINCT b),\n         |  COUNT(DISTINCT b) FILTER(WHERE b <> 5),\n         |  SUM(b),\n         |  AVG(b)\n         |FROM MyTable\n         |GROUP BY a\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testAggFilterClauseBothWithAvgAndCount() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  a,\n         |  COUNT(DISTINCT b) FILTER (WHERE NOT b = 2),\n         |  SUM(b) FILTER (WHERE NOT b = 5),\n         |  COUNT(b),\n         |  AVG(b),\n         |  SUM(b)\n         |FROM MyTable\n         |GROUP BY a\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    public SplitAggregateRuleTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.SplitAggregateRuleTest$$anon$2 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().buildStreamProgram(FlinkStreamProgram$.MODULE$.PHYSICAL());
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }
}

