/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkStreamProgram$;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.optimize.program.StreamOptimizeContext;
import org.apache.flink.table.planner.plan.rules.logical.CalcRankTransposeRule$;
import org.apache.flink.table.planner.plan.rules.logical.CalcSnapshotTransposeRule$;
import org.apache.flink.table.planner.plan.rules.logical.ConstantRankNumberColumnRemoveRule$;
import org.apache.flink.table.planner.plan.rules.logical.FlinkLogicalRankRule$;
import org.apache.flink.table.planner.plan.rules.logical.TemporalJoinRewriteWithUniqueKeyRule$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A3A!\u0001\u0002\u0001'\tAC+Z7q_J\fGNS8j]J+wO]5uK^KG\u000f[+oSF,XmS3z%VdW\rV3ti*\u00111\u0001B\u0001\bY><\u0017nY1m\u0015\t)a!A\u0003sk2,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/!\tQ!\u001e;jYNL!!\u0007\f\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0004!\u0001\t\u0007I\u0011C\u0011\u0002\tU$\u0018\u000e\\\u000b\u0002EA\u0011QcI\u0005\u0003IY\u00111c\u0015;sK\u0006lG+\u00192mKR+7\u000f^+uS2DaA\n\u0001!\u0002\u0013\u0011\u0013!B;uS2\u0004\u0003\"\u0002\u0015\u0001\t\u0003I\u0013!B:fiV\u0004H#\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0003OE\u0002\"AM\u001d\u000e\u0003MR!\u0001N\u001b\u0002\u0007\u0005\u0004\u0018N\u0003\u00027o\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001d\u0011\u0003\u0015QWO\\5u\u0013\tQ4G\u0001\u0006CK\u001a|'/Z#bG\"DQ\u0001\u0010\u0001\u0005\u0002%\nA\u0004^3tiB\u0013\u0018.\\1ss.+\u00170\u00138UK6\u0004xN]1m\u0015>Lg\u000e\u000b\u0002<}A\u0011!gP\u0005\u0003\u0001N\u0012A\u0001V3ti\")!\t\u0001C\u0001S\u0005!C/Z:u\u0013:4WM\u001d:fIB\u0013\u0018.\\1ss.+\u00170\u00138UK6\u0004xN]1m\u0015>Lg\u000e\u000b\u0002B}!)Q\t\u0001C\u0001S\u0005\u0011C/Z:u!JLW.\u0019:z\u0017\u0016L\u0018J\u001c+f[B|'/\u00197K_&twJ\u001c+sk\u0016D#\u0001\u0012 \t\u000b!\u0003A\u0011A\u0015\u0002GQ,7\u000f^%om\u0006d\u0017\u000e\u001a)sS6\f'/_&fs&sG+Z7q_J\fGNS8j]\"\u0012qI\u0010\u0005\u0006\u0017\u0002!\t!K\u0001,i\u0016\u001cH/\u00138wC2LG-\u00138gKJ\u0014X\r\u001a)sS6\f'/_&fs&sG+Z7q_J\fGNS8j]\"\u0012!J\u0010\u0005\u0006\u001d\u0002!\t!K\u0001+i\u0016\u001cH/\u00138gKJ\u0014X\r\u001a)sS6\f'/_&fs&sG+Z7q_J\fGNS8j]>sGK];fQ\tie\b")
public class TemporalJoinRewriteWithUniqueKeyRuleTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    public StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().buildStreamProgram(FlinkStreamProgram$.MODULE$.PHYSICAL());
        FlinkChainedProgram<StreamOptimizeContext> chainedProgram = this.util().getStreamProgram();
        chainedProgram.addLast("test_rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{FlinkLogicalRankRule$.MODULE$.INSTANCE(), CalcRankTransposeRule$.MODULE$.INSTANCE(), ConstantRankNumberColumnRemoveRule$.MODULE$.INSTANCE(), CalcSnapshotTransposeRule$.MODULE$.INSTANCE(), TemporalJoinRewriteWithUniqueKeyRule$.MODULE$.INSTANCE()})).build());
        this.util().replaceStreamProgram(chainedProgram);
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE T1 (\n                    | id STRING,\n                    | mount INT,\n                    | proctime as PROCTIME(),\n                    | rowtime TIMESTAMP(3),\n                    | WATERMARK FOR rowtime AS rowtime\n                    |) WITH (\n                    | 'connector' = 'COLLECTION',\n                    | 'is-bounded' = 'false'\n                    |)\n      ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE T2 (\n                    | id STRING,\n                    | rate INT,\n                    | rowtime TIMESTAMP(3),\n                    | WATERMARK FOR rowtime AS rowtime,\n                    | PRIMARY KEY(id) NOT ENFORCED\n                    |) WITH (\n                    | 'connector' = 'COLLECTION',\n                    | 'is-bounded' = 'false'\n                    |)\n      ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE T3 (\n                    | id STRING,\n                    | rate INT,\n                    | rowtime TIMESTAMP(3),\n                    | WATERMARK FOR rowtime AS rowtime\n                    |) WITH (\n                    | 'connector' = 'COLLECTION',\n                    | 'is-bounded' = 'false'\n                    |)\n      ")).stripMargin());
        this.util().addTable(" CREATE VIEW DeduplicatedView as SELECT id, rate, rowtime FROM   (SELECT *,           ROW_NUMBER() OVER (PARTITION BY id ORDER BY rowtime DESC) AS rowNum    FROM T3   ) T   WHERE rowNum = 1");
    }

    @Test
    public void testPrimaryKeyInTemporalJoin() {
        this.util().verifyRelPlan("SELECT * FROM T1 JOIN T2 FOR SYSTEM_TIME AS OF T1.rowtime AS T ON T1.id = T.id");
    }

    @Test
    public void testInferredPrimaryKeyInTemporalJoin() {
        this.util().verifyRelPlan("SELECT * FROM T1 JOIN DeduplicatedView FOR SYSTEM_TIME AS OF T1.rowtime AS T ON T1.id = T.id");
    }

    @Test
    public void testPrimaryKeyInTemporalJoinOnTrue() {
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan("SELECT * FROM T1 JOIN T2 FOR SYSTEM_TIME AS OF T1.rowtime AS T ON TRUE")).hasMessageContaining("Currently the join key in Temporal Table Join can not be empty.") instanceof ValidationException;
    }

    @Test
    public void testInvalidPrimaryKeyInTemporalJoin() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE noPkTable (\n                    | id STRING,\n                    | rate INT,\n                    | rowtime TIMESTAMP(3),\n                    | WATERMARK FOR rowtime AS rowtime\n                    |) WITH (\n                    | 'connector' = 'COLLECTION',\n                    | 'is-bounded' = 'false'\n                    |)\n      ")).stripMargin());
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan("SELECT * FROM T1 LEFT JOIN noPkTable FOR SYSTEM_TIME AS OF T1.rowtime AS T ON T1.id = T.id")).hasMessageContaining("Temporal Table Join requires primary key in versioned table, but no primary key can be found. The physical plan is:\nFlinkLogicalJoin(condition=[AND(=($0, $4), __INITIAL_TEMPORAL_JOIN_CONDITION($3, $6, __TEMPORAL_JOIN_LEFT_KEY($0), __TEMPORAL_JOIN_RIGHT_KEY($4)))], joinType=[left])") instanceof ValidationException;
    }

    @Test
    public void testInvalidInferredPrimaryKeyInTemporalJoin() {
        this.util().addTable(" CREATE VIEW noPkView as SELECT id, rate, rowtime FROM   (SELECT *,           ROW_NUMBER() OVER (PARTITION BY id ORDER BY rowtime DESC) AS rowNum    FROM T3   ) T   WHERE rowNum = 2");
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan("SELECT * FROM T1 JOIN noPkView FOR SYSTEM_TIME AS OF T1.rowtime AS T ON T1.id = T.id")).hasMessageContaining("Temporal Table Join requires primary key in versioned table, but no primary key can be found. The physical plan is:\nFlinkLogicalJoin(condition=[AND(=($0, $4), __INITIAL_TEMPORAL_JOIN_CONDITION($3, $6, __TEMPORAL_JOIN_LEFT_KEY($0), __TEMPORAL_JOIN_RIGHT_KEY($4)))], joinType=[inner])") instanceof ValidationException;
    }

    @Test
    public void testInferredPrimaryKeyInTemporalJoinOnTrue() {
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan("SELECT * FROM T1 JOIN DeduplicatedView FOR SYSTEM_TIME AS OF T1.rowtime AS T ON TRUE")).hasMessageContaining("Currently the join key in Temporal Table Join can not be empty.") instanceof ValidationException;
    }
}

