/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.rules.logical.WindowGroupReorderRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0001\u0002\u0001'\tQr+\u001b8e_^<%o\\;q%\u0016|'\u000fZ3s%VdW\rV3ti*\u00111\u0001B\u0001\bY><\u0017nY1m\u0015\t)a!A\u0003sk2,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/!\tQ!\u001e;jYNL!!\u0007\f\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0004!\u0001\t\u0007I\u0011B\u0011\u0002\tU$\u0018\u000e\\\u000b\u0002EA\u0011QcI\u0005\u0003IY\u0011!CQ1uG\"$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\"1a\u0005\u0001Q\u0001\n\t\nQ!\u001e;jY\u0002BQ\u0001\u000b\u0001\u0005\u0002%\nQa]3ukB$\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0005+:LG\u000f\u000b\u0002(cA\u0011!'O\u0007\u0002g)\u0011A'N\u0001\u0004CBL'B\u0001\u001c8\u0003\u001dQW\u000f]5uKJT!\u0001\u000f\t\u0002\u000b),h.\u001b;\n\u0005i\u001a$A\u0003\"fM>\u0014X-R1dQ\")A\b\u0001C\u0001S\u0005aC/Z:u'\u0006lW\rU1si&$\u0018n\u001c8LKf\u001cx+\u001b;i'\u0006lWm\u0014:eKJ\\U-_:Qe\u00164\u0017\u000e\u001f\u0015\u0003wy\u0002\"AM \n\u0005\u0001\u001b$\u0001\u0002+fgRDQA\u0011\u0001\u0005\u0002%\nq\u0005^3tiN\u000bW.\u001a)beRLG/[8o\u0017\u0016L8oV5uQ\u0012KgMZ(sI\u0016\u00148*Z=tc!\u0012\u0011I\u0010\u0005\u0006\u000b\u0002!\t!K\u0001(i\u0016\u001cHoU1nKB\u000b'\u000f^5uS>t7*Z=t/&$\b\u000eR5gM>\u0013H-\u001a:LKf\u001c(\u0007\u000b\u0002E}!)\u0001\n\u0001C\u0001S\u0005!D/Z:u'\u0006lW\rU1si&$\u0018n\u001c8LKf\u001cx+\u001b;i'\u0006lWm\u0014:eKJ\\U-_:ES\u001a4G)\u001b:fGRLwN\\\u0019)\u0005\u001ds\u0004\"B&\u0001\t\u0003I\u0013\u0001\u000e;fgR\u001c\u0016-\\3QCJ$\u0018\u000e^5p].+\u0017p],ji\"\u001c\u0016-\\3Pe\u0012,'oS3zg\u0012KgM\u001a#je\u0016\u001cG/[8oe!\u0012!J\u0010\u0005\u0006\u001d\u0002!\t!K\u00015i\u0016\u001cHoU1nKB\u000b'\u000f^5uS>t7*Z=t/&$\bnU1nK>\u0013H-\u001a:LKf\u001cx+\u001b;i\u000b6\u0004H/_(sI\u0016\u0014\bFA'?\u0011\u0015\t\u0006\u0001\"\u0001*\u0003\u0019\"Xm\u001d;ES\u001a4\u0007+\u0019:uSRLwN\\&fsN<\u0016\u000e\u001e5TC6,wJ\u001d3fe.+\u0017p\u001d\u0015\u0003!zBQ\u0001\u0016\u0001\u0005\u0002%\nq\u0005^3ti\u0012KgM\u001a)beRLG/[8o\u0017\u0016L8oV5uQ\u0012KgMZ(sI\u0016\u00148*Z=tc!\u00121K\u0010\u0005\u0006/\u0002!\t!K\u0001(i\u0016\u001cH\u000fR5gMB\u000b'\u000f^5uS>t7*Z=t/&$\b\u000eR5gM>\u0013H-\u001a:LKf\u001c(\u0007\u000b\u0002W}!)!\f\u0001C\u0001S\u0005aB/Z:u\u001bVdG/[(wKJ<\u0016N\u001c3poJ\u000bgnZ3UsB,\u0007FA-?\u0001")
public class WindowGroupReorderRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().buildBatchProgram(FlinkBatchProgram$.MODULE$.LOGICAL());
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.WindowGroupReorderRuleTest$$anon$2 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeysPrefix() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a,\n        |    RANK() OVER (PARTITION BY b ORDER BY c, a DESC),\n        |    RANK() OVER (PARTITION BY b ORDER BY c, b)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithDiffOrderKeys1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY c),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY b),\n        |    AVG(a) OVER (PARTITION BY b ORDER BY a),\n        |    RANK() OVER (PARTITION BY b ORDER BY c),\n        |    MIN(a) OVER (PARTITION BY b ORDER BY b)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithDiffOrderKeys2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY c),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY a),\n        |    AVG(a) OVER (PARTITION BY b ORDER BY a, c),\n        |    RANK() OVER (PARTITION BY b ORDER BY a, b),\n        |    MIN(a) OVER (PARTITION BY b ORDER BY b)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeysDiffDirection1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a ASC),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY a ASC),\n        |    AVG(a) OVER (PARTITION BY b ORDER BY a DESC),\n        |    RANK() OVER (PARTITION BY b ORDER BY a ASC),\n        |    MIN(a) OVER (PARTITION BY b ORDER BY a DESC)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeysDiffDirection2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    RANK() OVER (PARTITION BY b ORDER BY a DESC),\n        |    RANK() OVER (PARTITION BY b ORDER BY a ASC)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSamePartitionKeysWithSameOrderKeysWithEmptyOrder() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a),\n        |    MIN(a) OVER (PARTITION BY b),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY a)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testDiffPartitionKeysWithSameOrderKeys() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY a),\n        |    AVG(a) OVER (PARTITION BY c ORDER BY a),\n        |    RANK() OVER (PARTITION BY b ORDER BY a),\n        |    MIN(a) OVER (PARTITION BY c ORDER BY a)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testDiffPartitionKeysWithDiffOrderKeys1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY a),\n        |    MAX(a) OVER (PARTITION BY b ORDER BY c),\n        |    AVG(a) OVER (PARTITION BY c ORDER BY a),\n        |    RANK() OVER (PARTITION BY b ORDER BY a),\n        |    MIN(a) OVER (PARTITION BY c ORDER BY a)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testDiffPartitionKeysWithDiffOrderKeys2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    SUM(a) OVER (PARTITION BY b ORDER BY c),\n        |    MAX(a) OVER (PARTITION BY c ORDER BY a),\n        |    MIN(a) OVER (ORDER BY c, a),\n        |    RANK() OVER (PARTITION BY b ORDER BY c),\n        |    AVG(a) OVER (ORDER BY b)\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiOverWindowRangeType() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY a RANGE BETWEEN -1 PRECEDING AND 10 FOLLOWING),\n        |    SUM(a) OVER (PARTITION BY c ORDER BY a),\n        |    RANK() OVER (PARTITION BY c ORDER BY a, c),\n        |    SUM(a) OVER (PARTITION BY c ORDER BY a RANGE BETWEEN 1 PRECEDING AND 10 FOLLOWING),\n        |    COUNT(*) OVER (PARTITION BY c ORDER BY c ROWS BETWEEN 1 PRECEDING AND 10 FOLLOWING)\n        | FROM MyTable\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }
}

