/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical.subquery;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.rules.logical.subquery.SubQueryAntiJoinTest$;
import org.apache.flink.table.planner.plan.rules.logical.subquery.SubQueryTestBase;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableFunctions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t5e\u0001B\u0001\u0003\u0001U\u0011AcU;c#V,'/_!oi&Tu.\u001b8UKN$(BA\u0002\u0005\u0003!\u0019XOY9vKJL(BA\u0003\u0007\u0003\u001dawnZ5dC2T!a\u0002\u0005\u0002\u000bI,H.Z:\u000b\u0005%Q\u0011\u0001\u00029mC:T!a\u0003\u0007\u0002\u000fAd\u0017M\u001c8fe*\u0011QBD\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001fA\tQA\u001a7j].T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011C\u0001\u0001\u0017!\t9\u0002$D\u0001\u0003\u0013\tI\"A\u0001\tTk\n\fV/\u001a:z)\u0016\u001cHOQ1tK\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003/\u0001AQa\b\u0001\u0005\u0002\u0001\nA\u0004^3ti:{G/\u00138P]^CWM]3`\u001d>$8+\u001e2Rk\u0016\u0014\u0018\u0010F\u0001\"!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0011)f.\u001b;)\u0005yA\u0003CA\u00151\u001b\u0005Q#BA\u0016-\u0003\r\t\u0007/\u001b\u0006\u0003[9\nqA[;qSR,'O\u0003\u00020%\u0005)!.\u001e8ji&\u0011\u0011G\u000b\u0002\u0005)\u0016\u001cH\u000fC\u00034\u0001\u0011\u0005\u0001%A\u0011uKN$hj\u001c;J]^KG\u000f[+oG>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,\u0017\u0007\u000b\u00023Q!)a\u0007\u0001C\u0001A\u0005\tC/Z:u\u001d>$\u0018J\\,ji\",fnY8se\u0016d\u0017\r^3e\u001f:<\u0006.\u001a:fe!\u0012Q\u0007\u000b\u0005\u0006s\u0001!\t\u0001I\u0001\"i\u0016\u001cHOT8u\u0013:<\u0016\u000e\u001e5V]\u000e|'O]3mCR,Gm\u00148XQ\u0016\u0014Xm\r\u0015\u0003q!BQ\u0001\u0010\u0001\u0005\u0002\u0001\n\u0011\u0005^3ti:{G/\u00138XSRDWK\\2peJ,G.\u0019;fI>sw\u000b[3sKRB#a\u000f\u0015\t\u000b}\u0002A\u0011\u0001\u0011\u0002CQ,7\u000f\u001e(pi&sw+\u001b;i+:\u001cwN\u001d:fY\u0006$X\rZ(o/\",'/Z\u001b)\u0005yB\u0003\"\u0002\"\u0001\t\u0003\u0001\u0013!\t;fgRtu\u000e^%o/&$\b.\u00168d_J\u0014X\r\\1uK\u0012|en\u00165fe\u00164\u0004FA!)\u0011\u0015)\u0005\u0001\"\u0001!\u0003\u0005\"Xm\u001d;O_RLenV5uQVs7m\u001c:sK2\fG/\u001a3P]^CWM]38Q\t!\u0005\u0006C\u0003I\u0001\u0011\u0005\u0001%\u0001\u001auKN$hj\u001c;J]^KG\u000f[+oG>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,wlQ8na2,\u0007pQ8oI&$\u0018n\u001c82Q\t9\u0005\u0006C\u0003L\u0001\u0011\u0005\u0001%\u0001\u001auKN$hj\u001c;J]^KG\u000f[+oG>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,wlQ8na2,\u0007pQ8oI&$\u0018n\u001c83Q\tQ\u0005\u0006C\u0003O\u0001\u0011\u0005\u0001%\u0001\u001auKN$hj\u001c;J]^KG\u000f[+oG>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,wlQ8na2,\u0007pQ8oI&$\u0018n\u001c84Q\ti\u0005\u0006C\u0003R\u0001\u0011\u0005\u0001%\u0001\u001auKN$hj\u001c;J]^KG\u000f[+oG>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,wlQ8na2,\u0007pQ8oI&$\u0018n\u001c85Q\t\u0001\u0006\u0006C\u0003U\u0001\u0011\u0005\u0001%\u0001\u001auKN$hj\u001c;J]^KG\u000f[+oG>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,wlQ8na2,\u0007pQ8oI&$\u0018n\u001c86Q\t\u0019\u0006\u0006C\u0003X\u0001\u0011\u0005\u0001%\u0001\u001auKN$hj\u001c;J]^KG\u000f[+oG>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,wlQ8na2,\u0007pQ8oI&$\u0018n\u001c87Q\t1\u0006\u0006C\u0003[\u0001\u0011\u0005\u0001%\u0001\u001auKN$hj\u001c;J]^KG\u000f[+oG>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,wlQ8na2,\u0007pQ8oI&$\u0018n\u001c88Q\tI\u0006\u0006C\u0003^\u0001\u0011\u0005\u0001%A\u001buKN$hj\u001c;J]^KG\u000f[+oG>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,w,\u00168tkB\u0004xN\u001d;fI\u000e{g\u000eZ5uS>t\u0007F\u0001/)\u0011\u0015\u0001\u0007\u0001\"\u0001!\u0003\u0019\"Xm\u001d;O_RLenV5uQVs7m\u001c:sK2\fG/\u001a3P]^CWM]3`\u0007\u0006\u001cX-\r\u0015\u0003?\"BQa\u0019\u0001\u0005\u0002\u0001\na\u0005^3ti:{G/\u00138XSRDWK\\2peJ,G.\u0019;fI>sw\u000b[3sK~\u001b\u0015m]33Q\t\u0011\u0007\u0006C\u0003g\u0001\u0011\u0005\u0001%\u0001\u0014uKN$hj\u001c;J]^KG\u000f[+oG>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,wlQ1tKNB#!\u001a\u0015\t\u000b%\u0004A\u0011\u0001\u0011\u0002MQ,7\u000f\u001e(pi&sw+\u001b;i+:\u001cwN\u001d:fY\u0006$X\rZ(o/\",'/Z0DCN,G\u0007\u000b\u0002iQ!)A\u000e\u0001C\u0001A\u00051C/Z:u\u001d>$\u0018J\\,ji\",fnY8se\u0016d\u0017\r^3e\u001f:<\u0006.\u001a:f?\u000e\u000b7/Z\u001b)\u0005-D\u0003\"B8\u0001\t\u0003\u0001\u0013A\n;fgRtu\u000e^%o/&$\b.\u00168d_J\u0014X\r\\1uK\u0012|en\u00165fe\u0016|6)Y:fm!\u0012a\u000e\u000b\u0005\u0006e\u0002!\t\u0001I\u0001'i\u0016\u001cHOT8u\u0013:<\u0016\u000e\u001e5V]\u000e|'O]3mCR,Gm\u00148XQ\u0016\u0014XmX\"bg\u0016<\u0004FA9)\u0011\u0015)\b\u0001\"\u0001!\u00035\"Xm\u001d;O_RLenV5uQVs7m\u001c:sK2\fG/\u001a3P]^CWM]3`\u001bVdG/\u001b$jK2$7/\r\u0015\u0003i\"BQ\u0001\u001f\u0001\u0005\u0002\u0001\nQ\u0006^3ti:{G/\u00138XSRDWK\\2peJ,G.\u0019;fI>sw\u000b[3sK~kU\u000f\u001c;j\r&,G\u000eZ:3Q\t9\b\u0006C\u0003|\u0001\u0011\u0005\u0001%A\u0017uKN$hj\u001c;J]^KG\u000f[+oG>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,w,T;mi&4\u0015.\u001a7egNB#A\u001f\u0015\t\u000by\u0004A\u0011\u0001\u0011\u0002QQ,7\u000f^'vYRLgj\u001c;J]^KG\u000f[+oG>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,wl\u0014*)\u0005uD\u0003BBA\u0002\u0001\u0011\u0005\u0001%A\u0014uKN$hj\u001c;J]^KG\u000f[+oG>\u0014(/\u001a7bi\u0016$wJ\u001c'bi\u0016\u0014\u0018\r\u001c+bE2,\u0007fAA\u0001Q!1\u0011\u0011\u0002\u0001\u0005\u0002\u0001\nq\u0004^3ti:{G/\u00138XSRD7i\u001c:sK2\fG/\u001a3P]^CWM]32Q\r\t9\u0001\u000b\u0005\u0007\u0003\u001f\u0001A\u0011\u0001\u0011\u0002?Q,7\u000f\u001e(pi&sw+\u001b;i\u0007>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,'\u0007K\u0002\u0002\u000e!Ba!!\u0006\u0001\t\u0003\u0001\u0013a\b;fgRtu\u000e^%o/&$\bnQ8se\u0016d\u0017\r^3e\u001f:<\u0006.\u001a:fg!\u001a\u00111\u0003\u0015\t\r\u0005m\u0001\u0001\"\u0001!\u0003}!Xm\u001d;O_RLenV5uQ\u000e{'O]3mCR,Gm\u00148XQ\u0016\u0014X\r\u000e\u0015\u0004\u00033A\u0003BBA\u0011\u0001\u0011\u0005\u0001%A\u0010uKN$hj\u001c;J]^KG\u000f[\"peJ,G.\u0019;fI>sw\u000b[3sKVB3!a\b)\u0011\u0019\t9\u0003\u0001C\u0001A\u0005yB/Z:u\u001d>$\u0018J\\,ji\"\u001cuN\u001d:fY\u0006$X\rZ(o/\",'/\u001a\u001c)\u0007\u0005\u0015\u0002\u0006\u0003\u0004\u0002.\u0001!\t\u0001I\u0001%i\u0016\u001cHOT8u\u0013:<\u0016\u000e\u001e5D_J\u0014X\r\\1uK\u0012|en\u00165fe\u0016|6)Y:fc!\u001a\u00111\u0006\u0015\t\r\u0005M\u0002\u0001\"\u0001!\u0003\u0011\"Xm\u001d;O_RLenV5uQ\u000e{'O]3mCR,Gm\u00148XQ\u0016\u0014XmX\"bg\u0016\u0014\u0004fAA\u0019Q!1\u0011\u0011\b\u0001\u0005\u0002\u0001\nA\u0005^3ti:{G/\u00138XSRD7i\u001c:sK2\fG/\u001a3P]^CWM]3`\u0007\u0006\u001cXm\r\u0015\u0004\u0003oA\u0003BBA \u0001\u0011\u0005\u0001%\u0001\u0013uKN$hj\u001c;J]^KG\u000f[\"peJ,G.\u0019;fI>sw\u000b[3sK~\u001b\u0015m]35Q\r\ti\u0004\u000b\u0005\u0007\u0003\u000b\u0002A\u0011\u0001\u0011\u0002IQ,7\u000f\u001e(pi&sw+\u001b;i\u0007>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,wlQ1tKVB3!a\u0011)\u0011\u0019\tY\u0005\u0001C\u0001A\u0005!C/Z:u\u001d>$\u0018J\\,ji\"\u001cuN\u001d:fY\u0006$X\rZ(o/\",'/Z0DCN,g\u0007K\u0002\u0002J!Ba!!\u0015\u0001\t\u0003\u0001\u0013\u0001\r;fgRtu\u000e^%o/&$\bnQ8se\u0016d\u0017\r^3e\u001f:<\u0006.\u001a:f?\u000e{W\u000e\u001d7fq\u000e{g\u000eZ5uS>t\u0017\u0007K\u0002\u0002P!Ba!a\u0016\u0001\t\u0003\u0001\u0013\u0001\r;fgRtu\u000e^%o/&$\bnQ8se\u0016d\u0017\r^3e\u001f:<\u0006.\u001a:f?\u000e{W\u000e\u001d7fq\u000e{g\u000eZ5uS>t'\u0007K\u0002\u0002V!Ba!!\u0018\u0001\t\u0003\u0001\u0013\u0001\r;fgRtu\u000e^%o/&$\bnQ8se\u0016d\u0017\r^3e\u001f:<\u0006.\u001a:f?\u000e{W\u000e\u001d7fq\u000e{g\u000eZ5uS>t7\u0007K\u0002\u0002\\!Ba!a\u0019\u0001\t\u0003\u0001\u0013\u0001\r;fgRtu\u000e^%o/&$\bnQ8se\u0016d\u0017\r^3e\u001f:<\u0006.\u001a:f?\u000e{W\u000e\u001d7fq\u000e{g\u000eZ5uS>tG\u0007K\u0002\u0002b!Ba!!\u001b\u0001\t\u0003\u0001\u0013\u0001\r;fgRtu\u000e^%o/&$\bnQ8se\u0016d\u0017\r^3e\u001f:<\u0006.\u001a:f?\u000e{W\u000e\u001d7fq\u000e{g\u000eZ5uS>tW\u0007K\u0002\u0002h!Ba!a\u001c\u0001\t\u0003\u0001\u0013\u0001\r;fgRtu\u000e^%o/&$\bnQ8se\u0016d\u0017\r^3e\u001f:<\u0006.\u001a:f?\u000e{W\u000e\u001d7fq\u000e{g\u000eZ5uS>tg\u0007K\u0002\u0002n!Ba!!\u001e\u0001\t\u0003\u0001\u0013a\r;fgRtu\u000e^%o/&$\bnQ8se\u0016d\u0017\r^3e\u001f:<\u0006.\u001a:f?Vs7/\u001e9q_J$X\rZ\"p]\u0012LG/[8oQ\r\t\u0019\b\u000b\u0005\u0007\u0003w\u0002A\u0011\u0001\u0011\u0002WQ,7\u000f\u001e(pi&sw+\u001b;i\u0007>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,w,T;mi&4\u0015.\u001a7egFB3!!\u001f)\u0011\u0019\t\t\t\u0001C\u0001A\u0005YC/Z:u\u001d>$\u0018J\\,ji\"\u001cuN\u001d:fY\u0006$X\rZ(o/\",'/Z0Nk2$\u0018NR5fY\u0012\u001c(\u0007K\u0002\u0002\u0000!Ba!a\"\u0001\t\u0003\u0001\u0013a\u000b;fgRtu\u000e^%o/&$\bnQ8se\u0016d\u0017\r^3e\u001f:<\u0006.\u001a:f?6+H\u000e^5GS\u0016dGm]\u001a)\u0007\u0005\u0015\u0005\u0006\u0003\u0004\u0002\u000e\u0002!\t\u0001I\u0001/i\u0016\u001cHOT8u\u0013:<\u0016\u000e\u001e5V]\u000e|'O]3mCR,G-\u00118e\u0007>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,\u0017\u0007K\u0002\u0002\f\"Ba!a%\u0001\t\u0003\u0001\u0013A\f;fgRtu\u000e^%o/&$\b.\u00168d_J\u0014X\r\\1uK\u0012\fe\u000eZ\"peJ,G.\u0019;fI>sw\u000b[3sKJB3!!%)\u0011\u0019\tI\n\u0001C\u0001A\u0005qC/Z:u\u001d>$\u0018J\\,ji\",fnY8se\u0016d\u0017\r^3e\u0003:$7i\u001c:sK2\fG/\u001a3P]^CWM]34Q\r\t9\n\u000b\u0005\u0007\u0003?\u0003A\u0011\u0001\u0011\u0002]Q,7\u000f\u001e(pi&sw+\u001b;i+:\u001cwN\u001d:fY\u0006$X\rZ!oI\u000e{'O]3mCR,Gm\u00148XQ\u0016\u0014X\r\u000e\u0015\u0004\u0003;C\u0003BBAS\u0001\u0011\u0005\u0001%A\u0013uKN$hj\u001c;J]^KG\u000f[\"peJ,G.\u0019;fI>sG*\u0019;fe\u0006dG+\u00192mK\"\u001a\u00111\u0015\u0015\t\r\u0005-\u0006\u0001\"\u0001!\u0003\u0015\"Xm\u001d;O_R,\u00050[:ug^KG\u000f[+oG>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,\u0017\u0007K\u0002\u0002*\"Ba!!-\u0001\t\u0003\u0001\u0013!\n;fgRtu\u000e^#ySN$8oV5uQVs7m\u001c:sK2\fG/\u001a3P]^CWM]33Q\r\ty\u000b\u000b\u0005\u0007\u0003o\u0003A\u0011\u0001\u0011\u0002KQ,7\u000f\u001e(pi\u0016C\u0018n\u001d;t/&$\b.\u00168d_J\u0014X\r\\1uK\u0012|en\u00165fe\u0016\u001c\u0004fAA[Q!1\u0011Q\u0018\u0001\u0005\u0002\u0001\nQ\u0005^3ti:{G/\u0012=jgR\u001cx+\u001b;i+:\u001cwN\u001d:fY\u0006$X\rZ(o/\",'/\u001a\u001b)\u0007\u0005m\u0006\u0006\u0003\u0004\u0002D\u0002!\t\u0001I\u0001&i\u0016\u001cHOT8u\u000bbL7\u000f^:XSRDWK\\2peJ,G.\u0019;fI>sw\u000b[3sKVB3!!1)\u0011\u0019\tI\r\u0001C\u0001A\u0005)C/Z:u\u001d>$X\t_5tiN<\u0016\u000e\u001e5V]\u000e|'O]3mCR,Gm\u00148XQ\u0016\u0014XM\u000e\u0015\u0004\u0003\u000fD\u0003BBAh\u0001\u0011\u0005\u0001%A\u0013uKN$hj\u001c;Fq&\u001cHo],ji\",fnY8se\u0016d\u0017\r^3e\u001f:<\u0006.\u001a:fo!\u001a\u0011Q\u001a\u0015\t\r\u0005U\u0007\u0001\"\u0001!\u0003e\"Xm\u001d;O_R,\u00050[:ug^KG\u000f[+oG>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,w,\u00168tkB\u0004xN\u001d;fI\u000e{g\u000eZ5uS>t\u0007fAAjQ!1\u00111\u001c\u0001\u0005\u0002\u0001\na\u0006^3ti6+H\u000e^5O_R,\u00050[:ug^KG\u000f[+oG>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,w,\u0011(Ec!\u001a\u0011\u0011\u001c\u0015\t\r\u0005\u0005\b\u0001\"\u0001!\u00039\"Xm\u001d;Nk2$\u0018NT8u\u000bbL7\u000f^:XSRDWK\\2peJ,G.\u0019;fI>sw\u000b[3sK~\u000be\n\u0012\u001a)\u0007\u0005}\u0007\u0006\u0003\u0004\u0002h\u0002!\t\u0001I\u0001-i\u0016\u001cH/T;mi&tu\u000e^#ySN$8oV5uQVs7m\u001c:sK2\fG/\u001a3P]^CWM]3`\u001fJC3!!:)\u0011\u0019\ti\u000f\u0001C\u0001A\u0005YC/Z:u\u001d>$X\t_5tiN<\u0016\u000e\u001e5V]\u000e|'O]3mCR,Gm\u00148MCR,'/\u00197UC\ndW\rK\u0002\u0002l\"Ba!a=\u0001\t\u0003\u0001\u0013a\t;fgRtu\u000e^#ySN$8oV5uQ\u000e{'O]3mCR,Gm\u00148XQ\u0016\u0014X-\r\u0015\u0004\u0003cD\u0003BBA}\u0001\u0011\u0005\u0001%A\u0012uKN$hj\u001c;Fq&\u001cHo],ji\"\u001cuN\u001d:fY\u0006$X\rZ(o/\",'/\u001a\u001a)\u0007\u0005]\b\u0006\u0003\u0004\u0002\u0000\u0002!\t\u0001I\u0001$i\u0016\u001cHOT8u\u000bbL7\u000f^:XSRD7i\u001c:sK2\fG/\u001a3P]^CWM]34Q\r\ti\u0010\u000b\u0005\u0007\u0005\u000b\u0001A\u0011\u0001\u0011\u0002GQ,7\u000f\u001e(pi\u0016C\u0018n\u001d;t/&$\bnQ8se\u0016d\u0017\r^3e\u001f:<\u0006.\u001a:fi!\u001a!1\u0001\u0015\t\r\t-\u0001\u0001\"\u0001!\u0003\r\"Xm\u001d;O_R,\u00050[:ug^KG\u000f[\"peJ,G.\u0019;fI>sw\u000b[3sKVB3A!\u0003)\u0011\u0019\u0011\t\u0002\u0001C\u0001A\u0005\u0019C/Z:u\u001d>$X\t_5tiN<\u0016\u000e\u001e5D_J\u0014X\r\\1uK\u0012|en\u00165fe\u00164\u0004f\u0001B\bQ!1!q\u0003\u0001\u0005\u0002\u0001\n1\u0005^3ti:{G/\u0012=jgR\u001cx+\u001b;i\u0007>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,w\u0007K\u0002\u0003\u0016!BaA!\b\u0001\t\u0003\u0001\u0013a\t;fgRtu\u000e^#ySN$8oV5uQ\u000e{'O]3mCR,Gm\u00148XQ\u0016\u0014X\r\u000f\u0015\u0004\u00057A\u0003B\u0002B\u0012\u0001\u0011\u0005\u0001%A\u0012uKN$hj\u001c;Fq&\u001cHo],ji\"\u001cuN\u001d:fY\u0006$X\rZ(o/\",'/Z\u001d)\u0007\t\u0005\u0002\u0006\u0003\u0004\u0003*\u0001!\t\u0001I\u00018i\u0016\u001cHOT8u\u000bbL7\u000f^:XSRD7i\u001c:sK2\fG/\u001a3P]^CWM]3`+:\u001cX\u000f\u001d9peR,GmQ8oI&$\u0018n\u001c8)\u0007\t\u001d\u0002\u0006\u0003\u0004\u00030\u0001!\t\u0001I\u00019i\u0016\u001cHOT8u\u000bbL7\u000f^:XSRD7i\u001c:sK2\fG/\u001a3P]^CWM]3`+:\u001cX\u000f\u001d9peR,GmQ8oI&$\u0018n\u001c83Q\r\u0011i\u0003\u000b\u0005\u0007\u0005k\u0001A\u0011\u0001\u0011\u0002sQ,7\u000f^'vYRLgj\u001c;Fq&\u001cHo],ji\"\u001cuN\u001d:fY\u0006$X\rZ(o/\",'/Z0OKN$X\rZ\"peJ,G.\u0019;j_:D3Aa\r)\u0011\u0019\u0011Y\u0004\u0001C\u0001A\u0005aC/Z:u\u001bVdG/\u001b(pi\u0016C\u0018n\u001d;t/&$\bnQ8se\u0016d\u0017\r^3e\u001f:<\u0006.\u001a:f?\u0006sE)\r\u0015\u0004\u0005sA\u0003B\u0002B!\u0001\u0011\u0005\u0001%\u0001\u0017uKN$X*\u001e7uS:{G/\u0012=jgR\u001cx+\u001b;i\u0007>\u0014(/\u001a7bi\u0016$wJ\\,iKJ,w,\u0011(Ee!\u001a!q\b\u0015\t\r\t\u001d\u0003\u0001\"\u0001!\u00031\"Xm\u001d;Nk2$\u0018NT8u\u000bbL7\u000f^:XSRD7i\u001c:sK2\fG/\u001a3P]^CWM]3`\u0003:#5\u0007K\u0002\u0003F!BaA!\u0014\u0001\t\u0003\u0001\u0013A\u000b;fgRlU\u000f\u001c;j\u001d>$X\t_5tiN<\u0016\u000e\u001e5D_J\u0014X\r\\1uK\u0012|en\u00165fe\u0016|vJ\u0015\u0015\u0004\u0005\u0017B\u0003B\u0002B*\u0001\u0011\u0005\u0001%A\u001cuKN$X*\u001e7uS:{G/\u0012=jgR\u001cx+\u001b;i+:\u001cwN\u001d:fY\u0006$X\rZ!oI\u000e{'O]3mCR,Gm\u00148XQ\u0016\u0014X-\r\u0015\u0004\u0005#B\u0003B\u0002B-\u0001\u0011\u0005\u0001%A\u001cuKN$X*\u001e7uS:{G/\u0012=jgR\u001cx+\u001b;i+:\u001cwN\u001d:fY\u0006$X\rZ!oI\u000e{'O]3mCR,Gm\u00148XQ\u0016\u0014XM\r\u0015\u0004\u0005/B\u0003B\u0002B0\u0001\u0011\u0005\u0001%A\u001cuKN$X*\u001e7uS:{G/\u0012=jgR\u001cx+\u001b;i+:\u001cwN\u001d:fY\u0006$X\rZ!oI\u000e{'O]3mCR,Gm\u00148XQ\u0016\u0014Xm\r\u0015\u0004\u0005;B\u0003B\u0002B3\u0001\u0011\u0005\u0001%A\u001cuKN$X*\u001e7uS:{G/\u0012=jgR\u001cx+\u001b;i+:\u001cwN\u001d:fY\u0006$X\rZ!oI\u000e{'O]3mCR,Gm\u00148XQ\u0016\u0014X\r\u000e\u0015\u0004\u0005GB\u0003B\u0002B6\u0001\u0011\u0005\u0001%A\u0015uKN$hj\u001c;Fq&\u001cHo],ji\"\u001cuN\u001d:fY\u0006$X\rZ(o\u0019\u0006$XM]1m)\u0006\u0014G.\u001a\u0015\u0004\u0005SB\u0003B\u0002B9\u0001\u0011\u0005\u0001%A\nuKN$hj\u001c;J]:{G/\u0012=jgR\u001c\u0018\u0007K\u0002\u0003p!BaAa\u001e\u0001\t\u0003\u0001\u0013a\u0005;fgRtu\u000e^%o\u001d>$X\t_5tiN\u0014\u0004f\u0001B;Q!1!Q\u0010\u0001\u0005\u0002\u0001\n1\u0003^3ti:{G/\u00138O_R,\u00050[:ugNB3Aa\u001f)\u0011\u0019\u0011\u0019\t\u0001C\u0001A\u0005YB/Z:u\u0013:tu\u000e^%o\u000bbL7\u000f^:O_R,\u00050[:ugFB3A!!)\u0011\u0019\u0011I\t\u0001C\u0001A\u0005YB/Z:u\u0013:tu\u000e^%o\u000bbL7\u000f^:O_R,\u00050[:ugJB3Aa\")\u0001")
public class SubQueryAntiJoinTest
extends SubQueryTestBase {
    @Test
    public void testNotInOnWhere_NotSubQuery() {
        String sqlQuery = "SELECT * FROM x WHERE a NOT IN (1, 2, 3, 4)";
        this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere1() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE a NOT IN (SELECT c FROM y)");
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere2() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE a NOT IN (SELECT c FROM y WHERE d < 100) AND b > 10");
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere3() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE a + 1 NOT IN (SELECT c FROM y)");
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere4() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE a * b NOT IN (SELECT d FROM y)");
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere5() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE CAST(a AS BIGINT) NOT IN (SELECT d FROM y)");
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere6() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE a NOT IN (SELECT c FROM y WHERE c IS NOT NULL)");
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere7() {
        this.util().verifyRelPlan("SELECT a FROM x x1 WHERE a NOT IN (SELECT a FROM x WHERE a < 3 GROUP BY a)");
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere_ComplexCondition1() {
        String sqlQuery = "SELECT * FROM l WHERE b > 10 AND NOT (c like 'abc' AND a IN (SELECT d FROM r))";
        this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere_ComplexCondition2() {
        this.util().verifyRelPlan("SELECT * FROM l WHERE NOT (a IN (SELECT d FROM r))");
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere_ComplexCondition3() {
        this.util().verifyRelPlan("SELECT * FROM l WHERE NOT ( NOT ( a NOT IN (SELECT d FROM r)))");
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere_ComplexCondition4() {
        this.util().verifyRelPlan("SELECT * FROM l WHERE NOT (a IN (SELECT d FROM r) OR b > 10)");
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere_ComplexCondition5() {
        String sqlQuery = "SELECT * FROM l WHERE b > 10 AND (c like 'abc' AND a NOT IN (SELECT d FROM r))";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere_ComplexCondition6() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE (a NOT IN (SELECT c FROM y)) IS TRUE");
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere_ComplexCondition7() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE (a NOT IN (SELECT c FROM y) = TRUE)");
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere_UnsupportedCondition() {
        String sqlQuery1 = "SELECT * FROM x WHERE a NOT IN (SELECT c FROM y) OR b = 10";
        this.util().verifyRelPlanNotExpected(sqlQuery1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
        String sqlQuery2 = "SELECT * FROM x WHERE a NOT IN (SELECT c FROM y WHERE x.b NOT IN (SELECT e FROM z))";
        this.util().verifyRelPlanNotExpected(sqlQuery2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
        String sqlQuery3 = "SELECT * FROM x, y WHERE x.a = y.c AND (y.d NOT IN (SELECT d FROM y) OR x.a >= 1)";
        this.util().verifyRelPlanNotExpected(sqlQuery3, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
        String sqlQuery4 = "SELECT * FROM x WHERE a NOT IN (SELECT c FROM y) OR b NOT IN (SELECT e FROM z)";
        this.util().verifyRelPlanNotExpected(sqlQuery4, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
        String sqlQuery5 = "SELECT * FROM x WHERE a NOT IN (SELECT x.b FROM y)";
        this.util().verifyRelPlanNotExpected(sqlQuery5, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere_Case1() {
        String sqlQuery = "SELECT b FROM l WHERE (CASE WHEN a > 10 THEN 1 ELSE 2 END) NOT IN (SELECT d FROM r)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere_Case2() {
        this.util().addTableSource("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i"))}), BasicTypeInfo.getInfoFor(Integer.TYPE));
        String sqlQuery = "SELECT b FROM l WHERE (CASE WHEN a NOT IN (SELECT 1 FROM t1) THEN 1 ELSE 2 END) NOT IN (SELECT d FROM r)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere_Case3() {
        this.util().addTableSource("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i"))}), BasicTypeInfo.getInfoFor(Integer.TYPE));
        String sqlQuery = "SELECT b FROM l WHERE (CASE WHEN a NOT IN (SELECT i FROM t1) THEN 1 ELSE 2 END) NOT IN (SELECT d FROM r)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere_Case4() {
        this.util().addTableSource("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i"))}), BasicTypeInfo.getInfoFor(Integer.TYPE));
        this.util().addTableSource("t2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "j"))}), BasicTypeInfo.getInfoFor(Integer.TYPE));
        String sqlQuery = "SELECT b FROM l WHERE (CASE WHEN a NOT IN (SELECT i FROM t1) THEN 1 WHEN a NOT IN (SELECT j FROM t2) THEN 2 ELSE 3 END) NOT IN (SELECT d FROM r)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere_Case5() {
        this.util().addTableSource("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i"))}), BasicTypeInfo.getInfoFor(Integer.TYPE));
        this.util().addTableSource("t2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "j"))}), BasicTypeInfo.getInfoFor(Integer.TYPE));
        String sqlQuery = "SELECT b FROM l WHERE (b, (CASE WHEN a NOT IN (SELECT i FROM t1) THEN 1 WHEN a NOT IN (SELECT j FROM t2) THEN 2 ELSE 3 END)) NOT IN (SELECT e, d FROM r)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere_Case6() {
        this.util().addTableSource("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i"))}), BasicTypeInfo.getInfoFor(Integer.TYPE));
        this.util().addTableSource("t2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "j"))}), BasicTypeInfo.getInfoFor(Integer.TYPE));
        String sqlQuery = "SELECT c FROM l WHERE ( (CASE WHEN a NOT IN (SELECT i FROM t1) THEN 1 ELSE 2 END),  (CASE WHEN b NOT IN (SELECT j FROM t2) THEN 3 ELSE 4 END))  NOT IN (SELECT d, e FROM r)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere_Case7() {
        this.util().addTableSource("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i"))}), BasicTypeInfo.getInfoFor(Integer.TYPE));
        String sqlQuery = "SELECT b FROM l WHERE (CASE WHEN a NOT IN (SELECT i FROM t1 WHERE l.a = t1.i) THEN 1 ELSE 2 END) NOT IN (SELECT d FROM r)";
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"})));
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere_MultiFields1() {
        this.util().verifyRelPlan("SELECT * FROM l WHERE (a, c) NOT IN (SELECT d, f FROM r)");
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere_MultiFields2() {
        this.util().verifyRelPlan("SELECT * FROM l WHERE (a + 1, c) NOT IN (SELECT d, f FROM r)");
    }

    @Test
    public void testNotInWithUncorrelatedOnWhere_MultiFields3() {
        String sqlQuery = "SELECT * FROM l WHERE (a + 10, TRIM(c)) NOT IN (SELECT d + 100, SUBSTRING(f, 1, 5) FROM r)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiNotInWithUncorrelatedOnWhere_OR() {
        String sqlQuery = "SELECT * FROM x WHERE a NOT IN (SELECT c FROM y) OR b NOT IN (SELECT f FROM z WHERE f IS NOT NULL)";
        this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
    }

    @Test
    public void testNotInWithUncorrelatedOnLateralTable() {
        String sqlQuery = "SELECT * FROM l WHERE c NOT IN (SELECT f1 FROM r, LATERAL TABLE(table_func(f)) AS T(f1))";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithCorrelatedOnWhere1() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE a NOT IN (SELECT c FROM y where x.b = y.d)");
    }

    @Test
    public void testNotInWithCorrelatedOnWhere2() {
        String sqlQuery = "SELECT * FROM x WHERE b > 1 AND a NOT IN (SELECT c FROM y WHERE x.b = y.d AND y.c > 10)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithCorrelatedOnWhere3() {
        String sqlQuery = "SELECT * FROM x WHERE b > 1 AND a + 1 NOT IN (SELECT c FROM y WHERE x.b = y.d AND y.c > 10)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithCorrelatedOnWhere4() {
        String sqlQuery = "SELECT * FROM x WHERE a NOT IN (SELECT c1 FROM (SELECT d * 2 as d1, c + 1 as c1 FROM y) y1 WHERE x.b = y1.d1 AND d1 > 10)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithCorrelatedOnWhere5() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE a NOT IN (SELECT c FROM y WHERE x.b > y.d)");
    }

    @Test
    public void testNotInWithCorrelatedOnWhere6() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE a NOT IN (SELECT c FROM y WHERE x.b > 10)");
    }

    @Test
    public void testNotInWithCorrelatedOnWhere_Case1() {
        String sqlQuery = "SELECT b FROM l WHERE (CASE WHEN a > 10 THEN 1 ELSE 2 END) NOT IN (SELECT d FROM r WHERE l.a = r.d)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithCorrelatedOnWhere_Case2() {
        this.util().addTableSource("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i"))}), BasicTypeInfo.getInfoFor(Integer.TYPE));
        String sqlQuery = "SELECT b FROM l WHERE (CASE WHEN a IN (SELECT 1 FROM t1) THEN 1 ELSE 2 END) NOT IN (SELECT d FROM r WHERE l.c = r.f)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithCorrelatedOnWhere_Case3() {
        this.util().addTableSource("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i"))}), BasicTypeInfo.getInfoFor(Integer.TYPE));
        String sqlQuery = "SELECT b FROM l WHERE (CASE WHEN a NOT IN (SELECT i FROM t1) THEN 1 ELSE 2 END) NOT IN (SELECT d FROM r WHERE l.c = r.f)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithCorrelatedOnWhere_Case4() {
        this.util().addTableSource("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i"))}), BasicTypeInfo.getInfoFor(Integer.TYPE));
        this.util().addTableSource("t2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "j"))}), BasicTypeInfo.getInfoFor(Integer.TYPE));
        String sqlQuery = "SELECT b FROM l WHERE (CASE WHEN a NOT IN (SELECT i FROM t1) THEN 1 WHEN a NOT IN (SELECT j FROM t2) THEN 2 ELSE 3 END) NOT IN (SELECT d FROM r WHERE l.c = r.f)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithCorrelatedOnWhere_Case5() {
        this.util().addTableSource("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i"))}), BasicTypeInfo.getInfoFor(Integer.TYPE));
        this.util().addTableSource("t2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "j"))}), BasicTypeInfo.getInfoFor(Integer.TYPE));
        String sqlQuery = "SELECT b FROM l WHERE (b, (CASE WHEN a NOT IN (SELECT i FROM t1) THEN 1 WHEN a NOT IN (SELECT j FROM t2) THEN 2 ELSE 3 END)) NOT IN (SELECT e, d FROM r WHERE l.c = r.f)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithCorrelatedOnWhere_Case6() {
        this.util().addTableSource("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i"))}), BasicTypeInfo.getInfoFor(Integer.TYPE));
        this.util().addTableSource("t2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "j"))}), BasicTypeInfo.getInfoFor(Integer.TYPE));
        String sqlQuery = "SELECT b FROM l WHERE (CASE WHEN a NOT IN (SELECT i FROM t1 WHERE l.a = t1.i) THEN 1 ELSE 2 END) NOT IN (SELECT d FROM r WHERE l.c = r.f)";
        this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
    }

    @Test
    public void testNotInWithCorrelatedOnWhere_ComplexCondition1() {
        String sqlQuery = "SELECT * FROM l WHERE a NOT IN (SELECT CAST(e AS INTEGER) FROM r where CAST(l.b AS INTEGER) = CAST(r.d AS INTEGER))";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithCorrelatedOnWhere_ComplexCondition2() {
        String sqlQuery = "SELECT a + 10, c FROM l WHERE a + 10 NOT IN (SELECT d + 1 FROM r WHERE l.b + 1 = r.e)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithCorrelatedOnWhere_ComplexCondition3() {
        this.util().verifyRelPlan("SELECT * FROM l WHERE c NOT IN (SELECT TRIM(f) FROM r where l.a = r.d + 1)");
    }

    @Test
    public void testNotInWithCorrelatedOnWhere_ComplexCondition4() {
        String sqlQuery = "SELECT * FROM l WHERE b > 10 AND NOT (c like 'abc' AND a IN (SELECT d FROM r where l.b = r.e))";
        this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
    }

    @Test
    public void testNotInWithCorrelatedOnWhere_ComplexCondition5() {
        String sqlQuery = "SELECT * FROM l WHERE b > 10 AND (c like 'abc' AND a NOT IN (SELECT d FROM r where l.b = r.e))";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithCorrelatedOnWhere_ComplexCondition6() {
        String sqlQuery = "SELECT * FROM l WHERE b NOT IN (SELECT e * 5 FROM (SELECT SUM(e) AS e FROM r WHERE l.a = r.d) r1)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithCorrelatedOnWhere_UnsupportedCondition() {
        String sqlQuery1 = "SELECT * FROM x WHERE b NOT IN (SELECT d FROM y WHERE x.a = y.c OR y.c = 10)";
        this.util().verifyRelPlanNotExpected(sqlQuery1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
        String sqlQuery2 = "SELECT * FROM x WHERE b NOT IN (SELECT d FROM y WHERE x.a = y.c OR x.b = 10)";
        this.util().verifyRelPlanNotExpected(sqlQuery2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
        String sqlQuery3 = "SELECT * FROM x WHERE b NOT IN (SELECT d FROM y WHERE x.a = y.c) OR x.a = 10";
        this.util().verifyRelPlanNotExpected(sqlQuery3, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
        String sqlQuery4 = "SELECT * FROM x WHERE a NOT IN (SELECT x.b FROM y WHERE x.a = y.c)";
        this.util().verifyRelPlanNotExpected(sqlQuery4, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
        String sqlQuery5 = "SELECT * FROM l WHERE a NOT IN (SELECT d FROM r WHERE l.b NOT IN (SELECT j FROM t) AND l.c = r.f)";
        this.util().verifyRelPlanNotExpected(sqlQuery5, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
    }

    @Test
    public void testNotInWithCorrelatedOnWhere_MultiFields1() {
        this.util().verifyRelPlan("SELECT * FROM l WHERE (a, c) NOT IN (SELECT d, f FROM r WHERE l.b = r.e)");
    }

    @Test
    public void testNotInWithCorrelatedOnWhere_MultiFields2() {
        String sqlQuery = "SELECT * FROM l WHERE (a, SUBSTRING(c, 1, 5)) NOT IN (SELECT d, TRIM(f) FROM r WHERE l.b = r.e)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithCorrelatedOnWhere_MultiFields3() {
        String sqlQuery = "SELECT * FROM l WHERE (a + 10, SUBSTRING(c, 1, 5)) NOT IN (SELECT d + 100, TRIM(f) FROM r WHERE l.b = r.e)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithUncorrelatedAndCorrelatedOnWhere1() {
        String sqlQuery = "SELECT a FROM x WHERE a NOT IN (SELECT c FROM y WHERE x.b = y.d) AND b NOT IN (SELECT f FROM z)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithUncorrelatedAndCorrelatedOnWhere2() {
        String sqlQuery = "SELECT * FROM x WHERE a NOT IN (SELECT c FROM y) AND b NOT IN (SELECT e FROM z WHERE z.f = x.b)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithUncorrelatedAndCorrelatedOnWhere3() {
        String sqlQuery = "SELECT * FROM x WHERE a NOT IN (SELECT c FROM y WHERE d NOT IN (SELECT f FROM z) AND x.b = y.d)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithUncorrelatedAndCorrelatedOnWhere4() {
        String sqlQuery = "SELECT * FROM x WHERE a NOT IN (SELECT c FROM y WHERE d NOT IN (SELECT f FROM z WHERE z.e = y.c))";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInWithCorrelatedOnLateralTable() {
        String sqlQuery = "SELECT * FROM l WHERE c NOT IN (SELECT f1 FROM r, LATERAL TABLE(table_func(f)) AS T(f1) WHERE a = d)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotExistsWithUncorrelatedOnWhere1() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE NOT EXISTS (SELECT * FROM y)");
    }

    @Test
    public void testNotExistsWithUncorrelatedOnWhere2() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE NOT EXISTS (SELECT * FROM y where c > 0) AND a < 100");
    }

    @Test
    public void testNotExistsWithUncorrelatedOnWhere3() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE NOT (NOT (NOT EXISTS (SELECT * FROM y))) AND x.b = 10");
    }

    @Test
    public void testNotExistsWithUncorrelatedOnWhere4() {
        String sqlQuery = "SELECT * FROM x WHERE NOT EXISTS (SELECT * FROM y) OR x.b = 10";
        this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
    }

    @Test
    public void testNotExistsWithUncorrelatedOnWhere5() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE (NOT EXISTS (SELECT d FROM y)) IS TRUE");
    }

    @Test
    public void testNotExistsWithUncorrelatedOnWhere6() {
        this.util().verifyRelPlan("SELECT a FROM x WHERE NOT EXISTS (SELECT x.b IS NULL FROM y)");
    }

    @Test
    public void testNotExistsWithUncorrelatedOnWhere7() {
        this.util().verifyRelPlan("SELECT * FROM l WHERE (NOT EXISTS (SELECT d FROM r)) = true");
    }

    @Test
    public void testNotExistsWithUncorrelatedOnWhere_UnsupportedCondition() {
        String sqlQuery = "SELECT * FROM l WHERE (NOT EXISTS (SELECT d FROM r)) IS NOT NULL";
        this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
    }

    @Test
    public void testMultiNotExistsWithUncorrelatedOnWhere_AND1() {
        String sqlQuery = "SELECT * FROM x, y WHERE x.a = y.c AND NOT EXISTS (SELECT * FROM z z1 WHERE z1.e > 50) AND b >= 1 AND NOT EXISTS (SELECT * FROM z z2 WHERE z2.f < 100)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiNotExistsWithUncorrelatedOnWhere_AND2() {
        String sqlQuery = "SELECT * FROM x, y WHERE x.a = y.c AND NOT EXISTS (SELECT * FROM z z1 WHERE z1.e > 50) AND NOT (b >= 1 AND NOT EXISTS (SELECT * FROM z z2 WHERE z2.f < 100))";
        this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
    }

    @Test
    public void testMultiNotExistsWithUncorrelatedOnWhere_OR() {
        String sqlQuery = "SELECT * FROM l, r WHERE l.a = r.d AND (NOT EXISTS (SELECT * FROM t t1 WHERE t1.k > 50) OR NOT EXISTS (SELECT * FROM t t2 WHERE t2.j < 100))";
        this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
    }

    @Test
    public void testNotExistsWithUncorrelatedOnLateralTable() {
        String sqlQuery = "SELECT * FROM l WHERE NOT EXISTS (SELECT * FROM r, LATERAL TABLE(table_func(f)) AS T(f1))";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotExistsWithCorrelatedOnWhere1() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE NOT EXISTS (SELECT * FROM y WHERE a = c)");
    }

    @Test
    public void testNotExistsWithCorrelatedOnWhere2() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE NOT EXISTS (SELECT * FROM y WHERE a = c) AND x.a > 2");
    }

    @Test
    public void testNotExistsWithCorrelatedOnWhere3() {
        String sqlQuery = "SELECT * FROM x WHERE NOT EXISTS (SELECT 1, c + d, c + 2, d FROM y WHERE a = c)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotExistsWithCorrelatedOnWhere4() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE NOT EXISTS (SELECT * FROM y WHERE x.a = c and x.b > 10)");
    }

    @Test
    public void testNotExistsWithCorrelatedOnWhere5() {
        String sqlQuery = "SELECT x1.a FROM x x1, y WHERE x1.b = y.d AND x1.a < 10 AND y.c < 15  AND NOT EXISTS (SELECT * FROM x x2 WHERE x1.b = x2.b)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotExistsWithCorrelatedOnWhere6() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE NOT EXISTS (SELECT * FROM y WHERE x.a < y.c)");
    }

    @Test
    public void testNotExistsWithCorrelatedOnWhere7() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE (NOT EXISTS (SELECT d FROM y WHERE y.d = x.b)) IS TRUE");
    }

    @Test
    public void testNotExistsWithCorrelatedOnWhere8() {
        this.util().verifyRelPlan("SELECT a FROM x WHERE NOT EXISTS (SELECT x.a IS NULL FROM y WHERE y.d = x.b)");
    }

    @Test
    public void testNotExistsWithCorrelatedOnWhere9() {
        this.util().verifyRelPlan("SELECT * FROM x WHERE (NOT EXISTS (SELECT d FROM y WHERE y.d = x.b)) = true");
    }

    @Test
    public void testNotExistsWithCorrelatedOnWhere_UnsupportedCondition() {
        String sqlQuery1 = "SELECT * FROM x WHERE NOT EXISTS (SELECT * FROM y WHERE x.a = y.c OR y.c = 10)";
        this.util().verifyRelPlanNotExpected(sqlQuery1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
        String sqlQuery2 = "SELECT * FROM x WHERE NOT EXISTS (SELECT * FROM y WHERE x.a = y.c OR x.b = 10)";
        this.util().verifyRelPlanNotExpected(sqlQuery2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
        String sqlQuery3 = "SELECT * FROM x WHERE NOT EXISTS (SELECT * FROM y WHERE x.a = y.c) OR x.b = 10";
        this.util().verifyRelPlanNotExpected(sqlQuery3, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
        String sqlQuery4 = "SELECT * FROM x WHERE (NOT EXISTS (SELECT d FROM y WHERE y.d = x.b)) IS NOT NULL";
        this.util().verifyRelPlanNotExpected(sqlQuery4, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
    }

    @Test
    public void testNotExistsWithCorrelatedOnWhere_UnsupportedCondition2() {
        String sqlQuery = "SELECT * FROM l WHERE NOT EXISTS  (SELECT * FROM (SELECT * FROM r WHERE r.d = l.a AND r.e > 100) s LEFT JOIN t ON s.f = t.k AND l.b = t.j)";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> this.util().verifyRelPlan(sqlQuery));
    }

    @Test
    public void testMultiNotExistsWithCorrelatedOnWhere_NestedCorrelation() {
        String sqlQuery = "SELECT * FROM (SELECT 2 + a d2, 3 + b d3 FROM l) e WHERE NOT EXISTS (SELECT 1 FROM (SELECT d + 1 d1 FROM r) d WHERE d1 = e.d2 AND NOT EXISTS (SELECT 2 FROM (SELECT i + 4 d4, i + 5 d5, i + 6 d6 FROM t) WHERE d4 = d.d1 AND d5 = d.d1 AND d6 = e.d3))";
        this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
    }

    @Test
    public void testMultiNotExistsWithCorrelatedOnWhere_AND1() {
        String sqlQuery = "SELECT * FROM l, r WHERE l.a = r.d AND NOT EXISTS (SELECT * FROM t t1 WHERE l.b = t1.j AND t1.k > 50) AND c >= 1 AND NOT EXISTS (SELECT * FROM t t2 WHERE l.a = t2.i AND t2.j < 100)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiNotExistsWithCorrelatedOnWhere_AND2() {
        String sqlQuery = "SELECT * FROM l, r WHERE l.a = r.d AND NOT EXISTS (SELECT * FROM t t1 WHERE l.b = t1.j AND t1.k > 50) AND (c >= 1 AND NOT EXISTS (SELECT * FROM t t2 WHERE l.a = t2.i AND t2.j < 100))";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiNotExistsWithCorrelatedOnWhere_AND3() {
        String sqlQuery = "SELECT * FROM l, r WHERE l.a = r.d AND NOT EXISTS (SELECT * FROM t t1 WHERE l.b = t1.j AND t1.k > 50) AND NOT (c >= 1 AND NOT EXISTS (SELECT * FROM t t2 WHERE l.a = t2.i AND t2.j < 100))";
        this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
    }

    @Test
    public void testMultiNotExistsWithCorrelatedOnWhere_OR() {
        String sqlQuery = "SELECT * FROM l, r WHERE l.a = r.d AND (NOT EXISTS (SELECT * FROM t t1 WHERE l.b = t1.j AND t1.k > 50) OR NOT EXISTS (SELECT * FROM t t2 WHERE l.a = t2.i AND t2.j < 100))";
        this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"}));
    }

    @Test
    public void testMultiNotExistsWithUncorrelatedAndCorrelatedOnWhere1() {
        String sqlQuery = "SELECT * FROM l WHERE NOT EXISTS (SELECT * FROM r) AND NOT EXISTS (SELECT * FROM t WHERE l.a = t.i AND t.j < 100)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiNotExistsWithUncorrelatedAndCorrelatedOnWhere2() {
        String sqlQuery = "SELECT * FROM l WHERE NOT EXISTS (SELECT * FROM r WHERE l.a <> r.d) AND NOT EXISTS (SELECT * FROM t WHERE j < 100)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiNotExistsWithUncorrelatedAndCorrelatedOnWhere3() {
        String sqlQuery = "SELECT * FROM l WHERE NOT EXISTS (SELECT * FROM r WHERE NOT EXISTS (SELECT * FROM t) AND l.a = r.d)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiNotExistsWithUncorrelatedAndCorrelatedOnWhere4() {
        String sqlQuery = "SELECT * FROM l WHERE NOT EXISTS (SELECT * FROM r WHERE NOT EXISTS (SELECT * FROM t WHERE r.d = t.i))";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotExistsWithCorrelatedOnLateralTable() {
        String sqlQuery = "SELECT * FROM l WHERE NOT EXISTS (SELECT * FROM r, LATERAL TABLE(table_func(f)) AS T(f1) WHERE a = d)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInNotExists1() {
        String sqlQuery = "SELECT * FROM l WHERE NOT EXISTS (SELECT * FROM r WHERE l.a = r.d) AND a NOT IN (SELECT i FROM t WHERE l.b = t.j)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInNotExists2() {
        String sqlQuery = "SELECT * FROM l WHERE b NOT IN (SELECT j FROM t)  AND NOT EXISTS (SELECT * FROM r WHERE l.a = r.d)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNotInNotExists3() {
        this.util().addTableSource("t2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "l")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "m")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "n"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.plan.rules.logical.subquery.SubQueryAntiJoinTest$$anon$16 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = "SELECT c FROM l WHERE ( (CASE WHEN NOT EXISTS (SELECT * FROM t WHERE l.a = t.i) THEN 1 ELSE 2 END),  (CASE WHEN b NOT IN (SELECT m FROM t2) THEN 3 ELSE 4 END))   NOT IN (SELECT d, e FROM r)";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"})));
    }

    @Test
    public void testInNotInExistsNotExists1() {
        this.util().addTableSource("t2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "l")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "m")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "n"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$17 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.planner.plan.rules.logical.subquery.SubQueryAntiJoinTest$$anon$17 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = "SELECT * FROM l WHERE a IN (SELECT d FROM r)  AND b NOT IN (SELECT i FROM t WHERE l.c = t.k AND i > 10)  AND EXISTS (SELECT COUNT(l) FROM t2 where n like 'Test' GROUP BY l) AND NOT EXISTS (SELECT * FROM r WHERE l.b <> r.e)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testInNotInExistsNotExists2() {
        this.util().addTableSource("t2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "l")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "m")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "n"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$18 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$9[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$9(org.apache.flink.table.planner.plan.rules.logical.subquery.SubQueryAntiJoinTest$$anon$18 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = "SELECT c FROM l WHERE ( (CASE WHEN b IN (SELECT j FROM t WHERE l.a = t.i) THEN 1 ELSE 2 END),  (CASE WHEN NOT EXISTS (SELECT m FROM t2) THEN 3        WHEN EXISTS (select i FROM t) THEN 4 ELSE 5 END))   NOT IN (SELECT d, e FROM r)";
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinType=[anti]"})));
    }

    public SubQueryAntiJoinTest() {
        this.util().addTableSource("l", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.subquery.SubQueryAntiJoinTest$$anon$10 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("r", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.rules.logical.subquery.SubQueryAntiJoinTest$$anon$11 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("t", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "j")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "k"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.rules.logical.subquery.SubQueryAntiJoinTest$$anon$12 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("x", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}), new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.rules.logical.subquery.SubQueryAntiJoinTest$$anon$13 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("y", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.plan.rules.logical.subquery.SubQueryAntiJoinTest$$anon$14 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("z", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}), new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.plan.rules.logical.subquery.SubQueryAntiJoinTest$$anon$15 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTemporarySystemFunction("table_func", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
    }
}

