/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical.subquery;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.rules.logical.subquery.SubQueryTestBase;
import org.apache.flink.table.planner.plan.rules.logical.subquery.SubqueryCorrelateVariablesValidationTest$;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple9;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00113A!\u0001\u0002\u0001+\tA3+\u001e2rk\u0016\u0014\u0018pQ8se\u0016d\u0017\r^3WCJL\u0017M\u00197fgZ\u000bG.\u001b3bi&|g\u000eV3ti*\u00111\u0001B\u0001\tgV\u0014\u0017/^3ss*\u0011QAB\u0001\bY><\u0017nY1m\u0015\t9\u0001\"A\u0003sk2,7O\u0003\u0002\n\u0015\u0005!\u0001\u000f\\1o\u0015\tYA\"A\u0004qY\u0006tg.\u001a:\u000b\u00055q\u0011!\u0002;bE2,'BA\b\u0011\u0003\u00151G.\u001b8l\u0015\t\t\"#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ai\u0011AA\u0005\u00033\t\u0011\u0001cU;c#V,'/\u001f+fgR\u0014\u0015m]3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002CA\f\u0001\u0011\u0015y\u0002\u0001\"\u0001!\u0003}!Xm\u001d;XSRD\u0007K]8kK\u000e$\bK]8kK\u000e$8i\u001c:sK2\fG/\u001a\u000b\u0002CA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t!QK\\5uQ\tq\u0002\u0006\u0005\u0002*a5\t!F\u0003\u0002,Y\u0005\u0019\u0011\r]5\u000b\u00055r\u0013a\u00026va&$XM\u001d\u0006\u0003_I\tQA[;oSRL!!\r\u0016\u0003\tQ+7\u000f\u001e\u0005\u0006g\u0001!\t\u0001I\u0001\u001fi\u0016\u001cHoV5uQB\u0013xN[3di\u001aKG\u000e^3s\u0007>\u0014(/\u001a7bi\u0016D#A\r\u0015\t\u000bY\u0002A\u0011\u0001\u0011\u00029Q,7\u000f^,ji\"\u0004&o\u001c6fGRTu.\u001b8D_J\u0014X\r\\1uK\"\u0012Q\u0007\u000b\u0005\u0006s\u0001!\t\u0001I\u0001\u001ci\u0016\u001cHoV5uQ\u001aKG\u000e^3s\u0015>LgnQ8se\u0016d\u0017\r^3)\u0005aB\u0003\"\u0002\u001f\u0001\t\u0003\u0001\u0013!\u0007;fgR<\u0016\u000e\u001e5GS2$XM]%o\u0007>\u0014(/\u001a7bi\u0016D#a\u000f\u0015\t\u000b}\u0002A\u0011\u0001\u0011\u0002;Q,7\u000f^,ji\"4\u0015\u000e\u001c;fe\u0016C\u0018n\u001d;t\u0007>\u0014(/\u001a7bi\u0016D#A\u0010\u0015\t\u000b\t\u0003A\u0011\u0001\u0011\u0002AQ,7\u000f^,ji\"\u0004&o\u001c6fGR\u001c\u0015m]3XQ\u0016t7i\u001c:sK2\fG/\u001a\u0015\u0003\u0003\"\u0002")
public class SubqueryCorrelateVariablesValidationTest
extends SubQueryTestBase {
    @Test
    public void testWithProjectProjectCorrelate() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT (SELECT min(t1.t1d) FROM t3 WHERE t3.t3a = 'test') min_t1d\n        |FROM   t1\n        |WHERE  t1a = 'test'\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testWithProjectFilterCorrelate() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT (SELECT min(t3d) FROM t3 WHERE t3.t3a = t1.t1a) min_t3d,\n        |       (SELECT max(t2h) FROM t2 WHERE t2.t2a = t1.t1a) max_t2h\n        |FROM   t1\n        |    WHERE  t1a = 'test'\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testWithProjectJoinCorrelate() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT (SELECT max(t2h) FROM t2\n        |    LEFT OUTER JOIN t1 ttt\n        |    ON t2.t2a=t1.t1a) max_t2h\n        |FROM t1\n        |    WHERE  t1a = 'val1b'\n      ")).stripMargin();
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.util().verifyRelPlan(sqlQuery));
    }

    @Test
    public void testWithFilterJoinCorrelate() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1a\n        |FROM   t1\n        |WHERE  EXISTS (SELECT max(t2h) FROM t2\n        |               LEFT OUTER JOIN t1 ttt\n        |               ON t2.t2a=t1.t1a)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testWithFilterInCorrelate() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM t1\n        |WHERE t1a\n        |IN (SELECT t3a\n        |    FROM t3\n        |    WHERE t1.t1e\n        |    IN (select t2e from t2))\n      ")).stripMargin();
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyRelPlan(sqlQuery));
    }

    @Test
    public void testWithFilterExistsCorrelate() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM t1\n        |WHERE EXISTS (SELECT *\n        |              FROM t3\n        |              WHERE EXISTS(select * from t3 WHERE t1.t1a = t3.t3a))\n      ")).stripMargin();
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyRelPlan(sqlQuery));
    }

    @Test
    public void testWithProjectCaseWhenCorrelate() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    (CASE WHEN EXISTS (SELECT min(t3d)\n        |                       FROM t3\n        |                       WHERE t3.t3a = t1.t1a)\n        |     THEN 1 ELSE 2 END)\n        |FROM   t1\n        |    WHERE  t1a = 'test'\n      ")).stripMargin();
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> this.util().verifyRelPlan(sqlQuery));
    }

    public SubqueryCorrelateVariablesValidationTest() {
        this.util().addTableSource("t1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t1a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t1b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t1c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t1d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t1e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t1f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t1g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t1h")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t1i"))}), new CaseClassTypeInfo<Tuple9<String, Object, Object, Object, Object, Object, BigDecimal, Timestamp, Date>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple9<String, Object, Object, Object, Object, Object, BigDecimal, Timestamp, Date>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple9<String, Object, Object, Object, Object, Object, BigDecimal, Timestamp, Date>> unused = new ScalaCaseClassSerializer<Tuple9<String, Object, Object, Object, Object, Object, BigDecimal, Timestamp, Date>>(this, fieldSerializers){

                    public Tuple9<String, Object, Object, Object, Object, Object, BigDecimal, Timestamp, Date> createInstance(Object[] fields) {
                        return new Tuple9((Object)((String)fields[0]), (Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[4])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])), (Object)((BigDecimal)fields[6]), (Object)((Timestamp)fields[7]), (Object)((Date)fields[8]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple9<String, Object, Object, Object, Object, Object, BigDecimal, Timestamp, Date>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.subquery.SubqueryCorrelateVariablesValidationTest$$anon$4 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("t2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t2a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t2b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t2c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t2d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t2e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t2f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t2g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t2h")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t2i"))}), new CaseClassTypeInfo<Tuple9<String, Object, Object, Object, Object, Object, BigDecimal, Timestamp, Date>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple9<String, Object, Object, Object, Object, Object, BigDecimal, Timestamp, Date>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple9<String, Object, Object, Object, Object, Object, BigDecimal, Timestamp, Date>> unused = new ScalaCaseClassSerializer<Tuple9<String, Object, Object, Object, Object, Object, BigDecimal, Timestamp, Date>>(this, fieldSerializers){

                    public Tuple9<String, Object, Object, Object, Object, Object, BigDecimal, Timestamp, Date> createInstance(Object[] fields) {
                        return new Tuple9((Object)((String)fields[0]), (Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[4])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])), (Object)((BigDecimal)fields[6]), (Object)((Timestamp)fields[7]), (Object)((Date)fields[8]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple9<String, Object, Object, Object, Object, Object, BigDecimal, Timestamp, Date>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.rules.logical.subquery.SubqueryCorrelateVariablesValidationTest$$anon$5 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("t3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t3a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t3b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t3c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t3d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t3e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t3f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t3g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t3h")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t3i"))}), new CaseClassTypeInfo<Tuple9<String, Object, Object, Object, Object, Object, BigDecimal, Timestamp, Date>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple9<String, Object, Object, Object, Object, Object, BigDecimal, Timestamp, Date>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple9<String, Object, Object, Object, Object, Object, BigDecimal, Timestamp, Date>> unused = new ScalaCaseClassSerializer<Tuple9<String, Object, Object, Object, Object, Object, BigDecimal, Timestamp, Date>>(this, fieldSerializers){

                    public Tuple9<String, Object, Object, Object, Object, Object, BigDecimal, Timestamp, Date> createInstance(Object[] fields) {
                        return new Tuple9((Object)((String)fields[0]), (Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[4])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])), (Object)((BigDecimal)fields[6]), (Object)((Timestamp)fields[7]), (Object)((Date)fields[8]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple9<String, Object, Object, Object, Object, Object, BigDecimal, Timestamp, Date>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.rules.logical.subquery.SubqueryCorrelateVariablesValidationTest$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

