/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.batch;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.PlannerConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.calcite.CalciteConfig$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkRuleSetProgram;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchExecSortAggRuleForOnePhase$;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchPhysicalSortAggRule$;
import org.apache.flink.table.planner.plan.rules.physical.batch.EnforceLocalAggRuleTestBase;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y2A!\u0001\u0002\u0001+\tYRI\u001c4pe\u000e,Gj\\2bYN{'\u000f^!hOJ+H.\u001a+fgRT!a\u0001\u0003\u0002\u000b\t\fGo\u00195\u000b\u0005\u00151\u0011\u0001\u00039isNL7-\u00197\u000b\u0005\u001dA\u0011!\u0002:vY\u0016\u001c(BA\u0005\u000b\u0003\u0011\u0001H.\u00198\u000b\u0005-a\u0011a\u00029mC:tWM\u001d\u0006\u0003\u001b9\tQ\u0001^1cY\u0016T!a\u0004\t\u0002\u000b\u0019d\u0017N\\6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001815\t!!\u0003\u0002\u001a\u0005\tYRI\u001c4pe\u000e,Gj\\2bY\u0006;wMU;mKR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005]\u0001\u0001\"B\u0010\u0001\t\u0003\u0002\u0013!B:fiV\u0004H#A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\tUs\u0017\u000e\u001e\u0015\u0003=!\u0002\"!\u000b\u0019\u000e\u0003)R!a\u000b\u0017\u0002\u0007\u0005\u0004\u0018N\u0003\u0002.]\u00059!.\u001e9ji\u0016\u0014(BA\u0018\u0013\u0003\u0015QWO\\5u\u0013\t\t$F\u0001\u0006CK\u001a|'/Z#bG\"DQa\r\u0001\u0005\u0002\u0001\n\u0001\u0005^3tiJ{G\u000e\\;q/&$\b.\u00168nKJ<W-\u00192mK\u0006;wmQ1mY\"\u0012!'\u000e\t\u0003SYJ!a\u000e\u0016\u0003\tQ+7\u000f\u001e\u0005\u0006s\u0001!\t\u0001I\u0001\u001fi\u0016\u001cHoQ;cK^KG\u000f[+o[\u0016\u0014x-Z1cY\u0016\fumZ\"bY2D#\u0001O\u001b\t\u000bq\u0002A\u0011\u0001\u0011\u0002GQ,7\u000f^$s_V\u00048+\u001a;t/&$\b.\u00168nKJ<W-\u00192mK\u0006;wmQ1mY\"\u00121(\u000e")
public class EnforceLocalSortAggRuleTest
extends EnforceLocalAggRuleTestBase {
    @Override
    @BeforeEach
    public void setup() {
        super.setup();
        this.util().addTemporarySystemFunction("weightedAvg", (UserDefinedFunction)new JavaUserDefinedAggFunctions.WeightedAvg());
        FlinkChainedProgram program = FlinkBatchProgram$.MODULE$.buildProgram((ReadableConfig)this.util().tableEnv().getConfig());
        ((FlinkRuleSetProgram)program.getFlinkRuleSetProgram(FlinkBatchProgram$.MODULE$.PHYSICAL()).get()).remove(RuleSets.ofList((RelOptRule[])new RelOptRule[]{BatchPhysicalSortAggRule$.MODULE$.INSTANCE()}));
        ((FlinkRuleSetProgram)program.getFlinkRuleSetProgram(FlinkBatchProgram$.MODULE$.PHYSICAL()).get()).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{BatchExecSortAggRuleForOnePhase$.MODULE$.INSTANCE()}));
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.util().tableEnv().getConfig());
        calciteConfig = CalciteConfig$.MODULE$.createBuilder(calciteConfig).replaceBatchProgram(program).build();
        this.util().tableEnv().getConfig().setPlannerConfig((PlannerConfig)calciteConfig);
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashAgg");
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)"TWO_PHASE");
    }

    @Test
    public void testRollupWithUnmergeableAggCall() {
        this.util().verifyRelPlan("SELECT weightedAvg(a, 1) FROM t GROUP BY ROLLUP (b, c)");
    }

    @Test
    public void testCubeWithUnmergeableAggCall() {
        this.util().verifyRelPlan("SELECT weightedAvg(d, 1) FROM t GROUP BY CUBE (a, b)");
    }

    @Test
    public void testGroupSetsWithUnmergeableAggCall() {
        this.util().verifyRelPlan("select weightedAvg(a, 1) FROM t GROUP BY GROUPING SETS ((b, c), (b, d))");
    }
}

