/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkStreamProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkVolcanoProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.optimize.program.StreamOptimizeContext;
import org.apache.flink.table.planner.plan.rules.logical.FlinkCalcMergeRule$;
import org.apache.flink.table.planner.plan.rules.physical.FlinkExpandConversionRule$;
import org.apache.flink.table.planner.plan.rules.physical.stream.ExpandWindowTableFunctionTransposeRule$;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamPhysicalCalcRule$;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamPhysicalExpandRule$;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamPhysicalTableSourceScanRule$;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamPhysicalWatermarkAssignerRule$;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamPhysicalWindowAggregateRule$;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamPhysicalWindowTableFunctionRule$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%3A!\u0001\u0002\u0001+\tQS\t\u001f9b]\u0012<\u0016N\u001c3poR\u000b'\r\\3Gk:\u001cG/[8o)J\fgn\u001d9pg\u0016\u0014V\u000f\\3UKN$(BA\u0002\u0005\u0003\u0019\u0019HO]3b[*\u0011QAB\u0001\ta\"L8/[2bY*\u0011q\u0001C\u0001\u0006eVdWm\u001d\u0006\u0003\u0013)\tA\u0001\u001d7b]*\u00111\u0002D\u0001\ba2\fgN\\3s\u0015\tia\"A\u0003uC\ndWM\u0003\u0002\u0010!\u0005)a\r\\5oW*\u0011\u0011CE\u0001\u0007CB\f7\r[3\u000b\u0003M\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0005eQ\u0011!B;uS2\u001c\u0018BA\u000e\u0019\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011A\u0001\u0005\bE\u0001\u0011\r\u0011\"\u0003$\u0003\u0011)H/\u001b7\u0016\u0003\u0011\u0002\"aF\u0013\n\u0005\u0019B\"aE*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0015\u0001A\u0003%A%A\u0003vi&d\u0007\u0005C\u0003+\u0001\u0011\u00051&A\u0003tKR,\b\u000fF\u0001-!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0011)f.\u001b;)\u0005%\u001a\u0004C\u0001\u001b<\u001b\u0005)$B\u0001\u001c8\u0003\r\t\u0007/\u001b\u0006\u0003qe\nqA[;qSR,'O\u0003\u0002;%\u0005)!.\u001e8ji&\u0011A(\u000e\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0007\"\u0002 \u0001\t\u0003Y\u0013a\b;fgR$V/\u001c2mK~#\u0015n\u001d;j]\u000e$8\u000b\u001d7ji\u0016s\u0017M\u00197fI\"\u0012Q\b\u0011\t\u0003i\u0005K!AQ\u001b\u0003\tQ+7\u000f\u001e\u0005\u0006\t\u0002!\taK\u0001\u001di\u0016\u001cH\u000fS8q?\u0012K7\u000f^5oGR\u001c\u0006\u000f\\5u\u000b:\f'\r\\3eQ\t\u0019\u0005\tC\u0003H\u0001\u0011\u00051&A\u0011uKN$8)^7vY\u0006$Xm\u0018#jgRLgn\u0019;Ta2LG/\u00128bE2,G\r\u000b\u0002G\u0001\u0002")
public class ExpandWindowTableFunctionTransposeRuleTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().buildStreamProgram(FlinkStreamProgram$.MODULE$.PHYSICAL());
        FlinkChainedProgram<StreamOptimizeContext> chainedProgram = this.util().getStreamProgram();
        chainedProgram.addLast(FlinkStreamProgram$.MODULE$.PHYSICAL(), (FlinkOptimizeProgram)FlinkVolcanoProgramBuilder$.MODULE$.newBuilder().add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{FlinkExpandConversionRule$.MODULE$.STREAM_INSTANCE(), StreamPhysicalWindowTableFunctionRule$.MODULE$.INSTANCE(), StreamPhysicalWindowAggregateRule$.MODULE$.INSTANCE(), StreamPhysicalCalcRule$.MODULE$.INSTANCE(), StreamPhysicalExpandRule$.MODULE$.INSTANCE(), StreamPhysicalTableSourceScanRule$.MODULE$.INSTANCE(), StreamPhysicalWatermarkAssignerRule$.MODULE$.INSTANCE()})).setRequiredOutputTraits((RelTrait[])((Object[])new RelTrait[]{FlinkConventions$.MODULE$.STREAM_PHYSICAL()})).build());
        chainedProgram.addLast("test_rule", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_COLLECTION()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{FlinkCalcMergeRule$.MODULE$.STREAM_PHYSICAL_INSTANCE(), ExpandWindowTableFunctionTransposeRule$.MODULE$.INSTANCE()})).build());
        this.util().replaceStreamProgram(chainedProgram);
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE MyTable (\n                                |  a INT,\n                                |  b BIGINT,\n                                |  c STRING NOT NULL,\n                                |  d DECIMAL(10, 3),\n                                |  e BIGINT,\n                                |  rowtime TIMESTAMP(3),\n                                |  proctime as PROCTIME(),\n                                |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n                                |) with (\n                                |  'connector' = 'values'\n                                |)\n                                |")).stripMargin());
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    @Test
    public void testTumble_DistinctSplitEnabled() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testHop_DistinctSplitEnabled() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |   HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCumulate_DistinctSplitEnabled() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   a,\n        |   window_start,\n        |   window_end,\n        |   count(*),\n        |   sum(d),\n        |   max(d) filter (where b > 1000),\n        |   count(distinct c) AS uv\n        |FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |GROUP BY a, window_start, window_end\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }
}

