/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.planner.factories.TableFactoryHarness;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PushCalcPastChangelogNormalizeRuleTest
extends TableTestBase {
    private StreamTableTestUtil util;

    PushCalcPastChangelogNormalizeRuleTest() {
    }

    @BeforeEach
    void before() {
        this.util = this.streamTestUtil(TableConfig.getDefault());
    }

    @Test
    void testWithSinglePrimaryKeyFilter() {
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).column("f1", DataTypes.INT().notNull()).primaryKey(new String[]{"f1"}).build()).unboundedScanSource(ChangelogMode.upsert()).build();
        this.util.tableEnv().createTable("T", sourceDescriptor);
        this.util.verifyRelPlan("SELECT * FROM T WHERE f1 < 1");
    }

    @Test
    void testWithMultipleFilters() {
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).column("f1", DataTypes.INT().notNull()).column("f2", (AbstractDataType)DataTypes.STRING()).primaryKey(new String[]{"f1"}).build()).unboundedScanSource(ChangelogMode.upsert()).build();
        this.util.tableEnv().createTable("T", sourceDescriptor);
        this.util.verifyRelPlan("SELECT f1, SUM(f1) AS `sum` FROM T WHERE f1 < 10 AND (f1 > 3 OR f2 IS NULL) GROUP BY f1");
    }

    @Test
    void testWithMultiplePrimaryKeyColumns() {
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).column("f1", DataTypes.INT().notNull()).column("f2", DataTypes.BIGINT().notNull()).primaryKey(new String[]{"f1", "f2"}).build()).unboundedScanSource(ChangelogMode.upsert()).build();
        this.util.tableEnv().createTable("T", sourceDescriptor);
        this.util.verifyRelPlan("SELECT f0, f1 FROM T WHERE (f1 < 1 OR f2 > 10) AND f0 IS NOT NULL");
    }

    @Test
    void testOnlyProjection() {
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).column("f1", DataTypes.INT().notNull()).column("f2", DataTypes.STRING().notNull()).primaryKey(new String[]{"f1"}).build()).unboundedScanSource(ChangelogMode.upsert()).build();
        this.util.tableEnv().createTable("T", sourceDescriptor);
        this.util.verifyRelPlan("SELECT f1, f2 FROM T");
    }

    @Test
    void testFilterAndProjection() {
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).column("f1", DataTypes.INT().notNull()).column("f2", DataTypes.BIGINT().notNull()).column("f3", (AbstractDataType)DataTypes.STRING()).column("f4", DataTypes.BIGINT().notNull()).column("f5", DataTypes.BIGINT().notNull()).column("f6", DataTypes.BIGINT().notNull()).column("f7", DataTypes.BIGINT().notNull()).primaryKey(new String[]{"f1", "f2"}).build()).unboundedScanSource(ChangelogMode.upsert()).build();
        this.util.tableEnv().createTable("T", sourceDescriptor);
        this.util.verifyRelPlan("SELECT f1, f5 FROM T WHERE (f1 < 1 OR f2 > 10) AND f3 IS NOT NULL");
    }

    @Test
    void testPartialPrimaryKeyFilterAndProjection() {
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).column("f1", DataTypes.INT().notNull()).column("f2", DataTypes.BIGINT().notNull()).column("f3", (AbstractDataType)DataTypes.STRING()).column("f4", DataTypes.BIGINT().notNull()).column("f5", DataTypes.BIGINT().notNull()).column("f6", DataTypes.BIGINT().notNull()).column("f7", DataTypes.BIGINT().notNull()).primaryKey(new String[]{"f1", "f2"}).build()).unboundedScanSource(ChangelogMode.upsert()).build();
        this.util.tableEnv().createTable("T", sourceDescriptor);
        this.util.verifyRelPlan("SELECT f1, f5 FROM T WHERE f1 < 1 AND f3 IS NOT NULL");
    }
}

