/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.stream.sql.CalcTest$;
import org.apache.flink.table.planner.plan.utils.MyPojo;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001B\u0001\u0003\u0001M\u0011\u0001bQ1mGR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\tYA\"A\u0003uC\ndWM\u0003\u0002\u000e\u001d\u0005)a\r\\5oW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0005]A\u0011!B;uS2\u001c\u0018BA\r\u0017\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003\u0011)H/\u001b7\u0016\u0003\t\u0002\"!F\u0012\n\u0005\u00112\"aE*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0014\u0001A\u0003%!%A\u0003vi&d\u0007\u0005C\u0003)\u0001\u0011\u0005\u0011&A\u0003tKR,\b\u000fF\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0011)f.\u001b;)\u0005\u001d\n\u0004C\u0001\u001a:\u001b\u0005\u0019$B\u0001\u001b6\u0003\r\t\u0007/\u001b\u0006\u0003m]\nqA[;qSR,'O\u0003\u00029!\u0005)!.\u001e8ji&\u0011!h\r\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0007\"\u0002\u001f\u0001\t\u0003I\u0013a\u0004;fgR|e\u000e\\=Qe>TWm\u0019;)\u0005mr\u0004C\u0001\u001a@\u0013\t\u00015G\u0001\u0003UKN$\b\"\u0002\"\u0001\t\u0003I\u0013!\u0006;fgR\u0004&o\u001c6fGR<\u0016\u000e\u001e5OC6Lgn\u001a\u0015\u0003\u0003zBQ!\u0012\u0001\u0005\u0002%\n\u0011\u0003^3ti6+H\u000e^5Qe>TWm\u0019;tQ\t!e\bC\u0003I\u0001\u0011\u0005\u0011&\u0001\buKN$xJ\u001c7z\r&dG/\u001a:)\u0005\u001ds\u0004\"B&\u0001\t\u0003I\u0013!\u0006;fgR$\u0015n\u001d6v]\u000e$\u0018N^3GS2$XM\u001d\u0015\u0003\u0015zBQA\u0014\u0001\u0005\u0002%\nQ\u0003^3ti\u000e{gN[;oGRLg/\u001a$jYR,'\u000f\u000b\u0002N}!)\u0011\u000b\u0001C\u0001S\u0005\u0001B/Z:u\u001bVdG/\u001b$jYR,'o\u001d\u0015\u0003!zBQ\u0001\u0016\u0001\u0005\u0002%\nA\u0003^3tiB\u0013xN[3di\u0006sGMR5mi\u0016\u0014\bFA*?\u0011\u00159\u0006\u0001\"\u0001*\u0003\u0019!Xm\u001d;J]\"\u0012aK\u0010\u0005\u00065\u0002!\t!K\u0001\u001ci\u0016\u001cHOR5mi\u0016\u0014xJ\u001c(p]\u0006\u001b8-[5MSR,'/\u00197)\u0005es\u0004\"B/\u0001\t\u0003I\u0013!\u0003;fgRtu\u000e^%oQ\taf\bC\u0003a\u0001\u0011\u0005\u0011&\u0001\fuKN$X*\u001e7uSBdWM\u00127biR,g.\u001b8hQ\tyf\bC\u0003d\u0001\u0011\u0005\u0011&A\tuKN$\u0018J\u001c<bY&$g)[3mIND#A\u0019 \t\u000b\u0019\u0004A\u0011A\u0015\u0002)Q,7\u000f\u001e)sS6LG/\u001b<f\u001b\u0006\u0004H+\u001f9fQ\t)g\bC\u0003j\u0001\u0011\u0005\u0011&A\fuKN$hj\u001c8Qe&l\u0017\u000e^5wK6\u000b\u0007\u000fV=qK\"\u0012\u0001N\u0010\u0005\u0006Y\u0002!\t!K\u0001\fi\u0016\u001cHOU8x)f\u0004X\r\u000b\u0002l}!)q\u000e\u0001C\u0001S\u0005iA/Z:u\u0003J\u0014\u0018-\u001f+za\u0016D#A\u001c \t\u000bI\u0004A\u0011A\u0015\u0002/Q,7\u000f\u001e)s_*,7\r^,ji\"$\u0015\r^3UsB,\u0007FA9?\u0011\u0015)\b\u0001\"\u0001*\u0003Y!Xm\u001d;GS2$XM],ji\"$\u0015\r^3UsB,\u0007F\u0001;?\u0011\u0015A\b\u0001\"\u0001*\u00031!Xm\u001d;Q_*|G+\u001f9fQ\t9h\bC\u0003|\u0001\u0011\u0005\u0011&A\u0007uKN$X*\u001b=fIRK\b/\u001a\u0015\u0003uzBQA \u0001\u0005\u0002%\n\u0011\u0004^3ti>\u0013x+\u001b;i\u0013NtU\u000f\u001c7Qe\u0016$\u0017nY1uK\"\u0012QP\u0010\u0005\u0007\u0003\u0007\u0001A\u0011A\u0015\u0002)Q,7\u000f^(s/&$\b.S:Ok2d\u0017J\\%gQ\r\t\tA\u0010\u0005\u0007\u0003\u0013\u0001A\u0011A\u0015\u0002MQ,7\u000f\u001e#fG&l\u0017\r\\!se\u0006Lx+\u001b;i\t&4g-\u001a:f]R\u0004&/Z2jg&|g\u000eK\u0002\u0002\byBa!a\u0004\u0001\t\u0003I\u0013\u0001\n;fgR$UmY5nC2l\u0015\r],ji\"$\u0015N\u001a4fe\u0016tG\u000f\u0015:fG&\u001c\u0018n\u001c8)\u0007\u00055a\b\u0003\u0004\u0002\u0016\u0001!\t!K\u0001&i\u0016\u001cHoQ1mG6+'oZ3XSRDgj\u001c8EKR,'/\\5oSN$\u0018nY#yaJD3!a\u0005?\u0011\u0019\tY\u0002\u0001C\u0001S\u00051C/Z:u\u0007\u0006d7-T3sO\u0016<\u0016\u000e\u001e5O_:$U\r^3s[&t\u0017n\u001d;jG\u0016C\bO\u001d\u001a)\u0007\u0005ea\b")
public class CalcTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.CalcTest$$anon$9 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTemporarySystemFunction("random_udf", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.NonDeterministicUdf());
    }

    @Test
    public void testOnlyProject() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable");
    }

    @Test
    public void testProjectWithNaming() {
        this.util().verifyExecPlan("SELECT `1-_./\u00dc`, b, c FROM (SELECT a as `1-_./\u00dc`, b, c FROM MyTable)");
    }

    @Test
    public void testMultiProjects() {
        this.util().verifyExecPlan("SELECT c FROM (SELECT a, c FROM MyTable)");
    }

    @Test
    public void testOnlyFilter() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE b > 0");
    }

    @Test
    public void testDisjunctiveFilter() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE a < 10 OR a > 20");
    }

    @Test
    public void testConjunctiveFilter() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE a < 10 AND b > 20");
    }

    @Test
    public void testMultiFilters() {
        this.util().verifyExecPlan("SELECT * FROM (SELECT * FROM MyTable WHERE b > 0) t WHERE a < 50");
    }

    @Test
    public void testProjectAndFilter() {
        this.util().verifyExecPlan("SELECT a, b + 1 FROM MyTable WHERE b > 2");
    }

    @Test
    public void testIn() {
        String sql = "SELECT * FROM MyTable WHERE b IN (1, 3, 4, 5, 6) AND c = 'xx'";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testFilterOnNonAsciiLiteral() {
        String sql = "SELECT a, b, c, c || TRIM(' \u4e16\u754c ') FROM MyTable WHERE c = '\u4f60\u597d'";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testNotIn() {
        String sql = "SELECT * FROM MyTable WHERE b NOT IN (1, 3, 4, 5, 6) OR c = 'xx'";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMultipleFlattening() {
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>> unused = new ScalaCaseClassSerializer<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>>(this, fieldSerializers){

                    public Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((Tuple2)fields[0]), (Object)((Tuple2)fields[1]), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.plan.stream.sql.CalcTest$$anon$10 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().verifyExecPlan("SELECT MyTable2.a.*, c, MyTable2.b.* FROM MyTable2");
    }

    @Test
    public void testInvalidFields() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().tableEnv().sqlQuery("SELECT a, foo FROM MyTable"));
    }

    @Test
    public void testPrimitiveMapType() {
        this.util().verifyExecPlan("SELECT MAP[b, 30, 10, a] FROM MyTable");
    }

    @Test
    public void testNonPrimitiveMapType() {
        this.util().verifyExecPlan("SELECT MAP[a, c] FROM MyTable");
    }

    @Test
    public void testRowType() {
        this.util().verifyExecPlan("SELECT ROW(1, 'Hi', a) FROM MyTable");
    }

    @Test
    public void testArrayType() {
        this.util().verifyExecPlan("SELECT ARRAY['Hi', 'Hello', c] FROM MyTable");
    }

    @Test
    public void testProjectWithDateType() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c,\n        | DATE '1984-07-12',\n        | TIME '14:34:24',\n        | TIMESTAMP '1984-07-12 14:34:24'\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testFilterWithDateType() {
        this.util().addTableSource("MyTable3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple4<Object, Date, Time, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Date, Time, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Date, Time, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Date, Time, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Date, Time, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((Date)fields[1]), (Object)((Time)fields[2]), (Object)((Timestamp)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple4<Object, Date, Time, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.plan.stream.sql.CalcTest$$anon$15 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable3\n        |WHERE b = DATE '1984-07-12' AND c = TIME '14:34:24' AND d = TIMESTAMP '1984-07-12 14:34:24'\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testPojoType() {
        this.util().addTableSource("MyTable4", (TypeInformation[])((Object[])new TypeInformation[]{TypeExtractor.createTypeInfo(MyPojo.class)}), (String[])((Object[])new String[]{"a"}));
        this.util().verifyExecPlan("SELECT a FROM MyTable4");
    }

    @Test
    public void testMixedType() {
        this.util().addTableSource("MyTable5", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple3<String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((Timestamp)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.planner.plan.stream.sql.CalcTest$$anon$16 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().verifyExecPlan("SELECT ROW(a, b, c), ARRAY[12, b], MAP[a, c] FROM MyTable5 WHERE (a, b, c) = ('foo', 12, TIMESTAMP '1984-07-12 14:34:24')");
    }

    @Test
    public void testOrWithIsNullPredicate() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 10 OR a IS NULL");
    }

    @Test
    public void testOrWithIsNullInIf() {
        this.util().verifyExecPlan("SELECT IF(c = '' OR c IS NULL, 'a', 'b') FROM MyTable");
    }

    @Test
    public void testDecimalArrayWithDifferentPrecision() {
        this.util().verifyExecPlan("SELECT ARRAY[0.12, 0.5, 0.99]");
    }

    @Test
    public void testDecimalMapWithDifferentPrecision() {
        this.util().verifyExecPlan("SELECT MAP['a', 0.12, 'b', 0.5]");
    }

    @Test
    public void testCalcMergeWithNonDeterministicExpr() {
        String sqlQuery = "SELECT a, a1 FROM (SELECT a, random_udf(b) AS a1 FROM MyTable) t WHERE a1 > 10";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeWithNonDeterministicExpr2() {
        String sqlQuery = "SELECT a FROM (SELECT a, b FROM MyTable) t WHERE random_udf(b) > 10";
        this.util().verifyRelPlan(sqlQuery);
    }
}

