/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.optimize.RelNodeBlockPlanBuilder$;
import org.apache.flink.table.planner.plan.stream.sql.DagOptimizationTest$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableFunc1;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.sinks.RetractStreamTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sinks.UpsertStreamTableSink;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u0001M\u00111\u0003R1h\u001fB$\u0018.\\5{CRLwN\u001c+fgRT!a\u0001\u0003\u0002\u0007M\fHN\u0003\u0002\u0006\r\u000511\u000f\u001e:fC6T!a\u0002\u0005\u0002\tAd\u0017M\u001c\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\t\u0003\u0015)H/\u001b7t\u0013\tIbCA\u0007UC\ndW\rV3ti\n\u000b7/\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAq\u0001\t\u0001C\u0002\u0013%\u0011%\u0001\u0003vi&dW#\u0001\u0012\u0011\u0005U\u0019\u0013B\u0001\u0013\u0017\u0005M\u0019FO]3b[R\u000b'\r\\3UKN$X\u000b^5m\u0011\u00191\u0003\u0001)A\u0005E\u0005)Q\u000f^5mA!9\u0001\u0006\u0001b\u0001\n\u0003I\u0013AB*U%&su)F\u0001+!\tY\u0003'D\u0001-\u0015\tic&A\u0004m_\u001eL7-\u00197\u000b\u0005=R\u0011!\u0002;za\u0016\u001c\u0018BA\u0019-\u0005-1\u0016M]\"iCJ$\u0016\u0010]3\t\rM\u0002\u0001\u0015!\u0003+\u0003\u001d\u0019FKU%O\u000f\u0002Bq!\u000e\u0001C\u0002\u0013\u0005a'\u0001\u0003M\u001f:;U#A\u001c\u0011\u0005-B\u0014BA\u001d-\u0005)\u0011\u0015nZ%oiRK\b/\u001a\u0005\u0007w\u0001\u0001\u000b\u0011B\u001c\u0002\u000b1{ej\u0012\u0011\t\u000fu\u0002!\u0019!C\u0001}\u0005\u0019\u0011J\u0014+\u0016\u0003}\u0002\"a\u000b!\n\u0005\u0005c#aB%oiRK\b/\u001a\u0005\u0007\u0007\u0002\u0001\u000b\u0011B \u0002\t%sE\u000b\t\u0005\u0006\u000b\u0002!\tAR\u0001\u0010i\u0016\u001cHoU5oO2,7+\u001b8lcQ\tq\t\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015J\u0001\u0003V]&$\bF\u0001#O!\tye+D\u0001Q\u0015\t\t&+A\u0002ba&T!a\u0015+\u0002\u000f),\b/\u001b;fe*\u0011Q\u000bE\u0001\u0006UVt\u0017\u000e^\u0005\u0003/B\u0013A\u0001V3ti\")\u0011\f\u0001C\u0001\r\u0006yA/Z:u'&tw\r\\3TS:\\'\u0007\u000b\u0002Y\u001d\")A\f\u0001C\u0001\r\u0006yA/Z:u'&tw\r\\3TS:\\7\u0007\u000b\u0002\\\u001d\")q\f\u0001C\u0001\r\u0006yA/Z:u'&tw\r\\3TS:\\G\u0007\u000b\u0002_\u001d\")!\r\u0001C\u0001\r\u00061B/Z:u'&tw\r\\3TS:\\w+\u001b;i+\u0012#f\t\u000b\u0002b\u001d\")Q\r\u0001C\u0001\r\u0006QB/Z:u'&tw\r\\3TS:\\7\u000b\u001d7ji>sWK\\5p]\"\u0012AM\u0014\u0005\u0006Q\u0002!\tAR\u0001\u0010i\u0016\u001cH/T;mi&\u001c\u0016N\\6tc!\u0012qM\u0014\u0005\u0006W\u0002!\tAR\u0001\u0010i\u0016\u001cH/T;mi&\u001c\u0016N\\6te!\u0012!N\u0014\u0005\u0006]\u0002!\tAR\u0001\u0010i\u0016\u001cH/T;mi&\u001c\u0016N\\6tg!\u0012QN\u0014\u0005\u0006c\u0002!\tAR\u0001\u0010i\u0016\u001cH/T;mi&\u001c\u0016N\\6ti!\u0012\u0001O\u0014\u0005\u0006i\u0002!\tAR\u0001\u0010i\u0016\u001cH/T;mi&\u001c\u0016N\\6tk!\u00121O\u0014\u0005\u0006o\u0002!\tAR\u0001\u0017i\u0016\u001cH/T;mi&\u001c\u0016N\\6t/&$\b.\u0016#U\r\"\u0012aO\u0014\u0005\u0006u\u0002!\tAR\u0001\u001ci\u0016\u001cH/T;mi&\u001c\u0016N\\6t'Bd\u0017\u000e^(o+:LwN\\\u0019)\u0005et\u0005\"B?\u0001\t\u00031\u0015a\u0007;fgRlU\u000f\u001c;j'&t7n]*qY&$xJ\\+oS>t'\u0007\u000b\u0002}\u001d\"1\u0011\u0011\u0001\u0001\u0005\u0002\u0019\u000b1\u0004^3ti6+H\u000e^5TS:\\7o\u00159mSR|e.\u00168j_:\u001c\u0004FA@O\u0011\u0019\t9\u0001\u0001C\u0001\r\u0006YB/Z:u\u001bVdG/[*j].\u001c8\u000b\u001d7ji>sWK\\5p]RB3!!\u0002O\u0011\u0019\ti\u0001\u0001C\u0001\r\u0006)C/Z:u+:LwN\\!oI\u0006;wmV5uQ\u0012KgMZ3sK:$xI]8va&twm\u001d\u0015\u0004\u0003\u0017q\u0005BBA\n\u0001\u0011\u0005a)\u0001\u0014uKN$X\u000b\u001d3bi\u0016\f5OU3ue\u0006\u001cGoQ8ogVlW\rZ!u'&t7N\u00117pG.D3!!\u0005O\u0011\u0019\tI\u0002\u0001C\u0001\r\u0006AC/Z:u+B$\u0017\r^3BgJ+GO]1di\u000e{gn];nK\u0012\fEoU8ve\u000e,'\t\\8dW\"\u001a\u0011q\u0003(\t\r\u0005}\u0001\u0001\"\u0001G\u0003M!Xm\u001d;Nk2$\u0018\u000eT3wK24\u0016.Z<tQ\r\tiB\u0014\u0005\u0007\u0003K\u0001A\u0011\u0001$\u0002'Q,7\u000f^*iCJ,G-\u00168j_:tu\u000eZ3)\u0007\u0005\rb\n")
public class DagOptimizationTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
    private final VarCharType STRING;
    private final BigIntType LONG;
    private final IntType INT;

    private StreamTableTestUtil util() {
        return this.util;
    }

    public VarCharType STRING() {
        return this.STRING;
    }

    public BigIntType LONG() {
        return this.LONG;
    }

    public IntType INT() {
        return this.INT;
    }

    @Test
    public void testSingleSink1() {
        Table table = this.util().tableEnv().sqlQuery("SELECT c, COUNT(a) AS cnt FROM MyTable GROUP BY c");
        RetractStreamTableSink<Row> retractSink = this.util().createRetractTableSink((String[])((Object[])new String[]{"c", "cnt"}), (LogicalType[])((Object[])new LogicalType[]{this.STRING(), this.LONG()}));
        this.util().verifyRelPlanInsert(table, (TableSink<?>)retractSink, "retractSink", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testSingleSink2() {
        Table table1 = this.util().tableEnv().sqlQuery("SELECT a as a1, b FROM MyTable WHERE a <= 10");
        this.util().tableEnv().createTemporaryView("table1", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT a, b, c FROM MyTable WHERE a >= 0");
        this.util().tableEnv().createTemporaryView("table2", table2);
        Table table3 = this.util().tableEnv().sqlQuery("SELECT a AS a2, c FROM table2 WHERE b >= 5");
        this.util().tableEnv().createTemporaryView("table3", table3);
        Table table4 = this.util().tableEnv().sqlQuery("SELECT a AS a3, c as c1 FROM table2 WHERE b < 5");
        this.util().tableEnv().createTemporaryView("table4", table4);
        Table table5 = this.util().tableEnv().sqlQuery("SELECT a1, b, c as c2 FROM table1, table3 WHERE a1 = a2");
        this.util().tableEnv().createTemporaryView("table5", table5);
        Table table6 = this.util().tableEnv().sqlQuery("SELECT a1, b, c1 FROM table4, table5 WHERE a1 = a3");
        AppendStreamTableSink<Row> appendSink = this.util().createAppendTableSink((String[])((Object[])new String[]{"a1", "b", "c1"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG(), this.STRING()}));
        this.util().verifyRelPlanInsert(table6, (TableSink<?>)appendSink, "appendSink", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testSingleSink3() {
        this.util().addDataStream("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}), new CaseClassTypeInfo<Tuple5<Object, Object, String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, String, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, String, Object, Object>>(this, fieldSerializers){

                    public Tuple5<Object, Object, String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[3])), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[4])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple5<Object, Object, String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.DagOptimizationTest$$anon$12 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table table1 = this.util().tableEnv().sqlQuery("SELECT a AS a1, b as b1 FROM MyTable WHERE a <= 10");
        this.util().tableEnv().createTemporaryView("table1", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT a, b1 FROM table1, MyTable2 WHERE a = a1");
        this.util().tableEnv().createTemporaryView("table2", table2);
        Table table3 = this.util().tableEnv().sqlQuery("SELECT * FROM table1 UNION ALL SELECT * FROM table2");
        AppendStreamTableSink<Row> appendSink = this.util().createAppendTableSink((String[])((Object[])new String[]{"a1", "b1"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG()}));
        this.util().verifyRelPlanInsert(table3, (TableSink<?>)appendSink, "appendSink", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testSingleSink4() {
        Table table1 = this.util().tableEnv().sqlQuery("SELECT a as a1, b FROM MyTable WHERE a <= 10");
        this.util().tableEnv().createTemporaryView("table1", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT a, b, c FROM MyTable WHERE a >= 0");
        this.util().tableEnv().createTemporaryView("table2", table2);
        Table table3 = this.util().tableEnv().sqlQuery("SELECT a AS a2, c FROM table2 WHERE b >= 5");
        this.util().tableEnv().createTemporaryView("table3", table3);
        Table table4 = this.util().tableEnv().sqlQuery("SELECT a AS a3, c AS c1 FROM table2 WHERE b < 5");
        this.util().tableEnv().createTemporaryView("table4", table4);
        Table table5 = this.util().tableEnv().sqlQuery("SELECT a1, b, c AS c2 from table1, table3 WHERE a1 = a2");
        this.util().tableEnv().createTemporaryView("table5", table5);
        Table table6 = this.util().tableEnv().sqlQuery("SELECT a3, b as b1, c1 FROM table4, table5 WHERE a1 = a3");
        this.util().tableEnv().createTemporaryView("table6", table6);
        Table table7 = this.util().tableEnv().sqlQuery("SELECT a1, b1, c1 FROM table1, table6 WHERE a1 = a3");
        AppendStreamTableSink<Row> appendSink = this.util().createAppendTableSink((String[])((Object[])new String[]{"a", "b", "c"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG(), this.STRING()}));
        this.util().verifyRelPlanInsert(table7, (TableSink<?>)appendSink, "appendSink", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testSingleSinkWithUDTF() {
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "j")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "k")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "l")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "m"))}), new CaseClassTypeInfo<Tuple5<Object, Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple5<Object, Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[4])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple5<Object, Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.stream.sql.DagOptimizationTest$$anon$13 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTemporarySystemFunction("split", (UserDefinedFunction)new TableFunc1());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |select * from\n        |    (SELECT * FROM MyTable, MyTable1, MyTable2 WHERE b = e AND a = i) t,\n        |    LATERAL TABLE(split(c)) as T(s)\n      ")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(sqlQuery);
        AppendStreamTableSink<Row> appendSink = this.util().createAppendTableSink((String[])((Object[])new String[]{"a", "b", "c", "d", "e", "f", "i", "j", "k", "l", "m", "s"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG(), this.STRING(), this.INT(), this.LONG(), this.STRING(), this.INT(), this.LONG(), this.INT(), this.STRING(), this.LONG(), this.STRING()}));
        this.util().verifyRelPlanInsert(table, (TableSink<?>)appendSink, "appendSink", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testSingleSinkSplitOnUnion() {
        this.util().tableEnv().getConfig().set(RelNodeBlockPlanBuilder$.MODULE$.TABLE_OPTIMIZER_UNIONALL_AS_BREAKPOINT_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        String sqlQuery = "SELECT SUM(a) AS total_sum FROM (SELECT a, c FROM MyTable UNION ALL SELECT d, f FROM MyTable1)";
        Table table = this.util().tableEnv().sqlQuery(sqlQuery);
        RetractStreamTableSink<Row> retractSink = this.util().createRetractTableSink((String[])((Object[])new String[]{"total_sum"}), (LogicalType[])((Object[])new LogicalType[]{this.INT()}));
        this.util().verifyRelPlanInsert(table, (TableSink<?>)retractSink, "retractSink", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMultiSinks1() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        this.util().tableEnv().getConfig().set(RelNodeBlockPlanBuilder$.MODULE$.TABLE_OPTIMIZER_REUSE_OPTIMIZE_BLOCK_WITH_DIGEST_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        Table table1 = this.util().tableEnv().sqlQuery("SELECT SUM(a) AS sum_a, c FROM MyTable GROUP BY c");
        this.util().tableEnv().createTemporaryView("table1", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT SUM(sum_a) AS total_sum FROM table1");
        Table table3 = this.util().tableEnv().sqlQuery("SELECT MIN(sum_a) AS total_min FROM table1");
        RetractStreamTableSink<Row> retractSink1 = this.util().createRetractTableSink((String[])((Object[])new String[]{"total_sum"}), (LogicalType[])((Object[])new LogicalType[]{this.INT()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("retractSink1", retractSink1);
        stmtSet.addInsert("retractSink1", table2);
        RetractStreamTableSink<Row> retractSink2 = this.util().createRetractTableSink((String[])((Object[])new String[]{"total_min"}), (LogicalType[])((Object[])new LogicalType[]{this.INT()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("retractSink2", retractSink2);
        stmtSet.addInsert("retractSink2", table3);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMultiSinks2() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        this.util().tableEnv().getConfig().set(RelNodeBlockPlanBuilder$.MODULE$.TABLE_OPTIMIZER_UNIONALL_AS_BREAKPOINT_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}), new CaseClassTypeInfo<Tuple5<Object, Object, String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, String, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, String, Object, Object>>(this, fieldSerializers){

                    public Tuple5<Object, Object, String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[3])), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[4])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple5<Object, Object, String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.plan.stream.sql.DagOptimizationTest$$anon$14 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table table1 = this.util().tableEnv().sqlQuery("SELECT a as a1, b as b1 FROM MyTable WHERE a <= 10");
        this.util().tableEnv().createTemporaryView("table1", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT a, b1 from table1, MyTable2 where a = a1");
        this.util().tableEnv().createTemporaryView("table2", table2);
        Table table3 = this.util().tableEnv().sqlQuery("SELECT * FROM table1 UNION ALL SELECT * FROM table2");
        AppendStreamTableSink<Row> appendSink1 = this.util().createAppendTableSink((String[])((Object[])new String[]{"a", "b1"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("appendSink1", appendSink1);
        stmtSet.addInsert("appendSink1", table3);
        AppendStreamTableSink<Row> appendSink2 = this.util().createAppendTableSink((String[])((Object[])new String[]{"a", "b1"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("appendSink2", appendSink2);
        stmtSet.addInsert("appendSink2", table3);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMultiSinks3() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        this.util().tableEnv().getConfig().set(RelNodeBlockPlanBuilder$.MODULE$.TABLE_OPTIMIZER_UNIONALL_AS_BREAKPOINT_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}), new CaseClassTypeInfo<Tuple5<Object, Object, String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, String, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, String, Object, Object>>(this, fieldSerializers){

                    public Tuple5<Object, Object, String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[3])), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[4])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple5<Object, Object, String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.plan.stream.sql.DagOptimizationTest$$anon$15 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table table1 = this.util().tableEnv().sqlQuery("SELECT a AS a1, b AS b1 FROM MyTable WHERE a <= 10");
        this.util().tableEnv().createTemporaryView("table1", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT a, b1 FROM table1, MyTable2 WHERE a = a1");
        this.util().tableEnv().createTemporaryView("table2", table2);
        Table table3 = this.util().tableEnv().sqlQuery("SELECT * FROM table1 UNION ALL SELECT * FROM table2");
        AppendStreamTableSink<Row> appendSink1 = this.util().createAppendTableSink((String[])((Object[])new String[]{"a", "b1"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("appendSink1", appendSink1);
        stmtSet.addInsert("appendSink1", table2);
        AppendStreamTableSink<Row> appendSink2 = this.util().createAppendTableSink((String[])((Object[])new String[]{"a", "b1"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("appendSink2", appendSink2);
        stmtSet.addInsert("appendSink2", table3);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMultiSinks4() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        Table table1 = this.util().tableEnv().sqlQuery("SELECT a as a1, b FROM MyTable WHERE a <= 10");
        this.util().tableEnv().createTemporaryView("table1", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT a, b, c FROM MyTable WHERE a >= 0");
        this.util().tableEnv().createTemporaryView("table2", table2);
        Table table3 = this.util().tableEnv().sqlQuery("SELECT a as a2, c FROM table2 WHERE b >= 5");
        this.util().tableEnv().createTemporaryView("table3", table3);
        Table table4 = this.util().tableEnv().sqlQuery("SELECT a as a3, c as c1 FROM table2 WHERE b < 5");
        this.util().tableEnv().createTemporaryView("table4", table4);
        Table table5 = this.util().tableEnv().sqlQuery("SELECT a1, b, c as c2 FROM table1, table3 WHERE a1 = a2");
        this.util().tableEnv().createTemporaryView("table5", table5);
        Table table6 = this.util().tableEnv().sqlQuery("SELECT a1, b, c1 FROM table4, table5 WHERE a1 = a3");
        AppendStreamTableSink<Row> appendSink1 = this.util().createAppendTableSink((String[])((Object[])new String[]{"a1", "b", "c2"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG(), this.STRING()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("appendSink1", appendSink1);
        stmtSet.addInsert("appendSink1", table5);
        AppendStreamTableSink<Row> appendSink2 = this.util().createAppendTableSink((String[])((Object[])new String[]{"a1", "b", "c1"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG(), this.STRING()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("appendSink2", appendSink2);
        stmtSet.addInsert("appendSink2", table6);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMultiSinks5() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        this.util().tableEnv().getConfig().set(RelNodeBlockPlanBuilder$.MODULE$.TABLE_OPTIMIZER_REUSE_OPTIMIZE_BLOCK_WITH_DIGEST_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().addTemporarySystemFunction("random_udf", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.NonDeterministicUdf());
        Table table1 = this.util().tableEnv().sqlQuery("SELECT random_udf(a) AS a, c FROM MyTable");
        this.util().tableEnv().createTemporaryView("table1", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT SUM(a) AS total_sum FROM table1");
        Table table3 = this.util().tableEnv().sqlQuery("SELECT MIN(a) AS total_min FROM table1");
        RetractStreamTableSink<Row> retractSink1 = this.util().createRetractTableSink((String[])((Object[])new String[]{"total_sum"}), (LogicalType[])((Object[])new LogicalType[]{this.INT()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("retractSink1", retractSink1);
        stmtSet.addInsert("retractSink1", table2);
        RetractStreamTableSink<Row> retractSink2 = this.util().createRetractTableSink((String[])((Object[])new String[]{"total_min"}), (LogicalType[])((Object[])new LogicalType[]{this.INT()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("retractSink2", retractSink2);
        stmtSet.addInsert("retractSink2", table3);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMultiSinksWithUDTF() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        this.util().tableEnv().getConfig().set(RelNodeBlockPlanBuilder$.MODULE$.TABLE_OPTIMIZER_UNIONALL_AS_BREAKPOINT_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.util().addTemporarySystemFunction("split", (UserDefinedFunction)new TableFunc1());
        String sqlQuery1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT  a, b - MOD(b, 300) AS b, c FROM MyTable\n        |WHERE b >= UNIX_TIMESTAMP('${startTime}')\n      ")).stripMargin();
        Table table1 = this.util().tableEnv().sqlQuery(sqlQuery1);
        this.util().tableEnv().createTemporaryView("table1", table1);
        String sqlQuery2 = "SELECT a, b, c1 AS c FROM table1, LATERAL TABLE(split(c)) AS T(c1) WHERE c <> '' ";
        Table table2 = this.util().tableEnv().sqlQuery(sqlQuery2);
        this.util().tableEnv().createTemporaryView("table2", table2);
        String sqlQuery3 = "SELECT a, b, COUNT(DISTINCT c) AS total_c FROM table2 GROUP BY a, b";
        Table table3 = this.util().tableEnv().sqlQuery(sqlQuery3);
        this.util().tableEnv().createTemporaryView("table3", table3);
        String sqlQuery4 = "SELECT a, total_c FROM table3 UNION ALL SELECT a, 0 AS total_c FROM table1";
        Table table4 = this.util().tableEnv().sqlQuery(sqlQuery4);
        this.util().tableEnv().createTemporaryView("table4", table4);
        String sqlQuery5 = "SELECT * FROM table4 WHERE a > 50";
        Table table5 = this.util().tableEnv().sqlQuery(sqlQuery5);
        RetractStreamTableSink<Row> retractSink1 = this.util().createRetractTableSink((String[])((Object[])new String[]{"a", "total_c"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("retractSink1", retractSink1);
        stmtSet.addInsert("retractSink1", table5);
        String sqlQuery6 = "SELECT * FROM table4 WHERE a < 50";
        Table table6 = this.util().tableEnv().sqlQuery(sqlQuery6);
        RetractStreamTableSink<Row> retractSink2 = this.util().createRetractTableSink((String[])((Object[])new String[]{"a", "total_c"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("retractSink2", retractSink2);
        stmtSet.addInsert("retractSink2", table6);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMultiSinksSplitOnUnion1() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        this.util().tableEnv().getConfig().set(RelNodeBlockPlanBuilder$.MODULE$.TABLE_OPTIMIZER_UNIONALL_AS_BREAKPOINT_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        Table table = this.util().tableEnv().sqlQuery("SELECT a, c FROM MyTable UNION ALL SELECT d, f FROM MyTable1");
        this.util().tableEnv().createTemporaryView("TempTable", table);
        Table table1 = this.util().tableEnv().sqlQuery("SELECT SUM(a) AS total_sum FROM TempTable");
        UpsertStreamTableSink<RowData> upsertSink = this.util().createUpsertTableSink((int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (String[])((Object[])new String[]{"total_sum"}), (LogicalType[])((Object[])new LogicalType[]{this.INT()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("upsertSink", upsertSink);
        stmtSet.addInsert("upsertSink", table1);
        Table table3 = this.util().tableEnv().sqlQuery("SELECT MIN(a) AS total_min FROM TempTable");
        RetractStreamTableSink<Row> retractSink = this.util().createRetractTableSink((String[])((Object[])new String[]{"total_min"}), (LogicalType[])((Object[])new LogicalType[]{this.INT()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("retractSink", retractSink);
        stmtSet.addInsert("retractSink", table3);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMultiSinksSplitOnUnion2() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        this.util().tableEnv().getConfig().set(RelNodeBlockPlanBuilder$.MODULE$.TABLE_OPTIMIZER_REUSE_OPTIMIZE_BLOCK_WITH_DIGEST_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(RelNodeBlockPlanBuilder$.MODULE$.TABLE_OPTIMIZER_UNIONALL_AS_BREAKPOINT_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.plan.stream.sql.DagOptimizationTest$$anon$16 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, c FROM MyTable\n        |UNION ALL\n        |SELECT d, f FROM MyTable1\n        |UNION ALL\n        |SELECT a, c FROM MyTable2\n      ")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(sqlQuery1);
        this.util().tableEnv().createTemporaryView("TempTable", table);
        Table table1 = this.util().tableEnv().sqlQuery("SELECT SUM(a) AS total_sum FROM TempTable");
        RetractStreamTableSink<Row> retractSink1 = this.util().createRetractTableSink((String[])((Object[])new String[]{"total_sum"}), (LogicalType[])((Object[])new LogicalType[]{this.INT()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("retractSink1", retractSink1);
        stmtSet.addInsert("retractSink1", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT MIN(a) AS total_min FROM TempTable");
        RetractStreamTableSink<Row> retractSink2 = this.util().createRetractTableSink((String[])((Object[])new String[]{"total_min"}), (LogicalType[])((Object[])new LogicalType[]{this.INT()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("retractSink2", retractSink2);
        stmtSet.addInsert("retractSink2", table2);
        String sqlQuery2 = "SELECT a FROM (SELECT a, c FROM MyTable UNION ALL SELECT d, f FROM MyTable1)";
        Table table3 = this.util().tableEnv().sqlQuery(sqlQuery2);
        AppendStreamTableSink<Row> appendSink3 = this.util().createAppendTableSink((String[])((Object[])new String[]{"a"}), (LogicalType[])((Object[])new LogicalType[]{this.INT()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("appendSink3", appendSink3);
        stmtSet.addInsert("appendSink3", table3);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMultiSinksSplitOnUnion3() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        this.util().tableEnv().getConfig().set(RelNodeBlockPlanBuilder$.MODULE$.TABLE_OPTIMIZER_UNIONALL_AS_BREAKPOINT_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$17 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.planner.plan.stream.sql.DagOptimizationTest$$anon$17 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery1 = "SELECT a, c FROM MyTable UNION ALL SELECT d, f FROM MyTable1";
        Table table = this.util().tableEnv().sqlQuery(sqlQuery1);
        this.util().tableEnv().createTemporaryView("TempTable", table);
        AppendStreamTableSink<Row> appendSink = this.util().createAppendTableSink((String[])((Object[])new String[]{"a", "c"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.STRING()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("appendSink", appendSink);
        stmtSet.addInsert("appendSink", table);
        String sqlQuery2 = "SELECT a, c FROM TempTable UNION ALL SELECT a, c FROM MyTable2";
        Table table1 = this.util().tableEnv().sqlQuery(sqlQuery2);
        this.util().tableEnv().createTemporaryView("TempTable1", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT SUM(a) AS total_sum FROM TempTable1");
        RetractStreamTableSink<Row> retractSink = this.util().createRetractTableSink((String[])((Object[])new String[]{"total_sum"}), (LogicalType[])((Object[])new LogicalType[]{this.INT()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("retractSink", retractSink);
        stmtSet.addInsert("retractSink", table2);
        Table table3 = this.util().tableEnv().sqlQuery("SELECT MIN(a) AS total_min FROM TempTable1");
        UpsertStreamTableSink<RowData> upsertSink = this.util().createUpsertTableSink((int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (String[])((Object[])new String[]{"total_min"}), (LogicalType[])((Object[])new LogicalType[]{this.INT()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("upsertSink", upsertSink);
        stmtSet.addInsert("upsertSink", table3);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMultiSinksSplitOnUnion4() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        this.util().tableEnv().getConfig().set(RelNodeBlockPlanBuilder$.MODULE$.TABLE_OPTIMIZER_UNIONALL_AS_BREAKPOINT_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$18 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$9[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$9(org.apache.flink.table.planner.plan.stream.sql.DagOptimizationTest$$anon$18 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, c FROM MyTable\n        |UNION ALL\n        |SELECT d, f FROM MyTable1\n        |UNION ALL\n        |SELECT a, c FROM MyTable2\n      ")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(sqlQuery);
        this.util().tableEnv().createTemporaryView("TempTable", table);
        Table table1 = this.util().tableEnv().sqlQuery("SELECT SUM(a) AS total_sum FROM TempTable");
        UpsertStreamTableSink<RowData> upsertSink = this.util().createUpsertTableSink((int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (String[])((Object[])new String[]{"total_sum"}), (LogicalType[])((Object[])new LogicalType[]{this.INT()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("upsertSink", upsertSink);
        stmtSet.addInsert("upsertSink", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT MIN(a) AS total_min FROM TempTable");
        RetractStreamTableSink<Row> retractSink = this.util().createRetractTableSink((String[])((Object[])new String[]{"total_min"}), (LogicalType[])((Object[])new LogicalType[]{this.INT()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("retractSink", retractSink);
        stmtSet.addInsert("retractSink", table2);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testUnionAndAggWithDifferentGroupings() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c, SUM(a) AS a_sum FROM MyTable GROUP BY b, c\n        |UNION ALL\n        |SELECT 1 AS b, c, SUM(a) AS a_sum FROM MyTable GROUP BY c\n      ")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(sqlQuery);
        UpsertStreamTableSink<RowData> upsertSink = this.util().createUpsertTableSink((int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (String[])((Object[])new String[]{"b", "c", "a_sum"}), (LogicalType[])((Object[])new LogicalType[]{this.LONG(), this.STRING(), this.INT()}));
        this.util().verifyRelPlanInsert(table, (TableSink<?>)upsertSink, "upsertSink", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testUpdateAsRetractConsumedAtSinkBlock() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        Table table = this.util().tableEnv().sqlQuery("SELECT a, b, c FROM MyTable");
        this.util().tableEnv().createTemporaryView("TempTable", table);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM (\n         |  SELECT a, b, c,\n         |      ROW_NUMBER() OVER (PARTITION BY b ORDER BY c DESC) as rank_num\n         |  FROM TempTable)\n         |WHERE rank_num <= 10\n      ")).stripMargin();
        Table table1 = this.util().tableEnv().sqlQuery(sqlQuery);
        RetractStreamTableSink<Row> retractSink = this.util().createRetractTableSink((String[])((Object[])new String[]{"a", "b", "c", "rank_num"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG(), this.STRING(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("retractSink", retractSink);
        stmtSet.addInsert("retractSink", table1);
        UpsertStreamTableSink<RowData> upsertSink = this.util().createUpsertTableSink((int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (String[])((Object[])new String[]{"a", "b"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG()}));
        Table table2 = this.util().tableEnv().sqlQuery("SELECT a, b FROM TempTable WHERE a < 6");
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("upsertSink", upsertSink);
        stmtSet.addInsert("upsertSink", table2);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testUpdateAsRetractConsumedAtSourceBlock() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM (\n         |   SELECT a, b, c,\n         |      ROW_NUMBER() OVER (PARTITION BY b ORDER BY c DESC) as rank_num\n         |  FROM MyTable)\n         |WHERE rank_num <= 10\n      ")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(sqlQuery);
        this.util().tableEnv().createTemporaryView("TempTable", table);
        Table table1 = this.util().tableEnv().sqlQuery("SELECT a FROM TempTable WHERE a > 6");
        RetractStreamTableSink<Row> retractSink = this.util().createRetractTableSink((String[])((Object[])new String[]{"a"}), (LogicalType[])((Object[])new LogicalType[]{this.INT()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("retractSink", retractSink);
        stmtSet.addInsert("retractSink", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT a, b FROM TempTable WHERE a < 6");
        UpsertStreamTableSink<RowData> upsertSink = this.util().createUpsertTableSink((int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (String[])((Object[])new String[]{"a", "b"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("upsertSink", upsertSink);
        stmtSet.addInsert("upsertSink", table2);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMultiLevelViews() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        this.util().tableEnv().getConfig().set(RelNodeBlockPlanBuilder$.MODULE$.TABLE_OPTIMIZER_UNIONALL_AS_BREAKPOINT_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        Table table1 = this.util().tableEnv().sqlQuery("SELECT a, b, c FROM MyTable WHERE c LIKE '%hello%'");
        this.util().tableEnv().createTemporaryView("TempTable1", table1);
        AppendStreamTableSink<Row> appendSink = this.util().createAppendTableSink((String[])((Object[])new String[]{"a", "b", "c"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG(), this.STRING()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("appendSink", appendSink);
        stmtSet.addInsert("appendSink", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT a, b, c FROM MyTable WHERE c LIKE '%world%'");
        this.util().tableEnv().createTemporaryView("TempTable2", table2);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, COUNT(a) AS cnt FROM (\n        | (SELECT * FROM TempTable1)\n        | UNION ALL\n        | (SELECT * FROM TempTable2)\n        |) t\n        |GROUP BY b\n      ")).stripMargin();
        Table table3 = this.util().tableEnv().sqlQuery(sqlQuery);
        this.util().tableEnv().createTemporaryView("TempTable3", table3);
        Table table4 = this.util().tableEnv().sqlQuery("SELECT b, cnt FROM TempTable3 WHERE b < 4");
        RetractStreamTableSink<Row> retractSink = this.util().createRetractTableSink((String[])((Object[])new String[]{"b", "cnt"}), (LogicalType[])((Object[])new LogicalType[]{this.LONG(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("retractSink", retractSink);
        stmtSet.addInsert("retractSink", table4);
        Table table5 = this.util().tableEnv().sqlQuery("SELECT b, cnt FROM TempTable3 WHERE b >=4 AND b < 6");
        UpsertStreamTableSink<RowData> upsertSink = this.util().createUpsertTableSink((int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (String[])((Object[])new String[]{"b", "cnt"}), (LogicalType[])((Object[])new LogicalType[]{this.LONG(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("upsertSink", upsertSink);
        stmtSet.addInsert("upsertSink", table5);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testSharedUnionNode() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        this.util().tableEnv().getConfig().set(RelNodeBlockPlanBuilder$.MODULE$.TABLE_OPTIMIZER_UNIONALL_AS_BREAKPOINT_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        Table table1 = this.util().tableEnv().sqlQuery("SELECT a, b, c FROM MyTable WHERE c LIKE '%hello%'");
        this.util().tableEnv().createTemporaryView("TempTable1", table1);
        AppendStreamTableSink<Row> appendSink = this.util().createAppendTableSink((String[])((Object[])new String[]{"a", "b", "c"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG(), this.STRING()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("appendSink", appendSink);
        stmtSet.addInsert("appendSink", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT a, b, c FROM MyTable WHERE c LIKE '%world%'");
        this.util().tableEnv().createTemporaryView("TempTable2", table2);
        String sqlQuery1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM TempTable1\n        |UNION ALL\n        |SELECT * FROM TempTable2\n      ")).stripMargin();
        Table table3 = this.util().tableEnv().sqlQuery(sqlQuery1);
        this.util().tableEnv().createTemporaryView("TempTable3", table3);
        Table table4 = this.util().tableEnv().sqlQuery("SELECT * FROM TempTable3 WHERE b >= 5");
        RetractStreamTableSink<Row> retractSink1 = this.util().createRetractTableSink((String[])((Object[])new String[]{"a", "b", "c"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG(), this.STRING()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("retractSink1", retractSink1);
        stmtSet.addInsert("retractSink1", table4);
        Table table5 = this.util().tableEnv().sqlQuery("SELECT b, count(a) as cnt FROM TempTable3 GROUP BY b");
        this.util().tableEnv().createTemporaryView("TempTable4", table5);
        Table table6 = this.util().tableEnv().sqlQuery("SELECT b, cnt FROM TempTable4 WHERE b < 4");
        RetractStreamTableSink<Row> retractSink2 = this.util().createRetractTableSink((String[])((Object[])new String[]{"b", "cnt"}), (LogicalType[])((Object[])new LogicalType[]{this.LONG(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("retractSink2", retractSink2);
        stmtSet.addInsert("retractSink2", table6);
        this.util().tableEnv().sqlQuery("SELECT b, cnt FROM TempTable4 WHERE b >=4 AND b < 6");
        UpsertStreamTableSink<RowData> upsertSink = this.util().createUpsertTableSink((int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (String[])((Object[])new String[]{"b", "cnt"}), (LogicalType[])((Object[])new LogicalType[]{this.LONG(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("upsertSink", upsertSink);
        stmtSet.addInsert("upsertSink", table6);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    public DagOptimizationTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.DagOptimizationTest$$anon$10 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.DagOptimizationTest$$anon$11 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.STRING = VarCharType.STRING_TYPE;
        this.LONG = new BigIntType();
        this.INT = new IntType();
    }
}

