/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.DeduplicateTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001'\tyA)\u001a3va2L7-\u0019;f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/!\tQ!\u001e;jYNL!!\u0007\f\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0005!\u0001\u0001\u0007\t\u0019!C\u0001C\u0005!Q\u000f^5m+\u0005\u0011\u0003CA\u000b$\u0013\t!cCA\nTiJ,\u0017-\u001c+bE2,G+Z:u+RLG\u000eC\u0005'\u0001\u0001\u0007\t\u0019!C\u0001O\u0005AQ\u000f^5m?\u0012*\u0017\u000f\u0006\u0002)]A\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t!QK\\5u\u0011\u001dyS%!AA\u0002\t\n1\u0001\u001f\u00132\u0011%\t\u0004\u00011A\u0001B\u0003&!%A\u0003vi&d\u0007\u0005C\u00034\u0001\u0011\u0005A'A\u0003tKR,\u0006\u000fF\u0001)Q\t\u0011d\u0007\u0005\u00028}5\t\u0001H\u0003\u0002:u\u0005\u0019\u0011\r]5\u000b\u0005mb\u0014a\u00026va&$XM\u001d\u0006\u0003{A\tQA[;oSRL!a\u0010\u001d\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007\u000eC\u0003B\u0001\u0011\u0005A'A\u0014uKN$\u0018J\u001c<bY&$'k\\<Ok6\u0014WM]\"p]\u0012LG/[8o\u001f:\u0004&o\\2uS6,\u0007F\u0001!D!\t9D)\u0003\u0002Fq\t!A+Z:u\u0011\u00159\u0005\u0001\"\u00015\u0003\u0019\"Xm\u001d;J]Z\fG.\u001b3S_^tU/\u001c2fe\u000e{g\u000eZ5uS>twJ\u001c*poRLW.\u001a\u0015\u0003\r\u000eCQA\u0013\u0001\u0005\u0002Q\na\u0004^3ti2\u000b7\u000f\u001e*po^KG\u000f[,j]\u0012|wo\u00148S_^$\u0018.\\3)\u0005%\u001b\u0005\"B'\u0001\t\u0003!\u0014a\u0007;fgR\u001c\u0016.\u001c9mK\u001aK'o\u001d;S_^|eNU8xi&lW\r\u000b\u0002M\u0007\")\u0001\u000b\u0001C\u0001i\u0005\u0019C/Z:u\u001b&t\u0017NQ1uG\"LeNZ3s\r&\u00148\u000f\u001e*po>s'k\\<uS6,\u0007FA(D\u0011\u0015\u0019\u0006\u0001\"\u00015\u0003i!Xm\u001d;TS6\u0004H.\u001a'bgR\u0014vn^(o%><H/[7fQ\t\u00116\tC\u0003W\u0001\u0011\u0005A'\u0001\u0012uKN$X*\u001b8j\u0005\u0006$8\r[%oM\u0016\u0014H*Y:u%><xJ\u001c*poRLW.\u001a\u0015\u0003+\u000eCQ!\u0017\u0001\u0005\u0002Q\n1\u0004^3tiNKW\u000e\u001d7f\u0019\u0006\u001cHOU8x\u001f:\u0004&o\\2uS6,\u0007F\u0001-D\u0011\u0015a\u0006\u0001\"\u00015\u0003\t\"Xm\u001d;TS6\u0004H.\u001a'bgR\u0014vn^(o\u0005VLG\u000e^5o!J|7\r^5nK\"\u00121l\u0011\u0005\u0006?\u0002!\t\u0001N\u0001\u001di\u0016\u001cHoU5na2,g)\u001b:tiJ{wo\u00148Qe>\u001cG/[7fQ\tq6\tC\u0003c\u0001\u0011\u0005A'A\u0012uKN$8+[7qY\u00164\u0015N]:u%><xJ\u001c\"vS2$\u0018N\u001c)s_\u000e$\u0018.\\3)\u0005\u0005\u001c\u0005")
public class DeduplicateTest
extends TableTestBase {
    private StreamTableTestUtil util;

    public StreamTableTestUtil util() {
        return this.util;
    }

    public void util_$eq(StreamTableTestUtil x$1) {
        this.util = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.util_$eq(this.streamTestUtil(this.streamTestUtil$default$1()));
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.DeduplicateTest$$anon$2 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testInvalidRowNumberConditionOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT a, ROW_NUMBER() OVER (PARTITION BY b ORDER BY proctime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 2\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testInvalidRowNumberConditionOnRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT a, ROW_NUMBER() OVER (PARTITION BY b ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 3\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testLastRowWithWindowOnRowtime() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofMillis(500L));
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T (\n        | `a` INT,\n        | `b` STRING,\n        | `ts` TIMESTAMP(3),\n        | WATERMARK FOR `ts` AS `ts`\n        |) WITH (\n        | 'connector' = 'COLLECTION',\n        | 'is-bounded' = 'false'\n        |)\n      ")).stripMargin());
        String deduplicateSQl = new StringOps(Predef$.MODULE$.augmentString("\n        |(\n        |SELECT a, b, ts\n        |FROM (\n        |  SELECT *,\n        |    ROW_NUMBER() OVER (PARTITION BY a ORDER BY ts DESC) as rowNum\n        |  FROM T\n        |)\n        |WHERE rowNum = 1\n        |)\n      ")).stripMargin();
        String windowSql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(151).append("\n         |select b, sum(a), TUMBLE_START(ts, INTERVAL '0.004' SECOND)\n         |FROM ").append(deduplicateSQl).append("\n         |GROUP BY b, TUMBLE(ts, INTERVAL '0.004' SECOND)\n      ").toString())).stripMargin();
        this.util().verifyExplain(windowSql);
    }

    @Test
    public void testSimpleFirstRowOnRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c\n        |FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime ASC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num <= 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMiniBatchInferFirstRowOnRowtime() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)BoxesRunTime.boxToLong((long)3L));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |    a INT,\n         |    b VARCHAR,\n         |    rowtime TIMESTAMP(3),\n         |    proctime as PROCTIME(),\n         |    WATERMARK FOR rowtime AS rowtime\n         |) WITH (\n         | 'connector' = 'COLLECTION',\n         | 'is-bounded' = 'false'\n         |)\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(b) FROM (\n        |  SELECT a, b\n        |  FROM (\n        |    SELECT *,\n        |        ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime ASC) as rank_num\n        |    FROM T)\n        |  WHERE rank_num <= 1\n        |)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSimpleLastRowOnRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c\n        |FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMiniBatchInferLastRowOnRowtime() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)BoxesRunTime.boxToLong((long)3L));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |    a INT,\n         |    b VARCHAR,\n         |    rowtime TIMESTAMP(3),\n         |    proctime as PROCTIME(),\n         |    WATERMARK FOR rowtime AS rowtime\n         |) WITH (\n         | 'connector' = 'COLLECTION',\n         | 'is-bounded' = 'false'\n         |)\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(b) FROM (\n        |  SELECT a, b\n        |  FROM (\n        |    SELECT *,\n        |        ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |    FROM T)\n        |  WHERE rank_num = 1\n        |)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSimpleLastRowOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY proctime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSimpleLastRowOnBuiltinProctime() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *,\n        |    ROW_NUMBER() OVER (ORDER BY PROCTIME() DESC) as rowNum\n        |  FROM MyTable\n        |)\n        |WHERE rowNum = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSimpleFirstRowOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c\n        |FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY proctime ASC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSimpleFirstRowOnBuiltinProctime() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *,\n        |    ROW_NUMBER() OVER (PARTITION BY a ORDER BY PROCTIME() ASC) as rowNum\n        |  FROM MyTable\n        |)\n        |WHERE rowNum = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }
}

