/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.LegacySinkTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.sinks.RetractStreamTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sinks.UpsertStreamTableSink;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0001'\tqA*Z4bGf\u001c\u0016N\\6UKN$(BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\taa\u001d;sK\u0006l'BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0011\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%I!I\u0001\u0005kRLG.F\u0001#!\t)2%\u0003\u0002%-\t\u00192\u000b\u001e:fC6$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\"1a\u0005\u0001Q\u0001\n\t\nQ!\u001e;jY\u0002Bq\u0001\u000b\u0001C\u0002\u0013\u0005\u0011&\u0001\u0004T)JKejR\u000b\u0002UA\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\bY><\u0017nY1m\u0015\ty#\"A\u0003usB,7/\u0003\u00022Y\tYa+\u0019:DQ\u0006\u0014H+\u001f9f\u0011\u0019\u0019\u0004\u0001)A\u0005U\u000591\u000b\u0016*J\u001d\u001e\u0003\u0003bB\u001b\u0001\u0005\u0004%\tAN\u0001\u0005\u0019>su)F\u00018!\tY\u0003(\u0003\u0002:Y\tQ!)[4J]R$\u0016\u0010]3\t\rm\u0002\u0001\u0015!\u00038\u0003\u0015auJT$!\u0011\u001di\u0004A1A\u0005\u0002y\n1!\u0013(U+\u0005y\u0004CA\u0016A\u0013\t\tEFA\u0004J]R$\u0016\u0010]3\t\r\r\u0003\u0001\u0015!\u0003@\u0003\u0011Ie\n\u0016\u0011\t\u000b\u0015\u0003A\u0011\u0001$\u00025Q,7\u000f^#yG\u0016\u0004H/[8o\r>\u0014\u0018\t\u001d9f]\u0012\u001c\u0016N\\6\u0015\u0003\u001d\u0003\"\u0001S&\u000e\u0003%S\u0011AS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0019&\u0013A!\u00168ji\"\u0012AI\u0014\t\u0003\u001fZk\u0011\u0001\u0015\u0006\u0003#J\u000b1!\u00199j\u0015\t\u0019F+A\u0004kkBLG/\u001a:\u000b\u0005U\u0003\u0012!\u00026v]&$\u0018BA,Q\u0005\u0011!Vm\u001d;\t\u000be\u0003A\u0011\u0001$\u0002;Q,7\u000f^#yG\u0016\u0004H/[8o\r>\u0014xJ^3s\u0003\u001e<'/Z4bi\u0016D#\u0001\u0017(\t\u000bq\u0003A\u0011\u0001$\u0002\u001dQ,7\u000f^!qa\u0016tGmU5oW\"\u00121L\u0014\u0005\u0006?\u0002!\tAR\u0001\u0011i\u0016\u001cHOU3ue\u0006\u001cGoU5oWFB#A\u0018(\t\u000b\t\u0004A\u0011\u0001$\u0002!Q,7\u000f\u001e*fiJ\f7\r^*j].\u0014\u0004FA1O\u0011\u0015)\u0007\u0001\"\u0001G\u0003=!Xm\u001d;VaN,'\u000f^*j].\f\u0004F\u00013O\u0011\u0015A\u0007\u0001\"\u0001G\u0003=!Xm\u001d;VaN,'\u000f^*j].\u0014\u0004FA4O\u0011\u0015Y\u0007\u0001\"\u0001G\u0003a!Xm\u001d;VaN,'\u000f^*j].<\u0016\u000e\u001e5GS2$XM\u001d\u0015\u0003U:CQA\u001c\u0001\u0005\u0002\u0019\u000b\u0001\u0004^3tiJ+GO]1di\u0006sG-\u00169tKJ$8+\u001b8lQ\tig\nC\u0003r\u0001\u0011\u0005a)A\fuKN$X\u000b]:feR\fe\u000eZ+qg\u0016\u0014HoU5oW\"\u0012\u0001O\u0014\u0005\u0006i\u0002!\tAR\u0001\u001fi\u0016\u001cH/\u00119qK:$W\u000b]:feR\fe\u000e\u001a*fiJ\f7\r^*j].D#a\u001d(")
public class LegacySinkTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
    private final VarCharType STRING;
    private final BigIntType LONG;
    private final IntType INT;

    private StreamTableTestUtil util() {
        return this.util;
    }

    public VarCharType STRING() {
        return this.STRING;
    }

    public BigIntType LONG() {
        return this.LONG;
    }

    public IntType INT() {
        return this.INT;
    }

    @Test
    public void testExceptionForAppendSink() {
        Table table = this.util().tableEnv().sqlQuery("SELECT COUNT(*) AS cnt FROM MyTable GROUP BY a");
        AppendStreamTableSink<Row> appendSink = this.util().createAppendTableSink((String[])((Object[])new String[]{"a"}), (LogicalType[])((Object[])new LogicalType[]{this.LONG()}));
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlanInsert(table, (TableSink<?>)appendSink, "appendSink")).hasMessageContaining("AppendStreamTableSink doesn't support consuming update changes which is produced by node GroupAggregate(groupBy=[a], select=[a, COUNT(*) AS cnt])") instanceof TableException;
    }

    @Test
    public void testExceptionForOverAggregate() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        Table table = this.util().tableEnv().sqlQuery("SELECT COUNT(*) AS cnt FROM MyTable GROUP BY a");
        this.util().tableEnv().createTemporaryView("TempTable", table);
        RetractStreamTableSink<Row> retractSink = this.util().createRetractTableSink((String[])((Object[])new String[]{"cnt"}), (LogicalType[])((Object[])new LogicalType[]{this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("retractSink1", retractSink);
        stmtSet.addInsert("retractSink1", table);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT cnt, SUM(cnt) OVER (ORDER BY PROCTIME()) FROM TempTable");
        RetractStreamTableSink<Row> retractSink2 = this.util().createRetractTableSink((String[])((Object[])new String[]{"cnt", "total"}), (LogicalType[])((Object[])new LogicalType[]{this.LONG(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("retractSink2", retractSink2);
        stmtSet.addInsert("retractSink2", table2);
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(stmtSet)).hasMessageContaining("OverAggregate doesn't support consuming update changes which is produced by node Calc(select=[cnt]") instanceof TableException;
    }

    @Test
    public void testAppendSink() {
        Table table = this.util().tableEnv().sqlQuery("SELECT a + b, c FROM MyTable");
        AppendStreamTableSink<Row> appendSink = this.util().createAppendTableSink((String[])((Object[])new String[]{"d", "c"}), (LogicalType[])((Object[])new LogicalType[]{this.LONG(), this.STRING()}));
        this.util().verifyRelPlanInsert(table, (TableSink<?>)appendSink, "appendSink", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRetractSink1() {
        Table table = this.util().tableEnv().sqlQuery("SELECT a, COUNT(*) AS cnt FROM MyTable GROUP BY a");
        RetractStreamTableSink<Row> retractSink = this.util().createRetractTableSink((String[])((Object[])new String[]{"a", "cnt"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG()}));
        this.util().verifyRelPlanInsert(table, (TableSink<?>)retractSink, "retractSink", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRetractSink2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT cnt, COUNT(a) AS a FROM (\n        |    SELECT a, COUNT(*) AS cnt FROM MyTable GROUP BY a) t\n        |GROUP BY cnt\n      ")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(sqlQuery);
        RetractStreamTableSink<Row> retractSink = this.util().createRetractTableSink((String[])((Object[])new String[]{"cnt", "a"}), (LogicalType[])((Object[])new LogicalType[]{this.LONG(), this.LONG()}));
        this.util().verifyRelPlanInsert(table, (TableSink<?>)retractSink, "retractSink", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testUpsertSink1() {
        Table table = this.util().tableEnv().sqlQuery("SELECT a, COUNT(*) AS cnt FROM MyTable GROUP BY a");
        UpsertStreamTableSink<RowData> upsertSink = this.util().createUpsertTableSink(new int[]{0}, (String[])((Object[])new String[]{"a", "cnt"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG()}));
        this.util().verifyRelPlanInsert(table, (TableSink<?>)upsertSink, "upsertSink", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testUpsertSink2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |with t1 AS (SELECT a AS a1, b FROM MyTable WHERE a <= 10),\n        |     t2 AS (SELECT * from MyTable WHERE a >= 0),\n        |     t3 AS (SELECT a AS a2, c from t2 where b >= 5),\n        |     t4 AS (SELECT a AS a3, c AS c1 FROM t2 WHERE b < 5),\n        |     t5 AS (SELECT a1, b, c AS c2 FROM t1, t3 where a1 = a2)\n        |SELECT a1, b, c1 FROM t4, t5 WHERE a1 = a3\n      ")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(sqlQuery);
        UpsertStreamTableSink<RowData> upsertSink = this.util().createUpsertTableSink((int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (String[])((Object[])new String[]{"a1", "b", "c1"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG(), this.STRING()}));
        this.util().verifyRelPlanInsert(table, (TableSink<?>)upsertSink, "upsertSink", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testUpsertSinkWithFilter() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (SELECT a, COUNT(*) AS cnt FROM MyTable GROUP BY a)\n        |WHERE cnt < 10\n        |")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(sql);
        UpsertStreamTableSink<RowData> upsertSink = this.util().createUpsertTableSink(new int[]{0}, (String[])((Object[])new String[]{"a", "cnt"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG()}));
        this.util().verifyRelPlanInsert(table, (TableSink<?>)upsertSink, "upsertSink", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRetractAndUpsertSink() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        Table table = this.util().tableEnv().sqlQuery("SELECT b, COUNT(a) AS cnt FROM MyTable GROUP BY b");
        this.util().tableEnv().createTemporaryView("TempTable", table);
        Table table1 = this.util().tableEnv().sqlQuery("SELECT b, cnt FROM TempTable WHERE b < 4");
        RetractStreamTableSink<Row> retractSink = this.util().createRetractTableSink((String[])((Object[])new String[]{"b", "cnt"}), (LogicalType[])((Object[])new LogicalType[]{this.LONG(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("retractSink", retractSink);
        stmtSet.addInsert("retractSink", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT b, cnt FROM TempTable WHERE b >= 4 AND b < 6");
        UpsertStreamTableSink<RowData> upsertSink = this.util().createUpsertTableSink((int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (String[])((Object[])new String[]{"b", "cnt"}), (LogicalType[])((Object[])new LogicalType[]{this.LONG(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("upsertSink", upsertSink);
        stmtSet.addInsert("upsertSink", table2);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testUpsertAndUpsertSink() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        Table table = this.util().tableEnv().sqlQuery("SELECT b, COUNT(a) AS cnt FROM MyTable GROUP BY b");
        this.util().tableEnv().createTemporaryView("TempTable", table);
        Table table1 = this.util().tableEnv().sqlQuery("SELECT cnt, COUNT(b) AS frequency FROM TempTable WHERE b < 4 GROUP BY cnt");
        UpsertStreamTableSink<RowData> upsertSink1 = this.util().createUpsertTableSink(new int[]{0}, (String[])((Object[])new String[]{"b", "cnt"}), (LogicalType[])((Object[])new LogicalType[]{this.LONG(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("upsertSink1", upsertSink1);
        stmtSet.addInsert("upsertSink1", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT b, cnt FROM TempTable WHERE b >= 4 AND b < 6");
        UpsertStreamTableSink<RowData> upsertSink2 = this.util().createUpsertTableSink((int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (String[])((Object[])new String[]{"b", "cnt"}), (LogicalType[])((Object[])new LogicalType[]{this.LONG(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("upsertSink2", upsertSink2);
        stmtSet.addInsert("upsertSink2", table2);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testAppendUpsertAndRetractSink() {
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        this.util().addDataStream("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.LegacySinkTest$$anon$5 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "j")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "k"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.LegacySinkTest$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table table = this.util().tableEnv().sqlQuery("SELECT a, b FROM MyTable UNION ALL SELECT d, e FROM MyTable2");
        this.util().tableEnv().createTemporaryView("TempTable", table);
        AppendStreamTableSink<Row> appendSink = this.util().createAppendTableSink((String[])((Object[])new String[]{"a", "b"}), (LogicalType[])((Object[])new LogicalType[]{this.INT(), this.LONG()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("appendSink", appendSink);
        stmtSet.addInsert("appendSink", table);
        Table table1 = this.util().tableEnv().sqlQuery("SELECT a, b FROM TempTable UNION ALL SELECT i, j FROM MyTable3");
        this.util().tableEnv().createTemporaryView("TempTable1", table1);
        Table table2 = this.util().tableEnv().sqlQuery("SELECT SUM(a) AS total_sum FROM TempTable1");
        RetractStreamTableSink<Row> retractSink = this.util().createRetractTableSink((String[])((Object[])new String[]{"total_sum"}), (LogicalType[])((Object[])new LogicalType[]{this.INT()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("retractSink", retractSink);
        stmtSet.addInsert("retractSink", table2);
        Table table3 = this.util().tableEnv().sqlQuery("SELECT MIN(a) AS total_min FROM TempTable1");
        UpsertStreamTableSink<RowData> upsertSink = this.util().createUpsertTableSink((int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), (String[])((Object[])new String[]{"total_min"}), (LogicalType[])((Object[])new LogicalType[]{this.INT()}));
        ((TableEnvironmentInternal)this.util().tableEnv()).registerTableSinkInternal("upsertSink", upsertSink);
        stmtSet.addInsert("upsertSink", table3);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    public LegacySinkTest() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.LegacySinkTest$$anon$4 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.STRING = VarCharType.STRING_TYPE;
        this.LONG = new BigIntType();
        this.INT = new IntType();
    }
}

