/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.LimitTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u0001\u0003\u0001M\u0011\u0011\u0002T5nSR$Vm\u001d;\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0007gR\u0014X-Y7\u000b\u0005\u001dA\u0011\u0001\u00029mC:T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9\u0002\"A\u0003vi&d7/\u0003\u0002\u001a-\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000f\u0001\u0002!\u0019!C\tC\u0005!Q\u000f^5m+\u0005\u0011\u0003CA\u000b$\u0013\t!cCA\nTiJ,\u0017-\u001c+bE2,G+Z:u+RLG\u000e\u0003\u0004'\u0001\u0001\u0006IAI\u0001\u0006kRLG\u000e\t\u0005\u0006Q\u0001!\t!K\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t!QK\\5uQ\t9\u0013\u0007\u0005\u00023s5\t1G\u0003\u00025k\u0005\u0019\u0011\r]5\u000b\u0005Y:\u0014a\u00026va&$XM\u001d\u0006\u0003qA\tQA[;oSRL!AO\u001a\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007\u000eC\u0003=\u0001\u0011\u0005\u0011&\u0001\fuKN$H*[7ji^KG\u000f[8vi>3gm]3uQ\tYd\b\u0005\u00023\u007f%\u0011\u0001i\r\u0002\u0005)\u0016\u001cH\u000fC\u0003C\u0001\u0011\u0005\u0011&A\fuKN$H*[7jiB:\u0016\u000e\u001e5pkR|eMZ:fi\"\u0012\u0011I\u0010\u0005\u0006\u000b\u0002!\t!K\u0001\u001fi\u0016\u001cHOT3hCRLg/\u001a'j[&$x+\u001b;i_V$xJ\u001a4tKRD#\u0001\u0012 \t\u000b!\u0003A\u0011A\u0015\u0002'Q,7\u000f\u001e'j[&$x+\u001b;i\u001f\u001a47/\u001a;)\u0005\u001ds\u0004\"B&\u0001\t\u0003I\u0013\u0001\u0006;fgRd\u0015.\\5u/&$\bn\u00144gg\u0016$\b\u0007\u000b\u0002K}!)a\n\u0001C\u0001S\u0005)B/Z:u\u0019&l\u0017\u000e\u001e\u0019XSRDwJ\u001a4tKR\u0004\u0004FA'?\u0011\u0015\t\u0006\u0001\"\u0001*\u0003Q!Xm\u001d;MS6LG\u000fM,ji\"|eMZ:fi\"\u0012\u0001K\u0010\u0005\u0006)\u0002!\t!K\u0001\u001ci\u0016\u001cH\u000fT5nSR<\u0016\u000e\u001e5OK\u001e\fG/\u001b<f\u001f\u001a47/\u001a;)\u0005Ms\u0004\"B,\u0001\t\u0003I\u0013a\u0005;fgR4U\r^2i/&$\bn\u00144gg\u0016$\bF\u0001,?\u0011\u0015Q\u0006\u0001\"\u0001*\u0003Y!Xm\u001d;GKR\u001c\u0007nV5uQ>,Ho\u00144gg\u0016$\bFA-?\u0011\u0015i\u0006\u0001\"\u0001*\u0003]!Xm\u001d;GKR\u001c\u0007\u000eM,ji\"|W\u000f^(gMN,G\u000f\u000b\u0002]}!)\u0001\r\u0001C\u0001S\u0005qA/Z:u\u001f:d\u0017p\u00144gg\u0016$\bFA0?\u0011\u0015\u0019\u0007\u0001\"\u0001*\u0003Q!Xm\u001d;MS6LGoV5uQJ{w\u000fV5nK\"\u0012!M\u0010\u0005\u0006M\u0002!\t!K\u0001\u0016i\u0016\u001cH\u000fT5nSR\u0004t+\u001b;i%><H+[7fQ\t)g\bC\u0003j\u0001\u0011\u0005\u0011&A\u000buKN$xJ\u001a4tKR<\u0016\u000e\u001e5S_^$\u0016.\\3)\u0005!t\u0004\"\u00027\u0001\t\u0003I\u0013\u0001\b;fgRd\u0015.\\5ua]KG\u000f\u001b)s_\u000e,7o]5oORKW.\u001a\u0015\u0003WzBQa\u001c\u0001\u0005\u0002%\n1\u0004^3ti2KW.\u001b;XSRD\u0007K]8dKN\u001c\u0018N\\4US6,\u0007F\u00018?\u0011\u0015\u0011\b\u0001\"\u0001*\u0003q!Xm\u001d;PM\u001a\u001cX\r^,ji\"\u0004&o\\2fgNLgn\u001a+j[\u0016D#!\u001d \t\u000bU\u0004A\u0011A\u0015\u00027Q,7\u000f\u001e'j[&$\bgV5uQJ{w\u000fV5nKN+7m\u001c8eQ\t!h\bC\u0003y\u0001\u0011\u0005\u0011&\u0001\u000euKN$H*[7ji^KG\u000f\u001b*poRKW.Z*fG>tG\r\u000b\u0002x}!)1\u0010\u0001C\u0001S\u0005YB/Z:u\u001f\u001a47/\u001a;XSRD'k\\<US6,7+Z2p]\u0012D#A\u001f \t\u000by\u0004A\u0011A\u0015\u0002EQ,7\u000f\u001e'j[&$\bgV5uQB\u0013xnY3tg&tw\rV5nKN+7m\u001c8eQ\tih\b\u0003\u0004\u0002\u0004\u0001!\t!K\u0001\"i\u0016\u001cH\u000fT5nSR<\u0016\u000e\u001e5Qe>\u001cWm]:j]\u001e$\u0016.\\3TK\u000e|g\u000e\u001a\u0015\u0004\u0003\u0003q\u0004BBA\u0005\u0001\u0011\u0005\u0011&\u0001\u0012uKN$xJ\u001a4tKR<\u0016\u000e\u001e5Qe>\u001cWm]:j]\u001e$\u0016.\\3TK\u000e|g\u000e\u001a\u0015\u0004\u0003\u000fq\u0004BBA\b\u0001\u0011\u0005\u0011&A\ruKN$H*[7jiB:\u0016\u000e\u001e5S_^$\u0016.\\3EKN\u001c\u0007fAA\u0007}!1\u0011Q\u0003\u0001\u0005\u0002%\n\u0001\u0004^3ti2KW.\u001b;XSRD'k\\<US6,G)Z:dQ\r\t\u0019B\u0010\u0005\u0007\u00037\u0001A\u0011A\u0015\u00023Q,7\u000f^(gMN,GoV5uQJ{w\u000fV5nK\u0012+7o\u0019\u0015\u0004\u00033q\u0004BBA\u0011\u0001\u0011\u0005\u0011&\u0001\u0011uKN$H*[7jiB:\u0016\u000e\u001e5Qe>\u001cWm]:j]\u001e$\u0016.\\3EKN\u001c\u0007fAA\u0010}!1\u0011q\u0005\u0001\u0005\u0002%\nq\u0004^3ti2KW.\u001b;XSRD\u0007K]8dKN\u001c\u0018N\\4US6,G)Z:dQ\r\t)C\u0010\u0005\u0007\u0003[\u0001A\u0011A\u0015\u0002AQ,7\u000f^(gMN,GoV5uQB\u0013xnY3tg&tw\rV5nK\u0012+7o\u0019\u0015\u0004\u0003Wq\u0004BBA\u001a\u0001\u0011\u0005\u0011&A\u0010uKN$H*[7jiB:\u0016\u000e\u001e5S_^$\u0016.\\3EKN\u001c7+Z2p]\u0012D3!!\r?\u0011\u0019\tI\u0004\u0001C\u0001S\u0005qB/Z:u\u0019&l\u0017\u000e^,ji\"\u0014vn\u001e+j[\u0016$Um]2TK\u000e|g\u000e\u001a\u0015\u0004\u0003oq\u0004BBA \u0001\u0011\u0005\u0011&A\u0010uKN$xJ\u001a4tKR<\u0016\u000e\u001e5S_^$\u0016.\\3EKN\u001c7+Z2p]\u0012D3!!\u0010?\u0011\u0019\t)\u0005\u0001C\u0001S\u00051C/Z:u\u0019&l\u0017\u000e\u001e\u0019XSRD\u0007K]8dKN\u001c\u0018N\\4US6,G)Z:d'\u0016\u001cwN\u001c3)\u0007\u0005\rc\b\u0003\u0004\u0002L\u0001!\t!K\u0001&i\u0016\u001cH\u000fT5nSR<\u0016\u000e\u001e5Qe>\u001cWm]:j]\u001e$\u0016.\\3EKN\u001c7+Z2p]\u0012D3!!\u0013?\u0011\u0019\t\t\u0006\u0001C\u0001S\u00051C/Z:u\u001f\u001a47/\u001a;XSRD\u0007K]8dKN\u001c\u0018N\\4US6,G)Z:d'\u0016\u001cwN\u001c3)\u0007\u0005=c\b")
public class LimitTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    public StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.LimitTest$$anon$2 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testLimitWithoutOffset() {
        this.util().verifyExecPlan("SELECT * FROM MyTable LIMIT 5");
    }

    @Test
    public void testLimit0WithoutOffset() {
        this.util().verifyExecPlan("SELECT * FROM MyTable LIMIT 0");
    }

    @Test
    public void testNegativeLimitWithoutOffset() {
        Assertions.assertThatExceptionOfType(SqlParserException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT * FROM MyTable LIMIT -1"));
    }

    @Test
    public void testLimitWithOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable LIMIT 10 OFFSET 1");
    }

    @Test
    public void testLimitWithOffset0() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable LIMIT 10 OFFSET 0");
    }

    @Test
    public void testLimit0WithOffset0() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable LIMIT 0 OFFSET 0");
    }

    @Test
    public void testLimit0WithOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable LIMIT 0 OFFSET 10");
    }

    @Test
    public void testLimitWithNegativeOffset() {
        Assertions.assertThatExceptionOfType(SqlParserException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT a, c FROM MyTable LIMIT 10 OFFSET -1"));
    }

    @Test
    public void testFetchWithOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable OFFSET 10 ROWS FETCH NEXT 10 ROWS ONLY");
    }

    @Test
    public void testFetchWithoutOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable FETCH FIRST 10 ROWS ONLY");
    }

    @Test
    public void testFetch0WithoutOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable FETCH FIRST 0 ROWS ONLY");
    }

    @Test
    public void testOnlyOffset() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable OFFSET 10 ROWS");
    }

    @Test
    public void testLimitWithRowTime() {
        this.util().verifyExecPlan("SELECT rowtime, c FROM MyTable LIMIT 2");
    }

    @Test
    public void testLimit0WithRowTime() {
        this.util().verifyExecPlan("SELECT rowtime, c FROM MyTable LIMIT 0");
    }

    @Test
    public void testOffsetWithRowTime() {
        this.util().verifyExecPlan("SELECT rowtime, c FROM MyTable OFFSET 2");
    }

    @Test
    public void testLimit0WithProcessingTime() {
        this.util().verifyExecPlan("SELECT proctime, c FROM MyTable LIMIT 0");
    }

    @Test
    public void testLimitWithProcessingTime() {
        this.util().verifyExecPlan("SELECT proctime, c FROM MyTable LIMIT 2");
    }

    @Test
    public void testOffsetWithProcessingTime() {
        this.util().verifyExecPlan("SELECT proctime, c FROM MyTable OFFSET 2");
    }

    @Test
    public void testLimit0WithRowTimeSecond() {
        this.util().verifyExecPlan("SELECT c, rowtime FROM MyTable LIMIT 0");
    }

    @Test
    public void testLimitWithRowTimeSecond() {
        this.util().verifyExecPlan("SELECT c, rowtime FROM MyTable LIMIT 2");
    }

    @Test
    public void testOffsetWithRowTimeSecond() {
        this.util().verifyExecPlan("SELECT c, rowtime FROM MyTable OFFSET 2");
    }

    @Test
    public void testLimit0WithProcessingTimeSecond() {
        this.util().verifyExecPlan("SELECT c, proctime FROM MyTable LIMIT 0");
    }

    @Test
    public void testLimitWithProcessingTimeSecond() {
        this.util().verifyExecPlan("SELECT c, proctime FROM MyTable LIMIT 2");
    }

    @Test
    public void testOffsetWithProcessingTimeSecond() {
        this.util().verifyExecPlan("SELECT c, proctime FROM MyTable OFFSET 2");
    }

    @Test
    public void testLimit0WithRowTimeDesc() {
        this.util().verifyExecPlan("SELECT rowtime desc, c FROM MyTable LIMIT 0");
    }

    @Test
    public void testLimitWithRowTimeDesc() {
        this.util().verifyExecPlan("SELECT rowtime desc, c FROM MyTable LIMIT 2");
    }

    @Test
    public void testOffsetWithRowTimeDesc() {
        this.util().verifyExecPlan("SELECT rowtime desc, c FROM MyTable OFFSET 2");
    }

    @Test
    public void testLimit0WithProcessingTimeDesc() {
        this.util().verifyExecPlan("SELECT proctime desc, c FROM MyTable LIMIT 0");
    }

    @Test
    public void testLimitWithProcessingTimeDesc() {
        this.util().verifyExecPlan("SELECT proctime desc, c FROM MyTable LIMIT 2");
    }

    @Test
    public void testOffsetWithProcessingTimeDesc() {
        this.util().verifyExecPlan("SELECT proctime desc, c FROM MyTable OFFSET 2");
    }

    @Test
    public void testLimit0WithRowTimeDescSecond() {
        this.util().verifyExecPlan("SELECT c, rowtime desc FROM MyTable LIMIT 0");
    }

    @Test
    public void testLimitWithRowTimeDescSecond() {
        this.util().verifyExecPlan("SELECT c, rowtime desc FROM MyTable LIMIT 2");
    }

    @Test
    public void testOffsetWithRowTimeDescSecond() {
        this.util().verifyExecPlan("SELECT c, rowtime desc FROM MyTable OFFSET 2");
    }

    @Test
    public void testLimit0WithProcessingTimeDescSecond() {
        this.util().verifyExecPlan("SELECT c, proctime desc FROM MyTable LIMIT 0");
    }

    @Test
    public void testLimitWithProcessingTimeDescSecond() {
        this.util().verifyExecPlan("SELECT c, proctime desc FROM MyTable LIMIT 2");
    }

    @Test
    public void testOffsetWithProcessingTimeDescSecond() {
        this.util().verifyExecPlan("SELECT c, proctime desc FROM MyTable OFFSET 2");
    }
}

