/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0001\u0002\u0001'\t\u0011R*\u0019;dQJ+7m\\4oSj,G+Z:u\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\rM$(/Z1n\u0015\t9\u0001\"\u0001\u0003qY\u0006t'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003C\u0001\u0006kRLGn]\u0005\u00033Y\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\u0012\u0005\nA!\u001e;jYV\t!\u0005\u0005\u0002\u0016G%\u0011AE\u0006\u0002\u0014'R\u0014X-Y7UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007M\u0001\u0001\u000b\u0011\u0002\u0012\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b!\u0002A\u0011A\u0015\u0002\r\t,gm\u001c:f)\u0005Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#\u0001B+oSRD#aJ\u0019\u0011\u0005IJT\"A\u001a\u000b\u0005Q*\u0014aA1qS*\u0011agN\u0001\bUV\u0004\u0018\u000e^3s\u0015\tA\u0004#A\u0003kk:LG/\u0003\u0002;g\tQ!)\u001a4pe\u0016,\u0015m\u00195\t\u000bq\u0002A\u0011A\u0015\u00027Q,7\u000f^'bi\u000eD'+Z2pO:L'0Z(o%><H/[7fQ\tYd\b\u0005\u00023\u007f%\u0011\u0001i\r\u0002\u0005)\u0016\u001cH\u000fC\u0003C\u0001\u0011\u0005\u0011&\u0001\u0010uKN$X*\u0019;dQJ+7m\\4oSj,wJ\u001c*poRLW.\u001a'U5\"\u0012\u0011I\u0010\u0005\u0006\u000b\u0002!\t!K\u0001*i\u0016\u001cHoV5oI><HK\u0016$P]6\u000bGo\u00195SK\u000e|wM\\5{K>s'k\\<uS6,G\n\u0016.)\u0005\u0011s\u0004\"\u0002%\u0001\t\u0003I\u0013A\u000b;fgR|e/\u001a:XS:$wn^(o\u001b\u0006$8\r\u001b*fG><g.\u001b>f\u001f:\u0014vn\u001e;j[\u0016dEK\u0017\u0015\u0003\u000fzBQa\u0013\u0001\u0005\u0002%\n\u0001\u0003^3ti\u000e\u000b7oY1eK6\u000bGo\u00195)\u0005)s\u0004\"\u0002(\u0001\t\u0003I\u0013a\u000b;fgRl\u0015\r^2i%><H/[7f/&$\bn\\;u\u0003J<W/\\3oi>s'k\\<uS6,G\n\u0016.)\u00055s\u0004\"B)\u0001\t\u0003I\u0013\u0001\t;fgRl\u0015\r^2i%><H/[7f/&$\b.T;mi&\u0004H.Z!sOND#\u0001\u0015 \t\u000bQ\u0003A\u0011A\u0015\u0002[Q,7\u000f^'bi\u000eD'k\\<uS6,w+\u001b;i\u001d>t'k\\<US6,\u0017\t\u001e;sS\n,H/Z!t\u0003J<7\u000f\u000b\u0002T}!)q\u000b\u0001C\u0001S\u0005\u0001C/Z:u\u001b\u0006$8\r\u001b*poRLW.Z,ji\"\u0014V\r_\"bY2\f5/\u0011:hQ\t1f\b")
public class MatchRecognizeTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    public StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE Ticker (\n        | `symbol` STRING,\n        | `ts_ltz` TIMESTAMP_LTZ(3),\n        | `price` INT,\n        | `tax` INT,\n        | WATERMARK FOR `ts_ltz` AS `ts_ltz` - INTERVAL '1' SECOND\n        |) WITH (\n        | 'connector' = 'values'\n        |)\n        |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
    }

    @Test
    public void testMatchRecognizeOnRowtime() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE Ticker1 (\n        | `symbol` STRING,\n        | `ts` TIMESTAMP(3),\n        | `price` INT,\n        | `tax` INT,\n        | WATERMARK FOR `ts` AS `ts` - INTERVAL '1' SECOND\n        |) WITH (\n        | 'connector' = 'values'\n        |)\n        |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker1\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME() as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMatchRecognizeOnRowtimeLTZ() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(ts_ltz) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testWindowTVFOnMatchRecognizeOnRowtimeLTZ() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(ts_ltz) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(sqlQuery);
        this.util().tableEnv().createTemporaryView("T", table);
        String sqlQuery1 = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM TABLE(TUMBLE(TABLE T, DESCRIPTOR(matchRowtime), INTERVAL '3' second))\n         |")).stripMargin();
        this.util().verifyRelPlanWithType(sqlQuery1);
    }

    @Test
    public void testOverWindowOnMatchRecognizeOnRowtimeLTZ() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(ts_ltz) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |")).stripMargin();
        Table table = this.util().tableEnv().sqlQuery(sqlQuery);
        this.util().tableEnv().createTemporaryView("T", table);
        String sqlQuery1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  symbol,\n        |  price,\n        |  tax,\n        |  matchRowtime,\n        |  SUM(price) OVER (\n        |    PARTITION BY symbol ORDER BY matchRowtime RANGE UNBOUNDED PRECEDING) as price_sum\n        |FROM T\n    ")).stripMargin();
        this.util().verifyRelPlanWithType(sqlQuery1);
    }

    @Test
    public void testCascadeMatch() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM (\n         |  SELECT\n         |    symbol,\n         |    matchRowtime,\n         |    price,\n         |    TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |  FROM Ticker\n         |  MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(ts_ltz) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, matchRowtime, price, TUMBLE(matchRowtime, interval '3' second)\n         |)\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY matchRowtime\n         |  MEASURES\n         |    A.price as dPrice,\n         |    A.matchRowtime as matchRowtime\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.matchRowtime >= (CURRENT_TIMESTAMP - INTERVAL '1' day)\n         |)\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMatchRowtimeWithoutArgumentOnRowtimeLTZ() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME() as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(sqlQuery)).hasMessageContaining("MATCH_ROWTIME(rowtimeField) should be used when input stream contains rowtime attribute with TIMESTAMP_LTZ type.\nPlease pass rowtime attribute field as input argument of MATCH_ROWTIME(rowtimeField) function.") instanceof AssertionError;
    }

    @Test
    public void testMatchRowtimeWithMultipleArgs() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(ts_ltz, price) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(sqlQuery)).hasMessageContaining("Invalid number of arguments to function 'MATCH_ROWTIME'.") instanceof ValidationException;
    }

    @Test
    public void testMatchRowtimeWithNonRowTimeAttributeAsArgs() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(price) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(sqlQuery)).hasMessageContaining("The function MATCH_ROWTIME requires argument to be a row time attribute type, but is 'INTEGER'.") instanceof ValidationException;
    }

    @Test
    public void testMatchRowtimeWithRexCallAsArg() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(ts_ltz + INTERVAL '1' SECOND) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyRelPlan(sqlQuery)).hasMessageContaining("The function MATCH_ROWTIME requires a field reference as argument, but actual argument is not a simple field reference.") instanceof ValidationException;
    }
}

