/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.plan.stream.sql.PartitionableSourceTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001M\u0011q\u0003U1si&$\u0018n\u001c8bE2,7k\\;sG\u0016$Vm\u001d;\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0007gR\u0014X-Y7\u000b\u0005\u001dA\u0011\u0001\u00029mC:T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9\u0002\"A\u0003vi&d7/\u0003\u0002\u001a-\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016D\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u0016g>,(oY3GKR\u001c\u0007\u000eU1si&$\u0018n\u001c8t+\u0005i\u0002C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"a\u0002\"p_2,\u0017M\u001c\u0005\tI\u0001\u0011\t\u0011)A\u0005;\u000512o\\;sG\u00164U\r^2i!\u0006\u0014H/\u001b;j_:\u001c\b\u0005\u0003\u0005'\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003A)8/Z\"bi\u0006dwn\u001a$jYR,'\u000f\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003\u001e\u0003E)8/Z\"bi\u0006dwn\u001a$jYR,'\u000f\t\u0005\u0006U\u0001!\taK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00071rs\u0006\u0005\u0002.\u00015\t!\u0001C\u0003\u001cS\u0001\u0007Q\u0004C\u0003'S\u0001\u0007Q\u0004C\u00042\u0001\t\u0007I\u0011\u0002\u001a\u0002\tU$\u0018\u000e\\\u000b\u0002gA\u0011Q\u0003N\u0005\u0003kY\u00111c\u0015;sK\u0006lG+\u00192mKR+7\u000f^+uS2Daa\u000e\u0001!\u0002\u0013\u0019\u0014!B;uS2\u0004\u0003\"B\u001d\u0001\t\u0003Q\u0014!B:fiV\u0004H#A\u001e\u0011\u0005ya\u0014BA\u001f \u0005\u0011)f.\u001b;)\u0005az\u0004C\u0001!H\u001b\u0005\t%B\u0001\"D\u0003\r\t\u0007/\u001b\u0006\u0003\t\u0016\u000bqA[;qSR,'O\u0003\u0002G!\u0005)!.\u001e8ji&\u0011\u0001*\u0011\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0007\"\u0002&\u0001\t\u0003Q\u0014A\t;fgR\u001c\u0016.\u001c9mKB\u000b'\u000f^5uS>tg)[3mIB\u0013X\rZ5dCR,\u0017\u0007\u000b\u0002J\u0019B\u0011\u0001)T\u0005\u0003\u001d\u0006\u0013A\u0002V3tiR+W\u000e\u001d7bi\u0016DQ\u0001\u0015\u0001\u0005\u0002i\n!\u0006^3tiB\u000b'\u000f^5bYB\u000b'\u000f^5uS>tg)[3mIB\u0013X\rZ5dCR,\u0007+^:i\t><h\u000e\u000b\u0002P\u0019\")1\u000b\u0001C\u0001u\u0005YB/Z:u/&$\b.\u00163g\u0003:$g+\u001b:uk\u0006d7i\u001c7v[:D#A\u0015'\t\u000bY\u0003A\u0011\u0001\u001e\u00023Q,7\u000f^+oG>tg/\u001a:uK\u0012,\u0005\u0010\u001d:fgNLwN\u001c\u0015\u0003+2CQ!\u0017\u0001\u0005\u0002i\n1\u0007^3tiB+8\u000f\u001b#po:\u0004\u0016M\u001d;ji&|g.\u00118e\r&dG/\u001a:t\u0007>tG/Y5o!\u0006\u0014H/\u001b;j_:\\U-_:)\u0005ac\u0005\"\u0002/\u0001\t\u0003Q\u0014a\u0012;fgR\u0004Vo\u001d5E_^t\u0007+\u0019:uSRLwN\\!oI\u001aKG\u000e^3sg\u000e{g\u000e^1j]B\u000b'\u000f^5uS>t7*Z=t/&$\bnU5oO2,\u0007K]8kK\u000e$\u0018n\u001c8)\u0005mc\u0005\"B0\u0001\t\u0003Q\u0014\u0001\t;fgR\u0004Vo\u001d5E_^tgj\u001c8Fq&\u001cH/\u001a8u!\u0006\u0014H/\u001b;j_:D#A\u0018')\t\u0001\u0011\u0007.\u001b\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K\u0006\u000b\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\u0005\u001d$'AC#yi\u0016tGmV5uQ\u0006)a/\u00197vK2\n!nI\u0001l!\taG/D\u0001n\u0015\tqw.A\u0007qCJ\fW.\u001a;fe&TX\r\u001a\u0006\u0003aF\f!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\t1%O\u0003\u0002t\u0019\u0005IA/Z:ukRLGn]\u0005\u0003k6\u0014!\u0004U1sC6,G/\u001a:ju\u0016$G+Z:u\u000bb$XM\\:j_:<Qa\u001e\u0002\t\u0002a\fq\u0003U1si&$\u0018n\u001c8bE2,7k\\;sG\u0016$Vm\u001d;\u0011\u00055Jh!B\u0001\u0003\u0011\u0003Q8CA=|!\tqB0\u0003\u0002~?\t1\u0011I\\=SK\u001aDQAK=\u0005\u0002}$\u0012\u0001\u001f\u0005\b\u0003\u0007IH\u0011AA\u0003\u0003)\u0001\u0018M]1nKR,'o\u001d\u000b\u0003\u0003\u000f\u0001b!!\u0003\u0002\u0012\u0005UQBAA\u0006\u0015\r\t\u0014Q\u0002\u0006\u0003\u0003\u001f\tAA[1wC&!\u00111CA\u0006\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0006=\u0005]\u00111D\u0005\u0004\u00033y\"!B!se\u0006L\bc\u0001\u0010\u0002\u001e%\u0019\u0011qD\u0010\u0003\u0007\u0005s\u0017\u0010\u000b\u0005\u0002\u0002\u0005\r\u0012\u0011FA\u0016!\ra\u0017QE\u0005\u0004\u0003Oi'A\u0003)be\u0006lW\r^3sg\u0006!a.Y7fC\t\ti#A\u0018t_V\u00148-\u001a$fi\u000eD\u0007+\u0019:uSRLwN\\:>wBjH\u0006I;tK\u000e\u000bG/\u00197pO\u001aKG\u000e^3s{m\fT\u0010")
public class PartitionableSourceTest
extends TableTestBase {
    private final boolean sourceFetchPartitions;
    private final boolean useCatalogFilter;
    private final StreamTableTestUtil util;

    @Parameters(name="sourceFetchPartitions={0}, useCatalogFilter={1}")
    public static Collection<Object[]> parameters() {
        return PartitionableSourceTest$.MODULE$.parameters();
    }

    public boolean sourceFetchPartitions() {
        return this.sourceFetchPartitions;
    }

    public boolean useCatalogFilter() {
        return this.useCatalogFilter;
    }

    private StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void setup() {
        String partitionableTable = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE PartitionableTable (\n        |  id int,\n        |  name string,\n        |  part1 string,\n        |  part2 int,\n        |  virtualField as part2 + 1)\n        |  partitioned by (part1, part2)\n        |  with (\n        |    'connector' = 'values',\n        |    'bounded' = 'true',\n        |    'partition-list' = '%s'\n        |)\n        |")).stripMargin();
        String partitionableAndFilterableTable = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE PartitionableAndFilterableTable (\n        |  id int,\n        |  name string,\n        |  part1 string,\n        |  part2 int,\n        |  virtualField as part2 + 1)\n        |  partitioned by (part1, part2)\n        |  with (\n        |    'connector' = 'values',\n        |    'bounded' = 'true',\n        |    'partition-list' = '%s',\n        |    'filterable-fields' = 'id;part1;part2'\n        |)\n        |")).stripMargin();
        if (this.sourceFetchPartitions()) {
            String partitions = "part1:A,part2:1;part1:A,part2:2;part1:B,part2:3;part1:C,part2:1";
            this.util().tableEnv().executeSql(String.format(partitionableTable, partitions));
            this.util().tableEnv().executeSql(String.format(partitionableAndFilterableTable, partitions));
        } else {
            TestValuesCatalog catalog = new TestValuesCatalog("test_catalog", "test_database", this.useCatalogFilter());
            this.util().tableEnv().registerCatalog("test_catalog", (Catalog)catalog);
            this.util().tableEnv().useCatalog("test_catalog");
            this.util().tableEnv().executeSql(String.format(partitionableTable, ""));
            this.util().tableEnv().executeSql(String.format(partitionableAndFilterableTable, ""));
            ObjectPath partitionableTablePath = ObjectPath.fromString((String)"test_database.PartitionableTable");
            ObjectPath partitionableAndFilterableTablePath = ObjectPath.fromString((String)"test_database.PartitionableAndFilterableTable");
            Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"2")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"B"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"3")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"C"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")}))}));
            partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                PartitionableSourceTest.$anonfun$setup$1(catalog, partitionableTablePath, partitionableAndFilterableTablePath, partition);
                return BoxedUnit.UNIT;
            });
        }
    }

    @TestTemplate
    public void testSimplePartitionFieldPredicate1() {
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE part1 = 'A'");
    }

    @TestTemplate
    public void testPartialPartitionFieldPredicatePushDown() {
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE (id > 2 OR part1 = 'A') AND part2 > 1");
    }

    @TestTemplate
    public void testWithUdfAndVirtualColumn() {
        this.util().addTemporarySystemFunction("MyUdf", (UserDefinedFunction)Func1$.MODULE$);
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE id > 2 AND MyUdf(part2) < 3");
    }

    @TestTemplate
    public void testUnconvertedExpression() {
        this.util().verifyExecPlan("select * from PartitionableTable where trim(part1) = 'A' and part2 > 1");
    }

    @TestTemplate
    public void testPushDownPartitionAndFiltersContainPartitionKeys() {
        this.util().verifyExecPlan("select * from PartitionableAndFilterableTable where part1 = 'A' and part2 > 1 and id > 1");
    }

    @TestTemplate
    public void testPushDownPartitionAndFiltersContainPartitionKeysWithSingleProjection() {
        this.util().verifyExecPlan("select name from PartitionableAndFilterableTable where part1 = 'A' and part2 > 1 and id > 1");
    }

    @TestTemplate
    public void testPushDownNonExistentPartition() {
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE part2 = 4");
    }

    public static final /* synthetic */ void $anonfun$setup$1(TestValuesCatalog catalog$1, ObjectPath partitionableTablePath$1, ObjectPath partitionableAndFilterableTablePath$1, scala.collection.immutable.Map partition) {
        CatalogPartitionSpec catalogPartitionSpec = new CatalogPartitionSpec(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)partition));
        CatalogPartitionImpl catalogPartition = new CatalogPartitionImpl(new HashMap(), "");
        catalog$1.createPartition(partitionableTablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
        catalog$1.createPartition(partitionableAndFilterableTablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
    }

    public PartitionableSourceTest(boolean sourceFetchPartitions, boolean useCatalogFilter) {
        this.sourceFetchPartitions = sourceFetchPartitions;
        this.useCatalogFilter = useCatalogFilter;
        this.util = this.streamTestUtil(this.streamTestUtil$default$1());
    }
}

